from pathlib import Path

root_dir = Path(__file__).parent
data_sources = {
    "calendar": {
        "keys": ["team", "season_year"],
        "cols": ["date", "week", "team", "opp", "is_away", "season_year"],
        "is_required": True,
        "is_forward_looking": False,
    },
    "players": {
        "keys": ["team", "season_year"],
        "cols": ["name", "team", "position", "season_year"],
        "is_required": True,
        "is_forward_looking": False,
    },
    "stats": {
        "keys": ["date", "name", "team", "opp", "is_away"],
        "cols": [
            "pid",
            "name",
            "team",
            "opp",
            "is_active",
            "date",
            "result",
            "is_away",
            "is_start",
            "g_nbr",
            "receiving_rec",
            "receiving_yds",
            "receiving_td",
            "rushing_yds",
            "rushing_td",
            "passing_cmp",
            "passing_yds",
            "passing_td",
            "fumbles_fmb",
            "passing_int",
            "scoring_2pm",
            "punt_returns_td",
        ],
        "is_required": False,
        "is_forward_looking": False,
    },
    "betting": {
        "keys": ["date", "season_year", "team", "opp"],
        "cols": ["team", "opp", "projected_off_pts", "date", "season_year"],
        "is_required": False,
        "is_forward_looking": True,
    },
    "salary": {
        "keys": ["name", "position", "season_year", "week"],
        "cols": ["name", "position", "season_year", "week", "fanduel_salary"],
        "is_required": False,
        "is_forward_looking": True,
    },
    "defense": {
        "keys": ["week", "opp", "season_year"],
        "cols": [
            "week",
            "opp",
            "rushing_def_rank",
            "receiving_def_rank",
            "passing_def_rank",
            "season_year",
        ],
        "is_required": False,
        "is_forward_looking": True,
    },
    "weather": {
        "keys": ["date", "team", "opp"],
        "cols": [
            "date",
            "team",
            "opp",
            "stadium_name",
            "roof_type",
            "temperature",
            "is_rain",
            "is_snow",
            "wind_speed",
            "is_outdoor",
        ],
        "is_required": False,
        "is_forward_looking": True,
    },
    "injury": {
        "keys": ["name", "team", "position", "week", "season_year"],
        "cols": [
            "name",
            "team",
            "position",
            "season_year",
            "week",
            "injury_type",
            "has_dnp_tag",
            "has_limited_tag",
            "most_recent_injury_status",
            "n_injuries",
        ],
        "is_required": False,
        "is_forward_looking": True,
    },
    "draft": {
        "keys": ["name", "team", "position", "season_year"],
        "cols": ["name", "team", "position", "season_year", "avg_draft_position"],
        "is_required": False,
        "is_forward_looking": False,
    },
}

scoring = {
    "draft kings": {
        "scoring_columns": {
            "passing_td": 4,
            "passing_yds": 0.04,
            "passing_int": -1,
            "rushing_td": 6,
            "rushing_yds": 0.1,
            "receiving_rec": 1,
            "receiving_td": 6,
            "receiving_yds": 0.1,
            "fumbles_fmb": -1,
            "scoring_2pm": 2,
            "punt_returns_td": 6,
        },
        "multiplier": {
            "rushing_yds": {"threshold": 100, "points": 3},
            "passing_yds": {"threshold": 300, "points": 3},
            "receiving_yds": {"threshold": 100, "points": 3},
        },
    },
    "yahoo": {
        "scoring_columns": {
            "passing_td": 4,
            "passing_yds": 0.04,
            "passing_int": -1,
            "rushing_td": 6,
            "rushing_yds": 0.1,
            "receiving_rec": 0.5,
            "receiving_td": 6,
            "receiving_yds": 0.1,
            "fumbles_fmb": -2,
            "scoring_2pm": 2,
            "punt_returns_td": 6,
        },
        "multiplier": None,
    },
    "custom": {
        "scoring_columns": {
            "passing_td": 5,
            "passing_yds": 0.04,
            "passing_int": -2,
            "rushing_td": 6,
            "rushing_yds": 0.1,
            "receiving_rec": 0.5,
            "receiving_td": 5,
            "receiving_yds": 0.1,
            "fumbles_fmb": -2,
            "scoring_2pm": 4,
            "punt_returns_td": 6,
        },
        "multiplier": None,
    },
}
