from ..models import District, simple_numbered_districts

"""
Legacy Districts is how we represent districts that have been retired due to redistricting
which occurs every 10 years
"""

legacy_districts = {
    "id": simple_numbered_districts(
        "ocd-division/country:us/state:id",
        "lower",
        35,
        num_seats=2,
    ),
    "nd": [
        District("4", "lower", "ocd-division/country:us/state:nd/sldl:4", 2),
        District("9", "lower", "ocd-division/country:us/state:nd/sldl:9", 2),
    ],
    "ma": [
        # These Districts were Retired in 2022
        District(
            "Worcester, Hampden, Hampshire and Middlesex", "upper", division_id=None
        ),
        District(
            "Berkshire, Hampshire, Franklin and Hampden", "upper", division_id=None
        ),
        District("Worcester and Norfolk", "upper", division_id=None),
        District("Second Suffolk and Middlesex", "upper", division_id=None),
        District("Second Plymouth and Bristol", "upper", division_id=None),
        District("Second Middlesex and Norfolk", "upper", division_id=None),
        District("Second Hampden and Hampshire", "upper", division_id=None),
        District("Plymouth and Norfolk", "upper", division_id=None),
        District("Norfolk, Bristol and Plymouth", "upper", division_id=None),
        District("Norfolk, Bristol and Middlesex", "upper", division_id=None),
        District("First Suffolk and Middlesex", "upper", division_id=None),
        District("First Plymouth and Bristol", "upper", division_id=None),
        District("First Middlesex and Norfolk", "upper", division_id=None),
        District("First Hampden and Hampshire", "upper", division_id=None),
        District("First Middlesex and Norfolk", "upper", division_id=None),
        District("4th Berkshire", "lower", division_id=None),
    ],
    "md": [
        District("2C", "lower", division_id=None),
        District("30", "lower", division_id=None),
        District("42", "lower", division_id=None),
        District("44", "lower", division_id=None),
        District("47", "lower", division_id=None),
        District("4A", "lower", division_id=None),
        District("4B", "lower", division_id=None),
        District("5A", "lower", division_id=None),
        District("5B", "lower", division_id=None),
        District("7", "lower", division_id=None),
        District("3A", "lower", division_id=None),
        District("3B", "lower", division_id=None),
        District("11", "lower", division_id=None),
        District("12", "lower", division_id=None),
        District("23A", "lower", division_id=None),
        District("23B", "lower", division_id=None),
        District("31A", "lower", division_id=None),
        District("31B", "lower", division_id=None),
        District("33", "lower", division_id=None),
        District("43", "lower", division_id=None),
    ],
    "nh": [
        District("Strafford 22", "lower", division_id=None),
        District("Strafford 23", "lower", division_id=None),
        District("Strafford 24", "lower", division_id=None),
        District("Strafford 25", "lower", division_id=None),
        District("Sullivan 9", "lower", division_id=None),
        District("Sullivan 10", "lower", division_id=None),
        District("Sullivan 11", "lower", division_id=None),
        District("Belknap 9", "lower", division_id=None),
    ],
    "nv": [
        District("Capital Senatorial District", "upper", division_id=None),
        District("Central Nevada Senatorial District", "upper", division_id=None),
        District("Clark County, No. 1", "upper", division_id=None),
        District("Clark County, No. 3", "upper", division_id=None),
        District("Clark County, No. 4", "upper", division_id=None),
        District("Clark County, No. 5", "upper", division_id=None),
        District("Clark County, No. 6", "upper", division_id=None),
        District("Clark County, No. 7", "upper", division_id=None),
        District("Clark County, No. 8", "upper", division_id=None),
        District("Clark County, No. 9", "upper", division_id=None),
        District("Clark County, No. 9", "upper", division_id=None),
        District("Clark County, No. 10", "upper", division_id=None),
        District("Clark County, No. 11", "upper", division_id=None),
        District("Clark County, No. 12", "upper", division_id=None),
        District("Rural Nevada Senatorial District", "upper", division_id=None),
        District("Washoe County, No. 1", "upper", division_id=None),
        District("Washoe County, No. 2", "upper", division_id=None),
        District("Washoe County, No. 3", "upper", division_id=None),
        District("Washoe County, No. 4", "upper", division_id=None),
    ],
    "pr": [
        District("I", "upper", division_id=None),
        District("II", "upper", division_id=None),
        District("III", "upper", division_id=None),
        District("IV", "upper", division_id=None),
        District("V", "upper", division_id=None),
        District("VI", "upper", division_id=None),
        District("VII", "upper", division_id=None),
        District("VIII", "upper", division_id=None),
    ],
    "vt": [
        District("Addison-Rutland-1", "lower", division_id=None),
        District("Bennington-Rutland-1", "lower", division_id=None),
        District("Chittenden-1-2", "lower", division_id=None),
        District("Chittenden-3-1", "lower", division_id=None),
        District("Chittenden-3-2", "lower", division_id=None),
        District("Chittenden-3-3", "lower", division_id=None),
        District("Chittenden-3-4", "lower", division_id=None),
        District("Chittenden-3-5", "lower", division_id=None),
        District("Chittenden-3-6", "lower", division_id=None),
        District("Chittenden-3-7", "lower", division_id=None),
        District("Chittenden-3-9", "lower", division_id=None),
        District("Chittenden-4", "lower", division_id=None),
        District("Chittenden-8", "lower", division_id=None),
        District("Chittenden-9", "lower", division_id=None),
        District("Franklin-3", "lower", division_id=None),
        District("Grand Isle-Chittenden-1-1", "lower", division_id=None),
        District("Lamoille-4", "lower", division_id=None),
        District("Lamoille-Washington-1", "lower", division_id=None),
        District("Orange-Addison-1", "lower", division_id=None),
        District("Orleans-Caledonia-1", "lower", division_id=None),
        District("Rutland-1-1", "lower", division_id=None),
        District("Rutland-1-2", "lower", division_id=None),
        District("Rutland-7", "lower", division_id=None),
        District("Rutland-8", "lower", division_id=None),
        District("Washington-3-2", "lower", division_id=None),
        District("Washington-3-3", "lower", division_id=None),
        District("Washington-Chittenden-1", "lower", division_id=None),
        District("Windham-2", "lower", division_id=None),
        District("Windham-3-1", "lower", division_id=None),
        District("Windham-3-3", "lower", division_id=None),
        District("Windham-Bennington-1", "lower", division_id=None),
        District("Windham-Bennington-Windsor-1", "lower", division_id=None),
        District("Windsor-1-1", "lower", division_id=None),
        District("Windsor-1-2", "lower", division_id=None),
        District("Windsor-3", "lower", division_id=None),
        District("Windsor-4", "lower", division_id=None),
        District("Windsor-6-1", "lower", division_id=None),
        District("Windsor-6-2", "lower", division_id=None),
        # These Districts were Retired in 2022
        District("Bennington-2-1", "lower", division_id=None),
        District("Bennington-2-2", "lower", division_id=None),
        District("Caledonia-4", "lower", division_id=None),
        District("Chittenden-4-1", "lower", division_id=None),
        District("Chittenden-4-2", "lower", division_id=None),
        District("Chittenden-5-1", "lower", division_id=None),
        District("Chittenden-5-2", "lower", division_id=None),
        District("Chittenden-6-1", "lower", division_id=None),
        District("Chittenden-6-2", "lower", division_id=None),
        District("Chittenden-6-3", "lower", division_id=None),
        District("Chittenden-6-4", "lower", division_id=None),
        District("Chittenden-6-5", "lower", division_id=None),
        District("Chittenden-6-6", "lower", division_id=None),
        District("Chittenden-6-7", "lower", division_id=None),
        District("Chittenden-7-1", "lower", division_id=None),
        District("Chittenden-7-2", "lower", division_id=None),
        District("Chittenden-7-3", "lower", division_id=None),
        District("Chittenden-7-4", "lower", division_id=None),
        District("Chittenden-8-1", "lower", division_id=None),
        District("Chittenden-8-2", "lower", division_id=None),
        District("Chittenden-8-3", "lower", division_id=None),
        District("Chittenden-9-1", "lower", division_id=None),
        District("Chittenden-9-2", "lower", division_id=None),
        District("Essex-Caledonia-Orleans", "lower", division_id=None),
        District("Franklin-3-1", "lower", division_id=None),
        District("Franklin-3-2", "lower", division_id=None),
        District("Orleans-Caledonia", "lower", division_id=None),
        District("Rutland-5-1", "lower", division_id=None),
        District("Rutland-5-2", "lower", division_id=None),
        District("Rutland-5-3", "lower", division_id=None),
        District("Rutland-5-4", "lower", division_id=None),
        District("Rutland-Windsor-1", "lower", division_id=None),
        District("Rutland-Windsor-2", "lower", division_id=None),
        District("Washington-7", "lower", division_id=None),
        District("Windham-2-1", "lower", division_id=None),
        District("Windham-2-2", "lower", division_id=None),
        District("Windham-2-3", "lower", division_id=None),
        District("Windham-Bennington", "lower", division_id=None),
        District("Windham-Bennington-Windsor", "lower", division_id=None),
        District("Windsor-3-1", "lower", division_id=None),
        District("Windsor-3-2", "lower", division_id=None),
        District("Windsor-4-1", "lower", division_id=None),
        District("Windsor-4-2", "lower", division_id=None),
        District("Windsor-Rutland", "lower", division_id=None),
        District("Chittenden", "upper", division_id=None),
        District("Essex-Orleans", "upper", division_id=None),
    ],
    "us": [
        District("CA-53", "lower", division_id=None),
        District("IL-18", "lower", division_id=None),
        District("IL-20", "lower", division_id=None),
        District("MA-10", "lower", division_id=None),
        District("MI-14", "lower", division_id=None),
        District("MO-9", "lower", division_id=None),
        District("NJ-13", "lower", division_id=None),
        District("NY-29", "lower", division_id=None),
        District("NY-27", "lower", division_id=None),
        District("OH-16", "lower", division_id=None),
        District("OH-17", "lower", division_id=None),
        District("OH-18", "lower", division_id=None),
        District("OK-6", "lower", division_id=None),
        District("PA-18", "lower", division_id=None),
        District("WV-3", "lower", division_id=None),
    ],
}
