"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.ApproleAuthBackendRole = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const cdktf = require("cdktf");
/**
* Represents a {@link https://www.terraform.io/docs/providers/vault/r/approle_auth_backend_role vault_approle_auth_backend_role}
*/
class ApproleAuthBackendRole extends cdktf.TerraformResource {
    // ===========
    // INITIALIZER
    // ===========
    /**
    * Create a new {@link https://www.terraform.io/docs/providers/vault/r/approle_auth_backend_role vault_approle_auth_backend_role} Resource
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options ApproleAuthBackendRoleConfig
    */
    constructor(scope, id, config) {
        super(scope, id, {
            terraformResourceType: 'vault_approle_auth_backend_role',
            terraformGeneratorMetadata: {
                providerName: 'vault',
                providerVersion: '3.8.2',
                providerVersionConstraint: '~> 3.7'
            },
            provider: config.provider,
            dependsOn: config.dependsOn,
            count: config.count,
            lifecycle: config.lifecycle,
            provisioners: config.provisioners,
            connection: config.connection,
            forEach: config.forEach
        });
        this._backend = config.backend;
        this._bindSecretId = config.bindSecretId;
        this._id = config.id;
        this._namespace = config.namespace;
        this._roleId = config.roleId;
        this._roleName = config.roleName;
        this._secretIdBoundCidrs = config.secretIdBoundCidrs;
        this._secretIdNumUses = config.secretIdNumUses;
        this._secretIdTtl = config.secretIdTtl;
        this._tokenBoundCidrs = config.tokenBoundCidrs;
        this._tokenExplicitMaxTtl = config.tokenExplicitMaxTtl;
        this._tokenMaxTtl = config.tokenMaxTtl;
        this._tokenNoDefaultPolicy = config.tokenNoDefaultPolicy;
        this._tokenNumUses = config.tokenNumUses;
        this._tokenPeriod = config.tokenPeriod;
        this._tokenPolicies = config.tokenPolicies;
        this._tokenTtl = config.tokenTtl;
        this._tokenType = config.tokenType;
    }
    get backend() {
        return this.getStringAttribute('backend');
    }
    set backend(value) {
        this._backend = value;
    }
    resetBackend() {
        this._backend = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get backendInput() {
        return this._backend;
    }
    get bindSecretId() {
        return this.getBooleanAttribute('bind_secret_id');
    }
    set bindSecretId(value) {
        this._bindSecretId = value;
    }
    resetBindSecretId() {
        this._bindSecretId = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get bindSecretIdInput() {
        return this._bindSecretId;
    }
    get id() {
        return this.getStringAttribute('id');
    }
    set id(value) {
        this._id = value;
    }
    resetId() {
        this._id = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get idInput() {
        return this._id;
    }
    get namespace() {
        return this.getStringAttribute('namespace');
    }
    set namespace(value) {
        this._namespace = value;
    }
    resetNamespace() {
        this._namespace = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get namespaceInput() {
        return this._namespace;
    }
    get roleId() {
        return this.getStringAttribute('role_id');
    }
    set roleId(value) {
        this._roleId = value;
    }
    resetRoleId() {
        this._roleId = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get roleIdInput() {
        return this._roleId;
    }
    get roleName() {
        return this.getStringAttribute('role_name');
    }
    set roleName(value) {
        this._roleName = value;
    }
    // Temporarily expose input value. Use with caution.
    get roleNameInput() {
        return this._roleName;
    }
    get secretIdBoundCidrs() {
        return cdktf.Fn.tolist(this.getListAttribute('secret_id_bound_cidrs'));
    }
    set secretIdBoundCidrs(value) {
        this._secretIdBoundCidrs = value;
    }
    resetSecretIdBoundCidrs() {
        this._secretIdBoundCidrs = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get secretIdBoundCidrsInput() {
        return this._secretIdBoundCidrs;
    }
    get secretIdNumUses() {
        return this.getNumberAttribute('secret_id_num_uses');
    }
    set secretIdNumUses(value) {
        this._secretIdNumUses = value;
    }
    resetSecretIdNumUses() {
        this._secretIdNumUses = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get secretIdNumUsesInput() {
        return this._secretIdNumUses;
    }
    get secretIdTtl() {
        return this.getNumberAttribute('secret_id_ttl');
    }
    set secretIdTtl(value) {
        this._secretIdTtl = value;
    }
    resetSecretIdTtl() {
        this._secretIdTtl = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get secretIdTtlInput() {
        return this._secretIdTtl;
    }
    get tokenBoundCidrs() {
        return cdktf.Fn.tolist(this.getListAttribute('token_bound_cidrs'));
    }
    set tokenBoundCidrs(value) {
        this._tokenBoundCidrs = value;
    }
    resetTokenBoundCidrs() {
        this._tokenBoundCidrs = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get tokenBoundCidrsInput() {
        return this._tokenBoundCidrs;
    }
    get tokenExplicitMaxTtl() {
        return this.getNumberAttribute('token_explicit_max_ttl');
    }
    set tokenExplicitMaxTtl(value) {
        this._tokenExplicitMaxTtl = value;
    }
    resetTokenExplicitMaxTtl() {
        this._tokenExplicitMaxTtl = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get tokenExplicitMaxTtlInput() {
        return this._tokenExplicitMaxTtl;
    }
    get tokenMaxTtl() {
        return this.getNumberAttribute('token_max_ttl');
    }
    set tokenMaxTtl(value) {
        this._tokenMaxTtl = value;
    }
    resetTokenMaxTtl() {
        this._tokenMaxTtl = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get tokenMaxTtlInput() {
        return this._tokenMaxTtl;
    }
    get tokenNoDefaultPolicy() {
        return this.getBooleanAttribute('token_no_default_policy');
    }
    set tokenNoDefaultPolicy(value) {
        this._tokenNoDefaultPolicy = value;
    }
    resetTokenNoDefaultPolicy() {
        this._tokenNoDefaultPolicy = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get tokenNoDefaultPolicyInput() {
        return this._tokenNoDefaultPolicy;
    }
    get tokenNumUses() {
        return this.getNumberAttribute('token_num_uses');
    }
    set tokenNumUses(value) {
        this._tokenNumUses = value;
    }
    resetTokenNumUses() {
        this._tokenNumUses = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get tokenNumUsesInput() {
        return this._tokenNumUses;
    }
    get tokenPeriod() {
        return this.getNumberAttribute('token_period');
    }
    set tokenPeriod(value) {
        this._tokenPeriod = value;
    }
    resetTokenPeriod() {
        this._tokenPeriod = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get tokenPeriodInput() {
        return this._tokenPeriod;
    }
    get tokenPolicies() {
        return cdktf.Fn.tolist(this.getListAttribute('token_policies'));
    }
    set tokenPolicies(value) {
        this._tokenPolicies = value;
    }
    resetTokenPolicies() {
        this._tokenPolicies = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get tokenPoliciesInput() {
        return this._tokenPolicies;
    }
    get tokenTtl() {
        return this.getNumberAttribute('token_ttl');
    }
    set tokenTtl(value) {
        this._tokenTtl = value;
    }
    resetTokenTtl() {
        this._tokenTtl = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get tokenTtlInput() {
        return this._tokenTtl;
    }
    get tokenType() {
        return this.getStringAttribute('token_type');
    }
    set tokenType(value) {
        this._tokenType = value;
    }
    resetTokenType() {
        this._tokenType = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get tokenTypeInput() {
        return this._tokenType;
    }
    // =========
    // SYNTHESIS
    // =========
    synthesizeAttributes() {
        return {
            backend: cdktf.stringToTerraform(this._backend),
            bind_secret_id: cdktf.booleanToTerraform(this._bindSecretId),
            id: cdktf.stringToTerraform(this._id),
            namespace: cdktf.stringToTerraform(this._namespace),
            role_id: cdktf.stringToTerraform(this._roleId),
            role_name: cdktf.stringToTerraform(this._roleName),
            secret_id_bound_cidrs: cdktf.listMapper(cdktf.stringToTerraform, false)(this._secretIdBoundCidrs),
            secret_id_num_uses: cdktf.numberToTerraform(this._secretIdNumUses),
            secret_id_ttl: cdktf.numberToTerraform(this._secretIdTtl),
            token_bound_cidrs: cdktf.listMapper(cdktf.stringToTerraform, false)(this._tokenBoundCidrs),
            token_explicit_max_ttl: cdktf.numberToTerraform(this._tokenExplicitMaxTtl),
            token_max_ttl: cdktf.numberToTerraform(this._tokenMaxTtl),
            token_no_default_policy: cdktf.booleanToTerraform(this._tokenNoDefaultPolicy),
            token_num_uses: cdktf.numberToTerraform(this._tokenNumUses),
            token_period: cdktf.numberToTerraform(this._tokenPeriod),
            token_policies: cdktf.listMapper(cdktf.stringToTerraform, false)(this._tokenPolicies),
            token_ttl: cdktf.numberToTerraform(this._tokenTtl),
            token_type: cdktf.stringToTerraform(this._tokenType),
        };
    }
}
exports.ApproleAuthBackendRole = ApproleAuthBackendRole;
_a = JSII_RTTI_SYMBOL_1;
ApproleAuthBackendRole[_a] = { fqn: "@cdktf/provider-vault.ApproleAuthBackendRole", version: "2.0.22" };
// =================
// STATIC PROPERTIES
// =================
ApproleAuthBackendRole.tfResourceType = "vault_approle_auth_backend_role";
//# sourceMappingURL=data:application/json;base64,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