import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface DataVaultKubernetesAuthBackendConfigConfig extends cdktf.TerraformMetaArguments {
    /**
    * Unique name of the kubernetes backend to configure.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/vault/d/kubernetes_auth_backend_config#backend DataVaultKubernetesAuthBackendConfig#backend}
    */
    readonly backend?: string;
    /**
    * Optional disable JWT issuer validation. Allows to skip ISS validation.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/vault/d/kubernetes_auth_backend_config#disable_iss_validation DataVaultKubernetesAuthBackendConfig#disable_iss_validation}
    */
    readonly disableIssValidation?: boolean | cdktf.IResolvable;
    /**
    * Optional disable defaulting to the local CA cert and service account JWT when running in a Kubernetes pod.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/vault/d/kubernetes_auth_backend_config#disable_local_ca_jwt DataVaultKubernetesAuthBackendConfig#disable_local_ca_jwt}
    */
    readonly disableLocalCaJwt?: boolean | cdktf.IResolvable;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/vault/d/kubernetes_auth_backend_config#id DataVaultKubernetesAuthBackendConfig#id}
    *
    * Please be aware that the id field is automatically added to all resources in Terraform providers using a Terraform provider SDK version below 2.
    * If you experience problems setting this value it might not be settable. Please take a look at the provider documentation to ensure it should be settable.
    */
    readonly id?: string;
    /**
    * Optional JWT issuer. If no issuer is specified, kubernetes.io/serviceaccount will be used as the default issuer.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/vault/d/kubernetes_auth_backend_config#issuer DataVaultKubernetesAuthBackendConfig#issuer}
    */
    readonly issuer?: string;
    /**
    * PEM encoded CA cert for use by the TLS client used to talk with the Kubernetes API.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/vault/d/kubernetes_auth_backend_config#kubernetes_ca_cert DataVaultKubernetesAuthBackendConfig#kubernetes_ca_cert}
    */
    readonly kubernetesCaCert?: string;
    /**
    * Host must be a host string, a host:port pair, or a URL to the base of the Kubernetes API server.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/vault/d/kubernetes_auth_backend_config#kubernetes_host DataVaultKubernetesAuthBackendConfig#kubernetes_host}
    */
    readonly kubernetesHost?: string;
    /**
    * Target namespace. (requires Enterprise)
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/vault/d/kubernetes_auth_backend_config#namespace DataVaultKubernetesAuthBackendConfig#namespace}
    */
    readonly namespace?: string;
    /**
    * Optional list of PEM-formatted public keys or certificates used to verify the signatures of Kubernetes service account JWTs. If a certificate is given, its public key will be extracted. Not every installation of Kubernetes exposes these keys.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/vault/d/kubernetes_auth_backend_config#pem_keys DataVaultKubernetesAuthBackendConfig#pem_keys}
    */
    readonly pemKeys?: string[];
}
/**
* Represents a {@link https://www.terraform.io/docs/providers/vault/d/kubernetes_auth_backend_config vault_kubernetes_auth_backend_config}
*/
export declare class DataVaultKubernetesAuthBackendConfig extends cdktf.TerraformDataSource {
    static readonly tfResourceType = "vault_kubernetes_auth_backend_config";
    /**
    * Create a new {@link https://www.terraform.io/docs/providers/vault/d/kubernetes_auth_backend_config vault_kubernetes_auth_backend_config} Data Source
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options DataVaultKubernetesAuthBackendConfigConfig = {}
    */
    constructor(scope: Construct, id: string, config?: DataVaultKubernetesAuthBackendConfigConfig);
    private _backend?;
    get backend(): string;
    set backend(value: string);
    resetBackend(): void;
    get backendInput(): string | undefined;
    private _disableIssValidation?;
    get disableIssValidation(): boolean | cdktf.IResolvable;
    set disableIssValidation(value: boolean | cdktf.IResolvable);
    resetDisableIssValidation(): void;
    get disableIssValidationInput(): boolean | cdktf.IResolvable | undefined;
    private _disableLocalCaJwt?;
    get disableLocalCaJwt(): boolean | cdktf.IResolvable;
    set disableLocalCaJwt(value: boolean | cdktf.IResolvable);
    resetDisableLocalCaJwt(): void;
    get disableLocalCaJwtInput(): boolean | cdktf.IResolvable | undefined;
    private _id?;
    get id(): string;
    set id(value: string);
    resetId(): void;
    get idInput(): string | undefined;
    private _issuer?;
    get issuer(): string;
    set issuer(value: string);
    resetIssuer(): void;
    get issuerInput(): string | undefined;
    private _kubernetesCaCert?;
    get kubernetesCaCert(): string;
    set kubernetesCaCert(value: string);
    resetKubernetesCaCert(): void;
    get kubernetesCaCertInput(): string | undefined;
    private _kubernetesHost?;
    get kubernetesHost(): string;
    set kubernetesHost(value: string);
    resetKubernetesHost(): void;
    get kubernetesHostInput(): string | undefined;
    private _namespace?;
    get namespace(): string;
    set namespace(value: string);
    resetNamespace(): void;
    get namespaceInput(): string | undefined;
    private _pemKeys?;
    get pemKeys(): string[];
    set pemKeys(value: string[]);
    resetPemKeys(): void;
    get pemKeysInput(): string[] | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
