"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.JwtAuthBackendRole = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const cdktf = require("cdktf");
/**
* Represents a {@link https://www.terraform.io/docs/providers/vault/r/jwt_auth_backend_role vault_jwt_auth_backend_role}
*/
class JwtAuthBackendRole extends cdktf.TerraformResource {
    // ===========
    // INITIALIZER
    // ===========
    /**
    * Create a new {@link https://www.terraform.io/docs/providers/vault/r/jwt_auth_backend_role vault_jwt_auth_backend_role} Resource
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options JwtAuthBackendRoleConfig
    */
    constructor(scope, id, config) {
        super(scope, id, {
            terraformResourceType: 'vault_jwt_auth_backend_role',
            terraformGeneratorMetadata: {
                providerName: 'vault',
                providerVersion: '3.8.2',
                providerVersionConstraint: '~> 3.7'
            },
            provider: config.provider,
            dependsOn: config.dependsOn,
            count: config.count,
            lifecycle: config.lifecycle,
            provisioners: config.provisioners,
            connection: config.connection,
            forEach: config.forEach
        });
        this._allowedRedirectUris = config.allowedRedirectUris;
        this._backend = config.backend;
        this._boundAudiences = config.boundAudiences;
        this._boundClaims = config.boundClaims;
        this._boundClaimsType = config.boundClaimsType;
        this._boundSubject = config.boundSubject;
        this._claimMappings = config.claimMappings;
        this._clockSkewLeeway = config.clockSkewLeeway;
        this._disableBoundClaimsParsing = config.disableBoundClaimsParsing;
        this._expirationLeeway = config.expirationLeeway;
        this._groupsClaim = config.groupsClaim;
        this._id = config.id;
        this._maxAge = config.maxAge;
        this._namespace = config.namespace;
        this._notBeforeLeeway = config.notBeforeLeeway;
        this._oidcScopes = config.oidcScopes;
        this._roleName = config.roleName;
        this._roleType = config.roleType;
        this._tokenBoundCidrs = config.tokenBoundCidrs;
        this._tokenExplicitMaxTtl = config.tokenExplicitMaxTtl;
        this._tokenMaxTtl = config.tokenMaxTtl;
        this._tokenNoDefaultPolicy = config.tokenNoDefaultPolicy;
        this._tokenNumUses = config.tokenNumUses;
        this._tokenPeriod = config.tokenPeriod;
        this._tokenPolicies = config.tokenPolicies;
        this._tokenTtl = config.tokenTtl;
        this._tokenType = config.tokenType;
        this._userClaim = config.userClaim;
        this._userClaimJsonPointer = config.userClaimJsonPointer;
        this._verboseOidcLogging = config.verboseOidcLogging;
    }
    get allowedRedirectUris() {
        return cdktf.Fn.tolist(this.getListAttribute('allowed_redirect_uris'));
    }
    set allowedRedirectUris(value) {
        this._allowedRedirectUris = value;
    }
    resetAllowedRedirectUris() {
        this._allowedRedirectUris = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get allowedRedirectUrisInput() {
        return this._allowedRedirectUris;
    }
    get backend() {
        return this.getStringAttribute('backend');
    }
    set backend(value) {
        this._backend = value;
    }
    resetBackend() {
        this._backend = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get backendInput() {
        return this._backend;
    }
    get boundAudiences() {
        return cdktf.Fn.tolist(this.getListAttribute('bound_audiences'));
    }
    set boundAudiences(value) {
        this._boundAudiences = value;
    }
    resetBoundAudiences() {
        this._boundAudiences = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get boundAudiencesInput() {
        return this._boundAudiences;
    }
    get boundClaims() {
        return this.getStringMapAttribute('bound_claims');
    }
    set boundClaims(value) {
        this._boundClaims = value;
    }
    resetBoundClaims() {
        this._boundClaims = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get boundClaimsInput() {
        return this._boundClaims;
    }
    get boundClaimsType() {
        return this.getStringAttribute('bound_claims_type');
    }
    set boundClaimsType(value) {
        this._boundClaimsType = value;
    }
    resetBoundClaimsType() {
        this._boundClaimsType = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get boundClaimsTypeInput() {
        return this._boundClaimsType;
    }
    get boundSubject() {
        return this.getStringAttribute('bound_subject');
    }
    set boundSubject(value) {
        this._boundSubject = value;
    }
    resetBoundSubject() {
        this._boundSubject = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get boundSubjectInput() {
        return this._boundSubject;
    }
    get claimMappings() {
        return this.getStringMapAttribute('claim_mappings');
    }
    set claimMappings(value) {
        this._claimMappings = value;
    }
    resetClaimMappings() {
        this._claimMappings = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get claimMappingsInput() {
        return this._claimMappings;
    }
    get clockSkewLeeway() {
        return this.getNumberAttribute('clock_skew_leeway');
    }
    set clockSkewLeeway(value) {
        this._clockSkewLeeway = value;
    }
    resetClockSkewLeeway() {
        this._clockSkewLeeway = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get clockSkewLeewayInput() {
        return this._clockSkewLeeway;
    }
    get disableBoundClaimsParsing() {
        return this.getBooleanAttribute('disable_bound_claims_parsing');
    }
    set disableBoundClaimsParsing(value) {
        this._disableBoundClaimsParsing = value;
    }
    resetDisableBoundClaimsParsing() {
        this._disableBoundClaimsParsing = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get disableBoundClaimsParsingInput() {
        return this._disableBoundClaimsParsing;
    }
    get expirationLeeway() {
        return this.getNumberAttribute('expiration_leeway');
    }
    set expirationLeeway(value) {
        this._expirationLeeway = value;
    }
    resetExpirationLeeway() {
        this._expirationLeeway = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get expirationLeewayInput() {
        return this._expirationLeeway;
    }
    get groupsClaim() {
        return this.getStringAttribute('groups_claim');
    }
    set groupsClaim(value) {
        this._groupsClaim = value;
    }
    resetGroupsClaim() {
        this._groupsClaim = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get groupsClaimInput() {
        return this._groupsClaim;
    }
    get id() {
        return this.getStringAttribute('id');
    }
    set id(value) {
        this._id = value;
    }
    resetId() {
        this._id = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get idInput() {
        return this._id;
    }
    get maxAge() {
        return this.getNumberAttribute('max_age');
    }
    set maxAge(value) {
        this._maxAge = value;
    }
    resetMaxAge() {
        this._maxAge = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get maxAgeInput() {
        return this._maxAge;
    }
    get namespace() {
        return this.getStringAttribute('namespace');
    }
    set namespace(value) {
        this._namespace = value;
    }
    resetNamespace() {
        this._namespace = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get namespaceInput() {
        return this._namespace;
    }
    get notBeforeLeeway() {
        return this.getNumberAttribute('not_before_leeway');
    }
    set notBeforeLeeway(value) {
        this._notBeforeLeeway = value;
    }
    resetNotBeforeLeeway() {
        this._notBeforeLeeway = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get notBeforeLeewayInput() {
        return this._notBeforeLeeway;
    }
    get oidcScopes() {
        return cdktf.Fn.tolist(this.getListAttribute('oidc_scopes'));
    }
    set oidcScopes(value) {
        this._oidcScopes = value;
    }
    resetOidcScopes() {
        this._oidcScopes = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get oidcScopesInput() {
        return this._oidcScopes;
    }
    get roleName() {
        return this.getStringAttribute('role_name');
    }
    set roleName(value) {
        this._roleName = value;
    }
    // Temporarily expose input value. Use with caution.
    get roleNameInput() {
        return this._roleName;
    }
    get roleType() {
        return this.getStringAttribute('role_type');
    }
    set roleType(value) {
        this._roleType = value;
    }
    resetRoleType() {
        this._roleType = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get roleTypeInput() {
        return this._roleType;
    }
    get tokenBoundCidrs() {
        return cdktf.Fn.tolist(this.getListAttribute('token_bound_cidrs'));
    }
    set tokenBoundCidrs(value) {
        this._tokenBoundCidrs = value;
    }
    resetTokenBoundCidrs() {
        this._tokenBoundCidrs = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get tokenBoundCidrsInput() {
        return this._tokenBoundCidrs;
    }
    get tokenExplicitMaxTtl() {
        return this.getNumberAttribute('token_explicit_max_ttl');
    }
    set tokenExplicitMaxTtl(value) {
        this._tokenExplicitMaxTtl = value;
    }
    resetTokenExplicitMaxTtl() {
        this._tokenExplicitMaxTtl = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get tokenExplicitMaxTtlInput() {
        return this._tokenExplicitMaxTtl;
    }
    get tokenMaxTtl() {
        return this.getNumberAttribute('token_max_ttl');
    }
    set tokenMaxTtl(value) {
        this._tokenMaxTtl = value;
    }
    resetTokenMaxTtl() {
        this._tokenMaxTtl = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get tokenMaxTtlInput() {
        return this._tokenMaxTtl;
    }
    get tokenNoDefaultPolicy() {
        return this.getBooleanAttribute('token_no_default_policy');
    }
    set tokenNoDefaultPolicy(value) {
        this._tokenNoDefaultPolicy = value;
    }
    resetTokenNoDefaultPolicy() {
        this._tokenNoDefaultPolicy = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get tokenNoDefaultPolicyInput() {
        return this._tokenNoDefaultPolicy;
    }
    get tokenNumUses() {
        return this.getNumberAttribute('token_num_uses');
    }
    set tokenNumUses(value) {
        this._tokenNumUses = value;
    }
    resetTokenNumUses() {
        this._tokenNumUses = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get tokenNumUsesInput() {
        return this._tokenNumUses;
    }
    get tokenPeriod() {
        return this.getNumberAttribute('token_period');
    }
    set tokenPeriod(value) {
        this._tokenPeriod = value;
    }
    resetTokenPeriod() {
        this._tokenPeriod = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get tokenPeriodInput() {
        return this._tokenPeriod;
    }
    get tokenPolicies() {
        return cdktf.Fn.tolist(this.getListAttribute('token_policies'));
    }
    set tokenPolicies(value) {
        this._tokenPolicies = value;
    }
    resetTokenPolicies() {
        this._tokenPolicies = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get tokenPoliciesInput() {
        return this._tokenPolicies;
    }
    get tokenTtl() {
        return this.getNumberAttribute('token_ttl');
    }
    set tokenTtl(value) {
        this._tokenTtl = value;
    }
    resetTokenTtl() {
        this._tokenTtl = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get tokenTtlInput() {
        return this._tokenTtl;
    }
    get tokenType() {
        return this.getStringAttribute('token_type');
    }
    set tokenType(value) {
        this._tokenType = value;
    }
    resetTokenType() {
        this._tokenType = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get tokenTypeInput() {
        return this._tokenType;
    }
    get userClaim() {
        return this.getStringAttribute('user_claim');
    }
    set userClaim(value) {
        this._userClaim = value;
    }
    // Temporarily expose input value. Use with caution.
    get userClaimInput() {
        return this._userClaim;
    }
    get userClaimJsonPointer() {
        return this.getBooleanAttribute('user_claim_json_pointer');
    }
    set userClaimJsonPointer(value) {
        this._userClaimJsonPointer = value;
    }
    resetUserClaimJsonPointer() {
        this._userClaimJsonPointer = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get userClaimJsonPointerInput() {
        return this._userClaimJsonPointer;
    }
    get verboseOidcLogging() {
        return this.getBooleanAttribute('verbose_oidc_logging');
    }
    set verboseOidcLogging(value) {
        this._verboseOidcLogging = value;
    }
    resetVerboseOidcLogging() {
        this._verboseOidcLogging = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get verboseOidcLoggingInput() {
        return this._verboseOidcLogging;
    }
    // =========
    // SYNTHESIS
    // =========
    synthesizeAttributes() {
        return {
            allowed_redirect_uris: cdktf.listMapper(cdktf.stringToTerraform, false)(this._allowedRedirectUris),
            backend: cdktf.stringToTerraform(this._backend),
            bound_audiences: cdktf.listMapper(cdktf.stringToTerraform, false)(this._boundAudiences),
            bound_claims: cdktf.hashMapper(cdktf.stringToTerraform)(this._boundClaims),
            bound_claims_type: cdktf.stringToTerraform(this._boundClaimsType),
            bound_subject: cdktf.stringToTerraform(this._boundSubject),
            claim_mappings: cdktf.hashMapper(cdktf.stringToTerraform)(this._claimMappings),
            clock_skew_leeway: cdktf.numberToTerraform(this._clockSkewLeeway),
            disable_bound_claims_parsing: cdktf.booleanToTerraform(this._disableBoundClaimsParsing),
            expiration_leeway: cdktf.numberToTerraform(this._expirationLeeway),
            groups_claim: cdktf.stringToTerraform(this._groupsClaim),
            id: cdktf.stringToTerraform(this._id),
            max_age: cdktf.numberToTerraform(this._maxAge),
            namespace: cdktf.stringToTerraform(this._namespace),
            not_before_leeway: cdktf.numberToTerraform(this._notBeforeLeeway),
            oidc_scopes: cdktf.listMapper(cdktf.stringToTerraform, false)(this._oidcScopes),
            role_name: cdktf.stringToTerraform(this._roleName),
            role_type: cdktf.stringToTerraform(this._roleType),
            token_bound_cidrs: cdktf.listMapper(cdktf.stringToTerraform, false)(this._tokenBoundCidrs),
            token_explicit_max_ttl: cdktf.numberToTerraform(this._tokenExplicitMaxTtl),
            token_max_ttl: cdktf.numberToTerraform(this._tokenMaxTtl),
            token_no_default_policy: cdktf.booleanToTerraform(this._tokenNoDefaultPolicy),
            token_num_uses: cdktf.numberToTerraform(this._tokenNumUses),
            token_period: cdktf.numberToTerraform(this._tokenPeriod),
            token_policies: cdktf.listMapper(cdktf.stringToTerraform, false)(this._tokenPolicies),
            token_ttl: cdktf.numberToTerraform(this._tokenTtl),
            token_type: cdktf.stringToTerraform(this._tokenType),
            user_claim: cdktf.stringToTerraform(this._userClaim),
            user_claim_json_pointer: cdktf.booleanToTerraform(this._userClaimJsonPointer),
            verbose_oidc_logging: cdktf.booleanToTerraform(this._verboseOidcLogging),
        };
    }
}
exports.JwtAuthBackendRole = JwtAuthBackendRole;
_a = JSII_RTTI_SYMBOL_1;
JwtAuthBackendRole[_a] = { fqn: "@cdktf/provider-vault.JwtAuthBackendRole", version: "2.0.22" };
// =================
// STATIC PROPERTIES
// =================
JwtAuthBackendRole.tfResourceType = "vault_jwt_auth_backend_role";
//# sourceMappingURL=data:application/json;base64,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