import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface KvSecretBackendV2Config extends cdktf.TerraformMetaArguments {
    /**
    * If true, all keys will require the cas parameter to be set on all write requests.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/vault/r/kv_secret_backend_v2#cas_required KvSecretBackendV2#cas_required}
    */
    readonly casRequired?: boolean | cdktf.IResolvable;
    /**
    * If set, specifies the length of time before a version is deleted
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/vault/r/kv_secret_backend_v2#delete_version_after KvSecretBackendV2#delete_version_after}
    */
    readonly deleteVersionAfter?: number;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/vault/r/kv_secret_backend_v2#id KvSecretBackendV2#id}
    *
    * Please be aware that the id field is automatically added to all resources in Terraform providers using a Terraform provider SDK version below 2.
    * If you experience problems setting this value it might not be settable. Please take a look at the provider documentation to ensure it should be settable.
    */
    readonly id?: string;
    /**
    * The number of versions to keep per key.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/vault/r/kv_secret_backend_v2#max_versions KvSecretBackendV2#max_versions}
    */
    readonly maxVersions?: number;
    /**
    * Path where KV-V2 engine is mounted.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/vault/r/kv_secret_backend_v2#mount KvSecretBackendV2#mount}
    */
    readonly mount: string;
    /**
    * Target namespace. (requires Enterprise)
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/vault/r/kv_secret_backend_v2#namespace KvSecretBackendV2#namespace}
    */
    readonly namespace?: string;
}
/**
* Represents a {@link https://www.terraform.io/docs/providers/vault/r/kv_secret_backend_v2 vault_kv_secret_backend_v2}
*/
export declare class KvSecretBackendV2 extends cdktf.TerraformResource {
    static readonly tfResourceType = "vault_kv_secret_backend_v2";
    /**
    * Create a new {@link https://www.terraform.io/docs/providers/vault/r/kv_secret_backend_v2 vault_kv_secret_backend_v2} Resource
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options KvSecretBackendV2Config
    */
    constructor(scope: Construct, id: string, config: KvSecretBackendV2Config);
    private _casRequired?;
    get casRequired(): boolean | cdktf.IResolvable;
    set casRequired(value: boolean | cdktf.IResolvable);
    resetCasRequired(): void;
    get casRequiredInput(): boolean | cdktf.IResolvable | undefined;
    private _deleteVersionAfter?;
    get deleteVersionAfter(): number;
    set deleteVersionAfter(value: number);
    resetDeleteVersionAfter(): void;
    get deleteVersionAfterInput(): number | undefined;
    private _id?;
    get id(): string;
    set id(value: string);
    resetId(): void;
    get idInput(): string | undefined;
    private _maxVersions?;
    get maxVersions(): number;
    set maxVersions(value: number);
    resetMaxVersions(): void;
    get maxVersionsInput(): number | undefined;
    private _mount?;
    get mount(): string;
    set mount(value: string);
    get mountInput(): string | undefined;
    private _namespace?;
    get namespace(): string;
    set namespace(value: string);
    resetNamespace(): void;
    get namespaceInput(): string | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
