import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface RaftSnapshotAgentConfigConfig extends cdktf.TerraformMetaArguments {
    /**
    * AWS access key ID.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/vault/r/raft_snapshot_agent_config#aws_access_key_id RaftSnapshotAgentConfig#aws_access_key_id}
    */
    readonly awsAccessKeyId?: string;
    /**
    * S3 bucket to write snapshots to.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/vault/r/raft_snapshot_agent_config#aws_s3_bucket RaftSnapshotAgentConfig#aws_s3_bucket}
    */
    readonly awsS3Bucket?: string;
    /**
    * Disable TLS for the S3 endpoint. This should only be used for testing purposes.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/vault/r/raft_snapshot_agent_config#aws_s3_disable_tls RaftSnapshotAgentConfig#aws_s3_disable_tls}
    */
    readonly awsS3DisableTls?: boolean | cdktf.IResolvable;
    /**
    * Use KMS to encrypt bucket contents.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/vault/r/raft_snapshot_agent_config#aws_s3_enable_kms RaftSnapshotAgentConfig#aws_s3_enable_kms}
    */
    readonly awsS3EnableKms?: boolean | cdktf.IResolvable;
    /**
    * AWS endpoint. This is typically only set when using a non-AWS S3 implementation like Minio.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/vault/r/raft_snapshot_agent_config#aws_s3_endpoint RaftSnapshotAgentConfig#aws_s3_endpoint}
    */
    readonly awsS3Endpoint?: string;
    /**
    * Use the endpoint/bucket URL style instead of bucket.endpoint.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/vault/r/raft_snapshot_agent_config#aws_s3_force_path_style RaftSnapshotAgentConfig#aws_s3_force_path_style}
    */
    readonly awsS3ForcePathStyle?: boolean | cdktf.IResolvable;
    /**
    * Use named KMS key, when aws_s3_enable_kms=true
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/vault/r/raft_snapshot_agent_config#aws_s3_kms_key RaftSnapshotAgentConfig#aws_s3_kms_key}
    */
    readonly awsS3KmsKey?: string;
    /**
    * AWS region bucket is in.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/vault/r/raft_snapshot_agent_config#aws_s3_region RaftSnapshotAgentConfig#aws_s3_region}
    */
    readonly awsS3Region?: string;
    /**
    * Use AES256 to encrypt bucket contents.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/vault/r/raft_snapshot_agent_config#aws_s3_server_side_encryption RaftSnapshotAgentConfig#aws_s3_server_side_encryption}
    */
    readonly awsS3ServerSideEncryption?: boolean | cdktf.IResolvable;
    /**
    * AWS secret access key.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/vault/r/raft_snapshot_agent_config#aws_secret_access_key RaftSnapshotAgentConfig#aws_secret_access_key}
    */
    readonly awsSecretAccessKey?: string;
    /**
    * AWS session token.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/vault/r/raft_snapshot_agent_config#aws_session_token RaftSnapshotAgentConfig#aws_session_token}
    */
    readonly awsSessionToken?: string;
    /**
    * Azure account key.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/vault/r/raft_snapshot_agent_config#azure_account_key RaftSnapshotAgentConfig#azure_account_key}
    */
    readonly azureAccountKey?: string;
    /**
    * Azure account name.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/vault/r/raft_snapshot_agent_config#azure_account_name RaftSnapshotAgentConfig#azure_account_name}
    */
    readonly azureAccountName?: string;
    /**
    * Azure blob environment.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/vault/r/raft_snapshot_agent_config#azure_blob_environment RaftSnapshotAgentConfig#azure_blob_environment}
    */
    readonly azureBlobEnvironment?: string;
    /**
    * Azure container name to write snapshots to.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/vault/r/raft_snapshot_agent_config#azure_container_name RaftSnapshotAgentConfig#azure_container_name}
    */
    readonly azureContainerName?: string;
    /**
    * Azure blob storage endpoint. This is typically only set when using a non-Azure implementation like Azurite.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/vault/r/raft_snapshot_agent_config#azure_endpoint RaftSnapshotAgentConfig#azure_endpoint}
    */
    readonly azureEndpoint?: string;
    /**
    * The file or object name of snapshot files will start with this string.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/vault/r/raft_snapshot_agent_config#file_prefix RaftSnapshotAgentConfig#file_prefix}
    */
    readonly filePrefix?: string;
    /**
    * Disable TLS for the GCS endpoint.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/vault/r/raft_snapshot_agent_config#google_disable_tls RaftSnapshotAgentConfig#google_disable_tls}
    */
    readonly googleDisableTls?: boolean | cdktf.IResolvable;
    /**
    * GCS endpoint. This is typically only set when using a non-Google GCS implementation like fake-gcs-server.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/vault/r/raft_snapshot_agent_config#google_endpoint RaftSnapshotAgentConfig#google_endpoint}
    */
    readonly googleEndpoint?: string;
    /**
    * GCS bucket to write snapshots to.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/vault/r/raft_snapshot_agent_config#google_gcs_bucket RaftSnapshotAgentConfig#google_gcs_bucket}
    */
    readonly googleGcsBucket?: string;
    /**
    * Google service account key in JSON format.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/vault/r/raft_snapshot_agent_config#google_service_account_key RaftSnapshotAgentConfig#google_service_account_key}
    */
    readonly googleServiceAccountKey?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/vault/r/raft_snapshot_agent_config#id RaftSnapshotAgentConfig#id}
    *
    * Please be aware that the id field is automatically added to all resources in Terraform providers using a Terraform provider SDK version below 2.
    * If you experience problems setting this value it might not be settable. Please take a look at the provider documentation to ensure it should be settable.
    */
    readonly id?: string;
    /**
    * Number of seconds between snapshots.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/vault/r/raft_snapshot_agent_config#interval_seconds RaftSnapshotAgentConfig#interval_seconds}
    */
    readonly intervalSeconds: number;
    /**
    * The maximum space, in bytes, to use for snapshots.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/vault/r/raft_snapshot_agent_config#local_max_space RaftSnapshotAgentConfig#local_max_space}
    */
    readonly localMaxSpace?: number;
    /**
    * Name of the snapshot agent configuration.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/vault/r/raft_snapshot_agent_config#name RaftSnapshotAgentConfig#name}
    */
    readonly name: string;
    /**
    * Target namespace. (requires Enterprise)
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/vault/r/raft_snapshot_agent_config#namespace RaftSnapshotAgentConfig#namespace}
    */
    readonly namespace?: string;
    /**
    * The directory or bucket prefix to to use.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/vault/r/raft_snapshot_agent_config#path_prefix RaftSnapshotAgentConfig#path_prefix}
    */
    readonly pathPrefix: string;
    /**
    * How many snapshots are to be kept.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/vault/r/raft_snapshot_agent_config#retain RaftSnapshotAgentConfig#retain}
    */
    readonly retain?: number;
    /**
    * What storage service to send snapshots to. One of "local", "azure-blob", "aws-s3", or "google-gcs".
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/vault/r/raft_snapshot_agent_config#storage_type RaftSnapshotAgentConfig#storage_type}
    */
    readonly storageType: string;
}
/**
* Represents a {@link https://www.terraform.io/docs/providers/vault/r/raft_snapshot_agent_config vault_raft_snapshot_agent_config}
*/
export declare class RaftSnapshotAgentConfig extends cdktf.TerraformResource {
    static readonly tfResourceType = "vault_raft_snapshot_agent_config";
    /**
    * Create a new {@link https://www.terraform.io/docs/providers/vault/r/raft_snapshot_agent_config vault_raft_snapshot_agent_config} Resource
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options RaftSnapshotAgentConfigConfig
    */
    constructor(scope: Construct, id: string, config: RaftSnapshotAgentConfigConfig);
    private _awsAccessKeyId?;
    get awsAccessKeyId(): string;
    set awsAccessKeyId(value: string);
    resetAwsAccessKeyId(): void;
    get awsAccessKeyIdInput(): string | undefined;
    private _awsS3Bucket?;
    get awsS3Bucket(): string;
    set awsS3Bucket(value: string);
    resetAwsS3Bucket(): void;
    get awsS3BucketInput(): string | undefined;
    private _awsS3DisableTls?;
    get awsS3DisableTls(): boolean | cdktf.IResolvable;
    set awsS3DisableTls(value: boolean | cdktf.IResolvable);
    resetAwsS3DisableTls(): void;
    get awsS3DisableTlsInput(): boolean | cdktf.IResolvable | undefined;
    private _awsS3EnableKms?;
    get awsS3EnableKms(): boolean | cdktf.IResolvable;
    set awsS3EnableKms(value: boolean | cdktf.IResolvable);
    resetAwsS3EnableKms(): void;
    get awsS3EnableKmsInput(): boolean | cdktf.IResolvable | undefined;
    private _awsS3Endpoint?;
    get awsS3Endpoint(): string;
    set awsS3Endpoint(value: string);
    resetAwsS3Endpoint(): void;
    get awsS3EndpointInput(): string | undefined;
    private _awsS3ForcePathStyle?;
    get awsS3ForcePathStyle(): boolean | cdktf.IResolvable;
    set awsS3ForcePathStyle(value: boolean | cdktf.IResolvable);
    resetAwsS3ForcePathStyle(): void;
    get awsS3ForcePathStyleInput(): boolean | cdktf.IResolvable | undefined;
    private _awsS3KmsKey?;
    get awsS3KmsKey(): string;
    set awsS3KmsKey(value: string);
    resetAwsS3KmsKey(): void;
    get awsS3KmsKeyInput(): string | undefined;
    private _awsS3Region?;
    get awsS3Region(): string;
    set awsS3Region(value: string);
    resetAwsS3Region(): void;
    get awsS3RegionInput(): string | undefined;
    private _awsS3ServerSideEncryption?;
    get awsS3ServerSideEncryption(): boolean | cdktf.IResolvable;
    set awsS3ServerSideEncryption(value: boolean | cdktf.IResolvable);
    resetAwsS3ServerSideEncryption(): void;
    get awsS3ServerSideEncryptionInput(): boolean | cdktf.IResolvable | undefined;
    private _awsSecretAccessKey?;
    get awsSecretAccessKey(): string;
    set awsSecretAccessKey(value: string);
    resetAwsSecretAccessKey(): void;
    get awsSecretAccessKeyInput(): string | undefined;
    private _awsSessionToken?;
    get awsSessionToken(): string;
    set awsSessionToken(value: string);
    resetAwsSessionToken(): void;
    get awsSessionTokenInput(): string | undefined;
    private _azureAccountKey?;
    get azureAccountKey(): string;
    set azureAccountKey(value: string);
    resetAzureAccountKey(): void;
    get azureAccountKeyInput(): string | undefined;
    private _azureAccountName?;
    get azureAccountName(): string;
    set azureAccountName(value: string);
    resetAzureAccountName(): void;
    get azureAccountNameInput(): string | undefined;
    private _azureBlobEnvironment?;
    get azureBlobEnvironment(): string;
    set azureBlobEnvironment(value: string);
    resetAzureBlobEnvironment(): void;
    get azureBlobEnvironmentInput(): string | undefined;
    private _azureContainerName?;
    get azureContainerName(): string;
    set azureContainerName(value: string);
    resetAzureContainerName(): void;
    get azureContainerNameInput(): string | undefined;
    private _azureEndpoint?;
    get azureEndpoint(): string;
    set azureEndpoint(value: string);
    resetAzureEndpoint(): void;
    get azureEndpointInput(): string | undefined;
    private _filePrefix?;
    get filePrefix(): string;
    set filePrefix(value: string);
    resetFilePrefix(): void;
    get filePrefixInput(): string | undefined;
    private _googleDisableTls?;
    get googleDisableTls(): boolean | cdktf.IResolvable;
    set googleDisableTls(value: boolean | cdktf.IResolvable);
    resetGoogleDisableTls(): void;
    get googleDisableTlsInput(): boolean | cdktf.IResolvable | undefined;
    private _googleEndpoint?;
    get googleEndpoint(): string;
    set googleEndpoint(value: string);
    resetGoogleEndpoint(): void;
    get googleEndpointInput(): string | undefined;
    private _googleGcsBucket?;
    get googleGcsBucket(): string;
    set googleGcsBucket(value: string);
    resetGoogleGcsBucket(): void;
    get googleGcsBucketInput(): string | undefined;
    private _googleServiceAccountKey?;
    get googleServiceAccountKey(): string;
    set googleServiceAccountKey(value: string);
    resetGoogleServiceAccountKey(): void;
    get googleServiceAccountKeyInput(): string | undefined;
    private _id?;
    get id(): string;
    set id(value: string);
    resetId(): void;
    get idInput(): string | undefined;
    private _intervalSeconds?;
    get intervalSeconds(): number;
    set intervalSeconds(value: number);
    get intervalSecondsInput(): number | undefined;
    private _localMaxSpace?;
    get localMaxSpace(): number;
    set localMaxSpace(value: number);
    resetLocalMaxSpace(): void;
    get localMaxSpaceInput(): number | undefined;
    private _name?;
    get name(): string;
    set name(value: string);
    get nameInput(): string | undefined;
    private _namespace?;
    get namespace(): string;
    set namespace(value: string);
    resetNamespace(): void;
    get namespaceInput(): string | undefined;
    private _pathPrefix?;
    get pathPrefix(): string;
    set pathPrefix(value: string);
    get pathPrefixInput(): string | undefined;
    private _retain?;
    get retain(): number;
    set retain(value: number);
    resetRetain(): void;
    get retainInput(): number | undefined;
    private _storageType?;
    get storageType(): string;
    set storageType(value: string);
    get storageTypeInput(): string | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
