# coding: utf-8

"""
    FreeClimb API

    FreeClimb is a cloud-based application programming interface (API) that puts the power of the Vail platform in your hands. FreeClimb simplifies the process of creating applications that can use a full range of telephony features without requiring specialized or on-site telephony equipment. Using the FreeClimb REST API to write applications is easy! You have the option to use the language of your choice or hit the API directly. Your application can execute a command by issuing a RESTful request to the FreeClimb API. The base URL to send HTTP requests to the FreeClimb REST API is: /apiserver. FreeClimb authenticates and processes your request.  # noqa: E501

    The version of the OpenAPI document: 1.0.0
    Contact: support@freeclimb.com
    Generated by: https://openapi-generator.tech
"""


import pprint
import re  # noqa: F401

import six

from freeclimb.configuration import Configuration


class ConferenceParticipantResultAllOf(object):
    """NOTE: This class is auto generated by OpenAPI Generator.
    Ref: https://openapi-generator.tech

    Do not edit the class manually.
    """

    """
    Attributes:
      openapi_types (dict): The key is attribute name
                            and the value is attribute type.
      attribute_map (dict): The key is attribute name
                            and the value is json key in definition.
    """
    openapi_types = {
        'account_id': 'str',
        'conference_id': 'str',
        'call_id': 'str',
        'talk': 'bool',
        'listen': 'bool',
        'start_conf_on_enter': 'bool'
    }

    attribute_map = {
        'account_id': 'accountId',
        'conference_id': 'conferenceId',
        'call_id': 'callId',
        'talk': 'talk',
        'listen': 'listen',
        'start_conf_on_enter': 'startConfOnEnter'
    }

    def __init__(self, account_id=None, conference_id=None, call_id=None, talk=None, listen=None, start_conf_on_enter=None, local_vars_configuration=None):  # noqa: E501
        """ConferenceParticipantResultAllOf - a model defined in OpenAPI"""  # noqa: E501
        if local_vars_configuration is None:
            local_vars_configuration = Configuration()
        self.local_vars_configuration = local_vars_configuration

        self._account_id = None
        self._conference_id = None
        self._call_id = None
        self._talk = None
        self._listen = None
        self._start_conf_on_enter = None
        self.discriminator = None

        if account_id is not None:
            self.account_id = account_id
        if conference_id is not None:
            self.conference_id = conference_id
        if call_id is not None:
            self.call_id = call_id
        if talk is not None:
            self.talk = talk
        if listen is not None:
            self.listen = listen
        if start_conf_on_enter is not None:
            self.start_conf_on_enter = start_conf_on_enter

    @property
    def account_id(self):
        """Gets the account_id of this ConferenceParticipantResultAllOf.  # noqa: E501

        ID of the account that created this participant.  # noqa: E501

        :return: The account_id of this ConferenceParticipantResultAllOf.  # noqa: E501
        :rtype: str
        """
        return self._account_id

    @account_id.setter
    def account_id(self, account_id):
        """Sets the account_id of this ConferenceParticipantResultAllOf.

        ID of the account that created this participant.  # noqa: E501

        :param account_id: The account_id of this ConferenceParticipantResultAllOf.  # noqa: E501
        :type: str
        """

        self._account_id = account_id

    @property
    def conference_id(self):
        """Gets the conference_id of this ConferenceParticipantResultAllOf.  # noqa: E501

        ID of the conference this participant is in.  # noqa: E501

        :return: The conference_id of this ConferenceParticipantResultAllOf.  # noqa: E501
        :rtype: str
        """
        return self._conference_id

    @conference_id.setter
    def conference_id(self, conference_id):
        """Sets the conference_id of this ConferenceParticipantResultAllOf.

        ID of the conference this participant is in.  # noqa: E501

        :param conference_id: The conference_id of this ConferenceParticipantResultAllOf.  # noqa: E501
        :type: str
        """

        self._conference_id = conference_id

    @property
    def call_id(self):
        """Gets the call_id of this ConferenceParticipantResultAllOf.  # noqa: E501

        ID of the Call associated with this Participant.  # noqa: E501

        :return: The call_id of this ConferenceParticipantResultAllOf.  # noqa: E501
        :rtype: str
        """
        return self._call_id

    @call_id.setter
    def call_id(self, call_id):
        """Sets the call_id of this ConferenceParticipantResultAllOf.

        ID of the Call associated with this Participant.  # noqa: E501

        :param call_id: The call_id of this ConferenceParticipantResultAllOf.  # noqa: E501
        :type: str
        """

        self._call_id = call_id

    @property
    def talk(self):
        """Gets the talk of this ConferenceParticipantResultAllOf.  # noqa: E501

        True if this Participant has talk privileges in the Conference. False otherwise.  # noqa: E501

        :return: The talk of this ConferenceParticipantResultAllOf.  # noqa: E501
        :rtype: bool
        """
        return self._talk

    @talk.setter
    def talk(self, talk):
        """Sets the talk of this ConferenceParticipantResultAllOf.

        True if this Participant has talk privileges in the Conference. False otherwise.  # noqa: E501

        :param talk: The talk of this ConferenceParticipantResultAllOf.  # noqa: E501
        :type: bool
        """

        self._talk = talk

    @property
    def listen(self):
        """Gets the listen of this ConferenceParticipantResultAllOf.  # noqa: E501

        True if this Participant has listen privileges in the Conference. False otherwise.  # noqa: E501

        :return: The listen of this ConferenceParticipantResultAllOf.  # noqa: E501
        :rtype: bool
        """
        return self._listen

    @listen.setter
    def listen(self, listen):
        """Sets the listen of this ConferenceParticipantResultAllOf.

        True if this Participant has listen privileges in the Conference. False otherwise.  # noqa: E501

        :param listen: The listen of this ConferenceParticipantResultAllOf.  # noqa: E501
        :type: bool
        """

        self._listen = listen

    @property
    def start_conf_on_enter(self):
        """Gets the start_conf_on_enter of this ConferenceParticipantResultAllOf.  # noqa: E501

        True if this Participant joining the Conference caused the Conference to start (status = inProgress). False otherwise.  # noqa: E501

        :return: The start_conf_on_enter of this ConferenceParticipantResultAllOf.  # noqa: E501
        :rtype: bool
        """
        return self._start_conf_on_enter

    @start_conf_on_enter.setter
    def start_conf_on_enter(self, start_conf_on_enter):
        """Sets the start_conf_on_enter of this ConferenceParticipantResultAllOf.

        True if this Participant joining the Conference caused the Conference to start (status = inProgress). False otherwise.  # noqa: E501

        :param start_conf_on_enter: The start_conf_on_enter of this ConferenceParticipantResultAllOf.  # noqa: E501
        :type: bool
        """

        self._start_conf_on_enter = start_conf_on_enter

    def to_dict(self):
        """Returns the model properties as a dict"""
        result = {}

        for attr, _ in six.iteritems(self.openapi_types):
            value = getattr(self, attr)
            attr = self.to_camel_case(attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            elif value is None:
                continue
            else:
                result[attr] = value

        return result

    def to_str(self):
        """Returns the string representation of the model"""
        return pprint.pformat(self.to_dict())

    def __repr__(self):
        """For `print` and `pprint`"""
        return self.to_str()

    def __eq__(self, other):
        """Returns true if both objects are equal"""
        if not isinstance(other, ConferenceParticipantResultAllOf):
            return False

        return self.to_dict() == other.to_dict()

    def __ne__(self, other):
        """Returns true if both objects are not equal"""
        if not isinstance(other, ConferenceParticipantResultAllOf):
            return True

        return self.to_dict() != other.to_dict()

    def to_camel_case(self, snake_str):
        components = snake_str.split('_')
        return components[0] + ''.join(x.title() for x in components[1:])
