import * as cdk from '@aws-cdk/core';
/**
 * Properties for defining a `AWS::SQS::Queue`
 *
 * @stability external
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sqs-queues.html
 */
export interface CfnQueueProps {
    /**
     * `AWS::SQS::Queue.ContentBasedDeduplication`
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sqs-queues.html#aws-sqs-queue-contentbaseddeduplication
     */
    readonly contentBasedDeduplication?: boolean | cdk.IResolvable;
    /**
     * `AWS::SQS::Queue.DelaySeconds`
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sqs-queues.html#aws-sqs-queue-delayseconds
     */
    readonly delaySeconds?: number;
    /**
     * `AWS::SQS::Queue.FifoQueue`
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sqs-queues.html#aws-sqs-queue-fifoqueue
     */
    readonly fifoQueue?: boolean | cdk.IResolvable;
    /**
     * `AWS::SQS::Queue.KmsDataKeyReusePeriodSeconds`
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sqs-queues.html#aws-sqs-queue-kmsdatakeyreuseperiodseconds
     */
    readonly kmsDataKeyReusePeriodSeconds?: number;
    /**
     * `AWS::SQS::Queue.KmsMasterKeyId`
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sqs-queues.html#aws-sqs-queue-kmsmasterkeyid
     */
    readonly kmsMasterKeyId?: string;
    /**
     * `AWS::SQS::Queue.MaximumMessageSize`
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sqs-queues.html#aws-sqs-queue-maxmesgsize
     */
    readonly maximumMessageSize?: number;
    /**
     * `AWS::SQS::Queue.MessageRetentionPeriod`
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sqs-queues.html#aws-sqs-queue-msgretentionperiod
     */
    readonly messageRetentionPeriod?: number;
    /**
     * `AWS::SQS::Queue.QueueName`
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sqs-queues.html#aws-sqs-queue-name
     */
    readonly queueName?: string;
    /**
     * `AWS::SQS::Queue.ReceiveMessageWaitTimeSeconds`
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sqs-queues.html#aws-sqs-queue-receivemsgwaittime
     */
    readonly receiveMessageWaitTimeSeconds?: number;
    /**
     * `AWS::SQS::Queue.RedrivePolicy`
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sqs-queues.html#aws-sqs-queue-redrive
     */
    readonly redrivePolicy?: any | cdk.IResolvable;
    /**
     * `AWS::SQS::Queue.Tags`
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sqs-queues.html#cfn-sqs-queue-tags
     */
    readonly tags?: cdk.CfnTag[];
    /**
     * `AWS::SQS::Queue.VisibilityTimeout`
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sqs-queues.html#aws-sqs-queue-visiblitytimeout
     */
    readonly visibilityTimeout?: number;
}
/**
 * A CloudFormation `AWS::SQS::Queue`
 *
 * @cloudformationResource AWS::SQS::Queue
 * @stability external
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sqs-queues.html
 */
export declare class CfnQueue extends cdk.CfnResource implements cdk.IInspectable {
    /**
     * The CloudFormation resource type name for this resource class.
     */
    static readonly CFN_RESOURCE_TYPE_NAME = "AWS::SQS::Queue";
    /**
     * A factory method that creates a new instance of this class from an object
     * containing the CloudFormation properties of this resource.
     * Used in the @aws-cdk/cloudformation-include module.
     *
     * @experimental
     */
    static fromCloudFormation(scope: cdk.Construct, id: string, resourceAttributes: any, options: cdk.FromCloudFormationOptions): CfnQueue;
    /**
     * @cloudformationAttribute Arn
     */
    readonly attrArn: string;
    /**
     * @cloudformationAttribute QueueName
     */
    readonly attrQueueName: string;
    /**
     * `AWS::SQS::Queue.ContentBasedDeduplication`
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sqs-queues.html#aws-sqs-queue-contentbaseddeduplication
     */
    contentBasedDeduplication: boolean | cdk.IResolvable | undefined;
    /**
     * `AWS::SQS::Queue.DelaySeconds`
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sqs-queues.html#aws-sqs-queue-delayseconds
     */
    delaySeconds: number | undefined;
    /**
     * `AWS::SQS::Queue.FifoQueue`
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sqs-queues.html#aws-sqs-queue-fifoqueue
     */
    fifoQueue: boolean | cdk.IResolvable | undefined;
    /**
     * `AWS::SQS::Queue.KmsDataKeyReusePeriodSeconds`
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sqs-queues.html#aws-sqs-queue-kmsdatakeyreuseperiodseconds
     */
    kmsDataKeyReusePeriodSeconds: number | undefined;
    /**
     * `AWS::SQS::Queue.KmsMasterKeyId`
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sqs-queues.html#aws-sqs-queue-kmsmasterkeyid
     */
    kmsMasterKeyId: string | undefined;
    /**
     * `AWS::SQS::Queue.MaximumMessageSize`
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sqs-queues.html#aws-sqs-queue-maxmesgsize
     */
    maximumMessageSize: number | undefined;
    /**
     * `AWS::SQS::Queue.MessageRetentionPeriod`
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sqs-queues.html#aws-sqs-queue-msgretentionperiod
     */
    messageRetentionPeriod: number | undefined;
    /**
     * `AWS::SQS::Queue.QueueName`
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sqs-queues.html#aws-sqs-queue-name
     */
    queueName: string | undefined;
    /**
     * `AWS::SQS::Queue.ReceiveMessageWaitTimeSeconds`
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sqs-queues.html#aws-sqs-queue-receivemsgwaittime
     */
    receiveMessageWaitTimeSeconds: number | undefined;
    /**
     * `AWS::SQS::Queue.RedrivePolicy`
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sqs-queues.html#aws-sqs-queue-redrive
     */
    redrivePolicy: any | cdk.IResolvable | undefined;
    /**
     * `AWS::SQS::Queue.Tags`
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sqs-queues.html#cfn-sqs-queue-tags
     */
    readonly tags: cdk.TagManager;
    /**
     * `AWS::SQS::Queue.VisibilityTimeout`
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sqs-queues.html#aws-sqs-queue-visiblitytimeout
     */
    visibilityTimeout: number | undefined;
    /**
     * Create a new `AWS::SQS::Queue`.
     *
     * @param scope - scope in which this resource is defined
     * @param id    - scoped id of the resource
     * @param props - resource properties
     */
    constructor(scope: cdk.Construct, id: string, props?: CfnQueueProps);
    /**
     * Examines the CloudFormation resource and discloses attributes.
     *
     * @param inspector - tree inspector to collect and process attributes
     *
     * @stability experimental
     */
    inspect(inspector: cdk.TreeInspector): void;
    protected get cfnProperties(): {
        [key: string]: any;
    };
    protected renderProperties(props: {
        [key: string]: any;
    }): {
        [key: string]: any;
    };
}
/**
 * Properties for defining a `AWS::SQS::QueuePolicy`
 *
 * @stability external
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sqs-policy.html
 */
export interface CfnQueuePolicyProps {
    /**
     * `AWS::SQS::QueuePolicy.PolicyDocument`
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sqs-policy.html#cfn-sqs-queuepolicy-policydoc
     */
    readonly policyDocument: any | cdk.IResolvable;
    /**
     * `AWS::SQS::QueuePolicy.Queues`
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sqs-policy.html#cfn-sqs-queuepolicy-queues
     */
    readonly queues: string[];
}
/**
 * A CloudFormation `AWS::SQS::QueuePolicy`
 *
 * @cloudformationResource AWS::SQS::QueuePolicy
 * @stability external
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sqs-policy.html
 */
export declare class CfnQueuePolicy extends cdk.CfnResource implements cdk.IInspectable {
    /**
     * The CloudFormation resource type name for this resource class.
     */
    static readonly CFN_RESOURCE_TYPE_NAME = "AWS::SQS::QueuePolicy";
    /**
     * A factory method that creates a new instance of this class from an object
     * containing the CloudFormation properties of this resource.
     * Used in the @aws-cdk/cloudformation-include module.
     *
     * @experimental
     */
    static fromCloudFormation(scope: cdk.Construct, id: string, resourceAttributes: any, options: cdk.FromCloudFormationOptions): CfnQueuePolicy;
    /**
     * `AWS::SQS::QueuePolicy.PolicyDocument`
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sqs-policy.html#cfn-sqs-queuepolicy-policydoc
     */
    policyDocument: any | cdk.IResolvable;
    /**
     * `AWS::SQS::QueuePolicy.Queues`
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sqs-policy.html#cfn-sqs-queuepolicy-queues
     */
    queues: string[];
    /**
     * Create a new `AWS::SQS::QueuePolicy`.
     *
     * @param scope - scope in which this resource is defined
     * @param id    - scoped id of the resource
     * @param props - resource properties
     */
    constructor(scope: cdk.Construct, id: string, props: CfnQueuePolicyProps);
    /**
     * Examines the CloudFormation resource and discloses attributes.
     *
     * @param inspector - tree inspector to collect and process attributes
     *
     * @stability experimental
     */
    inspect(inspector: cdk.TreeInspector): void;
    protected get cfnProperties(): {
        [key: string]: any;
    };
    protected renderProperties(props: {
        [key: string]: any;
    }): {
        [key: string]: any;
    };
}
