import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
/**
 * @stability stable
 */
export interface ResourceConfig extends cdktf.TerraformMetaArguments {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/null/r/resource.html#triggers Resource#triggers}.
     *
     * @stability stable
     */
    readonly triggers?: {
        [key: string]: string;
    };
}
/**
 * Represents a {@link https://www.terraform.io/docs/providers/null/r/resource.html null_resource}.
 *
 * @stability stable
 */
export declare class Resource extends cdktf.TerraformResource {
    /**
     * Create a new {@link https://www.terraform.io/docs/providers/null/r/resource.html null_resource} Resource.
     *
     * @param scope The scope in which to define this construct.
     * @param id The scoped construct ID.
     * @stability stable
     */
    constructor(scope: Construct, id: string, config?: ResourceConfig);
    /**
     * @stability stable
     */
    get id(): string;
    private _triggers?;
    /**
     * @stability stable
     */
    get triggers(): {
        [key: string]: string;
    };
    /**
     * @stability stable
     */
    set triggers(value: {
        [key: string]: string;
    });
    /**
     * @stability stable
     */
    resetTriggers(): void;
    /**
     * @stability stable
     */
    get triggersInput(): {
        [key: string]: string;
    } | undefined;
    /**
     * @stability stable
     */
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
