"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.SnsEventSource = void 0;
const jsiiDeprecationWarnings = require("../.warnings.jsii.js");
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const subs = require("@aws-cdk/aws-sns-subscriptions");
/**
 * Use an Amazon SNS topic as an event source for AWS Lambda.
 */
class SnsEventSource {
    constructor(topic, props) {
        this.topic = topic;
        jsiiDeprecationWarnings._aws_cdk_aws_lambda_event_sources_SnsEventSourceProps(props);
        this.props = props;
    }
    bind(target) {
        this.topic.addSubscription(new subs.LambdaSubscription(target, this.props));
    }
}
exports.SnsEventSource = SnsEventSource;
_a = JSII_RTTI_SYMBOL_1;
SnsEventSource[_a] = { fqn: "@aws-cdk/aws-lambda-event-sources.SnsEventSource", version: "1.149.0" };
//# sourceMappingURL=data:application/json;base64,eyJ2ZXJzaW9uIjozLCJmaWxlIjoic25zLmpzIiwic291cmNlUm9vdCI6IiIsInNvdXJjZXMiOlsic25zLnRzIl0sIm5hbWVzIjpbXSwibWFwcGluZ3MiOiI7Ozs7OztBQUVBLHVEQUF1RDtBQVF2RDs7R0FFRztBQUNILE1BQWEsY0FBYztJQUd6QixZQUFxQixLQUFpQixFQUFFLEtBQTJCO1FBQTlDLFVBQUssR0FBTCxLQUFLLENBQVk7O1FBQ3BDLElBQUksQ0FBQyxLQUFLLEdBQUcsS0FBSyxDQUFDO0tBQ3BCO0lBRU0sSUFBSSxDQUFDLE1BQXdCO1FBQ2xDLElBQUksQ0FBQyxLQUFLLENBQUMsZUFBZSxDQUFDLElBQUksSUFBSSxDQUFDLGtCQUFrQixDQUFDLE1BQU0sRUFBRSxJQUFJLENBQUMsS0FBSyxDQUFDLENBQUMsQ0FBQztLQUM3RTs7QUFUSCx3Q0FVQyIsInNvdXJjZXNDb250ZW50IjpbImltcG9ydCAqIGFzIGxhbWJkYSBmcm9tICdAYXdzLWNkay9hd3MtbGFtYmRhJztcbmltcG9ydCAqIGFzIHNucyBmcm9tICdAYXdzLWNkay9hd3Mtc25zJztcbmltcG9ydCAqIGFzIHN1YnMgZnJvbSAnQGF3cy1jZGsvYXdzLXNucy1zdWJzY3JpcHRpb25zJztcblxuLyoqXG4gKiBQcm9wZXJ0aWVzIGZvcndhcmRlZCB0byB0aGUgTGFtYmRhIFN1YnNjcmlwdGlvbi5cbiAqL1xuZXhwb3J0IGludGVyZmFjZSBTbnNFdmVudFNvdXJjZVByb3BzIGV4dGVuZHMgc3Vicy5MYW1iZGFTdWJzY3JpcHRpb25Qcm9wcyB7XG59XG5cbi8qKlxuICogVXNlIGFuIEFtYXpvbiBTTlMgdG9waWMgYXMgYW4gZXZlbnQgc291cmNlIGZvciBBV1MgTGFtYmRhLlxuICovXG5leHBvcnQgY2xhc3MgU25zRXZlbnRTb3VyY2UgaW1wbGVtZW50cyBsYW1iZGEuSUV2ZW50U291cmNlIHtcbiAgcHJpdmF0ZSByZWFkb25seSBwcm9wcz86IFNuc0V2ZW50U291cmNlUHJvcHM7XG5cbiAgY29uc3RydWN0b3IocmVhZG9ubHkgdG9waWM6IHNucy5JVG9waWMsIHByb3BzPzogU25zRXZlbnRTb3VyY2VQcm9wcykge1xuICAgIHRoaXMucHJvcHMgPSBwcm9wcztcbiAgfVxuXG4gIHB1YmxpYyBiaW5kKHRhcmdldDogbGFtYmRhLklGdW5jdGlvbikge1xuICAgIHRoaXMudG9waWMuYWRkU3Vic2NyaXB0aW9uKG5ldyBzdWJzLkxhbWJkYVN1YnNjcmlwdGlvbih0YXJnZXQsIHRoaXMucHJvcHMpKTtcbiAgfVxufVxuIl19