"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.Mechanicalturk = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const shared_1 = require("../shared");
/**
 * (experimental) Statement provider for service [mechanicalturk](https://docs.aws.amazon.com/service-authorization/latest/reference/list_amazonmechanicalturk.html).
 *
 * @experimental
 */
class Mechanicalturk extends shared_1.PolicyStatement {
    /**
     * (experimental) Statement provider for service [mechanicalturk](https://docs.aws.amazon.com/service-authorization/latest/reference/list_amazonmechanicalturk.html).
     *
     * @param sid [SID](https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_elements_sid.html) of the statement.
     * @experimental
     */
    constructor(sid) {
        super(sid);
        /**
         * (experimental) Holds the prefix of the service actions, e.g. `ec2`.
         *
         * @experimental
         */
        this.servicePrefix = 'mechanicalturk';
        /**
         * @experimental
         */
        this.accessLevelList = {
            "Write": [
                "AcceptQualificationRequest",
                "ApproveAssignment",
                "AssociateQualificationWithWorker",
                "CreateAdditionalAssignmentsForHIT",
                "CreateHIT",
                "CreateHITType",
                "CreateHITWithHITType",
                "CreateQualificationType",
                "CreateWorkerBlock",
                "DeleteHIT",
                "DeleteQualificationType",
                "DeleteWorkerBlock",
                "DisassociateQualificationFromWorker",
                "NotifyWorkers",
                "RejectAssignment",
                "RejectQualificationRequest",
                "SendBonus",
                "SendTestEventNotification",
                "UpdateExpirationForHIT",
                "UpdateHITReviewStatus",
                "UpdateHITTypeOfHIT",
                "UpdateNotificationSettings",
                "UpdateQualificationType"
            ],
            "Read": [
                "GetAccountBalance",
                "GetAssignment",
                "GetFileUploadURL",
                "GetHIT",
                "GetQualificationScore",
                "GetQualificationType"
            ],
            "List": [
                "ListAssignmentsForHIT",
                "ListBonusPayments",
                "ListHITs",
                "ListHITsForQualificationType",
                "ListQualificationRequests",
                "ListQualificationTypes",
                "ListReviewPolicyResultsForHIT",
                "ListReviewableHITs",
                "ListWorkerBlocks",
                "ListWorkersWithQualificationType"
            ]
        };
    }
    /**
     * (experimental) The AcceptQualificationRequest operation grants a Worker's request for a Qualification.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/AWSMechTurk/latest/AWSMturkAPI/ApiReference_AcceptQualificationRequestOperation.html
     *
     * @experimental
     */
    toAcceptQualificationRequest() {
        return this.to('AcceptQualificationRequest');
    }
    /**
     * (experimental) The ApproveAssignment operation approves the results of a completed assignment.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/AWSMechTurk/latest/AWSMturkAPI/ApiReference_ApproveAssignmentOperation.html
     *
     * @experimental
     */
    toApproveAssignment() {
        return this.to('ApproveAssignment');
    }
    /**
     * (experimental) The AssociateQualificationWithWorker operation gives a Worker a Qualification.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/AWSMechTurk/latest/AWSMturkAPI/ApiReference_AssociateQualificationWithWorkerOperation.html
     *
     * @experimental
     */
    toAssociateQualificationWithWorker() {
        return this.to('AssociateQualificationWithWorker');
    }
    /**
     * (experimental) The CreateAdditionalAssignmentsForHIT operation increases the maximum number of assignments of an existing HIT.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/AWSMechTurk/latest/AWSMturkAPI/ApiReference_CreateAdditionalAssignmentsForHITOperation.html
     *
     * @experimental
     */
    toCreateAdditionalAssignmentsForHIT() {
        return this.to('CreateAdditionalAssignmentsForHIT');
    }
    /**
     * (experimental) The CreateHIT operation creates a new HIT (Human Intelligence Task).
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/AWSMechTurk/latest/AWSMturkAPI/ApiReference_CreateHITOperation.html
     *
     * @experimental
     */
    toCreateHIT() {
        return this.to('CreateHIT');
    }
    /**
     * (experimental) The CreateHITType operation creates a new HIT type.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/AWSMechTurk/latest/AWSMturkAPI/ApiReference_CreateHITTypeOperation.html
     *
     * @experimental
     */
    toCreateHITType() {
        return this.to('CreateHITType');
    }
    /**
     * (experimental) The CreateHITWithHITType operation creates a new Human Intelligence Task (HIT) using an existing HITTypeID generated by the CreateHITType operation.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/AWSMechTurk/latest/AWSMturkAPI/ApiReference_CreateHITWithHITTypeOperation.html
     *
     * @experimental
     */
    toCreateHITWithHITType() {
        return this.to('CreateHITWithHITType');
    }
    /**
     * (experimental) The CreateQualificationType operation creates a new Qualification type, which is represented by a QualificationType data structure.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/AWSMechTurk/latest/AWSMturkAPI/ApiReference_CreateQualificationTypeOperation.html
     *
     * @experimental
     */
    toCreateQualificationType() {
        return this.to('CreateQualificationType');
    }
    /**
     * (experimental) The CreateWorkerBlock operation allows you to prevent a Worker from working on your HITs.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/AWSMechTurk/latest/AWSMturkAPI/ApiReference_CreateWorkerBlockOperation.html
     *
     * @experimental
     */
    toCreateWorkerBlock() {
        return this.to('CreateWorkerBlock');
    }
    /**
     * (experimental) The DeleteHIT operation disposes of a HIT that is no longer needed.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/AWSMechTurk/latest/AWSMturkAPI/ApiReference_DeleteHITOperation.html
     *
     * @experimental
     */
    toDeleteHIT() {
        return this.to('DeleteHIT');
    }
    /**
     * (experimental) The DeleteQualificationType disposes a Qualification type and disposes any HIT types that are associated with the Qualification type.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/AWSMechTurk/latest/AWSMturkAPI/ApiReference_DeleteQualificationTypeOperation.html
     *
     * @experimental
     */
    toDeleteQualificationType() {
        return this.to('DeleteQualificationType');
    }
    /**
     * (experimental) The DeleteWorkerBlock operation allows you to reinstate a blocked Worker to work on your HITs.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/AWSMechTurk/latest/AWSMturkAPI/ApiReference_DeleteWorkerBlockOperation.html
     *
     * @experimental
     */
    toDeleteWorkerBlock() {
        return this.to('DeleteWorkerBlock');
    }
    /**
     * (experimental) The DisassociateQualificationFromWorker revokes a previously granted Qualification from a user.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/AWSMechTurk/latest/AWSMturkAPI/ApiReference_DisassociateQualificationFromWorkerOperation.html
     *
     * @experimental
     */
    toDisassociateQualificationFromWorker() {
        return this.to('DisassociateQualificationFromWorker');
    }
    /**
     * (experimental) The GetAccountBalance operation retrieves the amount of money in your Amazon Mechanical Turk account.
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/AWSMechTurk/latest/AWSMturkAPI/ApiReference_GetAccountBalanceOperation.html
     *
     * @experimental
     */
    toGetAccountBalance() {
        return this.to('GetAccountBalance');
    }
    /**
     * (experimental) The GetAssignment retrieves an assignment with an AssignmentStatus value of Submitted, Approved, or Rejected, using the assignment's ID.
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/AWSMechTurk/latest/AWSMturkAPI/ApiReference_GetAssignmentOperation.html
     *
     * @experimental
     */
    toGetAssignment() {
        return this.to('GetAssignment');
    }
    /**
     * (experimental) The GetFileUploadURL operation generates and returns a temporary URL.
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/AWSMechTurk/latest/AWSMturkAPI/ApiReference_GetFileUploadURLOperation.html
     *
     * @experimental
     */
    toGetFileUploadURL() {
        return this.to('GetFileUploadURL');
    }
    /**
     * (experimental) The GetHIT operation retrieves the details of the specified HIT.
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/AWSMechTurk/latest/AWSMturkAPI/ApiReference_GetHITOperation.html
     *
     * @experimental
     */
    toGetHIT() {
        return this.to('GetHIT');
    }
    /**
     * (experimental) The GetQualificationScore operation returns the value of a Worker's Qualification for a given Qualification type.
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/AWSMechTurk/latest/AWSMturkAPI/ApiReference_GetQualificationScoreOperation.html
     *
     * @experimental
     */
    toGetQualificationScore() {
        return this.to('GetQualificationScore');
    }
    /**
     * (experimental) The GetQualificationType operation retrieves information about a Qualification type using its ID.
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/AWSMechTurk/latest/AWSMturkAPI/ApiReference_GetQualificationTypeOperation.html
     *
     * @experimental
     */
    toGetQualificationType() {
        return this.to('GetQualificationType');
    }
    /**
     * (experimental) The ListAssignmentsForHIT operation retrieves completed assignments for a HIT.
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/AWSMechTurk/latest/AWSMturkAPI/ApiReference_ListAssignmentsForHITOperation.html
     *
     * @experimental
     */
    toListAssignmentsForHIT() {
        return this.to('ListAssignmentsForHIT');
    }
    /**
     * (experimental) The ListBonusPayments operation retrieves the amounts of bonuses you have paid to Workers for a given HIT or assignment.
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/AWSMechTurk/latest/AWSMturkAPI/ApiReference_ListBonusPaymentsOperation.html
     *
     * @experimental
     */
    toListBonusPayments() {
        return this.to('ListBonusPayments');
    }
    /**
     * (experimental) The ListHITs operation returns all of a Requester's HITs.
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/AWSMechTurk/latest/AWSMturkAPI/ApiReference_ListHITsOperation.html
     *
     * @experimental
     */
    toListHITs() {
        return this.to('ListHITs');
    }
    /**
     * (experimental) The ListHITsForQualificationType operation returns the HITs that use the given QualififcationType for a QualificationRequirement.
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/AWSMechTurk/latest/AWSMturkAPI/ApiReference_ListHITsForQualificationTypeOperation.html
     *
     * @experimental
     */
    toListHITsForQualificationType() {
        return this.to('ListHITsForQualificationType');
    }
    /**
     * (experimental) The ListQualificationRequests operation retrieves requests for Qualifications of a particular Qualification type.
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/AWSMechTurk/latest/AWSMturkAPI/ApiReference_ListQualificationRequestsOperation.html
     *
     * @experimental
     */
    toListQualificationRequests() {
        return this.to('ListQualificationRequests');
    }
    /**
     * (experimental) The ListQualificationTypes operation searches for Qualification types using the specified search query, and returns a list of Qualification types.
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/AWSMechTurk/latest/AWSMturkAPI/ApiReference_ListQualificationTypesOperation.html
     *
     * @experimental
     */
    toListQualificationTypes() {
        return this.to('ListQualificationTypes');
    }
    /**
     * (experimental) The ListReviewPolicyResultsForHIT operation retrieves the computed results and the actions taken in the course of executing your Review Policies during a CreateHIT operation.
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/AWSMechTurk/latest/AWSMturkAPI/ApiReference_ListReviewPolicyResultsForHITOperation.html
     *
     * @experimental
     */
    toListReviewPolicyResultsForHIT() {
        return this.to('ListReviewPolicyResultsForHIT');
    }
    /**
     * (experimental) The ListReviewableHITs operation returns all of a Requester's HITs that have not been approved or rejected.
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/AWSMechTurk/latest/AWSMturkAPI/ApiReference_ListReviewableHITsOperation.html
     *
     * @experimental
     */
    toListReviewableHITs() {
        return this.to('ListReviewableHITs');
    }
    /**
     * (experimental) The ListWorkersBlocks operation retrieves a list of Workers who are blocked from working on your HITs.
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/AWSMechTurk/latest/AWSMturkAPI/ApiReference_ListWorkerBlocksOperation.html
     *
     * @experimental
     */
    toListWorkerBlocks() {
        return this.to('ListWorkerBlocks');
    }
    /**
     * (experimental) The ListWorkersWithQualificationType operation returns all of the Workers with a given Qualification type.
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/AWSMechTurk/latest/AWSMturkAPI/ApiReference_ListWorkersWithQualificationTypeOperation.html
     *
     * @experimental
     */
    toListWorkersWithQualificationType() {
        return this.to('ListWorkersWithQualificationType');
    }
    /**
     * (experimental) The NotifyWorkers operation sends an email to one or more Workers that you specify with the Worker ID.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/AWSMechTurk/latest/AWSMturkAPI/ApiReference_NotifyWorkersOperation.html
     *
     * @experimental
     */
    toNotifyWorkers() {
        return this.to('NotifyWorkers');
    }
    /**
     * (experimental) The RejectAssignment operation rejects the results of a completed assignment.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/AWSMechTurk/latest/AWSMturkAPI/ApiReference_RejectAssignmentOperation.html
     *
     * @experimental
     */
    toRejectAssignment() {
        return this.to('RejectAssignment');
    }
    /**
     * (experimental) The RejectQualificationRequest operation rejects a user's request for a Qualification.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/AWSMechTurk/latest/AWSMturkAPI/ApiReference_RejectQualificationRequestOperation.html
     *
     * @experimental
     */
    toRejectQualificationRequest() {
        return this.to('RejectQualificationRequest');
    }
    /**
     * (experimental) The SendBonus operation issues a payment of money from your account to a Worker.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/AWSMechTurk/latest/AWSMturkAPI/ApiReference_SendBonusOperation.html
     *
     * @experimental
     */
    toSendBonus() {
        return this.to('SendBonus');
    }
    /**
     * (experimental) The SendTestEventNotification operation causes Amazon Mechanical Turk to send a notification message as if a HIT event occurred, according to the provided notification specification.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/AWSMechTurk/latest/AWSMturkAPI/ApiReference_SendTestEventNotificationOperation.html
     *
     * @experimental
     */
    toSendTestEventNotification() {
        return this.to('SendTestEventNotification');
    }
    /**
     * (experimental) The UpdateExpirationForHIT operation allows you extend the expiration time of a HIT beyond is current expiration or expire a HIT immediately.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/AWSMechTurk/latest/AWSMturkAPI/ApiReference_UpdateExpirationForHITOperation.html
     *
     * @experimental
     */
    toUpdateExpirationForHIT() {
        return this.to('UpdateExpirationForHIT');
    }
    /**
     * (experimental) The UpdateHITReviewStatus operation toggles the status of a HIT.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/AWSMechTurk/latest/AWSMturkAPI/ApiReference_UpdateHITReviewStatusOperation.html
     *
     * @experimental
     */
    toUpdateHITReviewStatus() {
        return this.to('UpdateHITReviewStatus');
    }
    /**
     * (experimental) The UpdateHITTypeOfHIT operation allows you to change the HITType properties of a HIT.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/AWSMechTurk/latest/AWSMturkAPI/ApiReference_UpdateHITTypeOfHITOperation.html
     *
     * @experimental
     */
    toUpdateHITTypeOfHIT() {
        return this.to('UpdateHITTypeOfHIT');
    }
    /**
     * (experimental) The UpdateNotificationSettings operation creates, updates, disables or re-enables notifications for a HIT type.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/AWSMechTurk/latest/AWSMturkAPI/ApiReference_UpdateNotificationSettingsOperation.html
     *
     * @experimental
     */
    toUpdateNotificationSettings() {
        return this.to('UpdateNotificationSettings');
    }
    /**
     * (experimental) The UpdateQualificationType operation modifies the attributes of an existing Qualification type, which is represented by a QualificationType data structure.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/AWSMechTurk/latest/AWSMturkAPI/ApiReference_UpdateQualificationTypeOperation.html
     *
     * @experimental
     */
    toUpdateQualificationType() {
        return this.to('UpdateQualificationType');
    }
}
exports.Mechanicalturk = Mechanicalturk;
_a = JSII_RTTI_SYMBOL_1;
Mechanicalturk[_a] = { fqn: "iam-floyd.Mechanicalturk", version: "0.238.0" };
//# sourceMappingURL=data:application/json;base64,eyJ2ZXJzaW9uIjozLCJmaWxlIjoibWVjaGFuaWNhbHR1cmsuanMiLCJzb3VyY2VSb290IjoiIiwic291cmNlcyI6WyJtZWNoYW5pY2FsdHVyay50cyJdLCJuYW1lcyI6W10sIm1hcHBpbmdzIjoiOzs7OztBQUNBLHNDQUE0Qzs7Ozs7O0FBRzVDLE1BQWEsY0FBZSxTQUFRLHdCQUFlOzs7Ozs7O0lBSWpELFlBQWEsR0FBWTtRQUN2QixLQUFLLENBQUMsR0FBRyxDQUFDLENBQUM7Ozs7OztRQUpOLGtCQUFhLEdBQUcsZ0JBQWdCLENBQUM7Ozs7UUEwTTlCLG9CQUFlLEdBQW9CO1lBQzNDLE9BQU8sRUFBRTtnQkFDUCw0QkFBNEI7Z0JBQzVCLG1CQUFtQjtnQkFDbkIsa0NBQWtDO2dCQUNsQyxtQ0FBbUM7Z0JBQ25DLFdBQVc7Z0JBQ1gsZUFBZTtnQkFDZixzQkFBc0I7Z0JBQ3RCLHlCQUF5QjtnQkFDekIsbUJBQW1CO2dCQUNuQixXQUFXO2dCQUNYLHlCQUF5QjtnQkFDekIsbUJBQW1CO2dCQUNuQixxQ0FBcUM7Z0JBQ3JDLGVBQWU7Z0JBQ2Ysa0JBQWtCO2dCQUNsQiw0QkFBNEI7Z0JBQzVCLFdBQVc7Z0JBQ1gsMkJBQTJCO2dCQUMzQix3QkFBd0I7Z0JBQ3hCLHVCQUF1QjtnQkFDdkIsb0JBQW9CO2dCQUNwQiw0QkFBNEI7Z0JBQzVCLHlCQUF5QjthQUMxQjtZQUNELE1BQU0sRUFBRTtnQkFDTixtQkFBbUI7Z0JBQ25CLGVBQWU7Z0JBQ2Ysa0JBQWtCO2dCQUNsQixRQUFRO2dCQUNSLHVCQUF1QjtnQkFDdkIsc0JBQXNCO2FBQ3ZCO1lBQ0QsTUFBTSxFQUFFO2dCQUNOLHVCQUF1QjtnQkFDdkIsbUJBQW1CO2dCQUNuQixVQUFVO2dCQUNWLDhCQUE4QjtnQkFDOUIsMkJBQTJCO2dCQUMzQix3QkFBd0I7Z0JBQ3hCLCtCQUErQjtnQkFDL0Isb0JBQW9CO2dCQUNwQixrQkFBa0I7Z0JBQ2xCLGtDQUFrQzthQUNuQztTQUNGLENBQUM7SUFuUEYsQ0FBQzs7Ozs7Ozs7OztJQUdNLDRCQUE0QjtRQUNqQyxPQUFPLElBQUksQ0FBQyxFQUFFLENBQUMsNEJBQTRCLENBQUMsQ0FBQztJQUMvQyxDQUFDOzs7Ozs7Ozs7O0lBR00sbUJBQW1CO1FBQ3hCLE9BQU8sSUFBSSxDQUFDLEVBQUUsQ0FBQyxtQkFBbUIsQ0FBQyxDQUFDO0lBQ3RDLENBQUM7Ozs7Ozs7Ozs7SUFHTSxrQ0FBa0M7UUFDdkMsT0FBTyxJQUFJLENBQUMsRUFBRSxDQUFDLGtDQUFrQyxDQUFDLENBQUM7SUFDckQsQ0FBQzs7Ozs7Ozs7OztJQUdNLG1DQUFtQztRQUN4QyxPQUFPLElBQUksQ0FBQyxFQUFFLENBQUMsbUNBQW1DLENBQUMsQ0FBQztJQUN0RCxDQUFDOzs7Ozs7Ozs7O0lBR00sV0FBVztRQUNoQixPQUFPLElBQUksQ0FBQyxFQUFFLENBQUMsV0FBVyxDQUFDLENBQUM7SUFDOUIsQ0FBQzs7Ozs7Ozs7OztJQUdNLGVBQWU7UUFDcEIsT0FBTyxJQUFJLENBQUMsRUFBRSxDQUFDLGVBQWUsQ0FBQyxDQUFDO0lBQ2xDLENBQUM7Ozs7Ozs7Ozs7SUFHTSxzQkFBc0I7UUFDM0IsT0FBTyxJQUFJLENBQUMsRUFBRSxDQUFDLHNCQUFzQixDQUFDLENBQUM7SUFDekMsQ0FBQzs7Ozs7Ozs7OztJQUdNLHlCQUF5QjtRQUM5QixPQUFPLElBQUksQ0FBQyxFQUFFLENBQUMseUJBQXlCLENBQUMsQ0FBQztJQUM1QyxDQUFDOzs7Ozs7Ozs7O0lBR00sbUJBQW1CO1FBQ3hCLE9BQU8sSUFBSSxDQUFDLEVBQUUsQ0FBQyxtQkFBbUIsQ0FBQyxDQUFDO0lBQ3RDLENBQUM7Ozs7Ozs7Ozs7SUFHTSxXQUFXO1FBQ2hCLE9BQU8sSUFBSSxDQUFDLEVBQUUsQ0FBQyxXQUFXLENBQUMsQ0FBQztJQUM5QixDQUFDOzs7Ozs7Ozs7O0lBR00seUJBQXlCO1FBQzlCLE9BQU8sSUFBSSxDQUFDLEVBQUUsQ0FBQyx5QkFBeUIsQ0FBQyxDQUFDO0lBQzVDLENBQUM7Ozs7Ozs7Ozs7SUFHTSxtQkFBbUI7UUFDeEIsT0FBTyxJQUFJLENBQUMsRUFBRSxDQUFDLG1CQUFtQixDQUFDLENBQUM7SUFDdEMsQ0FBQzs7Ozs7Ozs7OztJQUdNLHFDQUFxQztRQUMxQyxPQUFPLElBQUksQ0FBQyxFQUFFLENBQUMscUNBQXFDLENBQUMsQ0FBQztJQUN4RCxDQUFDOzs7Ozs7Ozs7O0lBR00sbUJBQW1CO1FBQ3hCLE9BQU8sSUFBSSxDQUFDLEVBQUUsQ0FBQyxtQkFBbUIsQ0FBQyxDQUFDO0lBQ3RDLENBQUM7Ozs7Ozs7Ozs7SUFHTSxlQUFlO1FBQ3BCLE9BQU8sSUFBSSxDQUFDLEVBQUUsQ0FBQyxlQUFlLENBQUMsQ0FBQztJQUNsQyxDQUFDOzs7Ozs7Ozs7O0lBR00sa0JBQWtCO1FBQ3ZCLE9BQU8sSUFBSSxDQUFDLEVBQUUsQ0FBQyxrQkFBa0IsQ0FBQyxDQUFDO0lBQ3JDLENBQUM7Ozs7Ozs7Ozs7SUFHTSxRQUFRO1FBQ2IsT0FBTyxJQUFJLENBQUMsRUFBRSxDQUFDLFFBQVEsQ0FBQyxDQUFDO0lBQzNCLENBQUM7Ozs7Ozs7Ozs7SUFHTSx1QkFBdUI7UUFDNUIsT0FBTyxJQUFJLENBQUMsRUFBRSxDQUFDLHVCQUF1QixDQUFDLENBQUM7SUFDMUMsQ0FBQzs7Ozs7Ozs7OztJQUdNLHNCQUFzQjtRQUMzQixPQUFPLElBQUksQ0FBQyxFQUFFLENBQUMsc0JBQXNCLENBQUMsQ0FBQztJQUN6QyxDQUFDOzs7Ozs7Ozs7O0lBR00sdUJBQXVCO1FBQzVCLE9BQU8sSUFBSSxDQUFDLEVBQUUsQ0FBQyx1QkFBdUIsQ0FBQyxDQUFDO0lBQzFDLENBQUM7Ozs7Ozs7Ozs7SUFHTSxtQkFBbUI7UUFDeEIsT0FBTyxJQUFJLENBQUMsRUFBRSxDQUFDLG1CQUFtQixDQUFDLENBQUM7SUFDdEMsQ0FBQzs7Ozs7Ozs7OztJQUdNLFVBQVU7UUFDZixPQUFPLElBQUksQ0FBQyxFQUFFLENBQUMsVUFBVSxDQUFDLENBQUM7SUFDN0IsQ0FBQzs7Ozs7Ozs7OztJQUdNLDhCQUE4QjtRQUNuQyxPQUFPLElBQUksQ0FBQyxFQUFFLENBQUMsOEJBQThCLENBQUMsQ0FBQztJQUNqRCxDQUFDOzs7Ozs7Ozs7O0lBR00sMkJBQTJCO1FBQ2hDLE9BQU8sSUFBSSxDQUFDLEVBQUUsQ0FBQywyQkFBMkIsQ0FBQyxDQUFDO0lBQzlDLENBQUM7Ozs7Ozs7Ozs7SUFHTSx3QkFBd0I7UUFDN0IsT0FBTyxJQUFJLENBQUMsRUFBRSxDQUFDLHdCQUF3QixDQUFDLENBQUM7SUFDM0MsQ0FBQzs7Ozs7Ozs7OztJQUdNLCtCQUErQjtRQUNwQyxPQUFPLElBQUksQ0FBQyxFQUFFLENBQUMsK0JBQStCLENBQUMsQ0FBQztJQUNsRCxDQUFDOzs7Ozs7Ozs7O0lBR00sb0JBQW9CO1FBQ3pCLE9BQU8sSUFBSSxDQUFDLEVBQUUsQ0FBQyxvQkFBb0IsQ0FBQyxDQUFDO0lBQ3ZDLENBQUM7Ozs7Ozs7Ozs7SUFHTSxrQkFBa0I7UUFDdkIsT0FBTyxJQUFJLENBQUMsRUFBRSxDQUFDLGtCQUFrQixDQUFDLENBQUM7SUFDckMsQ0FBQzs7Ozs7Ozs7OztJQUdNLGtDQUFrQztRQUN2QyxPQUFPLElBQUksQ0FBQyxFQUFFLENBQUMsa0NBQWtDLENBQUMsQ0FBQztJQUNyRCxDQUFDOzs7Ozs7Ozs7O0lBR00sZUFBZTtRQUNwQixPQUFPLElBQUksQ0FBQyxFQUFFLENBQUMsZUFBZSxDQUFDLENBQUM7SUFDbEMsQ0FBQzs7Ozs7Ozs7OztJQUdNLGtCQUFrQjtRQUN2QixPQUFPLElBQUksQ0FBQyxFQUFFLENBQUMsa0JBQWtCLENBQUMsQ0FBQztJQUNyQyxDQUFDOzs7Ozs7Ozs7O0lBR00sNEJBQTRCO1FBQ2pDLE9BQU8sSUFBSSxDQUFDLEVBQUUsQ0FBQyw0QkFBNEIsQ0FBQyxDQUFDO0lBQy9DLENBQUM7Ozs7Ozs7Ozs7SUFHTSxXQUFXO1FBQ2hCLE9BQU8sSUFBSSxDQUFDLEVBQUUsQ0FBQyxXQUFXLENBQUMsQ0FBQztJQUM5QixDQUFDOzs7Ozs7Ozs7O0lBR00sMkJBQTJCO1FBQ2hDLE9BQU8sSUFBSSxDQUFDLEVBQUUsQ0FBQywyQkFBMkIsQ0FBQyxDQUFDO0lBQzlDLENBQUM7Ozs7Ozs7Ozs7SUFHTSx3QkFBd0I7UUFDN0IsT0FBTyxJQUFJLENBQUMsRUFBRSxDQUFDLHdCQUF3QixDQUFDLENBQUM7SUFDM0MsQ0FBQzs7Ozs7Ozs7OztJQUdNLHVCQUF1QjtRQUM1QixPQUFPLElBQUksQ0FBQyxFQUFFLENBQUMsdUJBQXVCLENBQUMsQ0FBQztJQUMxQyxDQUFDOzs7Ozs7Ozs7O0lBR00sb0JBQW9CO1FBQ3pCLE9BQU8sSUFBSSxDQUFDLEVBQUUsQ0FBQyxvQkFBb0IsQ0FBQyxDQUFDO0lBQ3ZDLENBQUM7Ozs7Ozs7Ozs7SUFHTSw0QkFBNEI7UUFDakMsT0FBTyxJQUFJLENBQUMsRUFBRSxDQUFDLDRCQUE0QixDQUFDLENBQUM7SUFDL0MsQ0FBQzs7Ozs7Ozs7OztJQUdNLHlCQUF5QjtRQUM5QixPQUFPLElBQUksQ0FBQyxFQUFFLENBQUMseUJBQXlCLENBQUMsQ0FBQztJQUM1QyxDQUFDOztBQXpNSCx3Q0EwUEMiLCJzb3VyY2VzQ29udGVudCI6WyJpbXBvcnQgeyBBY2Nlc3NMZXZlbExpc3QgfSBmcm9tIFwiLi4vc2hhcmVkL2FjY2Vzcy1sZXZlbFwiO1xuaW1wb3J0IHsgUG9saWN5U3RhdGVtZW50IH0gZnJvbSBcIi4uL3NoYXJlZFwiO1xuXG4gICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICBcbmV4cG9ydCBjbGFzcyBNZWNoYW5pY2FsdHVyayBleHRlbmRzIFBvbGljeVN0YXRlbWVudCB7XG4gIHB1YmxpYyBzZXJ2aWNlUHJlZml4ID0gJ21lY2hhbmljYWx0dXJrJztcblxuICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgIFxuICBjb25zdHJ1Y3RvciAoc2lkPzogc3RyaW5nKSB7XG4gICAgc3VwZXIoc2lkKTtcbiAgfVxuXG4gICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgXG4gIHB1YmxpYyB0b0FjY2VwdFF1YWxpZmljYXRpb25SZXF1ZXN0KCkge1xuICAgIHJldHVybiB0aGlzLnRvKCdBY2NlcHRRdWFsaWZpY2F0aW9uUmVxdWVzdCcpO1xuICB9XG5cbiAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgXG4gIHB1YmxpYyB0b0FwcHJvdmVBc3NpZ25tZW50KCkge1xuICAgIHJldHVybiB0aGlzLnRvKCdBcHByb3ZlQXNzaWdubWVudCcpO1xuICB9XG5cbiAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICBcbiAgcHVibGljIHRvQXNzb2NpYXRlUXVhbGlmaWNhdGlvbldpdGhXb3JrZXIoKSB7XG4gICAgcmV0dXJuIHRoaXMudG8oJ0Fzc29jaWF0ZVF1YWxpZmljYXRpb25XaXRoV29ya2VyJyk7XG4gIH1cblxuICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICBcbiAgcHVibGljIHRvQ3JlYXRlQWRkaXRpb25hbEFzc2lnbm1lbnRzRm9ySElUKCkge1xuICAgIHJldHVybiB0aGlzLnRvKCdDcmVhdGVBZGRpdGlvbmFsQXNzaWdubWVudHNGb3JISVQnKTtcbiAgfVxuXG4gICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgXG4gIHB1YmxpYyB0b0NyZWF0ZUhJVCgpIHtcbiAgICByZXR1cm4gdGhpcy50bygnQ3JlYXRlSElUJyk7XG4gIH1cblxuICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgXG4gIHB1YmxpYyB0b0NyZWF0ZUhJVFR5cGUoKSB7XG4gICAgcmV0dXJuIHRoaXMudG8oJ0NyZWF0ZUhJVFR5cGUnKTtcbiAgfVxuXG4gICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgIFxuICBwdWJsaWMgdG9DcmVhdGVISVRXaXRoSElUVHlwZSgpIHtcbiAgICByZXR1cm4gdGhpcy50bygnQ3JlYXRlSElUV2l0aEhJVFR5cGUnKTtcbiAgfVxuXG4gICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICBcbiAgcHVibGljIHRvQ3JlYXRlUXVhbGlmaWNhdGlvblR5cGUoKSB7XG4gICAgcmV0dXJuIHRoaXMudG8oJ0NyZWF0ZVF1YWxpZmljYXRpb25UeXBlJyk7XG4gIH1cblxuICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgXG4gIHB1YmxpYyB0b0NyZWF0ZVdvcmtlckJsb2NrKCkge1xuICAgIHJldHVybiB0aGlzLnRvKCdDcmVhdGVXb3JrZXJCbG9jaycpO1xuICB9XG5cbiAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgIFxuICBwdWJsaWMgdG9EZWxldGVISVQoKSB7XG4gICAgcmV0dXJuIHRoaXMudG8oJ0RlbGV0ZUhJVCcpO1xuICB9XG5cbiAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgXG4gIHB1YmxpYyB0b0RlbGV0ZVF1YWxpZmljYXRpb25UeXBlKCkge1xuICAgIHJldHVybiB0aGlzLnRvKCdEZWxldGVRdWFsaWZpY2F0aW9uVHlwZScpO1xuICB9XG5cbiAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgXG4gIHB1YmxpYyB0b0RlbGV0ZVdvcmtlckJsb2NrKCkge1xuICAgIHJldHVybiB0aGlzLnRvKCdEZWxldGVXb3JrZXJCbG9jaycpO1xuICB9XG5cbiAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgIFxuICBwdWJsaWMgdG9EaXNhc3NvY2lhdGVRdWFsaWZpY2F0aW9uRnJvbVdvcmtlcigpIHtcbiAgICByZXR1cm4gdGhpcy50bygnRGlzYXNzb2NpYXRlUXVhbGlmaWNhdGlvbkZyb21Xb3JrZXInKTtcbiAgfVxuXG4gICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgIFxuICBwdWJsaWMgdG9HZXRBY2NvdW50QmFsYW5jZSgpIHtcbiAgICByZXR1cm4gdGhpcy50bygnR2V0QWNjb3VudEJhbGFuY2UnKTtcbiAgfVxuXG4gICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICBcbiAgcHVibGljIHRvR2V0QXNzaWdubWVudCgpIHtcbiAgICByZXR1cm4gdGhpcy50bygnR2V0QXNzaWdubWVudCcpO1xuICB9XG5cbiAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgXG4gIHB1YmxpYyB0b0dldEZpbGVVcGxvYWRVUkwoKSB7XG4gICAgcmV0dXJuIHRoaXMudG8oJ0dldEZpbGVVcGxvYWRVUkwnKTtcbiAgfVxuXG4gICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgIFxuICBwdWJsaWMgdG9HZXRISVQoKSB7XG4gICAgcmV0dXJuIHRoaXMudG8oJ0dldEhJVCcpO1xuICB9XG5cbiAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgIFxuICBwdWJsaWMgdG9HZXRRdWFsaWZpY2F0aW9uU2NvcmUoKSB7XG4gICAgcmV0dXJuIHRoaXMudG8oJ0dldFF1YWxpZmljYXRpb25TY29yZScpO1xuICB9XG5cbiAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICBcbiAgcHVibGljIHRvR2V0UXVhbGlmaWNhdGlvblR5cGUoKSB7XG4gICAgcmV0dXJuIHRoaXMudG8oJ0dldFF1YWxpZmljYXRpb25UeXBlJyk7XG4gIH1cblxuICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgIFxuICBwdWJsaWMgdG9MaXN0QXNzaWdubWVudHNGb3JISVQoKSB7XG4gICAgcmV0dXJuIHRoaXMudG8oJ0xpc3RBc3NpZ25tZW50c0ZvckhJVCcpO1xuICB9XG5cbiAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgIFxuICBwdWJsaWMgdG9MaXN0Qm9udXNQYXltZW50cygpIHtcbiAgICByZXR1cm4gdGhpcy50bygnTGlzdEJvbnVzUGF5bWVudHMnKTtcbiAgfVxuXG4gICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICBcbiAgcHVibGljIHRvTGlzdEhJVHMoKSB7XG4gICAgcmV0dXJuIHRoaXMudG8oJ0xpc3RISVRzJyk7XG4gIH1cblxuICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICBcbiAgcHVibGljIHRvTGlzdEhJVHNGb3JRdWFsaWZpY2F0aW9uVHlwZSgpIHtcbiAgICByZXR1cm4gdGhpcy50bygnTGlzdEhJVHNGb3JRdWFsaWZpY2F0aW9uVHlwZScpO1xuICB9XG5cbiAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICBcbiAgcHVibGljIHRvTGlzdFF1YWxpZmljYXRpb25SZXF1ZXN0cygpIHtcbiAgICByZXR1cm4gdGhpcy50bygnTGlzdFF1YWxpZmljYXRpb25SZXF1ZXN0cycpO1xuICB9XG5cbiAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICBcbiAgcHVibGljIHRvTGlzdFF1YWxpZmljYXRpb25UeXBlcygpIHtcbiAgICByZXR1cm4gdGhpcy50bygnTGlzdFF1YWxpZmljYXRpb25UeXBlcycpO1xuICB9XG5cbiAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgIFxuICBwdWJsaWMgdG9MaXN0UmV2aWV3UG9saWN5UmVzdWx0c0ZvckhJVCgpIHtcbiAgICByZXR1cm4gdGhpcy50bygnTGlzdFJldmlld1BvbGljeVJlc3VsdHNGb3JISVQnKTtcbiAgfVxuXG4gICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICBcbiAgcHVibGljIHRvTGlzdFJldmlld2FibGVISVRzKCkge1xuICAgIHJldHVybiB0aGlzLnRvKCdMaXN0UmV2aWV3YWJsZUhJVHMnKTtcbiAgfVxuXG4gICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgIFxuICBwdWJsaWMgdG9MaXN0V29ya2VyQmxvY2tzKCkge1xuICAgIHJldHVybiB0aGlzLnRvKCdMaXN0V29ya2VyQmxvY2tzJyk7XG4gIH1cblxuICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgIFxuICBwdWJsaWMgdG9MaXN0V29ya2Vyc1dpdGhRdWFsaWZpY2F0aW9uVHlwZSgpIHtcbiAgICByZXR1cm4gdGhpcy50bygnTGlzdFdvcmtlcnNXaXRoUXVhbGlmaWNhdGlvblR5cGUnKTtcbiAgfVxuXG4gICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICBcbiAgcHVibGljIHRvTm90aWZ5V29ya2VycygpIHtcbiAgICByZXR1cm4gdGhpcy50bygnTm90aWZ5V29ya2VycycpO1xuICB9XG5cbiAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgXG4gIHB1YmxpYyB0b1JlamVjdEFzc2lnbm1lbnQoKSB7XG4gICAgcmV0dXJuIHRoaXMudG8oJ1JlamVjdEFzc2lnbm1lbnQnKTtcbiAgfVxuXG4gICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICBcbiAgcHVibGljIHRvUmVqZWN0UXVhbGlmaWNhdGlvblJlcXVlc3QoKSB7XG4gICAgcmV0dXJuIHRoaXMudG8oJ1JlamVjdFF1YWxpZmljYXRpb25SZXF1ZXN0Jyk7XG4gIH1cblxuICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgIFxuICBwdWJsaWMgdG9TZW5kQm9udXMoKSB7XG4gICAgcmV0dXJuIHRoaXMudG8oJ1NlbmRCb251cycpO1xuICB9XG5cbiAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgXG4gIHB1YmxpYyB0b1NlbmRUZXN0RXZlbnROb3RpZmljYXRpb24oKSB7XG4gICAgcmV0dXJuIHRoaXMudG8oJ1NlbmRUZXN0RXZlbnROb3RpZmljYXRpb24nKTtcbiAgfVxuXG4gICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICBcbiAgcHVibGljIHRvVXBkYXRlRXhwaXJhdGlvbkZvckhJVCgpIHtcbiAgICByZXR1cm4gdGhpcy50bygnVXBkYXRlRXhwaXJhdGlvbkZvckhJVCcpO1xuICB9XG5cbiAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgIFxuICBwdWJsaWMgdG9VcGRhdGVISVRSZXZpZXdTdGF0dXMoKSB7XG4gICAgcmV0dXJuIHRoaXMudG8oJ1VwZGF0ZUhJVFJldmlld1N0YXR1cycpO1xuICB9XG5cbiAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICBcbiAgcHVibGljIHRvVXBkYXRlSElUVHlwZU9mSElUKCkge1xuICAgIHJldHVybiB0aGlzLnRvKCdVcGRhdGVISVRUeXBlT2ZISVQnKTtcbiAgfVxuXG4gICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgXG4gIHB1YmxpYyB0b1VwZGF0ZU5vdGlmaWNhdGlvblNldHRpbmdzKCkge1xuICAgIHJldHVybiB0aGlzLnRvKCdVcGRhdGVOb3RpZmljYXRpb25TZXR0aW5ncycpO1xuICB9XG5cbiAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICBcbiAgcHVibGljIHRvVXBkYXRlUXVhbGlmaWNhdGlvblR5cGUoKSB7XG4gICAgcmV0dXJuIHRoaXMudG8oJ1VwZGF0ZVF1YWxpZmljYXRpb25UeXBlJyk7XG4gIH1cblxuICBwcm90ZWN0ZWQgYWNjZXNzTGV2ZWxMaXN0OiBBY2Nlc3NMZXZlbExpc3QgPSB7XG4gICAgXCJXcml0ZVwiOiBbXG4gICAgICBcIkFjY2VwdFF1YWxpZmljYXRpb25SZXF1ZXN0XCIsXG4gICAgICBcIkFwcHJvdmVBc3NpZ25tZW50XCIsXG4gICAgICBcIkFzc29jaWF0ZVF1YWxpZmljYXRpb25XaXRoV29ya2VyXCIsXG4gICAgICBcIkNyZWF0ZUFkZGl0aW9uYWxBc3NpZ25tZW50c0ZvckhJVFwiLFxuICAgICAgXCJDcmVhdGVISVRcIixcbiAgICAgIFwiQ3JlYXRlSElUVHlwZVwiLFxuICAgICAgXCJDcmVhdGVISVRXaXRoSElUVHlwZVwiLFxuICAgICAgXCJDcmVhdGVRdWFsaWZpY2F0aW9uVHlwZVwiLFxuICAgICAgXCJDcmVhdGVXb3JrZXJCbG9ja1wiLFxuICAgICAgXCJEZWxldGVISVRcIixcbiAgICAgIFwiRGVsZXRlUXVhbGlmaWNhdGlvblR5cGVcIixcbiAgICAgIFwiRGVsZXRlV29ya2VyQmxvY2tcIixcbiAgICAgIFwiRGlzYXNzb2NpYXRlUXVhbGlmaWNhdGlvbkZyb21Xb3JrZXJcIixcbiAgICAgIFwiTm90aWZ5V29ya2Vyc1wiLFxuICAgICAgXCJSZWplY3RBc3NpZ25tZW50XCIsXG4gICAgICBcIlJlamVjdFF1YWxpZmljYXRpb25SZXF1ZXN0XCIsXG4gICAgICBcIlNlbmRCb251c1wiLFxuICAgICAgXCJTZW5kVGVzdEV2ZW50Tm90aWZpY2F0aW9uXCIsXG4gICAgICBcIlVwZGF0ZUV4cGlyYXRpb25Gb3JISVRcIixcbiAgICAgIFwiVXBkYXRlSElUUmV2aWV3U3RhdHVzXCIsXG4gICAgICBcIlVwZGF0ZUhJVFR5cGVPZkhJVFwiLFxuICAgICAgXCJVcGRhdGVOb3RpZmljYXRpb25TZXR0aW5nc1wiLFxuICAgICAgXCJVcGRhdGVRdWFsaWZpY2F0aW9uVHlwZVwiXG4gICAgXSxcbiAgICBcIlJlYWRcIjogW1xuICAgICAgXCJHZXRBY2NvdW50QmFsYW5jZVwiLFxuICAgICAgXCJHZXRBc3NpZ25tZW50XCIsXG4gICAgICBcIkdldEZpbGVVcGxvYWRVUkxcIixcbiAgICAgIFwiR2V0SElUXCIsXG4gICAgICBcIkdldFF1YWxpZmljYXRpb25TY29yZVwiLFxuICAgICAgXCJHZXRRdWFsaWZpY2F0aW9uVHlwZVwiXG4gICAgXSxcbiAgICBcIkxpc3RcIjogW1xuICAgICAgXCJMaXN0QXNzaWdubWVudHNGb3JISVRcIixcbiAgICAgIFwiTGlzdEJvbnVzUGF5bWVudHNcIixcbiAgICAgIFwiTGlzdEhJVHNcIixcbiAgICAgIFwiTGlzdEhJVHNGb3JRdWFsaWZpY2F0aW9uVHlwZVwiLFxuICAgICAgXCJMaXN0UXVhbGlmaWNhdGlvblJlcXVlc3RzXCIsXG4gICAgICBcIkxpc3RRdWFsaWZpY2F0aW9uVHlwZXNcIixcbiAgICAgIFwiTGlzdFJldmlld1BvbGljeVJlc3VsdHNGb3JISVRcIixcbiAgICAgIFwiTGlzdFJldmlld2FibGVISVRzXCIsXG4gICAgICBcIkxpc3RXb3JrZXJCbG9ja3NcIixcbiAgICAgIFwiTGlzdFdvcmtlcnNXaXRoUXVhbGlmaWNhdGlvblR5cGVcIlxuICAgIF1cbiAgfTtcbn1cbiJdfQ==