# -*- coding: utf-8 -*-
from setuptools import setup

packages = \
['dbt_coves',
 'dbt_coves.config',
 'dbt_coves.core',
 'dbt_coves.tasks',
 'dbt_coves.tasks.dbt',
 'dbt_coves.tasks.extract',
 'dbt_coves.tasks.generate',
 'dbt_coves.tasks.load',
 'dbt_coves.tasks.setup',
 'dbt_coves.ui',
 'dbt_coves.utils']

package_data = \
{'': ['*'], 'dbt_coves': ['templates/*']}

install_requires = \
['Jinja2>2.11.2',
 'PyYAML>=5.4.1',
 'bumpversion>=0.6.0,<0.7.0',
 'click>=8.0.3,<9.0.0',
 'dbt-core==1.3.0',
 'luddite>=1.0.1,<2.0.0',
 'packaging>=20.8,<22.0',
 'pretty-errors>=1.2.19,<2.0.0',
 'pydantic>=1.8,<2.0',
 'pyfiglet>=0.8.post1,<0.9',
 'python-slugify<=7.0.0',
 'questionary>=1.9.0,<2.0.0',
 'rich>=10.4,<13.0',
 'yamlloader>=1.0.0,<2.0.0']

extras_require = \
{':python_version >= "3.7" and python_version < "4.0"': ['typing_extensions>=4.0,<5.0']}

entry_points = \
{'console_scripts': ['dbt-coves = dbt_coves.core.main:main']}

setup_kwargs = {
    'name': 'dbt-coves',
    'version': '1.3.0a18',
    'description': 'CLI tool for dbt users adopting analytics engineering best practices.',
    'long_description': '# dbt-coves\n\n[![Maintenance](https://img.shields.io/badge/Maintained%3F-yes-green.svg)](https://github.com/datacoves/dbt-coves/graphs/commit-activity)\n[![PyPI version\nfury.io](https://badge.fury.io/py/dbt-coves.svg)](https://pypi.python.org/pypi/dbt-coves/)\n[![Code\nStyle](https://img.shields.io/badge/code%20style-black-000000.svg)](https://github.com/ambv/black)\n[![Imports:\nisort](https://img.shields.io/badge/%20imports-isort-%231674b1?style=flat&labelColor=ef8336)](https://pycqa.github.io/isort/)\n[![Imports:\npython](https://img.shields.io/badge/python-3.8%20%7C%203.9-blue)](https://img.shields.io/badge/python-3.8%20%7C%203.9-blue)\n[![Build](https://github.com/datacoves/dbt-coves/actions/workflows/main_ci.yml/badge.svg)](https://github.com/datacoves/dbt-coves/actions/workflows/main_ci.yml/badge.svg)\n\n<!-- [![codecov](https://codecov.io/gh/datacoves/dbt-coves/branch/main/graph/badge.svg?token=JB0E0LZDW1)](https://codecov.io/gh/datacoves/dbt-coves) -->\n\n[![Maintainability](https://api.codeclimate.com/v1/badges/1e6a887de605ef8e0eca/maintainability)](https://codeclimate.com/github/datacoves/dbt-coves/maintainability)\n[![Downloads](https://pepy.tech/badge/dbt-coves)](https://pepy.tech/project/dbt-coves)\n\n## What is dbt-coves?\n\ndbt-coves is a CLI tool that automates certain tasks for [dbt](https://www.getdbt.com) making life simpler for the dbt user.\n\ndbt-coves generates dbt soruces and staging models and property(yml) files by analyzing information from the data warehouse and creating the necessary files (sql and yml).\n\nFinally, dbt-coves includes functionality to bootstrap a dbt project and to extract and load configurations from Airbyte.\n\n## Supported dbt versions\n\n| Version | Status           |\n| ------- | ---------------- |\n| \\< 1.0  | ❌ Not supported |\n| >= 1.0  | ✅ Tested        |\n\n## Supported adapters\n\n| Feature                           | Snowflake | Redshift       |\n| --------------------------------- | --------- | -------------- |\n| dbt project setup                 | ✅ Tested | 🕥 In progress |\n| source model (sql) generation     | ✅ Tested | 🕥 In progress |\n| model properties (yml) generation | ✅ Tested | 🕥 In progress |\n\nNOTE: Other database adapters may work, we have just not tested them. Feed free to try them and let us know if you test them we can update the table above.\n\n### Here\\\'s the tool in action\n\n[![image](https://cdn.loom.com/sessions/thumbnails/74062cf71cbe4898805ca508ea2d9455-1624905546029-with-play.gif)](https://www.loom.com/share/74062cf71cbe4898805ca508ea2d9455)\n\n# Installation\n\n```console\npip install dbt-coves\n```\n\nWe recommend using [python\nvirtualenvs](https://docs.python.org/3/tutorial/venv.html) and create\none separate environment per project.\n\n# Command Reference\n\nFor a complete list of options, please run:\n\n```console\ndbt-coves -h\ndbt-coves <command> -h\n```\n\n## Environment setup\n\nSetting up your environment can be done in two different ways:\n\nRuns a set of scripts in your local environment to configure your project components: `ssh keys`, `git` and `dbt`\n\n```console\ndbt-coves setup all\n```\n\nYou can configure individual components:\n\nSet up `git` repository of dbt-coves project\n\n```console\ndbt-coves setup git\n```\n\nSetup `dbt` within the project (delegates to dbt init)\n\n```console\ndbt-coves setup dbt\n```\n\nSet up SSH Keys for dbt project. Supports the argument `--open_ssl_public_key` which generates an extra Public Key in Open SSL format, useful for configuring certain providers (i.e. Snowflake authentication)\n\n```console\ndbt-coves setup ssh\n```\n\n## Models generation\n\n```console\ndbt-coves generate <resource>\n```\n\nWhere _\\<resource\\>_ could be _sources_, _properties_ or _metadata_.\n\n```console\ndbt-coves generate sources\n```\n\nThis command will generate the dbt source configuration as well as the initial dbt staging model(s). It will look in the database defined in your `profiles.yml` file or you can pass the `--database` argument or set up default configuration options (see below)\n\n```console\ndbt-coves generate sources --database raw\n```\n\nSupports Jinja templates to adjust how the resources are generated. See below for examples.\n\n### Source Generation Arguments\n\ndbt-coves can be used to create the initial staging models. It will do the following:\n\n1. Create / Update the source yml file\n2. Create the initial staging model(sql) file and offer to flatten VARIANT(JSON) fields\n3. Create the staging model\'s property(yml) file.\n\n`dbt-coves generate sources` supports the following args:\n\nSee full list in help\n\n```console\ndbt-coves generate sources -h\n```\n\n```console\n--database\n# Database to inspect\n```\n\n```console\n--schema\n# Schema to inspect\n```\n\n```console\n--select-relations\n# List of relations where raw data resides. The parameter must be enclosed in quotes. Accepts wildcards.\n```\n\n```console\n--exclude-relations\n# Filter relation(s) to exclude from source file(s) generation. The parameter must be enclosed in quotes. Accepts wildcards.\n```\n\n```console\n--sources-destination\n# Where sources yml files will be generated, default: \'models/staging/{{schema}}/sources.yml\'\n```\n\n```console\n--models-destination\n# Where models sql files will be generated, default: \'models/staging/{{schema}}/{{relation}}.sql\'\n```\n\n```console\n--model-props-destination\n# Where models yml files will be generated, default: \'models/staging/{{schema}}/{{relation}}.yml\'\n```\n\n```console\n--update-strategy\n# Action to perform when a property file already exists: \'update\', \'recreate\', \'fail\', \'ask\' (per file)\n```\n\n```console\n--templates-folder\n# Folder with jinja templates that override default sources generation templates, i.e. \'templates\'\n```\n\n```console\n--metadata\n# Path to csv file containing metadata, i.e. \'metadata.csv\'\n```\n\n### Properties Generation Arguments\n\nYou can use dbt-coves to generate and update the properties(yml) file for a given dbt model(sql) file.\n\n`dbt-coves generate properties` supports the following args:\n\n```console\n--destination\n# Where models yml files will be generated, default: \'{{model_folder_path}}/{{model_file_name}}.yml\'\n```\n\n```console\n--update-strategy\n# Action to perform when a property file already exists: \'update\', \'recreate\', \'fail\', \'ask\' (per file)\n```\n\n```console\n-s --select\n# Filter model(s) to generate property file(s)\n```\n\n```console\n--exclude\n# Filter model(s) to exclude from property file(s) generation\n```\n\n```console\n--selector\n# Specify dbt selector for more complex model filtering\n```\n\n```console\n--templates-folder\n# Folder with jinja templates that override default properties generation templates, i.e. \'templates\'\n```\n\n```console\n--metadata\n# Path to csv file containing metadata, i.e. \'metadata.csv\'\n```\n\nNote: `--select (or -s)`, `--exclude` and `--selector` work exactly as `dbt ls` selectors do. For usage details, visit [dbt list docs](https://docs.getdbt.com/reference/commands/list)\n\n### Metadata Generation Arguments\n\nYou can use dbt-coves to generate the metadata file(s) containing the basic structure of the csv that can be used in the above `dbt-coves generate sources/properties` commands.\nUsage of these metadata files can be found in [metadata](https://github.com/datacoves/dbt-coves#metadata) below.\n\n`dbt-coves generate metadata` supports the following args:\n\n```console\n--database\n# Database to inspect\n```\n\n```console\n--schemas\n# Comma separated list of schemas where raw data resides\n```\n\n```console\n--select-relations\n# List of relations where raw data resides. The parameter must be enclosed in quotes. Accepts wildcards.\n```\n\n```console\n--exclude-relations\n# Filter relation(s) to exclude from source file(s) generation. The parameter must be enclosed in quotes. Accepts wildcards.\n```\n\n```console\n--destination\n# Where csv file(s) will be generated, default: \'metadata.csv\'\n# Supports using the Jinja tags `{{relation}}` and `{{schema}}`\n# if creating one csv per relation/table in schema, i.e: "metadata/{{relation}}.csv"\n```\n\n### Metadata\n\ndbt-coves supports the argument `--metadata` which allows users to specify a csv file containing field types and descriptions to be used when creating the staging models and property files.\n\n```console\ndbt-coves generate sources --metadata metadata.csv\n```\n\nMetadata format:\nYou can download a [sample csv file](sample_metadata.csv) as reference\n\n| database | schema | relation                          | column          | key  | type    | description                                     |\n| -------- | ------ | --------------------------------- | --------------- | ---- | ------- | ----------------------------------------------- |\n| raw      | raw    | \\_airbyte_raw_country_populations | \\_airbyte_data  | Year | integer | Year of country population measurement          |\n| raw      | raw    | \\_airbyte_raw_country_populations | \\_airbyte_data  |      | variant | Airbyte data columns (VARIANT) in Snowflake     |\n| raw      | raw    | \\_airbyte_raw_country_populations | \\_airbyte_ab_id |      | varchar | Airbyte unique identifier used during data load |\n\n## Extract configuration from Airbyte\n\n```console\ndbt-coves extract airbyte\n```\n\nExtracts the configuration from your Airbyte sources, connections and destinations (excluding credentials) and stores it in the specified folder. The main goal of this feature is to keep track of the configuration changes in your git repo, and rollback to a specific version when needed.\n\nFull usage example:\n\n```console\ndbt-coves extract airbyte --host http://airbyte-server --port 8001 --path /config/workspace/load/airbyte\n```\n\n## Load configuration to Airbyte\n\n```console\ndbt-coves load airbyte\n```\n\nLoads the Airbyte configuration generated with `dbt-coves extract airbyte` on an Airbyte server. Secrets folder needs to be specified separately. You can use [git-secret](https://git-secret.io/) to encrypt secrets and make them part of your git repo.\n\n### Loading secrets\n\nSecret credentials can be approached in two different ways: locally or remotely (through a provider/manager).\n\nIn order to load encrypted fields locally:\n\n```console\ndbt-coves load airbyte --secrets-path /path/to/secret/directory\n\n# This directory must have \'sources\', \'destinations\' and \'connections\' folders nested inside, and inside them the respective JSON files with unencrypted fields.\n# Naming convention: JSON unencrypted secret files must be named exactly as the extracted ones.\n```\n\nTo load encrypted fields through a manager (in this case we are connecting to Datacoves\' Service Credentials):\n\n```console\n--secrets-manager datacoves\n```\n\n```console\n--secrets-url https://api.datacoves.localhost/service-credentials/airbyte\n```\n\n```console\n--secrets-token <secret token>\n```\n\nFull usage example:\n\n```console\ndbt-coves load airbyte --host http://airbyte-server --port 8001 --path /config/workspace/load/airbyte --secrets-path /config/workspace/secrets\n```\n\n## Extract configuration from Fivetran\n\n```console\ndbt-coves extract fivetran\n```\n\nExtracts the configuration from your Fivetran destinations and connectors (excluding credentials) and stores it in the specified folder. The main goal of this feature is to keep track of the configuration changes in your git repo, and rollback to a specific version when needed.\n\nFull usage example:\n\n```console\ndbt-coves extract fivetran --credentials /config/workspace/secrets/fivetran/credentials.yml --path /config/workspace/load/fivetran\n```\n\n## Load configuration to Fivetran\n\n```console\ndbt-coves load fivetran\n```\n\nLoads the Fivetran configuration generated with `dbt-coves extract fivetran` on a Fivetran instance. Secrets folder needs to be specified separately. You can use [git-secret](https://git-secret.io/) to encrypt secrets and make them part of your git repo.\n\n### Credentials\n\nIn order for extract/load fivetran to work properly, you need to provide an api key-secret pair (you can generate them [here](https://fivetran.com/account/settings/account)).\n\nThese credentials can be used with `--api-key [key] --api-secret [secret]`, or specyfing a YML file with `--credentials /path/to/credentials.yml`. The required structure of this file is the following:\n\n```yaml\naccount_name: # Any name, used by dbt-coves to ask which to use when more than one is found\n  api_key: [key]\n  api_secret: [secret]\naccount_name_2:\n  api_key: [key]\n  api_secret: [secret]\n```\n\nThis YML file approach allows you to both work with multiple Fivetran accounts, and treat this credentials file as a secret.\n\n> :warning: **Warning**: --api-key/secret and --credentials flags are mutually exclusive, don\'t use them together.\n\n### Loading secrets\n\nSecret credentials can be approached via `--secrets-path` flag\n\n```console\ndbt-coves load fivetran --secrets-path /path/to/secret/directory\n```\n\n#### Field naming convention\n\nAlthough secret files can have any name, unencrypted JSON files must follow a simple structure:\n\n- Keys should match their corresponding Fivetran destination ID: two words automatically generated by Fivetran, which can be found in previously extracted data.\n- Inside those keys, a nested dictionary of which fields should be overwritten\n\nFor example:\n\n```json\n{\n  "extract_muscle": {\n    // Internal ID that Fivetran gave to a Snowflake warehouse Destination\n    "password": "[PASSWORD]" // Field:Value pair\n  },\n  "centre_straighten": {\n    "password": "[PASSWORD]"\n  }\n}\n```\n\n## Run dbt commands\n\n```shell\ndbt-coves dbt <arguments> -- <command>\n```\n\nRun dbt commands on special environments such as Airflow, or CI workers, with the possibility of changing dbt project location and activating a specific virtual environment in which running commands.\n\n### Arguments\n\n`dbt-coves dbt` supports the following arguments\n\n```shell\n--project-dir\n# Path of the dbt project where command will be executed, i.e.: /opt/user/dbt_project\n```\n\n```shell\n--virtualenv\n# Virtual environment path. i.e.: /opt/user/virtualenvs/airflow\n```\n\n### Sample usage\n\n```shell\ndbt-coves dbt --project-dir /opt/user/dbt_project --virtualenv /opt/user/virtualenvs/airflow -- run -s model --vars \\"{key: value}\\"\n# Make sure to escape special characters such as quotation marks\n# Double dash (--) between <arguments> and <command> are mandatory\n```\n\n# Settings\n\ndbt-coves will read settings from `.dbt_coves/config.yml`. A standard settings files could look like\nthis:\n\n```yaml\ngenerate:\n  sources:\n    database: "RAW" # Database where to look for source tables\n    schemas: # List of schema names where to look for source tables\n      - RAW\n    select_relations: # list of relations where raw data resides\n      - TABLE_1\n      - TABLE_2\n    exclude_relations: # Filter relation(s) to exclude from source file(s) generation\n      - TABLE_1\n      - TABLE_2\n    sources_destination: "models/staging/{{schema}}/{{schema}}.yml" # Where sources yml files will be generated\n    models_destination: "models/staging/{{schema}}/{{relation}}.sql" # Where models sql files will be generated\n    model_props_destination: "models/staging/{{schema}}/{{relation}}.yml" # Where models yml files will be generated\n    update_strategy: ask # Action to perform when a property file already exists. Options: update, recreate, fail, ask (per file)\n    templates_folder: ".dbt_coves/templates" # Folder where source generation jinja templates are located. Override default templates creating  source_props.yml, source_model_props.yml, and source_model.sql under this folder\n    metadata: "metadata.csv" # Path to csv file containing metadata\n\n  properties:\n    destination: "{{model_folder_path}}/{{model_file_name}}.yml" # Where models yml files will be generated\n    # You can specify a different path by declaring it explicitly, i.e.: "models/staging/{{model_file_name}}.yml"\n    update-strategy: ask # Action to perform when a property file already exists. Options: update, recreate, fail, ask (per file)\n    select: "models/staging/bays" # Filter model(s) to generate property file(s)\n    exclude: "models/staging/bays/test_bay" # Filter model(s) to generate property file(s)\n    selector: "selectors/bay_selector.yml" # Specify dbt selector for more complex model filtering\n    templates_folder: ".dbt_coves/templates" # Folder where source generation jinja templates are located. Override default template creating model_props.yml under this folder\n    metadata: "metadata.csv" # Path to csv file containing metadata\n\n  metadata:\n    database: RAW # Database where to look for source tables\n    schemas: # List of schema names where to look for source tables\n      - RAW\n    select_relations: # list of relations where raw data resides\n      - TABLE_1\n      - TABLE_2\n    exclude_relations: # Filter relation(s) to exclude from source file(s) generation\n      - TABLE_1\n      - TABLE_2\n    destination: # Where metadata file will be generated, default: \'metadata.csv\'\n\nextract:\n  airbyte:\n    path: /config/workspace/load/airbyte # Where json files will be generated\n    host: http://airbyte-server # Airbyte\'s API hostname\n    port: 8001 # Airbyte\'s API port\n  fivetran:\n    path: /config/workspace/load/fivetran # Where Fivetran export will be generated\n    api_key: [KEY] # Fivetran API Key\n    api_secret: [SECRET] # Fivetran API Secret\n    credentials: /opt/fivetran_credentials.yml # Fivetran set of key:secret pairs\n    # \'api_key\' + \'api_secret\' are mutually exclusive with \'credentials\', use one or the other\n\nload:\n  airbyte:\n    path: /config/workspace/load\n    host: http://airbyte-server\n    port: 8001\n    secrets_manager: datacoves # (optional) Secret credentials provider (secrets_path OR secrets_manager should be used, can\'t load secrets locally and remotely at the same time)\n    secrets_path: /config/workspace/secrets # (optional) Secret files location if secrets_manager was not specified\n    secrets_url: https://api.datacoves.localhost/service-credentials/airbyte # Secrets url if secrets_manager is datacoves\n    secrets_token: <TOKEN> # Secrets auth token if secrets_manager is datacoves\n  fivetran:\n    path: /config/workspace/load/fivetran # Where previous Fivetran export resides, subject of import\n    api_key: [KEY] # Fivetran API Key\n    api_secret: [SECRET] # Fivetran API Secret\n    secrets_path: /config/workspace/secrets/fivetran # Fivetran secret fields\n    credentials: /opt/fivetran_credentials.yml # Fivetran set of key:secret pairs\n    # \'api_key\' + \'api_secret\' are mutually exclusive with \'credentials\', use one or the other\n```\n\n## Override generation templates\n\nCustomizing generated models and model properties requires placing\ntemplate files under the `.dbt-coves/templates` folder.\n\nThere are different variables available in the templates:\n\n- `adapter_name` refers to the Adapter\'s class name being used by the target, e.g. `SnowflakeAdapter` when using [Snowflake](https://github.com/dbt-labs/dbt-snowflake/blob/21b52127e7d221db8b92114aae066fb8a7151bba/dbt/adapters/snowflake/impl.py#L33).\n- `columns` contains the list of relation columns that don\'t contain nested (JSON) data, it\'s type is `List[Item]`.\n- `nested` contains a dict of nested columns, grouped by column name, it\'s type is `Dict[column_name, Dict[nested_key, Item]]`.\n\n`Item` is a `dict` with the keys `id`, `name`, `type`, and `description`, where `id` contains an slugified id generated from `name`.\n\n### dbt-coves generate sources\n\n#### Source property file (.yml) template\n\nThis file is used to create the sources yml file\n\n[source_props.yml](dbt_coves/templates/source_props.yml)\n\n#### Staging model file (.sql) template\n\nThis file is used to create the staging model (sql) files.\n\n[staging_model.sql](dbt_coves/templates/staging_model.sql)\n\n#### Staging model property file (.yml) template\n\nThis file is used to create the model properties (yml) file\n\n[staging_model_props.yml](dbt_coves/templates/staging_model_props.yml)\n\n### dbt-coves generate properties\n\nThis file is used to create the properties (yml) files for models\n\n[model_props.yml](dbt_coves/templates/model_props.yml)\n\n# Thanks\n\nThe project main structure was inspired by [dbt-sugar](https://github.com/bitpicky/dbt-sugar). Special thanks to [Bastien Boutonnet](https://github.com/bastienboutonnet) for the great work done.\n\n# Authors\n\n- Sebastian Sassi [\\@sebasuy](https://twitter.com/sebasuy) -- [Datacoves](https://datacoves.com/)\n- Noel Gomez [\\@noel_g](https://twitter.com/noel_g) -- [Datacoves](https://datacoves.com/)\n- Bruno Antonellini -- [Datacoves](https://datacoves.com/)\n\n# About\n\nLearn more about [Datacoves](https://datacoves.com).\n\n⚠️ **dbt-coves is still in development, make sure to test it for your dbt project version and DW before using in production and please submit any issues you find. We also welcome any contributions from the community**\n',
    'author': 'Datacoves',
    'author_email': 'hello@datacoves.com',
    'maintainer': 'None',
    'maintainer_email': 'None',
    'url': 'https://datacoves.com',
    'packages': packages,
    'package_data': package_data,
    'install_requires': install_requires,
    'extras_require': extras_require,
    'entry_points': entry_points,
    'python_requires': '>=3.7.2,<3.11',
}


setup(**setup_kwargs)
