[![Build Status](https://app.travis-ci.com/ToFuProject/tofu.svg?branch=devel)](https://app.travis-ci.com/ToFuProject/tofu)
[![Travis-CI](https://travis-ci.org/ToFuProject/tofu.svg?branch=master)](https://travis-ci.org/ToFuProject/tofu)
[![Conda]( https://anaconda.org/conda-forge/tofu/badges/version.svg)](https://anaconda.org/conda-forge/tofu)
[![](https://anaconda.org/conda-forge/tofu/badges/downloads.svg)](https://anaconda.org/conda-forge/tofu)
[![](https://anaconda.org/conda-forge/tofu/badges/latest_release_date.svg)](https://anaconda.org/conda-forge/tofu)
[![](https://anaconda.org/conda-forge/tofu/badges/platforms.svg)](https://anaconda.org/conda-forge/tofu)
[![](https://anaconda.org/conda-forge/tofu/badges/license.svg)](https://github.com/conda-forge/tofu/blob/master/LICENSE.txt)
[![](https://anaconda.org/conda-forge/tofu/badges/installer/conda.svg)](https://anaconda.org/conda-forge/tofu)
[![](https://codecov.io/gh/ToFuProject/tofu/branch/master/graph/badge.svg)](https://codecov.io/gh/ToFuProject/tofu)
[![](https://badge.fury.io/py/tofu.svg)](https://badge.fury.io/py/tofu)
[![Gitter](https://img.shields.io/gitter/room/ToFuProject/community?style=plastic)](https://gitter.im/ToFuProject/community)
[![PlamsaPy](https://img.shields.io/badge/Affiliated-PlasmaPy-ff2929?labelColor=435466&logo=data:image/png;base64,iVBORw0KGgoAAAANSUhEUgAAAA4AAAAOCAYAAAAfSC3RAAAAAXNSR0IArs4c6QAAAIRlWElmTU0AKgAAAAgABQESAAMAAAABAAEAAAEaAAUAAAABAAAASgEbAAUAAAABAAAAUgEoAAMAAAABAAIAAIdpAAQAAAABAAAAWgAAAAAAAADIAAAAAQAAAMgAAAABAAOgAQADAAAAAQABAACgAgAEAAAAAQAAAA6gAwAEAAAAAQAAAA4AAAAAnETOywAAAAlwSFlzAAAewgAAHsIBbtB1PgAAAVlpVFh0WE1MOmNvbS5hZG9iZS54bXAAAAAAADx4OnhtcG1ldGEgeG1sbnM6eD0iYWRvYmU6bnM6bWV0YS8iIHg6eG1wdGs9IlhNUCBDb3JlIDUuNC4wIj4KICAgPHJkZjpSREYgeG1sbnM6cmRmPSJodHRwOi8vd3d3LnczLm9yZy8xOTk5LzAyLzIyLXJkZi1zeW50YXgtbnMjIj4KICAgICAgPHJkZjpEZXNjcmlwdGlvbiByZGY6YWJvdXQ9IiIKICAgICAgICAgICAgeG1sbnM6dGlmZj0iaHR0cDovL25zLmFkb2JlLmNvbS90aWZmLzEuMC8iPgogICAgICAgICA8dGlmZjpPcmllbnRhdGlvbj4xPC90aWZmOk9yaWVudGF0aW9uPgogICAgICA8L3JkZjpEZXNjcmlwdGlvbj4KICAgPC9yZGY6UkRGPgo8L3g6eG1wbWV0YT4KTMInWQAAAjdJREFUKBVdkk9IVFEUxs99f6bXjDNS4TRvMiHQImsRpBCZEC5clLOKZtFOIdrmzmWroM0IuotAcOlshlwpGEFkuBAM+ycFiomODE6O49x58+a+e/vu2MjQg998591zzj33fvOI/j2KyGyJjWastTXXun6aQMEtMAOWwTvwUoXDSV2cyWTO0tTUmdNGJC39An0CDkAJ7IJ94EvG1qEJWliIP5ydvU5KMV1v4FcgcRfxNCiCTVAAR2Sab5lSr2Qi8Ywcp90Soqszm22coHmX541CTIT6oEaW9ZPa2uqIx467uy/S4WHcC4WunCe6jTWyMM2FdoE84Mo0TYrHi2xvr0Clkl4vrfX350jKvorj9OAEEawRQ+M16GtQVpZFzDA4+f4S3u3iyIi5Ojj4cbi3d2hAiHtcSo7G3ZqUE9oYDxTItn1Wr1cRz9xYXHSVlMPfHaeMTfoGOL/JcQ3GWASTRUelYujGI7AvXFdY29sfxnK5oQrRi06l1u5Xqwe+EK7HGMHEdjjqKMPYeT866mlX/5Bh/EDTLxhS3gyFHrhK5QS2L0vZUyO6QIxFUReBXoKbKxhEJ65KuRxEo8ckxO8ty1rBPdalUkkUn0Ox/qJM6FXs9c0Lgje6sfHnQ7+IZLLD3NjIb9n2dMLzPpuxWFhyTrgrLGQUcP7JZuzR13Tafzw3Z2pXsYzTE8V2xsfrlycnq6n5+XDetp+i6Q7MQFItraZSjUm6KZtOB3qq/tzQe/LoRDP+X1tzfwGubPWENrTteQAAAABJRU5ErkJggg==)](https://www.plasmapy.org/affiliates/)
[![PlamsaPy](https://img.shields.io/badge/Community-PlasmaPy-54bfbf?labelColor=435466&logo=data:image/png;base64,iVBORw0KGgoAAAANSUhEUgAAAA4AAAAOCAYAAAAfSC3RAAAAAXNSR0IArs4c6QAAAIRlWElmTU0AKgAAAAgABQESAAMAAAABAAEAAAEaAAUAAAABAAAASgEbAAUAAAABAAAAUgEoAAMAAAABAAIAAIdpAAQAAAABAAAAWgAAAAAAAADIAAAAAQAAAMgAAAABAAOgAQADAAAAAQABAACgAgAEAAAAAQAAAA6gAwAEAAAAAQAAAA4AAAAAnETOywAAAAlwSFlzAAAewgAAHsIBbtB1PgAAAVlpVFh0WE1MOmNvbS5hZG9iZS54bXAAAAAAADx4OnhtcG1ldGEgeG1sbnM6eD0iYWRvYmU6bnM6bWV0YS8iIHg6eG1wdGs9IlhNUCBDb3JlIDUuNC4wIj4KICAgPHJkZjpSREYgeG1sbnM6cmRmPSJodHRwOi8vd3d3LnczLm9yZy8xOTk5LzAyLzIyLXJkZi1zeW50YXgtbnMjIj4KICAgICAgPHJkZjpEZXNjcmlwdGlvbiByZGY6YWJvdXQ9IiIKICAgICAgICAgICAgeG1sbnM6dGlmZj0iaHR0cDovL25zLmFkb2JlLmNvbS90aWZmLzEuMC8iPgogICAgICAgICA8dGlmZjpPcmllbnRhdGlvbj4xPC90aWZmOk9yaWVudGF0aW9uPgogICAgICA8L3JkZjpEZXNjcmlwdGlvbj4KICAgPC9yZGY6UkRGPgo8L3g6eG1wbWV0YT4KTMInWQAAAjdJREFUKBVdkk9IVFEUxs99f6bXjDNS4TRvMiHQImsRpBCZEC5clLOKZtFOIdrmzmWroM0IuotAcOlshlwpGEFkuBAM+ycFiomODE6O49x58+a+e/vu2MjQg998591zzj33fvOI/j2KyGyJjWastTXXun6aQMEtMAOWwTvwUoXDSV2cyWTO0tTUmdNGJC39An0CDkAJ7IJ94EvG1qEJWliIP5ydvU5KMV1v4FcgcRfxNCiCTVAAR2Sab5lSr2Qi8Ywcp90Soqszm22coHmX541CTIT6oEaW9ZPa2uqIx467uy/S4WHcC4WunCe6jTWyMM2FdoE84Mo0TYrHi2xvr0Clkl4vrfX350jKvorj9OAEEawRQ+M16GtQVpZFzDA4+f4S3u3iyIi5Ojj4cbi3d2hAiHtcSo7G3ZqUE9oYDxTItn1Wr1cRz9xYXHSVlMPfHaeMTfoGOL/JcQ3GWASTRUelYujGI7AvXFdY29sfxnK5oQrRi06l1u5Xqwe+EK7HGMHEdjjqKMPYeT866mlX/5Bh/EDTLxhS3gyFHrhK5QS2L0vZUyO6QIxFUReBXoKbKxhEJ65KuRxEo8ckxO8ty1rBPdalUkkUn0Ox/qJM6FXs9c0Lgje6sfHnQ7+IZLLD3NjIb9n2dMLzPpuxWFhyTrgrLGQUcP7JZuzR13Tafzw3Z2pXsYzTE8V2xsfrlycnq6n5+XDetp+i6Q7MQFItraZSjUm6KZtOB3qq/tzQe/LoRDP+X1tzfwGubPWENrTteQAAAABJRU5ErkJggg==)](https://www.plasmapy.org/affiliates/)




tofu
====

**tofu** stands for **To**mography for **Fu**sion, it is an IMAS-compatible open-source machine-independent python library.

tofu tries to take an active part in the plasma community open-source python environment, like [PlasmaPy](https://github.com/PlasmaPy/PlasmaPy), with which some degree of interoperability is being implemented.

It aims at providing the **fusion** and **plasma** community with an object-oriented, transparent and documented tool for designing **tomography diagnostics**, computing **synthetic signal** (direct problem) as well as **tomographic inversions** (inverse problem). It gives access to a full 3D description of the diagnostic geometry, thus reducing the impact of geometrical approximations on the direct and, most importantly, on the inverse problem.

**tofu** is relevant for all diagnostics integrating, in a finitie field of view or along a set of lines of sight, a quantity (scalar or vector) for which the plasma can be considered transparent (e.g.: light in the visible, UV, soft and hard X-ray ranges, or electron density for interferometers).

**tofu** is **command-line oriented**, for maximum flexibility and scriptability.
The absence of a GUI is compensated by built-in one-liners for interactive plots.


It has a sphinx-generated [documentation](https://tofuproject.github.io/tofu/index.html), and the code itself is hosted on [GitHub](https://github.com/ToFuProject/tofu).



## Examples Gallery

Here are some examples of what **tofu** can do

#### Built-in one-liners for interactive camera geometry visualization
<p align="center">
<img align="middle" src="https://github.com/ToFuProject/tofu/blob/master/README_figures/CamLOS1D_touch.png" width="600" alt="Built-in one-liners for interactive camera geometry visualization"/>
</p>

#### ...both for 1D and 2D cameras, including the basics for multiple reflections handling
<p align="center">
<img align="middle" src="https://github.com/ToFuProject/tofu/blob/master/README_figures/CamLOS2D_touch_refelect.png" width="600" alt="...both for 1D and 2D cameras, including the basics for multiple reflections handling"/>
</p>

####    Built-in plotting of sinograms

<p align="center">
<img align="middle" src="https://github.com/ToFuProject/tofu/blob/master/README_figures/CamLOS1D_sino.png" width="600" alt="Built-in plotting of sinograms"/>
</p>

####    Basic magnetic field line tracing

<p align="center">
<img align="middle" src="https://github.com/ToFuProject/tofu/blob/master/README_figures/MagfieldLines.png" width="600" alt="Basic magnetic field line tracing"/>
</p>


####    Multiple 1d profiles interactive plotting
<p align="center">
<img align="middle" src="https://github.com/ToFuProject/tofu/blob/master/README_figures/Plasma2D_1dneTe.png" width="600" alt="Multiple 1d profiles interactive plotting"/>
</p>

####    Built-in basic data treatment and interactive plotting: svd and spectrograms
<p align="center">
<img align="middle" src="https://github.com/ToFuProject/tofu/blob/master/README_figures/Plasma2D_1dneTe.png" width="600" alt="Built-in basic data treatment and interactive plotting: svd and spectrograms"/>
</p>



**tofu** provides the user with a series of python classes for creating, handling and visualizing a diagnostic geometry, meshes and basis functions, 
geometry matrices, pre-treating experimental data and computing tomographic inversions.

Each one of these main tasks is accomplished by a dedicated module in the larger tofu package.

The geometry module is sufficient for diagnostic designing and for a synthetic diagnostic approach (i.e.: computing the integrated signal from a simulated 2D or 3D emissivity).
This geometry module allows in particular:

* To handle linear and toroidal vaccum vessels
* To define apertures and detectors as planar polygons of arbitrary shapes
* To automatically compute the full Volume of Sight (VOS) in 3D of each {detector+aperture(s)} set
* To discretise the VOS for a numerical 3D integration of a simulated emissivity in order to compute the associated signal

It is in this geometrical sense that tofu enables a synthetic diagnostic approach, it does not provide the tools for simulating the emissivity itself (that should be an input, provided by another code).


## IMAS-compatibility


IMAS is a standardized data structure, it comes as an extra layer on the database of any Tokamak to provide a machine-independent way of accessing scientific data.
tofu has built-in advanced classes for handling the interface with IMAS, hold in the imas2tofu sub-package.
It pre-supposes, of course, that IMAS is installed and operational next to your python install, but tofu does not require IMAS to run in general.
If IMAS is not available, tofu will simply display a warning stating that the imas2tofu sub-package is not usable.

tofu can thus easily load and handle multiple IDSs (IMAS data structure units) and provide command-line tools for exporting IMAS data to other general tofu classes (e.g.: Cameras, Plasma2D...) and for interactive plotting.
All tofu objects have methods to facailitate in-python-console introspection, the ``__repr__`` method is overloaded to display relevant information, an dthis is widely used to explore the data loaded from IMAS.

Do you want to use **tofu** on IMAS and don't know where to start?
[See our documetation.](https://tofuproject.github.io/tofu/installation.html#using-tofu-on-a-iter-cluster)

----


## Installing tofu

**From source** (compiled on your system using pip, all platforms)

   ``` pip install tofu ```

**From pre-compiled binaries** (using conda, all platforms)

   ``` conda install -c conda-forge tofu ```

**For Developers and other platforms**

Clone the git repository from github
[See our documentation.](https://tofuproject.github.io/tofu/installation.html)


## Licensing

It is distributed under the MIT license and aims at providing the fusion
community with a transparent and modular tool for creating / designing
diagnostics and using them for synthetic diagnostic (direct problem)
and tomography (inverse problem).

## History

It was first created at the Max-Planck Institute for Plasma Physics (IPP)
in Garching, Germany, by Didier Vezinet, and is now maintained, debugged
and updated by a team of contributors.


-----

**Warning**
This Pypi package focuses on tomography for fusion research.
It uses the same name as a previous package dedicated to a testing framework
coupling fixtures and tests loosely, now renamed **reahl-tofu** and developped
by Iwan Vosloo since 2006. If you ended up here looking for a web-oriented
library, you should probably redirect to the more recent
[**reahl-tofu**](https://pypi.python.org/pypi/reahl-tofu) page.
