# Generated by Django 4.0.3 on 2022-03-07 03:18

from django.conf import settings
from django.db import migrations, models
import django.db.models.deletion


class Migration(migrations.Migration):

    initial = True

    dependencies = [
        migrations.swappable_dependency(settings.AUTH_USER_MODEL),
    ]

    operations = [
        migrations.CreateModel(
            name='Survey',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('created_at', models.DateTimeField(auto_now_add=True)),
                ('updated_at', models.DateTimeField(auto_now=True)),
                ('name', models.CharField(max_length=200)),
                ('description', models.TextField(default='')),
                ('slug', models.SlugField(default='', max_length=225)),
            ],
            options={
                'abstract': False,
            },
        ),
        migrations.CreateModel(
            name='UserAnswer',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('created_at', models.DateTimeField(auto_now_add=True)),
                ('updated_at', models.DateTimeField(auto_now=True)),
                ('survey', models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, to='djf_surveys.survey')),
                ('user', models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, to=settings.AUTH_USER_MODEL)),
            ],
            options={
                'abstract': False,
            },
        ),
        migrations.CreateModel(
            name='Question',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('created_at', models.DateTimeField(auto_now_add=True)),
                ('updated_at', models.DateTimeField(auto_now=True)),
                ('label', models.CharField(help_text='Enter your question in here', max_length=200)),
                ('type_field', models.PositiveSmallIntegerField(choices=[(0, 'Text'), (1, 'Number'), (2, 'Radio'), (3, 'Select'), (4, 'Multi Select'), (5, 'Text Area'), (6, 'URL'), (7, 'Email'), (8, 'Date')])),
                ('choices', models.CharField(blank=True, help_text='if Type Field is (radio, select, multi select), fill in the option separated by commas. ex: Male, Female', max_length=200, null=True)),
                ('help_text', models.CharField(blank=True, help_text='You can add a help text in here', max_length=200, null=True)),
                ('required', models.BooleanField(default=True)),
                ('ordering', models.PositiveIntegerField(default=0)),
                ('survey', models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, related_name='questions', to='djf_surveys.survey')),
            ],
            options={
                'abstract': False,
            },
        ),
        migrations.CreateModel(
            name='Answer',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('created_at', models.DateTimeField(auto_now_add=True)),
                ('updated_at', models.DateTimeField(auto_now=True)),
                ('value', models.CharField(max_length=200)),
                ('question', models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, related_name='answers', to='djf_surveys.question')),
                ('user_answer', models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, to='djf_surveys.useranswer')),
            ],
            options={
                'abstract': False,
            },
        ),
    ]
