# mypy-boto3-dynamodb

[![PyPI - mypy-boto3-dynamodb](https://img.shields.io/pypi/v/mypy-boto3-dynamodb.svg?color=blue)](https://pypi.org/project/mypy-boto3-dynamodb)
[![PyPI - Python Version](https://img.shields.io/pypi/pyversions/mypy-boto3-dynamodb.svg?color=blue)](https://pypi.org/project/mypy-boto3-dynamodb)
[![Docs](https://img.shields.io/readthedocs/mypy-boto3-builder.svg?color=blue)](https://mypy-boto3-builder.readthedocs.io/)

Type annotations for
[boto3.DynamoDB 1.12.37](https://boto3.amazonaws.com/v1/documentation/api/1.12.37/reference/services/dynamodb.html#DynamoDB) service
compatible with [mypy](https://github.com/python/mypy), [VSCode](https://code.visualstudio.com/),
[PyCharm](https://www.jetbrains.com/pycharm/) and other tools.

Generated by [mypy-boto3-buider 1.0.6](https://github.com/vemel/mypy_boto3_builder).

More information can be found on [boto3-stubs](https://pypi.org/project/boto3-stubs/) page.

- [mypy-boto3-dynamodb](#mypy-boto3-dynamodb)
  - [How to use](#how-to-use)
    - [Type checking](#type-checking)
  - [How it works](#how-it-works)

## How to use

### Type checking

Make sure you have [mypy](https://github.com/python/mypy) installed and activated in your IDE.

Install `boto3-stubs` for `DynamoDB` service.

```bash
python -m pip install boto3-stubs[mypy-boto3-dynamodb]
```

Use `boto3` with `mypy_boto3` in your project and enjoy type checking and auto-complete.

```python
import boto3

from mypy_boto3 import dynamodb
# alternative import if you do not want to install mypy_boto3 package
# import mypy_boto3_dynamodb as dynamodb

# Use this client as usual, now mypy can check if your code is valid.
# Check if your IDE supports function overloads,
# you probably do not need explicit type annotations
# client = boto3.client("dynamodb")
client: dynamodb.DynamoDBClient = boto3.client("dynamodb")

# works for session as well
session = boto3.session.Session(region="us-west-1")
session_client: dynamodb.DynamoDBClient = session.client("dynamodb")

# Do you prefer resource approach? We've got you covered!
resource: dynamodb.DynamoDBServiceResource = boto3.resource("dynamodb")

# Waiters need type annotation on creation
table_exists_waiter: dynamodb.TableExistsWaiter = client.get_waiter("table_exists")
table_not_exists_waiter: dynamodb.TableNotExistsWaiter = client.get_waiter("table_not_exists")

# Paginators need type annotation on creation
list_backups_paginator: dynamodb.ListBackupsPaginator = client.get_paginator("list_backups")
list_tables_paginator: dynamodb.ListTablesPaginator = client.get_paginator("list_tables")
list_tags_of_resource_paginator: dynamodb.ListTagsOfResourcePaginator = client.get_paginator("list_tags_of_resource")
query_paginator: dynamodb.QueryPaginator = client.get_paginator("query")
scan_paginator: dynamodb.ScanPaginator = client.get_paginator("scan")
```

## How it works

Fully automated [builder](https://github.com/vemel/mypy_boto3_builder) carefully generates
type annotations for each service, patiently waiting for `boto3` updates. It delivers
a drop-in type annotations for you and makes sure that:

- All available `boto3` services are covered.
- Each public class and method of every `boto3` service gets valid type annotations
  extracted from the documentation (blame `botocore` docs if types are incorrect).
- Type annotations include up-to-date documentation.
- Link to documentation is provided for every method.
- Code is processed by [black](https://github.com/psf/black) for readability.