# File generated from our OpenAPI spec by Stainless. See CONTRIBUTING.md for details.

from __future__ import annotations

import httpx

from ..._types import NOT_GIVEN, Body, Query, Headers, NotGiven
from ..._utils import maybe_transform
from ..._compat import cached_property
from ..._resource import SyncAPIResource, AsyncAPIResource
from ..._response import (
    to_raw_response_wrapper,
    to_streamed_response_wrapper,
    async_to_raw_response_wrapper,
    async_to_streamed_response_wrapper,
)
from ...pagination import (
    SyncPageOffset,
    AsyncPageOffset,
    SyncPageOffsetTotalCount,
    AsyncPageOffsetTotalCount,
    SyncPageOffsetNoStartField,
    AsyncPageOffsetNoStartField,
)
from ..._base_client import AsyncPaginator, make_request_options
from ...types.my_model import MyModel
from ...types.pagination_tests import (
    offset_list_params,
    offset_with_total_count_params,
    offset_list_no_start_field_params,
)

__all__ = ["OffsetResource", "AsyncOffsetResource"]


class OffsetResource(SyncAPIResource):
    @cached_property
    def with_raw_response(self) -> OffsetResourceWithRawResponse:
        return OffsetResourceWithRawResponse(self)

    @cached_property
    def with_streaming_response(self) -> OffsetResourceWithStreamingResponse:
        return OffsetResourceWithStreamingResponse(self)

    def list(
        self,
        *,
        limit: int | NotGiven = NOT_GIVEN,
        offset: int | NotGiven = NOT_GIVEN,
        # Use the following arguments if you need to pass additional parameters to the API that aren't available via kwargs.
        # The extra values given here take precedence over values defined on the client or passed to this method.
        extra_headers: Headers | None = None,
        extra_query: Query | None = None,
        extra_body: Body | None = None,
        timeout: float | httpx.Timeout | None | NotGiven = NOT_GIVEN,
    ) -> SyncPageOffset[MyModel]:
        """
        Test case for offset pagination

        Args:
          extra_headers: Send extra headers

          extra_query: Add additional query parameters to the request

          extra_body: Add additional JSON properties to the request

          timeout: Override the client-level default timeout for this request, in seconds
        """
        return self._get_api_list(
            "/paginated/offset",
            page=SyncPageOffset[MyModel],
            options=make_request_options(
                extra_headers=extra_headers,
                extra_query=extra_query,
                extra_body=extra_body,
                timeout=timeout,
                query=maybe_transform(
                    {
                        "limit": limit,
                        "offset": offset,
                    },
                    offset_list_params.OffsetListParams,
                ),
            ),
            model=MyModel,
        )

    def list_no_start_field(
        self,
        *,
        limit: int | NotGiven = NOT_GIVEN,
        offset: int | NotGiven = NOT_GIVEN,
        # Use the following arguments if you need to pass additional parameters to the API that aren't available via kwargs.
        # The extra values given here take precedence over values defined on the client or passed to this method.
        extra_headers: Headers | None = None,
        extra_query: Query | None = None,
        extra_body: Body | None = None,
        timeout: float | httpx.Timeout | None | NotGiven = NOT_GIVEN,
    ) -> SyncPageOffsetNoStartField[MyModel]:
        """
        Test case for offset pagination with no start response field

        Args:
          extra_headers: Send extra headers

          extra_query: Add additional query parameters to the request

          extra_body: Add additional JSON properties to the request

          timeout: Override the client-level default timeout for this request, in seconds
        """
        return self._get_api_list(
            "/paginated/offset/no_start_field",
            page=SyncPageOffsetNoStartField[MyModel],
            options=make_request_options(
                extra_headers=extra_headers,
                extra_query=extra_query,
                extra_body=extra_body,
                timeout=timeout,
                query=maybe_transform(
                    {
                        "limit": limit,
                        "offset": offset,
                    },
                    offset_list_no_start_field_params.OffsetListNoStartFieldParams,
                ),
            ),
            model=MyModel,
        )

    def with_total_count(
        self,
        *,
        limit: int | NotGiven = NOT_GIVEN,
        offset: int | NotGiven = NOT_GIVEN,
        # Use the following arguments if you need to pass additional parameters to the API that aren't available via kwargs.
        # The extra values given here take precedence over values defined on the client or passed to this method.
        extra_headers: Headers | None = None,
        extra_query: Query | None = None,
        extra_body: Body | None = None,
        timeout: float | httpx.Timeout | None | NotGiven = NOT_GIVEN,
    ) -> SyncPageOffsetTotalCount[MyModel]:
        """
        Test case for offset pagination with a total count response property

        Args:
          extra_headers: Send extra headers

          extra_query: Add additional query parameters to the request

          extra_body: Add additional JSON properties to the request

          timeout: Override the client-level default timeout for this request, in seconds
        """
        return self._get_api_list(
            "/paginated/offset/with_total_count",
            page=SyncPageOffsetTotalCount[MyModel],
            options=make_request_options(
                extra_headers=extra_headers,
                extra_query=extra_query,
                extra_body=extra_body,
                timeout=timeout,
                query=maybe_transform(
                    {
                        "limit": limit,
                        "offset": offset,
                    },
                    offset_with_total_count_params.OffsetWithTotalCountParams,
                ),
            ),
            model=MyModel,
        )


class AsyncOffsetResource(AsyncAPIResource):
    @cached_property
    def with_raw_response(self) -> AsyncOffsetResourceWithRawResponse:
        return AsyncOffsetResourceWithRawResponse(self)

    @cached_property
    def with_streaming_response(self) -> AsyncOffsetResourceWithStreamingResponse:
        return AsyncOffsetResourceWithStreamingResponse(self)

    def list(
        self,
        *,
        limit: int | NotGiven = NOT_GIVEN,
        offset: int | NotGiven = NOT_GIVEN,
        # Use the following arguments if you need to pass additional parameters to the API that aren't available via kwargs.
        # The extra values given here take precedence over values defined on the client or passed to this method.
        extra_headers: Headers | None = None,
        extra_query: Query | None = None,
        extra_body: Body | None = None,
        timeout: float | httpx.Timeout | None | NotGiven = NOT_GIVEN,
    ) -> AsyncPaginator[MyModel, AsyncPageOffset[MyModel]]:
        """
        Test case for offset pagination

        Args:
          extra_headers: Send extra headers

          extra_query: Add additional query parameters to the request

          extra_body: Add additional JSON properties to the request

          timeout: Override the client-level default timeout for this request, in seconds
        """
        return self._get_api_list(
            "/paginated/offset",
            page=AsyncPageOffset[MyModel],
            options=make_request_options(
                extra_headers=extra_headers,
                extra_query=extra_query,
                extra_body=extra_body,
                timeout=timeout,
                query=maybe_transform(
                    {
                        "limit": limit,
                        "offset": offset,
                    },
                    offset_list_params.OffsetListParams,
                ),
            ),
            model=MyModel,
        )

    def list_no_start_field(
        self,
        *,
        limit: int | NotGiven = NOT_GIVEN,
        offset: int | NotGiven = NOT_GIVEN,
        # Use the following arguments if you need to pass additional parameters to the API that aren't available via kwargs.
        # The extra values given here take precedence over values defined on the client or passed to this method.
        extra_headers: Headers | None = None,
        extra_query: Query | None = None,
        extra_body: Body | None = None,
        timeout: float | httpx.Timeout | None | NotGiven = NOT_GIVEN,
    ) -> AsyncPaginator[MyModel, AsyncPageOffsetNoStartField[MyModel]]:
        """
        Test case for offset pagination with no start response field

        Args:
          extra_headers: Send extra headers

          extra_query: Add additional query parameters to the request

          extra_body: Add additional JSON properties to the request

          timeout: Override the client-level default timeout for this request, in seconds
        """
        return self._get_api_list(
            "/paginated/offset/no_start_field",
            page=AsyncPageOffsetNoStartField[MyModel],
            options=make_request_options(
                extra_headers=extra_headers,
                extra_query=extra_query,
                extra_body=extra_body,
                timeout=timeout,
                query=maybe_transform(
                    {
                        "limit": limit,
                        "offset": offset,
                    },
                    offset_list_no_start_field_params.OffsetListNoStartFieldParams,
                ),
            ),
            model=MyModel,
        )

    def with_total_count(
        self,
        *,
        limit: int | NotGiven = NOT_GIVEN,
        offset: int | NotGiven = NOT_GIVEN,
        # Use the following arguments if you need to pass additional parameters to the API that aren't available via kwargs.
        # The extra values given here take precedence over values defined on the client or passed to this method.
        extra_headers: Headers | None = None,
        extra_query: Query | None = None,
        extra_body: Body | None = None,
        timeout: float | httpx.Timeout | None | NotGiven = NOT_GIVEN,
    ) -> AsyncPaginator[MyModel, AsyncPageOffsetTotalCount[MyModel]]:
        """
        Test case for offset pagination with a total count response property

        Args:
          extra_headers: Send extra headers

          extra_query: Add additional query parameters to the request

          extra_body: Add additional JSON properties to the request

          timeout: Override the client-level default timeout for this request, in seconds
        """
        return self._get_api_list(
            "/paginated/offset/with_total_count",
            page=AsyncPageOffsetTotalCount[MyModel],
            options=make_request_options(
                extra_headers=extra_headers,
                extra_query=extra_query,
                extra_body=extra_body,
                timeout=timeout,
                query=maybe_transform(
                    {
                        "limit": limit,
                        "offset": offset,
                    },
                    offset_with_total_count_params.OffsetWithTotalCountParams,
                ),
            ),
            model=MyModel,
        )


class OffsetResourceWithRawResponse:
    def __init__(self, offset: OffsetResource) -> None:
        self._offset = offset

        self.list = to_raw_response_wrapper(
            offset.list,
        )
        self.list_no_start_field = to_raw_response_wrapper(
            offset.list_no_start_field,
        )
        self.with_total_count = to_raw_response_wrapper(
            offset.with_total_count,
        )


class AsyncOffsetResourceWithRawResponse:
    def __init__(self, offset: AsyncOffsetResource) -> None:
        self._offset = offset

        self.list = async_to_raw_response_wrapper(
            offset.list,
        )
        self.list_no_start_field = async_to_raw_response_wrapper(
            offset.list_no_start_field,
        )
        self.with_total_count = async_to_raw_response_wrapper(
            offset.with_total_count,
        )


class OffsetResourceWithStreamingResponse:
    def __init__(self, offset: OffsetResource) -> None:
        self._offset = offset

        self.list = to_streamed_response_wrapper(
            offset.list,
        )
        self.list_no_start_field = to_streamed_response_wrapper(
            offset.list_no_start_field,
        )
        self.with_total_count = to_streamed_response_wrapper(
            offset.with_total_count,
        )


class AsyncOffsetResourceWithStreamingResponse:
    def __init__(self, offset: AsyncOffsetResource) -> None:
        self._offset = offset

        self.list = async_to_streamed_response_wrapper(
            offset.list,
        )
        self.list_no_start_field = async_to_streamed_response_wrapper(
            offset.list_no_start_field,
        )
        self.with_total_count = async_to_streamed_response_wrapper(
            offset.with_total_count,
        )
