# File generated from our OpenAPI spec by Stainless. See CONTRIBUTING.md for details.

from __future__ import annotations

import os
from typing import Any, cast

import pytest

from tests.utils import assert_matches_type
from sink.api.sdk import Sink, AsyncSink
from sink.api.sdk.types.names.reserved_names.public import Class

base_url = os.environ.get("TEST_API_BASE_URL", "http://127.0.0.1:4010")


class TestClass:
    parametrize = pytest.mark.parametrize("client", [False, True], indirect=True, ids=["loose", "strict"])

    @parametrize
    def test_method_class(self, client: Sink) -> None:
        class_ = client.names.reserved_names.public.class_.class_()
        assert_matches_type(Class, class_, path=["response"])

    @parametrize
    def test_raw_response_class(self, client: Sink) -> None:
        response = client.names.reserved_names.public.class_.with_raw_response.class_()

        assert response.is_closed is True
        class_ = response.parse()
        assert_matches_type(Class, class_, path=["response"])

    @parametrize
    def test_streaming_response_class(self, client: Sink) -> None:
        with client.names.reserved_names.public.class_.with_streaming_response.class_() as response:
            assert not response.is_closed

            class_ = response.parse()
            assert_matches_type(Class, class_, path=["response"])

        assert cast(Any, response.is_closed) is True


class TestAsyncClass:
    parametrize = pytest.mark.parametrize("async_client", [False, True], indirect=True, ids=["loose", "strict"])

    @parametrize
    async def test_method_class(self, async_client: AsyncSink) -> None:
        class_ = await async_client.names.reserved_names.public.class_.class_()
        assert_matches_type(Class, class_, path=["response"])

    @parametrize
    async def test_raw_response_class(self, async_client: AsyncSink) -> None:
        response = await async_client.names.reserved_names.public.class_.with_raw_response.class_()

        assert response.is_closed is True
        class_ = await response.parse()
        assert_matches_type(Class, class_, path=["response"])

    @parametrize
    async def test_streaming_response_class(self, async_client: AsyncSink) -> None:
        async with async_client.names.reserved_names.public.class_.with_streaming_response.class_() as response:
            assert not response.is_closed

            class_ = await response.parse()
            assert_matches_type(Class, class_, path=["response"])

        assert cast(Any, response.is_closed) is True
