/*
* Copyright © 2020 Contrast Security, Inc.
* See https://www.contrastsecurity.com/enduser-terms-0317a for more details.
*/
/* THIS FILE WAS AUTOMATICALLY GENERATED BY HOOKSPY */
/* Python requires its own header to always be included first */
#define PY_SSIZE_T_CLEAN
#include <Python.h>

#include <contrast/assess/propagate.h>
#include <contrast/assess/scope.h>
#include <contrast/assess/utils.h>

typedef PyObject *(*fastcall_func)(PyObject *, PyObject *const *, Py_ssize_t);
typedef PyObject *(*fastcall_kwargs_func)(PyObject *, PyObject *const *, Py_ssize_t, PyObject *);

#define BYTEARRAY_DECODE_OFFSET 7
#define BYTEARRAY_REPLACE_OFFSET 29
#define BYTEARRAY_SPLIT_OFFSET 37
#define BYTEARRAY_RSPLIT_OFFSET 35
#define BYTEARRAY_JOIN_OFFSET 22
#define BYTEARRAY_CAPITALIZE_OFFSET 4
#define BYTEARRAY_TITLE_OFFSET 42
#define BYTEARRAY_CENTER_OFFSET 5
#define BYTEARRAY_EXPANDTABS_OFFSET 9
#define BYTEARRAY_PARTITION_OFFSET 26
#define BYTEARRAY_LJUST_OFFSET 23
#define BYTEARRAY_LOWER_OFFSET 24
#define BYTEARRAY_LSTRIP_OFFSET 25
#define BYTEARRAY_RJUST_OFFSET 33
#define BYTEARRAY_RSTRIP_OFFSET 36
#define BYTEARRAY_RPARTITION_OFFSET 34
#define BYTEARRAY_SPLITLINES_OFFSET 38
#define BYTEARRAY_STRIP_OFFSET 40
#define BYTEARRAY_SWAPCASE_OFFSET 41
#define BYTEARRAY_TRANSLATE_OFFSET 43
#define BYTEARRAY_UPPER_OFFSET 44
#define BYTEARRAY_ZFILL_OFFSET 45


ternaryfunc bytearray_decode_orig;
binaryfunc bytearray_replace_orig;
binaryfunc bytearray_split_orig;
binaryfunc bytearray_rsplit_orig;
binaryfunc bytearray_join_orig;
unaryfunc bytearray_capitalize_orig;
unaryfunc bytearray_title_orig;
binaryfunc bytearray_center_orig;
binaryfunc bytearray_expandtabs_orig;
binaryfunc bytearray_partition_orig;
binaryfunc bytearray_ljust_orig;
unaryfunc bytearray_lower_orig;
binaryfunc bytearray_lstrip_orig;
binaryfunc bytearray_rjust_orig;
binaryfunc bytearray_rstrip_orig;
binaryfunc bytearray_rpartition_orig;
binaryfunc bytearray_splitlines_orig;
binaryfunc bytearray_strip_orig;
unaryfunc bytearray_swapcase_orig;
binaryfunc bytearray_translate_orig;
unaryfunc bytearray_upper_orig;
binaryfunc bytearray_zfill_orig;
initproc bytearray_init_orig;


HOOK_TERNARYFUNC(bytearray_decode, "decode");
HOOK_BINARYFUNC(bytearray_replace, "replace");
HOOK_BINARYFUNC(bytearray_split, "split");
HOOK_BINARYFUNC(bytearray_rsplit, "rsplit");
PyObject *bytearray_join_new(PyObject *self, PyObject *args) {
    PyObject *list = PySequence_List(args);

    enter_propagation_scope();

    /* If this fails for any reason, just call the original function and get
     * out of here.
     */
    if (list == NULL) {
        PyErr_Clear();
        return bytearray_join_orig((PyObject *)self, args);
    }

    /* In Py36+ we also hook an internal function that is called by this
     * function in order to propagate fstring formatting. We still want to have
     * a separate hook for join so that the events are reported differently.
     * This means that we need to go into scope when calling the original
     * function here so that we don't propagate twice.
     */
    PyObject *result = bytearray_join_orig((PyObject *)self, list);
    exit_propagation_scope();

    PyObject *prop_args = PyTuple_Pack(1, list);

    if (prop_args == NULL || result == NULL)
        goto cleanup_and_exit;

    propagate_result("join", (PyObject *)self, result, prop_args, NULL);

cleanup_and_exit:
    Py_XDECREF(list);
    Py_XDECREF(prop_args);
    return result;

}

HOOK_UNARYFUNC(bytearray_capitalize, "capitalize");
HOOK_UNARYFUNC(bytearray_title, "title");
HOOK_BINARYFUNC(bytearray_center, "center");
HOOK_BINARYFUNC(bytearray_expandtabs, "expandtabs");
HOOK_BINARYFUNC(bytearray_partition, "partition");
HOOK_BINARYFUNC(bytearray_ljust, "ljust");
HOOK_UNARYFUNC(bytearray_lower, "lower");
HOOK_BINARYFUNC(bytearray_lstrip, "lstrip");
HOOK_BINARYFUNC(bytearray_rjust, "rjust");
HOOK_BINARYFUNC(bytearray_rstrip, "rstrip");
HOOK_BINARYFUNC(bytearray_rpartition, "rpartition");
HOOK_BINARYFUNC(bytearray_splitlines, "splitlines");
HOOK_BINARYFUNC(bytearray_strip, "strip");
HOOK_UNARYFUNC(bytearray_swapcase, "swapcase");
HOOK_BINARYFUNC(bytearray_translate, "translate");
HOOK_UNARYFUNC(bytearray_upper, "upper");
HOOK_BINARYFUNC(bytearray_zfill, "zfill");
int bytearray_init_new(PyObject *self, PyObject *args, PyObject *kwds) {
    int result = bytearray_init_orig(self, args, kwds);

    if (result == -1)
        return result;

    /* Here we report self_obj=None and ret=self
       to maintain the illusion of casting */
    propagate_result("CAST", NULL, self, args, kwds);

    return result;

}




int apply_bytearray_patches(funchook_t *funchook) {

    ADD_METHOD_HOOK(PyByteArray_Type, bytearray_decode, BYTEARRAY_DECODE_OFFSET);
    ADD_METHOD_HOOK(PyByteArray_Type, bytearray_replace, BYTEARRAY_REPLACE_OFFSET);
    ADD_METHOD_HOOK(PyByteArray_Type, bytearray_split, BYTEARRAY_SPLIT_OFFSET);
    ADD_METHOD_HOOK(PyByteArray_Type, bytearray_rsplit, BYTEARRAY_RSPLIT_OFFSET);
    ADD_METHOD_HOOK(PyByteArray_Type, bytearray_join, BYTEARRAY_JOIN_OFFSET);
    ADD_METHOD_HOOK(PyByteArray_Type, bytearray_capitalize, BYTEARRAY_CAPITALIZE_OFFSET);
    ADD_METHOD_HOOK(PyByteArray_Type, bytearray_title, BYTEARRAY_TITLE_OFFSET);
    ADD_METHOD_HOOK(PyByteArray_Type, bytearray_center, BYTEARRAY_CENTER_OFFSET);
    ADD_METHOD_HOOK(PyByteArray_Type, bytearray_expandtabs, BYTEARRAY_EXPANDTABS_OFFSET);
    ADD_METHOD_HOOK(PyByteArray_Type, bytearray_partition, BYTEARRAY_PARTITION_OFFSET);
    ADD_METHOD_HOOK(PyByteArray_Type, bytearray_ljust, BYTEARRAY_LJUST_OFFSET);
    ADD_METHOD_HOOK(PyByteArray_Type, bytearray_lower, BYTEARRAY_LOWER_OFFSET);
    ADD_METHOD_HOOK(PyByteArray_Type, bytearray_lstrip, BYTEARRAY_LSTRIP_OFFSET);
    ADD_METHOD_HOOK(PyByteArray_Type, bytearray_rjust, BYTEARRAY_RJUST_OFFSET);
    ADD_METHOD_HOOK(PyByteArray_Type, bytearray_rstrip, BYTEARRAY_RSTRIP_OFFSET);
    ADD_METHOD_HOOK(PyByteArray_Type, bytearray_rpartition, BYTEARRAY_RPARTITION_OFFSET);
    ADD_METHOD_HOOK(PyByteArray_Type, bytearray_splitlines, BYTEARRAY_SPLITLINES_OFFSET);
    ADD_METHOD_HOOK(PyByteArray_Type, bytearray_strip, BYTEARRAY_STRIP_OFFSET);
    ADD_METHOD_HOOK(PyByteArray_Type, bytearray_swapcase, BYTEARRAY_SWAPCASE_OFFSET);
    ADD_METHOD_HOOK(PyByteArray_Type, bytearray_translate, BYTEARRAY_TRANSLATE_OFFSET);
    ADD_METHOD_HOOK(PyByteArray_Type, bytearray_upper, BYTEARRAY_UPPER_OFFSET);
    ADD_METHOD_HOOK(PyByteArray_Type, bytearray_zfill, BYTEARRAY_ZFILL_OFFSET);
    ADD_INITPROC_HOOK(PyByteArray_Type, bytearray_init);

    /* Indicates success */
    return 0;
}

