/*
* Copyright © 2020 Contrast Security, Inc.
* See https://www.contrastsecurity.com/enduser-terms-0317a for more details.
*/
/* THIS FILE WAS AUTOMATICALLY GENERATED BY HOOKSPY */
/* Python requires its own header to always be included first */
#define PY_SSIZE_T_CLEAN
#include <Python.h>

#include <contrast/assess/propagate.h>
#include <contrast/assess/scope.h>
#include <contrast/assess/utils.h>

typedef PyObject *(*fastcall_func)(PyObject *, PyObject *const *, Py_ssize_t);
typedef PyObject *(*fastcall_kwargs_func)(PyObject *, PyObject *const *, Py_ssize_t, PyObject *);

#define UNICODE_ENCODE_OFFSET 0
#define UNICODE_DECODE_OFFSET 16
#define UNICODE_REPLACE_OFFSET 1
#define UNICODE_SPLIT_OFFSET 2
#define UNICODE_RSPLIT_OFFSET 3
#define UNICODE_JOIN_OFFSET 4
#define UNICODE_CAPITALIZE_OFFSET 5
#define UNICODE_TITLE_OFFSET 6
#define UNICODE_CENTER_OFFSET 7
#define UNICODE_EXPANDTABS_OFFSET 9
#define UNICODE_LJUST_OFFSET 13
#define UNICODE_LOWER_OFFSET 14
#define UNICODE_LSTRIP_OFFSET 15
#define UNICODE_RJUST_OFFSET 19
#define UNICODE_RSTRIP_OFFSET 20
#define UNICODE_SPLITLINES_OFFSET 22
#define UNICODE_STRIP_OFFSET 23
#define UNICODE_SWAPCASE_OFFSET 24
#define UNICODE_TRANSLATE_OFFSET 25
#define UNICODE_UPPER_OFFSET 26
#define UNICODE_ZFILL_OFFSET 38


ternaryfunc unicode_encode_orig;
ternaryfunc unicode_decode_orig;
binaryfunc unicode_replace_orig;
binaryfunc unicode_split_orig;
binaryfunc unicode_rsplit_orig;
binaryfunc unicode_join_orig;
unaryfunc unicode_capitalize_orig;
unaryfunc unicode_title_orig;
binaryfunc unicode_center_orig;
binaryfunc unicode_expandtabs_orig;
binaryfunc unicode_ljust_orig;
unaryfunc unicode_lower_orig;
binaryfunc unicode_lstrip_orig;
binaryfunc unicode_rjust_orig;
binaryfunc unicode_rstrip_orig;
binaryfunc unicode_splitlines_orig;
binaryfunc unicode_strip_orig;
unaryfunc unicode_swapcase_orig;
binaryfunc unicode_translate_orig;
unaryfunc unicode_upper_orig;
binaryfunc unicode_zfill_orig;
newfunc unicode_new_orig;


HOOK_TERNARYFUNC(unicode_encode, "encode");
HOOK_TERNARYFUNC(unicode_decode, "decode");
HOOK_BINARYFUNC(unicode_replace, "replace");
HOOK_BINARYFUNC(unicode_split, "split");
HOOK_BINARYFUNC(unicode_rsplit, "rsplit");
PyObject *unicode_join_new(PyObject *self, PyObject *args) {
    PyObject *list = PySequence_List(args);

    enter_propagation_scope();

    /* If this fails for any reason, just call the original function and get
     * out of here.
     */
    if (list == NULL) {
        PyErr_Clear();
        return unicode_join_orig((PyObject *)self, args);
    }

    /* In Py36+ we also hook an internal function that is called by this
     * function in order to propagate fstring formatting. We still want to have
     * a separate hook for join so that the events are reported differently.
     * This means that we need to go into scope when calling the original
     * function here so that we don't propagate twice.
     */
    PyObject *result = unicode_join_orig((PyObject *)self, list);
    exit_propagation_scope();

    PyObject *prop_args = PyTuple_Pack(1, list);

    if (prop_args == NULL || result == NULL)
        goto cleanup_and_exit;

    propagate_result("join", (PyObject *)self, result, prop_args, NULL);

cleanup_and_exit:
    Py_XDECREF(list);
    Py_XDECREF(prop_args);
    return result;

}

HOOK_UNARYFUNC(unicode_capitalize, "capitalize");
HOOK_UNARYFUNC(unicode_title, "title");
HOOK_BINARYFUNC(unicode_center, "center");
HOOK_BINARYFUNC(unicode_expandtabs, "expandtabs");
HOOK_BINARYFUNC(unicode_ljust, "ljust");
HOOK_UNARYFUNC(unicode_lower, "lower");
HOOK_BINARYFUNC(unicode_lstrip, "lstrip");
HOOK_BINARYFUNC(unicode_rjust, "rjust");
HOOK_BINARYFUNC(unicode_rstrip, "rstrip");
HOOK_BINARYFUNC(unicode_splitlines, "splitlines");
HOOK_BINARYFUNC(unicode_strip, "strip");
HOOK_UNARYFUNC(unicode_swapcase, "swapcase");
HOOK_BINARYFUNC(unicode_translate, "translate");
HOOK_UNARYFUNC(unicode_upper, "upper");
HOOK_BINARYFUNC(unicode_zfill, "zfill");
PyObject *unicode_new_new(PyTypeObject *type, PyObject *args, PyObject *kwds) {
    PyObject *result = unicode_new_orig(type, args, kwds);

    if (result == NULL)
        return result;

    propagate_result("CAST", NULL, result, args, kwds);

    return result;

}




int apply_unicode_patches(funchook_t *funchook) {

    ADD_METHOD_HOOK(PyUnicode_Type, unicode_encode, UNICODE_ENCODE_OFFSET);
    ADD_METHOD_HOOK(PyUnicode_Type, unicode_decode, UNICODE_DECODE_OFFSET);
    ADD_METHOD_HOOK(PyUnicode_Type, unicode_replace, UNICODE_REPLACE_OFFSET);
    ADD_METHOD_HOOK(PyUnicode_Type, unicode_split, UNICODE_SPLIT_OFFSET);
    ADD_METHOD_HOOK(PyUnicode_Type, unicode_rsplit, UNICODE_RSPLIT_OFFSET);
    ADD_METHOD_HOOK(PyUnicode_Type, unicode_join, UNICODE_JOIN_OFFSET);
    ADD_METHOD_HOOK(PyUnicode_Type, unicode_capitalize, UNICODE_CAPITALIZE_OFFSET);
    ADD_METHOD_HOOK(PyUnicode_Type, unicode_title, UNICODE_TITLE_OFFSET);
    ADD_METHOD_HOOK(PyUnicode_Type, unicode_center, UNICODE_CENTER_OFFSET);
    ADD_METHOD_HOOK(PyUnicode_Type, unicode_expandtabs, UNICODE_EXPANDTABS_OFFSET);
    /* unicode.partition hook is not included because it is buggy */
    ADD_METHOD_HOOK(PyUnicode_Type, unicode_ljust, UNICODE_LJUST_OFFSET);
    ADD_METHOD_HOOK(PyUnicode_Type, unicode_lower, UNICODE_LOWER_OFFSET);
    ADD_METHOD_HOOK(PyUnicode_Type, unicode_lstrip, UNICODE_LSTRIP_OFFSET);
    ADD_METHOD_HOOK(PyUnicode_Type, unicode_rjust, UNICODE_RJUST_OFFSET);
    ADD_METHOD_HOOK(PyUnicode_Type, unicode_rstrip, UNICODE_RSTRIP_OFFSET);
    /* unicode.rpartition hook is not included because it is buggy */
    ADD_METHOD_HOOK(PyUnicode_Type, unicode_splitlines, UNICODE_SPLITLINES_OFFSET);
    ADD_METHOD_HOOK(PyUnicode_Type, unicode_strip, UNICODE_STRIP_OFFSET);
    ADD_METHOD_HOOK(PyUnicode_Type, unicode_swapcase, UNICODE_SWAPCASE_OFFSET);
    ADD_METHOD_HOOK(PyUnicode_Type, unicode_translate, UNICODE_TRANSLATE_OFFSET);
    ADD_METHOD_HOOK(PyUnicode_Type, unicode_upper, UNICODE_UPPER_OFFSET);
    ADD_METHOD_HOOK(PyUnicode_Type, unicode_zfill, UNICODE_ZFILL_OFFSET);
    ADD_NEWFUNC_HOOK(PyUnicode_Type, unicode_new);

    /* Indicates success */
    return 0;
}

