"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.ChimeVoiceConnector = exports.Protocol = exports.NotificationTargetType = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
// import { Termination } from '@aws-sdk/client-chime-sdk-voice';
const cdk = require("aws-cdk-lib");
const constructs_1 = require("constructs");
const pstnCustomResources_1 = require("./pstnCustomResources");
const voiceConnectorValidator_1 = require("./voiceConnectorValidator");
var NotificationTargetType;
(function (NotificationTargetType) {
    NotificationTargetType["EVENTBRIDGE"] = "EventBridge";
    NotificationTargetType["SNS"] = "SNS";
    NotificationTargetType["SQS"] = "SQS";
})(NotificationTargetType = exports.NotificationTargetType || (exports.NotificationTargetType = {}));
var Protocol;
(function (Protocol) {
    Protocol["TCP"] = "TCP";
    Protocol["UDP"] = "UDP";
})(Protocol = exports.Protocol || (exports.Protocol = {}));
class ChimeVoiceConnector extends constructs_1.Construct {
    constructor(scope, id, props) {
        super(scope, id);
        const uid = cdk.Names.uniqueId(this);
        const { name, region, encryption, termination, origination, streaming, loggingConfiguration, } = props;
        voiceConnectorValidator_1.voiceConnectorValidator(props);
        const voiceConnectorRequest = new pstnCustomResources_1.PSTNResources(this, 'voiceConnectorRequest', {
            resourceType: 'VoiceConnector',
            uid: uid,
            properties: {
                region: region || cdk.Stack.of(this).region,
                name: name ?? uid,
                encryption: encryption || false,
                termination: termination,
                origination: origination,
                streaming: streaming,
                logging: loggingConfiguration,
            },
        });
        this.voiceConnectorId =
            voiceConnectorRequest.pstnCustomResource.getAttString('voiceConnectorId');
    }
}
exports.ChimeVoiceConnector = ChimeVoiceConnector;
_a = JSII_RTTI_SYMBOL_1;
ChimeVoiceConnector[_a] = { fqn: "cdk-amazon-chime-resources.ChimeVoiceConnector", version: "2.0.21" };
//# sourceMappingURL=data:application/json;base64,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