import { StreamingNotificationTarget } from '@aws-sdk/client-chime-sdk-voice';
interface Routes {
    protocol: string;
    host: string;
    port: string;
    priority: string;
    weight: string;
}
interface TerminationProps {
    callingRegions: string[];
    terminationCidrs: string[];
    cpsLimit: string;
}
interface StreamingProps {
    enabled: boolean;
    dataRetention: string;
    notificationTarget: StreamingNotificationTarget[];
}
interface LoggingProps {
    enableSIPLogs: boolean;
    enableMediaMetricLogs: boolean;
}
export interface CreateVoiceConnectorProps {
    name?: string;
    region?: string;
    encryption?: boolean;
    termination?: TerminationProps;
    origination?: Routes[];
    logging?: LoggingProps;
    streaming?: StreamingProps;
}
export declare const CreateVoiceConnector: (uid: string, props: CreateVoiceConnectorProps) => Promise<{
    voiceConnectorId: string;
}>;
export interface UpdateVoiceConnectorProps {
    name?: string;
    region?: string;
    encryption?: boolean;
    termination?: TerminationProps;
    origination?: Routes[];
    logging?: LoggingProps;
    streaming?: StreamingProps;
}
export declare const UpdateVoiceConnector: (uid: string, props: CreateVoiceConnectorProps) => Promise<void>;
export declare const DeleteVoiceConnector: (uid: string) => Promise<void>;
export {};
