import { SENSITIVE_STRING } from "@aws-sdk/smithy-client";
import { AddressFilterSensitiveLog, AlexaForBusinessMetadataFilterSensitiveLog, AppInstanceAdminSummaryFilterSensitiveLog, AppInstanceStreamingConfigurationFilterSensitiveLog, AppInstanceSummaryFilterSensitiveLog, AppInstanceUserSummaryFilterSensitiveLog, AttendeeFilterSensitiveLog, BotFilterSensitiveLog, CandidateAddressFilterSensitiveLog, ChannelBanSummaryFilterSensitiveLog, ChannelMembershipForAppInstanceUserSummaryFilterSensitiveLog, ChannelMembershipSummaryFilterSensitiveLog, ChannelMessageSummaryFilterSensitiveLog, ChannelModeratedByAppInstanceUserSummaryFilterSensitiveLog, ChannelModeratorSummaryFilterSensitiveLog, ChannelSummaryFilterSensitiveLog, CredentialFilterSensitiveLog, EmergencyCallingConfigurationFilterSensitiveLog, EventsConfigurationFilterSensitiveLog, MediaCapturePipelineFilterSensitiveLog, MeetingFilterSensitiveLog, PhoneNumberFilterSensitiveLog, ProxySessionFilterSensitiveLog, RoomFilterSensitiveLog, RoomMembershipFilterSensitiveLog, SipMediaApplicationEndpointFilterSensitiveLog, SipMediaApplicationFilterSensitiveLog, TagFilterSensitiveLog, UserFilterSensitiveLog, } from "./models_0";
export const OriginationRouteProtocol = {
    TCP: "TCP",
    UDP: "UDP",
};
export const NotificationTarget = {
    EventBridge: "EventBridge",
    SNS: "SNS",
    SQS: "SQS",
};
export const SortOrder = {
    ASCENDING: "ASCENDING",
    DESCENDING: "DESCENDING",
};
export const GetRoomResponseFilterSensitiveLog = (obj) => ({
    ...obj,
    ...(obj.Room && { Room: RoomFilterSensitiveLog(obj.Room) }),
});
export const GetSipMediaApplicationResponseFilterSensitiveLog = (obj) => ({
    ...obj,
    ...(obj.SipMediaApplication && {
        SipMediaApplication: SipMediaApplicationFilterSensitiveLog(obj.SipMediaApplication),
    }),
});
export const GetUserResponseFilterSensitiveLog = (obj) => ({
    ...obj,
    ...(obj.User && { User: UserFilterSensitiveLog(obj.User) }),
});
export const GetVoiceConnectorEmergencyCallingConfigurationResponseFilterSensitiveLog = (obj) => ({
    ...obj,
    ...(obj.EmergencyCallingConfiguration && {
        EmergencyCallingConfiguration: EmergencyCallingConfigurationFilterSensitiveLog(obj.EmergencyCallingConfiguration),
    }),
});
export const ProxyFilterSensitiveLog = (obj) => ({
    ...obj,
    ...(obj.FallBackPhoneNumber && { FallBackPhoneNumber: SENSITIVE_STRING }),
});
export const GetVoiceConnectorProxyResponseFilterSensitiveLog = (obj) => ({
    ...obj,
    ...(obj.Proxy && { Proxy: ProxyFilterSensitiveLog(obj.Proxy) }),
});
export const TerminationFilterSensitiveLog = (obj) => ({
    ...obj,
    ...(obj.DefaultPhoneNumber && { DefaultPhoneNumber: SENSITIVE_STRING }),
});
export const GetVoiceConnectorTerminationResponseFilterSensitiveLog = (obj) => ({
    ...obj,
    ...(obj.Termination && { Termination: TerminationFilterSensitiveLog(obj.Termination) }),
});
export const InviteFilterSensitiveLog = (obj) => ({
    ...obj,
    ...(obj.EmailAddress && { EmailAddress: SENSITIVE_STRING }),
});
export const InviteUsersRequestFilterSensitiveLog = (obj) => ({
    ...obj,
    ...(obj.UserEmailList && { UserEmailList: SENSITIVE_STRING }),
});
export const InviteUsersResponseFilterSensitiveLog = (obj) => ({
    ...obj,
    ...(obj.Invites && { Invites: obj.Invites.map((item) => InviteFilterSensitiveLog(item)) }),
});
export const ListAccountsRequestFilterSensitiveLog = (obj) => ({
    ...obj,
    ...(obj.UserEmail && { UserEmail: SENSITIVE_STRING }),
});
export const ListAppInstanceAdminsRequestFilterSensitiveLog = (obj) => ({
    ...obj,
    ...(obj.NextToken && { NextToken: SENSITIVE_STRING }),
});
export const ListAppInstanceAdminsResponseFilterSensitiveLog = (obj) => ({
    ...obj,
    ...(obj.AppInstanceAdmins && {
        AppInstanceAdmins: obj.AppInstanceAdmins.map((item) => AppInstanceAdminSummaryFilterSensitiveLog(item)),
    }),
    ...(obj.NextToken && { NextToken: SENSITIVE_STRING }),
});
export const ListAppInstancesRequestFilterSensitiveLog = (obj) => ({
    ...obj,
    ...(obj.NextToken && { NextToken: SENSITIVE_STRING }),
});
export const ListAppInstancesResponseFilterSensitiveLog = (obj) => ({
    ...obj,
    ...(obj.AppInstances && { AppInstances: obj.AppInstances.map((item) => AppInstanceSummaryFilterSensitiveLog(item)) }),
    ...(obj.NextToken && { NextToken: SENSITIVE_STRING }),
});
export const ListAppInstanceUsersRequestFilterSensitiveLog = (obj) => ({
    ...obj,
    ...(obj.NextToken && { NextToken: SENSITIVE_STRING }),
});
export const ListAppInstanceUsersResponseFilterSensitiveLog = (obj) => ({
    ...obj,
    ...(obj.AppInstanceUsers && {
        AppInstanceUsers: obj.AppInstanceUsers.map((item) => AppInstanceUserSummaryFilterSensitiveLog(item)),
    }),
    ...(obj.NextToken && { NextToken: SENSITIVE_STRING }),
});
export const ListAttendeesResponseFilterSensitiveLog = (obj) => ({
    ...obj,
    ...(obj.Attendees && { Attendees: obj.Attendees.map((item) => AttendeeFilterSensitiveLog(item)) }),
});
export const ListAttendeeTagsResponseFilterSensitiveLog = (obj) => ({
    ...obj,
    ...(obj.Tags && { Tags: obj.Tags.map((item) => TagFilterSensitiveLog(item)) }),
});
export const ListBotsResponseFilterSensitiveLog = (obj) => ({
    ...obj,
    ...(obj.Bots && { Bots: obj.Bots.map((item) => BotFilterSensitiveLog(item)) }),
});
export const ListChannelBansRequestFilterSensitiveLog = (obj) => ({
    ...obj,
    ...(obj.NextToken && { NextToken: SENSITIVE_STRING }),
});
export const ListChannelBansResponseFilterSensitiveLog = (obj) => ({
    ...obj,
    ...(obj.NextToken && { NextToken: SENSITIVE_STRING }),
    ...(obj.ChannelBans && { ChannelBans: obj.ChannelBans.map((item) => ChannelBanSummaryFilterSensitiveLog(item)) }),
});
export const ListChannelMembershipsRequestFilterSensitiveLog = (obj) => ({
    ...obj,
    ...(obj.NextToken && { NextToken: SENSITIVE_STRING }),
});
export const ListChannelMembershipsResponseFilterSensitiveLog = (obj) => ({
    ...obj,
    ...(obj.ChannelMemberships && {
        ChannelMemberships: obj.ChannelMemberships.map((item) => ChannelMembershipSummaryFilterSensitiveLog(item)),
    }),
    ...(obj.NextToken && { NextToken: SENSITIVE_STRING }),
});
export const ListChannelMembershipsForAppInstanceUserRequestFilterSensitiveLog = (obj) => ({
    ...obj,
    ...(obj.NextToken && { NextToken: SENSITIVE_STRING }),
});
export const ListChannelMembershipsForAppInstanceUserResponseFilterSensitiveLog = (obj) => ({
    ...obj,
    ...(obj.ChannelMemberships && {
        ChannelMemberships: obj.ChannelMemberships.map((item) => ChannelMembershipForAppInstanceUserSummaryFilterSensitiveLog(item)),
    }),
    ...(obj.NextToken && { NextToken: SENSITIVE_STRING }),
});
export const ListChannelMessagesRequestFilterSensitiveLog = (obj) => ({
    ...obj,
    ...(obj.NextToken && { NextToken: SENSITIVE_STRING }),
});
export const ListChannelMessagesResponseFilterSensitiveLog = (obj) => ({
    ...obj,
    ...(obj.NextToken && { NextToken: SENSITIVE_STRING }),
    ...(obj.ChannelMessages && {
        ChannelMessages: obj.ChannelMessages.map((item) => ChannelMessageSummaryFilterSensitiveLog(item)),
    }),
});
export const ListChannelModeratorsRequestFilterSensitiveLog = (obj) => ({
    ...obj,
    ...(obj.NextToken && { NextToken: SENSITIVE_STRING }),
});
export const ListChannelModeratorsResponseFilterSensitiveLog = (obj) => ({
    ...obj,
    ...(obj.NextToken && { NextToken: SENSITIVE_STRING }),
    ...(obj.ChannelModerators && {
        ChannelModerators: obj.ChannelModerators.map((item) => ChannelModeratorSummaryFilterSensitiveLog(item)),
    }),
});
export const ListChannelsRequestFilterSensitiveLog = (obj) => ({
    ...obj,
    ...(obj.NextToken && { NextToken: SENSITIVE_STRING }),
});
export const ListChannelsResponseFilterSensitiveLog = (obj) => ({
    ...obj,
    ...(obj.Channels && { Channels: obj.Channels.map((item) => ChannelSummaryFilterSensitiveLog(item)) }),
    ...(obj.NextToken && { NextToken: SENSITIVE_STRING }),
});
export const ListChannelsModeratedByAppInstanceUserRequestFilterSensitiveLog = (obj) => ({
    ...obj,
    ...(obj.NextToken && { NextToken: SENSITIVE_STRING }),
});
export const ListChannelsModeratedByAppInstanceUserResponseFilterSensitiveLog = (obj) => ({
    ...obj,
    ...(obj.Channels && {
        Channels: obj.Channels.map((item) => ChannelModeratedByAppInstanceUserSummaryFilterSensitiveLog(item)),
    }),
    ...(obj.NextToken && { NextToken: SENSITIVE_STRING }),
});
export const ListMediaCapturePipelinesResponseFilterSensitiveLog = (obj) => ({
    ...obj,
    ...(obj.MediaCapturePipelines && {
        MediaCapturePipelines: obj.MediaCapturePipelines.map((item) => MediaCapturePipelineFilterSensitiveLog(item)),
    }),
});
export const ListMeetingsResponseFilterSensitiveLog = (obj) => ({
    ...obj,
    ...(obj.Meetings && { Meetings: obj.Meetings.map((item) => MeetingFilterSensitiveLog(item)) }),
});
export const ListMeetingTagsResponseFilterSensitiveLog = (obj) => ({
    ...obj,
    ...(obj.Tags && { Tags: obj.Tags.map((item) => TagFilterSensitiveLog(item)) }),
});
export const ListPhoneNumberOrdersResponseFilterSensitiveLog = (obj) => ({
    ...obj,
});
export const ListPhoneNumbersResponseFilterSensitiveLog = (obj) => ({
    ...obj,
    ...(obj.PhoneNumbers && { PhoneNumbers: obj.PhoneNumbers.map((item) => PhoneNumberFilterSensitiveLog(item)) }),
});
export const ListProxySessionsResponseFilterSensitiveLog = (obj) => ({
    ...obj,
});
export const ListRoomMembershipsResponseFilterSensitiveLog = (obj) => ({
    ...obj,
    ...(obj.RoomMemberships && {
        RoomMemberships: obj.RoomMemberships.map((item) => RoomMembershipFilterSensitiveLog(item)),
    }),
});
export const ListRoomsResponseFilterSensitiveLog = (obj) => ({
    ...obj,
    ...(obj.Rooms && { Rooms: obj.Rooms.map((item) => RoomFilterSensitiveLog(item)) }),
});
export const ListSipMediaApplicationsResponseFilterSensitiveLog = (obj) => ({
    ...obj,
});
export const ListTagsForResourceRequestFilterSensitiveLog = (obj) => ({
    ...obj,
    ...(obj.ResourceARN && { ResourceARN: SENSITIVE_STRING }),
});
export const ListTagsForResourceResponseFilterSensitiveLog = (obj) => ({
    ...obj,
    ...(obj.Tags && { Tags: obj.Tags.map((item) => TagFilterSensitiveLog(item)) }),
});
export const ListUsersRequestFilterSensitiveLog = (obj) => ({
    ...obj,
    ...(obj.UserEmail && { UserEmail: SENSITIVE_STRING }),
});
export const ListUsersResponseFilterSensitiveLog = (obj) => ({
    ...obj,
    ...(obj.Users && { Users: obj.Users.map((item) => UserFilterSensitiveLog(item)) }),
});
export const ListVoiceConnectorTerminationCredentialsResponseFilterSensitiveLog = (obj) => ({
    ...obj,
    ...(obj.Usernames && { Usernames: SENSITIVE_STRING }),
});
export const PutAppInstanceStreamingConfigurationsRequestFilterSensitiveLog = (obj) => ({
    ...obj,
    ...(obj.AppInstanceStreamingConfigurations && {
        AppInstanceStreamingConfigurations: obj.AppInstanceStreamingConfigurations.map((item) => AppInstanceStreamingConfigurationFilterSensitiveLog(item)),
    }),
});
export const PutAppInstanceStreamingConfigurationsResponseFilterSensitiveLog = (obj) => ({
    ...obj,
    ...(obj.AppInstanceStreamingConfigurations && {
        AppInstanceStreamingConfigurations: obj.AppInstanceStreamingConfigurations.map((item) => AppInstanceStreamingConfigurationFilterSensitiveLog(item)),
    }),
});
export const PutEventsConfigurationRequestFilterSensitiveLog = (obj) => ({
    ...obj,
    ...(obj.OutboundEventsHTTPSEndpoint && { OutboundEventsHTTPSEndpoint: SENSITIVE_STRING }),
    ...(obj.LambdaFunctionArn && { LambdaFunctionArn: SENSITIVE_STRING }),
});
export const PutEventsConfigurationResponseFilterSensitiveLog = (obj) => ({
    ...obj,
    ...(obj.EventsConfiguration && {
        EventsConfiguration: EventsConfigurationFilterSensitiveLog(obj.EventsConfiguration),
    }),
});
export const PutVoiceConnectorEmergencyCallingConfigurationRequestFilterSensitiveLog = (obj) => ({
    ...obj,
    ...(obj.EmergencyCallingConfiguration && {
        EmergencyCallingConfiguration: EmergencyCallingConfigurationFilterSensitiveLog(obj.EmergencyCallingConfiguration),
    }),
});
export const PutVoiceConnectorEmergencyCallingConfigurationResponseFilterSensitiveLog = (obj) => ({
    ...obj,
    ...(obj.EmergencyCallingConfiguration && {
        EmergencyCallingConfiguration: EmergencyCallingConfigurationFilterSensitiveLog(obj.EmergencyCallingConfiguration),
    }),
});
export const PutVoiceConnectorProxyRequestFilterSensitiveLog = (obj) => ({
    ...obj,
    ...(obj.FallBackPhoneNumber && { FallBackPhoneNumber: SENSITIVE_STRING }),
});
export const PutVoiceConnectorProxyResponseFilterSensitiveLog = (obj) => ({
    ...obj,
    ...(obj.Proxy && { Proxy: ProxyFilterSensitiveLog(obj.Proxy) }),
});
export const PutVoiceConnectorTerminationRequestFilterSensitiveLog = (obj) => ({
    ...obj,
    ...(obj.Termination && { Termination: TerminationFilterSensitiveLog(obj.Termination) }),
});
export const PutVoiceConnectorTerminationResponseFilterSensitiveLog = (obj) => ({
    ...obj,
    ...(obj.Termination && { Termination: TerminationFilterSensitiveLog(obj.Termination) }),
});
export const PutVoiceConnectorTerminationCredentialsRequestFilterSensitiveLog = (obj) => ({
    ...obj,
    ...(obj.Credentials && { Credentials: obj.Credentials.map((item) => CredentialFilterSensitiveLog(item)) }),
});
export const RegenerateSecurityTokenResponseFilterSensitiveLog = (obj) => ({
    ...obj,
    ...(obj.Bot && { Bot: BotFilterSensitiveLog(obj.Bot) }),
});
export const ResetPersonalPINResponseFilterSensitiveLog = (obj) => ({
    ...obj,
    ...(obj.User && { User: UserFilterSensitiveLog(obj.User) }),
});
export const RestorePhoneNumberResponseFilterSensitiveLog = (obj) => ({
    ...obj,
    ...(obj.PhoneNumber && { PhoneNumber: PhoneNumberFilterSensitiveLog(obj.PhoneNumber) }),
});
export const SearchAvailablePhoneNumbersResponseFilterSensitiveLog = (obj) => ({
    ...obj,
    ...(obj.E164PhoneNumbers && { E164PhoneNumbers: SENSITIVE_STRING }),
});
export const SendChannelMessageRequestFilterSensitiveLog = (obj) => ({
    ...obj,
    ...(obj.Content && { Content: SENSITIVE_STRING }),
    ...(obj.Metadata && { Metadata: SENSITIVE_STRING }),
    ...(obj.ClientRequestToken && { ClientRequestToken: SENSITIVE_STRING }),
});
export const TagAttendeeRequestFilterSensitiveLog = (obj) => ({
    ...obj,
    ...(obj.Tags && { Tags: obj.Tags.map((item) => TagFilterSensitiveLog(item)) }),
});
export const TagMeetingRequestFilterSensitiveLog = (obj) => ({
    ...obj,
    ...(obj.Tags && { Tags: obj.Tags.map((item) => TagFilterSensitiveLog(item)) }),
});
export const TagResourceRequestFilterSensitiveLog = (obj) => ({
    ...obj,
    ...(obj.ResourceARN && { ResourceARN: SENSITIVE_STRING }),
    ...(obj.Tags && { Tags: obj.Tags.map((item) => TagFilterSensitiveLog(item)) }),
});
export const UntagAttendeeRequestFilterSensitiveLog = (obj) => ({
    ...obj,
    ...(obj.TagKeys && { TagKeys: SENSITIVE_STRING }),
});
export const UntagMeetingRequestFilterSensitiveLog = (obj) => ({
    ...obj,
    ...(obj.TagKeys && { TagKeys: SENSITIVE_STRING }),
});
export const UntagResourceRequestFilterSensitiveLog = (obj) => ({
    ...obj,
    ...(obj.ResourceARN && { ResourceARN: SENSITIVE_STRING }),
    ...(obj.TagKeys && { TagKeys: SENSITIVE_STRING }),
});
export const UpdateAppInstanceRequestFilterSensitiveLog = (obj) => ({
    ...obj,
    ...(obj.Name && { Name: SENSITIVE_STRING }),
    ...(obj.Metadata && { Metadata: SENSITIVE_STRING }),
});
export const UpdateAppInstanceUserRequestFilterSensitiveLog = (obj) => ({
    ...obj,
    ...(obj.Name && { Name: SENSITIVE_STRING }),
    ...(obj.Metadata && { Metadata: SENSITIVE_STRING }),
});
export const UpdateBotResponseFilterSensitiveLog = (obj) => ({
    ...obj,
    ...(obj.Bot && { Bot: BotFilterSensitiveLog(obj.Bot) }),
});
export const UpdateChannelRequestFilterSensitiveLog = (obj) => ({
    ...obj,
    ...(obj.Name && { Name: SENSITIVE_STRING }),
    ...(obj.Metadata && { Metadata: SENSITIVE_STRING }),
});
export const UpdateChannelMessageRequestFilterSensitiveLog = (obj) => ({
    ...obj,
    ...(obj.Content && { Content: SENSITIVE_STRING }),
    ...(obj.Metadata && { Metadata: SENSITIVE_STRING }),
});
export const UpdatePhoneNumberRequestFilterSensitiveLog = (obj) => ({
    ...obj,
    ...(obj.CallingName && { CallingName: SENSITIVE_STRING }),
});
export const UpdatePhoneNumberResponseFilterSensitiveLog = (obj) => ({
    ...obj,
    ...(obj.PhoneNumber && { PhoneNumber: PhoneNumberFilterSensitiveLog(obj.PhoneNumber) }),
});
export const UpdatePhoneNumberSettingsRequestFilterSensitiveLog = (obj) => ({
    ...obj,
    ...(obj.CallingName && { CallingName: SENSITIVE_STRING }),
});
export const UpdateProxySessionResponseFilterSensitiveLog = (obj) => ({
    ...obj,
    ...(obj.ProxySession && { ProxySession: ProxySessionFilterSensitiveLog(obj.ProxySession) }),
});
export const UpdateRoomRequestFilterSensitiveLog = (obj) => ({
    ...obj,
    ...(obj.Name && { Name: SENSITIVE_STRING }),
});
export const UpdateRoomResponseFilterSensitiveLog = (obj) => ({
    ...obj,
    ...(obj.Room && { Room: RoomFilterSensitiveLog(obj.Room) }),
});
export const UpdateRoomMembershipResponseFilterSensitiveLog = (obj) => ({
    ...obj,
    ...(obj.RoomMembership && { RoomMembership: RoomMembershipFilterSensitiveLog(obj.RoomMembership) }),
});
export const UpdateSipMediaApplicationRequestFilterSensitiveLog = (obj) => ({
    ...obj,
    ...(obj.Endpoints && { Endpoints: obj.Endpoints.map((item) => SipMediaApplicationEndpointFilterSensitiveLog(item)) }),
});
export const UpdateSipMediaApplicationResponseFilterSensitiveLog = (obj) => ({
    ...obj,
    ...(obj.SipMediaApplication && {
        SipMediaApplication: SipMediaApplicationFilterSensitiveLog(obj.SipMediaApplication),
    }),
});
export const UpdateSipMediaApplicationCallRequestFilterSensitiveLog = (obj) => ({
    ...obj,
    ...(obj.Arguments && { Arguments: SENSITIVE_STRING }),
});
export const UpdateUserRequestFilterSensitiveLog = (obj) => ({
    ...obj,
    ...(obj.AlexaForBusinessMetadata && {
        AlexaForBusinessMetadata: AlexaForBusinessMetadataFilterSensitiveLog(obj.AlexaForBusinessMetadata),
    }),
});
export const UpdateUserResponseFilterSensitiveLog = (obj) => ({
    ...obj,
    ...(obj.User && { User: UserFilterSensitiveLog(obj.User) }),
});
export const ValidateE911AddressRequestFilterSensitiveLog = (obj) => ({
    ...obj,
    ...(obj.StreetNumber && { StreetNumber: SENSITIVE_STRING }),
    ...(obj.StreetInfo && { StreetInfo: SENSITIVE_STRING }),
    ...(obj.City && { City: SENSITIVE_STRING }),
    ...(obj.State && { State: SENSITIVE_STRING }),
    ...(obj.Country && { Country: SENSITIVE_STRING }),
    ...(obj.PostalCode && { PostalCode: SENSITIVE_STRING }),
});
export const ValidateE911AddressResponseFilterSensitiveLog = (obj) => ({
    ...obj,
    ...(obj.Address && { Address: AddressFilterSensitiveLog(obj.Address) }),
    ...(obj.CandidateAddressList && {
        CandidateAddressList: obj.CandidateAddressList.map((item) => CandidateAddressFilterSensitiveLog(item)),
    }),
});
