import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface ServerConfig extends cdktf.TerraformMetaArguments {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/ionoscloud/r/server#availability_zone Server#availability_zone}
    */
    readonly availabilityZone?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/ionoscloud/r/server#boot_cdrom Server#boot_cdrom}
    */
    readonly bootCdrom?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/ionoscloud/r/server#boot_image Server#boot_image}
    */
    readonly bootImage?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/ionoscloud/r/server#cores Server#cores}
    */
    readonly cores?: number;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/ionoscloud/r/server#cpu_family Server#cpu_family}
    */
    readonly cpuFamily?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/ionoscloud/r/server#datacenter_id Server#datacenter_id}
    */
    readonly datacenterId: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/ionoscloud/r/server#image_name Server#image_name}
    */
    readonly imageName?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/ionoscloud/r/server#image_password Server#image_password}
    */
    readonly imagePassword?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/ionoscloud/r/server#name Server#name}
    */
    readonly name: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/ionoscloud/r/server#ram Server#ram}
    */
    readonly ram?: number;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/ionoscloud/r/server#ssh_key_path Server#ssh_key_path}
    */
    readonly sshKeyPath?: string[];
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/ionoscloud/r/server#template_uuid Server#template_uuid}
    */
    readonly templateUuid?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/ionoscloud/r/server#type Server#type}
    */
    readonly type?: string;
    /**
    * nic block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/ionoscloud/r/server#nic Server#nic}
    */
    readonly nic: ServerNic;
    /**
    * timeouts block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/ionoscloud/r/server#timeouts Server#timeouts}
    */
    readonly timeouts?: ServerTimeouts;
    /**
    * volume block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/ionoscloud/r/server#volume Server#volume}
    */
    readonly volume: ServerVolume;
}
export interface ServerNicFirewall {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/ionoscloud/r/server#icmp_code Server#icmp_code}
    */
    readonly icmpCode?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/ionoscloud/r/server#icmp_type Server#icmp_type}
    */
    readonly icmpType?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/ionoscloud/r/server#name Server#name}
    */
    readonly name?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/ionoscloud/r/server#port_range_end Server#port_range_end}
    */
    readonly portRangeEnd?: number;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/ionoscloud/r/server#port_range_start Server#port_range_start}
    */
    readonly portRangeStart?: number;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/ionoscloud/r/server#protocol Server#protocol}
    */
    readonly protocol: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/ionoscloud/r/server#source_ip Server#source_ip}
    */
    readonly sourceIp?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/ionoscloud/r/server#source_mac Server#source_mac}
    */
    readonly sourceMac?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/ionoscloud/r/server#target_ip Server#target_ip}
    */
    readonly targetIp?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/ionoscloud/r/server#type Server#type}
    */
    readonly type?: string;
}
export declare function serverNicFirewallToTerraform(struct?: ServerNicFirewallOutputReference | ServerNicFirewall): any;
export declare class ServerNicFirewallOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): ServerNicFirewall | undefined;
    set internalValue(value: ServerNicFirewall | undefined);
    private _icmpCode?;
    get icmpCode(): string;
    set icmpCode(value: string);
    resetIcmpCode(): void;
    get icmpCodeInput(): string | undefined;
    private _icmpType?;
    get icmpType(): string;
    set icmpType(value: string);
    resetIcmpType(): void;
    get icmpTypeInput(): string | undefined;
    private _name?;
    get name(): string;
    set name(value: string);
    resetName(): void;
    get nameInput(): string | undefined;
    private _portRangeEnd?;
    get portRangeEnd(): number;
    set portRangeEnd(value: number);
    resetPortRangeEnd(): void;
    get portRangeEndInput(): number | undefined;
    private _portRangeStart?;
    get portRangeStart(): number;
    set portRangeStart(value: number);
    resetPortRangeStart(): void;
    get portRangeStartInput(): number | undefined;
    private _protocol?;
    get protocol(): string;
    set protocol(value: string);
    get protocolInput(): string | undefined;
    private _sourceIp?;
    get sourceIp(): string;
    set sourceIp(value: string);
    resetSourceIp(): void;
    get sourceIpInput(): string | undefined;
    private _sourceMac?;
    get sourceMac(): string;
    set sourceMac(value: string);
    resetSourceMac(): void;
    get sourceMacInput(): string | undefined;
    private _targetIp?;
    get targetIp(): string;
    set targetIp(value: string);
    resetTargetIp(): void;
    get targetIpInput(): string | undefined;
    private _type?;
    get type(): string;
    set type(value: string);
    resetType(): void;
    get typeInput(): string | undefined;
}
export interface ServerNic {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/ionoscloud/r/server#dhcp Server#dhcp}
    */
    readonly dhcp?: boolean | cdktf.IResolvable;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/ionoscloud/r/server#firewall_active Server#firewall_active}
    */
    readonly firewallActive?: boolean | cdktf.IResolvable;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/ionoscloud/r/server#firewall_type Server#firewall_type}
    */
    readonly firewallType?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/ionoscloud/r/server#ips Server#ips}
    */
    readonly ips?: string[];
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/ionoscloud/r/server#lan Server#lan}
    */
    readonly lan: number;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/ionoscloud/r/server#name Server#name}
    */
    readonly name?: string;
    /**
    * firewall block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/ionoscloud/r/server#firewall Server#firewall}
    */
    readonly firewall?: ServerNicFirewall;
}
export declare function serverNicToTerraform(struct?: ServerNicOutputReference | ServerNic): any;
export declare class ServerNicOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): ServerNic | undefined;
    set internalValue(value: ServerNic | undefined);
    get deviceNumber(): number;
    private _dhcp?;
    get dhcp(): boolean | cdktf.IResolvable;
    set dhcp(value: boolean | cdktf.IResolvable);
    resetDhcp(): void;
    get dhcpInput(): boolean | cdktf.IResolvable | undefined;
    private _firewallActive?;
    get firewallActive(): boolean | cdktf.IResolvable;
    set firewallActive(value: boolean | cdktf.IResolvable);
    resetFirewallActive(): void;
    get firewallActiveInput(): boolean | cdktf.IResolvable | undefined;
    private _firewallType?;
    get firewallType(): string;
    set firewallType(value: string);
    resetFirewallType(): void;
    get firewallTypeInput(): string | undefined;
    private _ips?;
    get ips(): string[];
    set ips(value: string[]);
    resetIps(): void;
    get ipsInput(): string[] | undefined;
    private _lan?;
    get lan(): number;
    set lan(value: number);
    get lanInput(): number | undefined;
    get mac(): string;
    private _name?;
    get name(): string;
    set name(value: string);
    resetName(): void;
    get nameInput(): string | undefined;
    get pciSlot(): number;
    private _firewall;
    get firewall(): ServerNicFirewallOutputReference;
    putFirewall(value: ServerNicFirewall): void;
    resetFirewall(): void;
    get firewallInput(): ServerNicFirewall | undefined;
}
export interface ServerTimeouts {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/ionoscloud/r/server#create Server#create}
    */
    readonly create?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/ionoscloud/r/server#default Server#default}
    */
    readonly default?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/ionoscloud/r/server#delete Server#delete}
    */
    readonly delete?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/ionoscloud/r/server#update Server#update}
    */
    readonly update?: string;
}
export declare function serverTimeoutsToTerraform(struct?: ServerTimeoutsOutputReference | ServerTimeouts | cdktf.IResolvable): any;
export declare class ServerTimeoutsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): ServerTimeouts | undefined;
    set internalValue(value: ServerTimeouts | undefined);
    private _create?;
    get create(): string;
    set create(value: string);
    resetCreate(): void;
    get createInput(): string | undefined;
    private _default?;
    get default(): string;
    set default(value: string);
    resetDefault(): void;
    get defaultInput(): string | undefined;
    private _delete?;
    get delete(): string;
    set delete(value: string);
    resetDelete(): void;
    get deleteInput(): string | undefined;
    private _update?;
    get update(): string;
    set update(value: string);
    resetUpdate(): void;
    get updateInput(): string | undefined;
}
export interface ServerVolume {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/ionoscloud/r/server#availability_zone Server#availability_zone}
    */
    readonly availabilityZone?: string;
    /**
    * The uuid of the Backup Unit that user has access to. The property is immutable and is only allowed to be set on a new volume creation. It is mandatory to provide either 'public image' or 'imageAlias' in conjunction with this property.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/ionoscloud/r/server#backup_unit_id Server#backup_unit_id}
    */
    readonly backupUnitId?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/ionoscloud/r/server#bus Server#bus}
    */
    readonly bus?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/ionoscloud/r/server#disk_type Server#disk_type}
    */
    readonly diskType: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/ionoscloud/r/server#image_name Server#image_name}
    */
    readonly imageName?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/ionoscloud/r/server#image_password Server#image_password}
    */
    readonly imagePassword?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/ionoscloud/r/server#licence_type Server#licence_type}
    */
    readonly licenceType?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/ionoscloud/r/server#name Server#name}
    */
    readonly name?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/ionoscloud/r/server#size Server#size}
    */
    readonly size?: number;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/ionoscloud/r/server#ssh_key_path Server#ssh_key_path}
    */
    readonly sshKeyPath?: string[];
    /**
    * The cloud-init configuration for the volume as base64 encoded string. The property is immutable and is only allowed to be set on a new volume creation. It is mandatory to provide either 'public image' or 'imageAlias' that has cloud-init compatibility in conjunction with this property.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/ionoscloud/r/server#user_data Server#user_data}
    */
    readonly userData?: string;
}
export declare function serverVolumeToTerraform(struct?: ServerVolumeOutputReference | ServerVolume): any;
export declare class ServerVolumeOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): ServerVolume | undefined;
    set internalValue(value: ServerVolume | undefined);
    private _availabilityZone?;
    get availabilityZone(): string;
    set availabilityZone(value: string);
    resetAvailabilityZone(): void;
    get availabilityZoneInput(): string | undefined;
    private _backupUnitId?;
    get backupUnitId(): string;
    set backupUnitId(value: string);
    resetBackupUnitId(): void;
    get backupUnitIdInput(): string | undefined;
    get bootServer(): string;
    private _bus?;
    get bus(): string;
    set bus(value: string);
    resetBus(): void;
    get busInput(): string | undefined;
    get cpuHotPlug(): cdktf.IResolvable;
    get deviceNumber(): number;
    get discVirtioHotPlug(): cdktf.IResolvable;
    get discVirtioHotUnplug(): cdktf.IResolvable;
    private _diskType?;
    get diskType(): string;
    set diskType(value: string);
    get diskTypeInput(): string | undefined;
    private _imageName?;
    get imageName(): string;
    set imageName(value: string);
    resetImageName(): void;
    get imageNameInput(): string | undefined;
    private _imagePassword?;
    get imagePassword(): string;
    set imagePassword(value: string);
    resetImagePassword(): void;
    get imagePasswordInput(): string | undefined;
    private _licenceType?;
    get licenceType(): string;
    set licenceType(value: string);
    resetLicenceType(): void;
    get licenceTypeInput(): string | undefined;
    private _name?;
    get name(): string;
    set name(value: string);
    resetName(): void;
    get nameInput(): string | undefined;
    get nicHotPlug(): cdktf.IResolvable;
    get nicHotUnplug(): cdktf.IResolvable;
    get pciSlot(): number;
    get ramHotPlug(): cdktf.IResolvable;
    private _size?;
    get size(): number;
    set size(value: number);
    resetSize(): void;
    get sizeInput(): number | undefined;
    private _sshKeyPath?;
    get sshKeyPath(): string[];
    set sshKeyPath(value: string[]);
    resetSshKeyPath(): void;
    get sshKeyPathInput(): string[] | undefined;
    private _userData?;
    get userData(): string;
    set userData(value: string);
    resetUserData(): void;
    get userDataInput(): string | undefined;
}
/**
* Represents a {@link https://www.terraform.io/docs/providers/ionoscloud/r/server ionoscloud_server}
*/
export declare class Server extends cdktf.TerraformResource {
    static readonly tfResourceType = "ionoscloud_server";
    /**
    * Create a new {@link https://www.terraform.io/docs/providers/ionoscloud/r/server ionoscloud_server} Resource
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options ServerConfig
    */
    constructor(scope: Construct, id: string, config: ServerConfig);
    private _availabilityZone?;
    get availabilityZone(): string;
    set availabilityZone(value: string);
    resetAvailabilityZone(): void;
    get availabilityZoneInput(): string | undefined;
    private _bootCdrom?;
    get bootCdrom(): string;
    set bootCdrom(value: string);
    resetBootCdrom(): void;
    get bootCdromInput(): string | undefined;
    private _bootImage?;
    get bootImage(): string;
    set bootImage(value: string);
    resetBootImage(): void;
    get bootImageInput(): string | undefined;
    get bootVolume(): string;
    private _cores?;
    get cores(): number;
    set cores(value: number);
    resetCores(): void;
    get coresInput(): number | undefined;
    private _cpuFamily?;
    get cpuFamily(): string;
    set cpuFamily(value: string);
    resetCpuFamily(): void;
    get cpuFamilyInput(): string | undefined;
    private _datacenterId?;
    get datacenterId(): string;
    set datacenterId(value: string);
    get datacenterIdInput(): string | undefined;
    get firewallruleId(): string;
    get id(): string;
    private _imageName?;
    get imageName(): string;
    set imageName(value: string);
    resetImageName(): void;
    get imageNameInput(): string | undefined;
    private _imagePassword?;
    get imagePassword(): string;
    set imagePassword(value: string);
    resetImagePassword(): void;
    get imagePasswordInput(): string | undefined;
    private _name?;
    get name(): string;
    set name(value: string);
    get nameInput(): string | undefined;
    get primaryIp(): string;
    get primaryNic(): string;
    private _ram?;
    get ram(): number;
    set ram(value: number);
    resetRam(): void;
    get ramInput(): number | undefined;
    private _sshKeyPath?;
    get sshKeyPath(): string[];
    set sshKeyPath(value: string[]);
    resetSshKeyPath(): void;
    get sshKeyPathInput(): string[] | undefined;
    private _templateUuid?;
    get templateUuid(): string;
    set templateUuid(value: string);
    resetTemplateUuid(): void;
    get templateUuidInput(): string | undefined;
    private _type?;
    get type(): string;
    set type(value: string);
    resetType(): void;
    get typeInput(): string | undefined;
    private _nic;
    get nic(): ServerNicOutputReference;
    putNic(value: ServerNic): void;
    get nicInput(): ServerNic | undefined;
    private _timeouts;
    get timeouts(): ServerTimeoutsOutputReference;
    putTimeouts(value: ServerTimeouts): void;
    resetTimeouts(): void;
    get timeoutsInput(): ServerTimeouts | undefined;
    private _volume;
    get volume(): ServerVolumeOutputReference;
    putVolume(value: ServerVolume): void;
    get volumeInput(): ServerVolume | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
