#!/usr/bin/env bash
set -x

# Available environment variables
#
# DOCKER_REGISTRY
# REPOSITORY
# VERSION

DOCKER_REGISTRY=${DOCKER_REGISTRY:-quay.io}
REVISION=$(git rev-parse HEAD)
VERSION=${VERSION:-latest}

if [[ -n $DOCKER_REGISTRY ]]; then
    REPOSITORY="$DOCKER_REGISTRY/$REPOSITORY"
fi

buildah login --password $DOCKER_PASSWORD --username $DOCKER_USERNAME $DOCKER_REGISTRY

buildah tag "$REPOSITORY:$REVISION" "$REPOSITORY:$VERSION"
buildah push "$REPOSITORY:$VERSION"

buildah tag "$REPOSITORY-netbox:$REVISION" "$REPOSITORY-netbox:$VERSION"
buildah push "$REPOSITORY-netbox:$VERSION"
