import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface ComputeProjectMetadataConfig extends cdktf.TerraformMetaArguments {
    /**
    * A series of key value pairs.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_project_metadata#metadata ComputeProjectMetadata#metadata}
    */
    readonly metadata: {
        [key: string]: string;
    };
    /**
    * The ID of the project in which the resource belongs. If it is not provided, the provider project is used.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_project_metadata#project ComputeProjectMetadata#project}
    */
    readonly project?: string;
    /**
    * timeouts block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_project_metadata#timeouts ComputeProjectMetadata#timeouts}
    */
    readonly timeouts?: ComputeProjectMetadataTimeouts;
}
export interface ComputeProjectMetadataTimeouts {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_project_metadata#create ComputeProjectMetadata#create}
    */
    readonly create?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_project_metadata#delete ComputeProjectMetadata#delete}
    */
    readonly delete?: string;
}
export declare function computeProjectMetadataTimeoutsToTerraform(struct?: ComputeProjectMetadataTimeoutsOutputReference | ComputeProjectMetadataTimeouts | cdktf.IResolvable): any;
export declare class ComputeProjectMetadataTimeoutsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): ComputeProjectMetadataTimeouts | undefined;
    set internalValue(value: ComputeProjectMetadataTimeouts | undefined);
    private _create?;
    get create(): string;
    set create(value: string);
    resetCreate(): void;
    get createInput(): string | undefined;
    private _delete?;
    get delete(): string;
    set delete(value: string);
    resetDelete(): void;
    get deleteInput(): string | undefined;
}
/**
* Represents a {@link https://www.terraform.io/docs/providers/google/r/compute_project_metadata google_compute_project_metadata}
*/
export declare class ComputeProjectMetadata extends cdktf.TerraformResource {
    static readonly tfResourceType = "google_compute_project_metadata";
    /**
    * Create a new {@link https://www.terraform.io/docs/providers/google/r/compute_project_metadata google_compute_project_metadata} Resource
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options ComputeProjectMetadataConfig
    */
    constructor(scope: Construct, id: string, config: ComputeProjectMetadataConfig);
    get id(): string;
    private _metadata?;
    get metadata(): {
        [key: string]: string;
    };
    set metadata(value: {
        [key: string]: string;
    });
    get metadataInput(): {
        [key: string]: string;
    } | undefined;
    private _project?;
    get project(): string;
    set project(value: string);
    resetProject(): void;
    get projectInput(): string | undefined;
    private _timeouts;
    get timeouts(): ComputeProjectMetadataTimeoutsOutputReference;
    putTimeouts(value: ComputeProjectMetadataTimeouts): void;
    resetTimeouts(): void;
    get timeoutsInput(): ComputeProjectMetadataTimeouts | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
