"use strict";
var _a, _b, _c;
Object.defineProperty(exports, "__esModule", { value: true });
exports.ComputeRouterNat = exports.ComputeRouterNatTimeoutsOutputReference = exports.computeRouterNatTimeoutsToTerraform = exports.computeRouterNatSubnetworkToTerraform = exports.ComputeRouterNatLogConfigOutputReference = exports.computeRouterNatLogConfigToTerraform = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const cdktf = require("cdktf");
function computeRouterNatLogConfigToTerraform(struct) {
    if (!cdktf.canInspect(struct) || cdktf.Tokenization.isResolvable(struct)) {
        return struct;
    }
    if (cdktf.isComplexElement(struct)) {
        throw new Error("A complex element was used as configuration, this is not supported: https://cdk.tf/complex-object-as-configuration");
    }
    return {
        enable: cdktf.booleanToTerraform(struct.enable),
        filter: cdktf.stringToTerraform(struct.filter),
    };
}
exports.computeRouterNatLogConfigToTerraform = computeRouterNatLogConfigToTerraform;
class ComputeRouterNatLogConfigOutputReference extends cdktf.ComplexObject {
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource, terraformAttribute) {
        super(terraformResource, terraformAttribute, false, 0);
        this.isEmptyObject = false;
    }
    get internalValue() {
        let hasAnyValues = this.isEmptyObject;
        const internalValueResult = {};
        if (this._enable !== undefined) {
            hasAnyValues = true;
            internalValueResult.enable = this._enable;
        }
        if (this._filter !== undefined) {
            hasAnyValues = true;
            internalValueResult.filter = this._filter;
        }
        return hasAnyValues ? internalValueResult : undefined;
    }
    set internalValue(value) {
        if (value === undefined) {
            this.isEmptyObject = false;
            this._enable = undefined;
            this._filter = undefined;
        }
        else {
            this.isEmptyObject = Object.keys(value).length === 0;
            this._enable = value.enable;
            this._filter = value.filter;
        }
    }
    get enable() {
        return this.getBooleanAttribute('enable');
    }
    set enable(value) {
        this._enable = value;
    }
    // Temporarily expose input value. Use with caution.
    get enableInput() {
        return this._enable;
    }
    get filter() {
        return this.getStringAttribute('filter');
    }
    set filter(value) {
        this._filter = value;
    }
    // Temporarily expose input value. Use with caution.
    get filterInput() {
        return this._filter;
    }
}
exports.ComputeRouterNatLogConfigOutputReference = ComputeRouterNatLogConfigOutputReference;
_a = JSII_RTTI_SYMBOL_1;
ComputeRouterNatLogConfigOutputReference[_a] = { fqn: "@cdktf/provider-google.ComputeRouterNatLogConfigOutputReference", version: "0.8.24" };
function computeRouterNatSubnetworkToTerraform(struct) {
    if (!cdktf.canInspect(struct) || cdktf.Tokenization.isResolvable(struct)) {
        return struct;
    }
    if (cdktf.isComplexElement(struct)) {
        throw new Error("A complex element was used as configuration, this is not supported: https://cdk.tf/complex-object-as-configuration");
    }
    return {
        name: cdktf.stringToTerraform(struct.name),
        secondary_ip_range_names: cdktf.listMapper(cdktf.stringToTerraform)(struct.secondaryIpRangeNames),
        source_ip_ranges_to_nat: cdktf.listMapper(cdktf.stringToTerraform)(struct.sourceIpRangesToNat),
    };
}
exports.computeRouterNatSubnetworkToTerraform = computeRouterNatSubnetworkToTerraform;
function computeRouterNatTimeoutsToTerraform(struct) {
    if (!cdktf.canInspect(struct) || cdktf.Tokenization.isResolvable(struct)) {
        return struct;
    }
    if (cdktf.isComplexElement(struct)) {
        throw new Error("A complex element was used as configuration, this is not supported: https://cdk.tf/complex-object-as-configuration");
    }
    return {
        create: cdktf.stringToTerraform(struct.create),
        delete: cdktf.stringToTerraform(struct.delete),
        update: cdktf.stringToTerraform(struct.update),
    };
}
exports.computeRouterNatTimeoutsToTerraform = computeRouterNatTimeoutsToTerraform;
class ComputeRouterNatTimeoutsOutputReference extends cdktf.ComplexObject {
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource, terraformAttribute) {
        super(terraformResource, terraformAttribute, false, 0);
        this.isEmptyObject = false;
    }
    get internalValue() {
        let hasAnyValues = this.isEmptyObject;
        const internalValueResult = {};
        if (this._create !== undefined) {
            hasAnyValues = true;
            internalValueResult.create = this._create;
        }
        if (this._delete !== undefined) {
            hasAnyValues = true;
            internalValueResult.delete = this._delete;
        }
        if (this._update !== undefined) {
            hasAnyValues = true;
            internalValueResult.update = this._update;
        }
        return hasAnyValues ? internalValueResult : undefined;
    }
    set internalValue(value) {
        if (value === undefined) {
            this.isEmptyObject = false;
            this._create = undefined;
            this._delete = undefined;
            this._update = undefined;
        }
        else {
            this.isEmptyObject = Object.keys(value).length === 0;
            this._create = value.create;
            this._delete = value.delete;
            this._update = value.update;
        }
    }
    get create() {
        return this.getStringAttribute('create');
    }
    set create(value) {
        this._create = value;
    }
    resetCreate() {
        this._create = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get createInput() {
        return this._create;
    }
    get delete() {
        return this.getStringAttribute('delete');
    }
    set delete(value) {
        this._delete = value;
    }
    resetDelete() {
        this._delete = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get deleteInput() {
        return this._delete;
    }
    get update() {
        return this.getStringAttribute('update');
    }
    set update(value) {
        this._update = value;
    }
    resetUpdate() {
        this._update = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get updateInput() {
        return this._update;
    }
}
exports.ComputeRouterNatTimeoutsOutputReference = ComputeRouterNatTimeoutsOutputReference;
_b = JSII_RTTI_SYMBOL_1;
ComputeRouterNatTimeoutsOutputReference[_b] = { fqn: "@cdktf/provider-google.ComputeRouterNatTimeoutsOutputReference", version: "0.8.24" };
/**
* Represents a {@link https://www.terraform.io/docs/providers/google/r/compute_router_nat google_compute_router_nat}
*/
class ComputeRouterNat extends cdktf.TerraformResource {
    // ===========
    // INITIALIZER
    // ===========
    /**
    * Create a new {@link https://www.terraform.io/docs/providers/google/r/compute_router_nat google_compute_router_nat} Resource
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options ComputeRouterNatConfig
    */
    constructor(scope, id, config) {
        super(scope, id, {
            terraformResourceType: 'google_compute_router_nat',
            terraformGeneratorMetadata: {
                providerName: 'google',
                providerVersion: '4.19.0',
                providerVersionConstraint: '~> 4.0'
            },
            provider: config.provider,
            dependsOn: config.dependsOn,
            count: config.count,
            lifecycle: config.lifecycle
        });
        // log_config - computed: false, optional: true, required: false
        this._logConfig = new ComputeRouterNatLogConfigOutputReference(this, "log_config");
        // timeouts - computed: false, optional: true, required: false
        this._timeouts = new ComputeRouterNatTimeoutsOutputReference(this, "timeouts");
        this._drainNatIps = config.drainNatIps;
        this._enableEndpointIndependentMapping = config.enableEndpointIndependentMapping;
        this._icmpIdleTimeoutSec = config.icmpIdleTimeoutSec;
        this._minPortsPerVm = config.minPortsPerVm;
        this._name = config.name;
        this._natIpAllocateOption = config.natIpAllocateOption;
        this._natIps = config.natIps;
        this._project = config.project;
        this._region = config.region;
        this._router = config.router;
        this._sourceSubnetworkIpRangesToNat = config.sourceSubnetworkIpRangesToNat;
        this._tcpEstablishedIdleTimeoutSec = config.tcpEstablishedIdleTimeoutSec;
        this._tcpTransitoryIdleTimeoutSec = config.tcpTransitoryIdleTimeoutSec;
        this._udpIdleTimeoutSec = config.udpIdleTimeoutSec;
        this._logConfig.internalValue = config.logConfig;
        this._subnetwork = config.subnetwork;
        this._timeouts.internalValue = config.timeouts;
    }
    get drainNatIps() {
        return cdktf.Fn.tolist(this.getListAttribute('drain_nat_ips'));
    }
    set drainNatIps(value) {
        this._drainNatIps = value;
    }
    resetDrainNatIps() {
        this._drainNatIps = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get drainNatIpsInput() {
        return this._drainNatIps;
    }
    get enableEndpointIndependentMapping() {
        return this.getBooleanAttribute('enable_endpoint_independent_mapping');
    }
    set enableEndpointIndependentMapping(value) {
        this._enableEndpointIndependentMapping = value;
    }
    resetEnableEndpointIndependentMapping() {
        this._enableEndpointIndependentMapping = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get enableEndpointIndependentMappingInput() {
        return this._enableEndpointIndependentMapping;
    }
    get icmpIdleTimeoutSec() {
        return this.getNumberAttribute('icmp_idle_timeout_sec');
    }
    set icmpIdleTimeoutSec(value) {
        this._icmpIdleTimeoutSec = value;
    }
    resetIcmpIdleTimeoutSec() {
        this._icmpIdleTimeoutSec = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get icmpIdleTimeoutSecInput() {
        return this._icmpIdleTimeoutSec;
    }
    // id - computed: true, optional: true, required: false
    get id() {
        return this.getStringAttribute('id');
    }
    get minPortsPerVm() {
        return this.getNumberAttribute('min_ports_per_vm');
    }
    set minPortsPerVm(value) {
        this._minPortsPerVm = value;
    }
    resetMinPortsPerVm() {
        this._minPortsPerVm = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get minPortsPerVmInput() {
        return this._minPortsPerVm;
    }
    get name() {
        return this.getStringAttribute('name');
    }
    set name(value) {
        this._name = value;
    }
    // Temporarily expose input value. Use with caution.
    get nameInput() {
        return this._name;
    }
    get natIpAllocateOption() {
        return this.getStringAttribute('nat_ip_allocate_option');
    }
    set natIpAllocateOption(value) {
        this._natIpAllocateOption = value;
    }
    // Temporarily expose input value. Use with caution.
    get natIpAllocateOptionInput() {
        return this._natIpAllocateOption;
    }
    get natIps() {
        return cdktf.Fn.tolist(this.getListAttribute('nat_ips'));
    }
    set natIps(value) {
        this._natIps = value;
    }
    resetNatIps() {
        this._natIps = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get natIpsInput() {
        return this._natIps;
    }
    get project() {
        return this.getStringAttribute('project');
    }
    set project(value) {
        this._project = value;
    }
    resetProject() {
        this._project = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get projectInput() {
        return this._project;
    }
    get region() {
        return this.getStringAttribute('region');
    }
    set region(value) {
        this._region = value;
    }
    resetRegion() {
        this._region = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get regionInput() {
        return this._region;
    }
    get router() {
        return this.getStringAttribute('router');
    }
    set router(value) {
        this._router = value;
    }
    // Temporarily expose input value. Use with caution.
    get routerInput() {
        return this._router;
    }
    get sourceSubnetworkIpRangesToNat() {
        return this.getStringAttribute('source_subnetwork_ip_ranges_to_nat');
    }
    set sourceSubnetworkIpRangesToNat(value) {
        this._sourceSubnetworkIpRangesToNat = value;
    }
    // Temporarily expose input value. Use with caution.
    get sourceSubnetworkIpRangesToNatInput() {
        return this._sourceSubnetworkIpRangesToNat;
    }
    get tcpEstablishedIdleTimeoutSec() {
        return this.getNumberAttribute('tcp_established_idle_timeout_sec');
    }
    set tcpEstablishedIdleTimeoutSec(value) {
        this._tcpEstablishedIdleTimeoutSec = value;
    }
    resetTcpEstablishedIdleTimeoutSec() {
        this._tcpEstablishedIdleTimeoutSec = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get tcpEstablishedIdleTimeoutSecInput() {
        return this._tcpEstablishedIdleTimeoutSec;
    }
    get tcpTransitoryIdleTimeoutSec() {
        return this.getNumberAttribute('tcp_transitory_idle_timeout_sec');
    }
    set tcpTransitoryIdleTimeoutSec(value) {
        this._tcpTransitoryIdleTimeoutSec = value;
    }
    resetTcpTransitoryIdleTimeoutSec() {
        this._tcpTransitoryIdleTimeoutSec = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get tcpTransitoryIdleTimeoutSecInput() {
        return this._tcpTransitoryIdleTimeoutSec;
    }
    get udpIdleTimeoutSec() {
        return this.getNumberAttribute('udp_idle_timeout_sec');
    }
    set udpIdleTimeoutSec(value) {
        this._udpIdleTimeoutSec = value;
    }
    resetUdpIdleTimeoutSec() {
        this._udpIdleTimeoutSec = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get udpIdleTimeoutSecInput() {
        return this._udpIdleTimeoutSec;
    }
    get logConfig() {
        return this._logConfig;
    }
    putLogConfig(value) {
        this._logConfig.internalValue = value;
    }
    resetLogConfig() {
        this._logConfig.internalValue = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get logConfigInput() {
        return this._logConfig.internalValue;
    }
    get subnetwork() {
        // Getting the computed value is not yet implemented
        return cdktf.Token.asAny(cdktf.Fn.tolist(this.interpolationForAttribute('subnetwork')));
    }
    set subnetwork(value) {
        this._subnetwork = value;
    }
    resetSubnetwork() {
        this._subnetwork = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get subnetworkInput() {
        return this._subnetwork;
    }
    get timeouts() {
        return this._timeouts;
    }
    putTimeouts(value) {
        this._timeouts.internalValue = value;
    }
    resetTimeouts() {
        this._timeouts.internalValue = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get timeoutsInput() {
        return this._timeouts.internalValue;
    }
    // =========
    // SYNTHESIS
    // =========
    synthesizeAttributes() {
        return {
            drain_nat_ips: cdktf.listMapper(cdktf.stringToTerraform)(this._drainNatIps),
            enable_endpoint_independent_mapping: cdktf.booleanToTerraform(this._enableEndpointIndependentMapping),
            icmp_idle_timeout_sec: cdktf.numberToTerraform(this._icmpIdleTimeoutSec),
            min_ports_per_vm: cdktf.numberToTerraform(this._minPortsPerVm),
            name: cdktf.stringToTerraform(this._name),
            nat_ip_allocate_option: cdktf.stringToTerraform(this._natIpAllocateOption),
            nat_ips: cdktf.listMapper(cdktf.stringToTerraform)(this._natIps),
            project: cdktf.stringToTerraform(this._project),
            region: cdktf.stringToTerraform(this._region),
            router: cdktf.stringToTerraform(this._router),
            source_subnetwork_ip_ranges_to_nat: cdktf.stringToTerraform(this._sourceSubnetworkIpRangesToNat),
            tcp_established_idle_timeout_sec: cdktf.numberToTerraform(this._tcpEstablishedIdleTimeoutSec),
            tcp_transitory_idle_timeout_sec: cdktf.numberToTerraform(this._tcpTransitoryIdleTimeoutSec),
            udp_idle_timeout_sec: cdktf.numberToTerraform(this._udpIdleTimeoutSec),
            log_config: computeRouterNatLogConfigToTerraform(this._logConfig.internalValue),
            subnetwork: cdktf.listMapper(computeRouterNatSubnetworkToTerraform)(this._subnetwork),
            timeouts: computeRouterNatTimeoutsToTerraform(this._timeouts.internalValue),
        };
    }
}
exports.ComputeRouterNat = ComputeRouterNat;
_c = JSII_RTTI_SYMBOL_1;
ComputeRouterNat[_c] = { fqn: "@cdktf/provider-google.ComputeRouterNat", version: "0.8.24" };
// =================
// STATIC PROPERTIES
// =================
ComputeRouterNat.tfResourceType = "google_compute_router_nat";
//# sourceMappingURL=data:application/json;base64,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