import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface DataGoogleComputeBackendServiceConfig extends cdktf.TerraformMetaArguments {
    /**
    * Name of the resource. Provided by the client when the resource is
  created. The name must be 1-63 characters long, and comply with
  RFC1035. Specifically, the name must be 1-63 characters long and match
  the regular expression '[a-z]([-a-z0-9]*[a-z0-9])?' which means the
  first character must be a lowercase letter, and all following
  characters must be a dash, lowercase letter, or digit, except the last
  character, which cannot be a dash.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/d/compute_backend_service#name DataGoogleComputeBackendService#name}
    */
    readonly name: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/d/compute_backend_service#project DataGoogleComputeBackendService#project}
    */
    readonly project?: string;
}
export interface DataGoogleComputeBackendServiceBackend {
}
export declare function dataGoogleComputeBackendServiceBackendToTerraform(struct?: DataGoogleComputeBackendServiceBackend): any;
export declare class DataGoogleComputeBackendServiceBackendOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): DataGoogleComputeBackendServiceBackend | undefined;
    set internalValue(value: DataGoogleComputeBackendServiceBackend | undefined);
    get balancingMode(): string;
    get capacityScaler(): number;
    get description(): string;
    get group(): string;
    get maxConnections(): number;
    get maxConnectionsPerEndpoint(): number;
    get maxConnectionsPerInstance(): number;
    get maxRate(): number;
    get maxRatePerEndpoint(): number;
    get maxRatePerInstance(): number;
    get maxUtilization(): number;
}
export declare class DataGoogleComputeBackendServiceBackendList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): DataGoogleComputeBackendServiceBackendOutputReference;
}
export interface DataGoogleComputeBackendServiceCdnPolicyCacheKeyPolicy {
}
export declare function dataGoogleComputeBackendServiceCdnPolicyCacheKeyPolicyToTerraform(struct?: DataGoogleComputeBackendServiceCdnPolicyCacheKeyPolicy): any;
export declare class DataGoogleComputeBackendServiceCdnPolicyCacheKeyPolicyOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): DataGoogleComputeBackendServiceCdnPolicyCacheKeyPolicy | undefined;
    set internalValue(value: DataGoogleComputeBackendServiceCdnPolicyCacheKeyPolicy | undefined);
    get includeHost(): cdktf.IResolvable;
    get includeProtocol(): cdktf.IResolvable;
    get includeQueryString(): cdktf.IResolvable;
    get queryStringBlacklist(): string[];
    get queryStringWhitelist(): string[];
}
export declare class DataGoogleComputeBackendServiceCdnPolicyCacheKeyPolicyList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): DataGoogleComputeBackendServiceCdnPolicyCacheKeyPolicyOutputReference;
}
export interface DataGoogleComputeBackendServiceCdnPolicyNegativeCachingPolicy {
}
export declare function dataGoogleComputeBackendServiceCdnPolicyNegativeCachingPolicyToTerraform(struct?: DataGoogleComputeBackendServiceCdnPolicyNegativeCachingPolicy): any;
export declare class DataGoogleComputeBackendServiceCdnPolicyNegativeCachingPolicyOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): DataGoogleComputeBackendServiceCdnPolicyNegativeCachingPolicy | undefined;
    set internalValue(value: DataGoogleComputeBackendServiceCdnPolicyNegativeCachingPolicy | undefined);
    get code(): number;
    get ttl(): number;
}
export declare class DataGoogleComputeBackendServiceCdnPolicyNegativeCachingPolicyList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): DataGoogleComputeBackendServiceCdnPolicyNegativeCachingPolicyOutputReference;
}
export interface DataGoogleComputeBackendServiceCdnPolicy {
}
export declare function dataGoogleComputeBackendServiceCdnPolicyToTerraform(struct?: DataGoogleComputeBackendServiceCdnPolicy): any;
export declare class DataGoogleComputeBackendServiceCdnPolicyOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): DataGoogleComputeBackendServiceCdnPolicy | undefined;
    set internalValue(value: DataGoogleComputeBackendServiceCdnPolicy | undefined);
    private _cacheKeyPolicy;
    get cacheKeyPolicy(): DataGoogleComputeBackendServiceCdnPolicyCacheKeyPolicyList;
    get cacheMode(): string;
    get clientTtl(): number;
    get defaultTtl(): number;
    get maxTtl(): number;
    get negativeCaching(): cdktf.IResolvable;
    private _negativeCachingPolicy;
    get negativeCachingPolicy(): DataGoogleComputeBackendServiceCdnPolicyNegativeCachingPolicyList;
    get serveWhileStale(): number;
    get signedUrlCacheMaxAgeSec(): number;
}
export declare class DataGoogleComputeBackendServiceCdnPolicyList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): DataGoogleComputeBackendServiceCdnPolicyOutputReference;
}
export interface DataGoogleComputeBackendServiceCircuitBreakers {
}
export declare function dataGoogleComputeBackendServiceCircuitBreakersToTerraform(struct?: DataGoogleComputeBackendServiceCircuitBreakers): any;
export declare class DataGoogleComputeBackendServiceCircuitBreakersOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): DataGoogleComputeBackendServiceCircuitBreakers | undefined;
    set internalValue(value: DataGoogleComputeBackendServiceCircuitBreakers | undefined);
    get maxConnections(): number;
    get maxPendingRequests(): number;
    get maxRequests(): number;
    get maxRequestsPerConnection(): number;
    get maxRetries(): number;
}
export declare class DataGoogleComputeBackendServiceCircuitBreakersList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): DataGoogleComputeBackendServiceCircuitBreakersOutputReference;
}
export interface DataGoogleComputeBackendServiceConsistentHashHttpCookieTtl {
}
export declare function dataGoogleComputeBackendServiceConsistentHashHttpCookieTtlToTerraform(struct?: DataGoogleComputeBackendServiceConsistentHashHttpCookieTtl): any;
export declare class DataGoogleComputeBackendServiceConsistentHashHttpCookieTtlOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): DataGoogleComputeBackendServiceConsistentHashHttpCookieTtl | undefined;
    set internalValue(value: DataGoogleComputeBackendServiceConsistentHashHttpCookieTtl | undefined);
    get nanos(): number;
    get seconds(): number;
}
export declare class DataGoogleComputeBackendServiceConsistentHashHttpCookieTtlList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): DataGoogleComputeBackendServiceConsistentHashHttpCookieTtlOutputReference;
}
export interface DataGoogleComputeBackendServiceConsistentHashHttpCookie {
}
export declare function dataGoogleComputeBackendServiceConsistentHashHttpCookieToTerraform(struct?: DataGoogleComputeBackendServiceConsistentHashHttpCookie): any;
export declare class DataGoogleComputeBackendServiceConsistentHashHttpCookieOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): DataGoogleComputeBackendServiceConsistentHashHttpCookie | undefined;
    set internalValue(value: DataGoogleComputeBackendServiceConsistentHashHttpCookie | undefined);
    get name(): string;
    get path(): string;
    private _ttl;
    get ttl(): DataGoogleComputeBackendServiceConsistentHashHttpCookieTtlList;
}
export declare class DataGoogleComputeBackendServiceConsistentHashHttpCookieList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): DataGoogleComputeBackendServiceConsistentHashHttpCookieOutputReference;
}
export interface DataGoogleComputeBackendServiceConsistentHash {
}
export declare function dataGoogleComputeBackendServiceConsistentHashToTerraform(struct?: DataGoogleComputeBackendServiceConsistentHash): any;
export declare class DataGoogleComputeBackendServiceConsistentHashOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): DataGoogleComputeBackendServiceConsistentHash | undefined;
    set internalValue(value: DataGoogleComputeBackendServiceConsistentHash | undefined);
    private _httpCookie;
    get httpCookie(): DataGoogleComputeBackendServiceConsistentHashHttpCookieList;
    get httpHeaderName(): string;
    get minimumRingSize(): number;
}
export declare class DataGoogleComputeBackendServiceConsistentHashList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): DataGoogleComputeBackendServiceConsistentHashOutputReference;
}
export interface DataGoogleComputeBackendServiceIap {
}
export declare function dataGoogleComputeBackendServiceIapToTerraform(struct?: DataGoogleComputeBackendServiceIap): any;
export declare class DataGoogleComputeBackendServiceIapOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): DataGoogleComputeBackendServiceIap | undefined;
    set internalValue(value: DataGoogleComputeBackendServiceIap | undefined);
    get oauth2ClientId(): string;
    get oauth2ClientSecret(): string;
    get oauth2ClientSecretSha256(): string;
}
export declare class DataGoogleComputeBackendServiceIapList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): DataGoogleComputeBackendServiceIapOutputReference;
}
export interface DataGoogleComputeBackendServiceLogConfig {
}
export declare function dataGoogleComputeBackendServiceLogConfigToTerraform(struct?: DataGoogleComputeBackendServiceLogConfig): any;
export declare class DataGoogleComputeBackendServiceLogConfigOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): DataGoogleComputeBackendServiceLogConfig | undefined;
    set internalValue(value: DataGoogleComputeBackendServiceLogConfig | undefined);
    get enable(): cdktf.IResolvable;
    get sampleRate(): number;
}
export declare class DataGoogleComputeBackendServiceLogConfigList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): DataGoogleComputeBackendServiceLogConfigOutputReference;
}
export interface DataGoogleComputeBackendServiceOutlierDetectionBaseEjectionTime {
}
export declare function dataGoogleComputeBackendServiceOutlierDetectionBaseEjectionTimeToTerraform(struct?: DataGoogleComputeBackendServiceOutlierDetectionBaseEjectionTime): any;
export declare class DataGoogleComputeBackendServiceOutlierDetectionBaseEjectionTimeOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): DataGoogleComputeBackendServiceOutlierDetectionBaseEjectionTime | undefined;
    set internalValue(value: DataGoogleComputeBackendServiceOutlierDetectionBaseEjectionTime | undefined);
    get nanos(): number;
    get seconds(): number;
}
export declare class DataGoogleComputeBackendServiceOutlierDetectionBaseEjectionTimeList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): DataGoogleComputeBackendServiceOutlierDetectionBaseEjectionTimeOutputReference;
}
export interface DataGoogleComputeBackendServiceOutlierDetectionInterval {
}
export declare function dataGoogleComputeBackendServiceOutlierDetectionIntervalToTerraform(struct?: DataGoogleComputeBackendServiceOutlierDetectionInterval): any;
export declare class DataGoogleComputeBackendServiceOutlierDetectionIntervalOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): DataGoogleComputeBackendServiceOutlierDetectionInterval | undefined;
    set internalValue(value: DataGoogleComputeBackendServiceOutlierDetectionInterval | undefined);
    get nanos(): number;
    get seconds(): number;
}
export declare class DataGoogleComputeBackendServiceOutlierDetectionIntervalList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): DataGoogleComputeBackendServiceOutlierDetectionIntervalOutputReference;
}
export interface DataGoogleComputeBackendServiceOutlierDetection {
}
export declare function dataGoogleComputeBackendServiceOutlierDetectionToTerraform(struct?: DataGoogleComputeBackendServiceOutlierDetection): any;
export declare class DataGoogleComputeBackendServiceOutlierDetectionOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): DataGoogleComputeBackendServiceOutlierDetection | undefined;
    set internalValue(value: DataGoogleComputeBackendServiceOutlierDetection | undefined);
    private _baseEjectionTime;
    get baseEjectionTime(): DataGoogleComputeBackendServiceOutlierDetectionBaseEjectionTimeList;
    get consecutiveErrors(): number;
    get consecutiveGatewayFailure(): number;
    get enforcingConsecutiveErrors(): number;
    get enforcingConsecutiveGatewayFailure(): number;
    get enforcingSuccessRate(): number;
    private _interval;
    get interval(): DataGoogleComputeBackendServiceOutlierDetectionIntervalList;
    get maxEjectionPercent(): number;
    get successRateMinimumHosts(): number;
    get successRateRequestVolume(): number;
    get successRateStdevFactor(): number;
}
export declare class DataGoogleComputeBackendServiceOutlierDetectionList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): DataGoogleComputeBackendServiceOutlierDetectionOutputReference;
}
export interface DataGoogleComputeBackendServiceSecuritySettings {
}
export declare function dataGoogleComputeBackendServiceSecuritySettingsToTerraform(struct?: DataGoogleComputeBackendServiceSecuritySettings): any;
export declare class DataGoogleComputeBackendServiceSecuritySettingsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): DataGoogleComputeBackendServiceSecuritySettings | undefined;
    set internalValue(value: DataGoogleComputeBackendServiceSecuritySettings | undefined);
    get clientTlsPolicy(): string;
    get subjectAltNames(): string[];
}
export declare class DataGoogleComputeBackendServiceSecuritySettingsList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): DataGoogleComputeBackendServiceSecuritySettingsOutputReference;
}
/**
* Represents a {@link https://www.terraform.io/docs/providers/google/d/compute_backend_service google_compute_backend_service}
*/
export declare class DataGoogleComputeBackendService extends cdktf.TerraformDataSource {
    static readonly tfResourceType = "google_compute_backend_service";
    /**
    * Create a new {@link https://www.terraform.io/docs/providers/google/d/compute_backend_service google_compute_backend_service} Data Source
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options DataGoogleComputeBackendServiceConfig
    */
    constructor(scope: Construct, id: string, config: DataGoogleComputeBackendServiceConfig);
    get affinityCookieTtlSec(): number;
    private _backend;
    get backend(): DataGoogleComputeBackendServiceBackendList;
    private _cdnPolicy;
    get cdnPolicy(): DataGoogleComputeBackendServiceCdnPolicyList;
    private _circuitBreakers;
    get circuitBreakers(): DataGoogleComputeBackendServiceCircuitBreakersList;
    get connectionDrainingTimeoutSec(): number;
    private _consistentHash;
    get consistentHash(): DataGoogleComputeBackendServiceConsistentHashList;
    get creationTimestamp(): string;
    get customRequestHeaders(): string[];
    get customResponseHeaders(): string[];
    get description(): string;
    get enableCdn(): cdktf.IResolvable;
    get fingerprint(): string;
    get healthChecks(): string[];
    private _iap;
    get iap(): DataGoogleComputeBackendServiceIapList;
    get id(): string;
    get loadBalancingScheme(): string;
    get localityLbPolicy(): string;
    private _logConfig;
    get logConfig(): DataGoogleComputeBackendServiceLogConfigList;
    private _name?;
    get name(): string;
    set name(value: string);
    get nameInput(): string | undefined;
    private _outlierDetection;
    get outlierDetection(): DataGoogleComputeBackendServiceOutlierDetectionList;
    get portName(): string;
    private _project?;
    get project(): string;
    set project(value: string);
    resetProject(): void;
    get projectInput(): string | undefined;
    get protocol(): string;
    get securityPolicy(): string;
    private _securitySettings;
    get securitySettings(): DataGoogleComputeBackendServiceSecuritySettingsList;
    get selfLink(): string;
    get sessionAffinity(): string;
    get timeoutSec(): number;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
