import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface DataGoogleIamPolicyConfig extends cdktf.TerraformMetaArguments {
    /**
    * audit_config block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/d/iam_policy#audit_config DataGoogleIamPolicy#audit_config}
    */
    readonly auditConfig?: DataGoogleIamPolicyAuditConfig[] | cdktf.IResolvable;
    /**
    * binding block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/d/iam_policy#binding DataGoogleIamPolicy#binding}
    */
    readonly binding?: DataGoogleIamPolicyBinding[] | cdktf.IResolvable;
}
export interface DataGoogleIamPolicyAuditConfigAuditLogConfigs {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/d/iam_policy#exempted_members DataGoogleIamPolicy#exempted_members}
    */
    readonly exemptedMembers?: string[];
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/d/iam_policy#log_type DataGoogleIamPolicy#log_type}
    */
    readonly logType: string;
}
export declare function dataGoogleIamPolicyAuditConfigAuditLogConfigsToTerraform(struct?: DataGoogleIamPolicyAuditConfigAuditLogConfigs | cdktf.IResolvable): any;
export interface DataGoogleIamPolicyAuditConfig {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/d/iam_policy#service DataGoogleIamPolicy#service}
    */
    readonly service: string;
    /**
    * audit_log_configs block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/d/iam_policy#audit_log_configs DataGoogleIamPolicy#audit_log_configs}
    */
    readonly auditLogConfigs: DataGoogleIamPolicyAuditConfigAuditLogConfigs[] | cdktf.IResolvable;
}
export declare function dataGoogleIamPolicyAuditConfigToTerraform(struct?: DataGoogleIamPolicyAuditConfig | cdktf.IResolvable): any;
export interface DataGoogleIamPolicyBindingCondition {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/d/iam_policy#description DataGoogleIamPolicy#description}
    */
    readonly description?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/d/iam_policy#expression DataGoogleIamPolicy#expression}
    */
    readonly expression: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/d/iam_policy#title DataGoogleIamPolicy#title}
    */
    readonly title: string;
}
export declare function dataGoogleIamPolicyBindingConditionToTerraform(struct?: DataGoogleIamPolicyBindingConditionOutputReference | DataGoogleIamPolicyBindingCondition): any;
export declare class DataGoogleIamPolicyBindingConditionOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): DataGoogleIamPolicyBindingCondition | undefined;
    set internalValue(value: DataGoogleIamPolicyBindingCondition | undefined);
    private _description?;
    get description(): string;
    set description(value: string);
    resetDescription(): void;
    get descriptionInput(): string | undefined;
    private _expression?;
    get expression(): string;
    set expression(value: string);
    get expressionInput(): string | undefined;
    private _title?;
    get title(): string;
    set title(value: string);
    get titleInput(): string | undefined;
}
export interface DataGoogleIamPolicyBinding {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/d/iam_policy#members DataGoogleIamPolicy#members}
    */
    readonly members: string[];
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/d/iam_policy#role DataGoogleIamPolicy#role}
    */
    readonly role: string;
    /**
    * condition block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/d/iam_policy#condition DataGoogleIamPolicy#condition}
    */
    readonly condition?: DataGoogleIamPolicyBindingCondition;
}
export declare function dataGoogleIamPolicyBindingToTerraform(struct?: DataGoogleIamPolicyBinding | cdktf.IResolvable): any;
/**
* Represents a {@link https://www.terraform.io/docs/providers/google/d/iam_policy google_iam_policy}
*/
export declare class DataGoogleIamPolicy extends cdktf.TerraformDataSource {
    static readonly tfResourceType = "google_iam_policy";
    /**
    * Create a new {@link https://www.terraform.io/docs/providers/google/d/iam_policy google_iam_policy} Data Source
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options DataGoogleIamPolicyConfig = {}
    */
    constructor(scope: Construct, id: string, config?: DataGoogleIamPolicyConfig);
    get id(): string;
    get policyData(): string;
    private _auditConfig?;
    get auditConfig(): DataGoogleIamPolicyAuditConfig[] | cdktf.IResolvable;
    set auditConfig(value: DataGoogleIamPolicyAuditConfig[] | cdktf.IResolvable);
    resetAuditConfig(): void;
    get auditConfigInput(): cdktf.IResolvable | DataGoogleIamPolicyAuditConfig[] | undefined;
    private _binding?;
    get binding(): DataGoogleIamPolicyBinding[] | cdktf.IResolvable;
    set binding(value: DataGoogleIamPolicyBinding[] | cdktf.IResolvable);
    resetBinding(): void;
    get bindingInput(): cdktf.IResolvable | DataGoogleIamPolicyBinding[] | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
