import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface DataGoogleKmsSecretCiphertextConfig extends cdktf.TerraformMetaArguments {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/d/kms_secret_ciphertext#crypto_key DataGoogleKmsSecretCiphertext#crypto_key}
    */
    readonly cryptoKey: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/d/kms_secret_ciphertext#plaintext DataGoogleKmsSecretCiphertext#plaintext}
    */
    readonly plaintext: string;
}
/**
* Represents a {@link https://www.terraform.io/docs/providers/google/d/kms_secret_ciphertext google_kms_secret_ciphertext}
*/
export declare class DataGoogleKmsSecretCiphertext extends cdktf.TerraformDataSource {
    static readonly tfResourceType = "google_kms_secret_ciphertext";
    /**
    * Create a new {@link https://www.terraform.io/docs/providers/google/d/kms_secret_ciphertext google_kms_secret_ciphertext} Data Source
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options DataGoogleKmsSecretCiphertextConfig
    */
    constructor(scope: Construct, id: string, config: DataGoogleKmsSecretCiphertextConfig);
    get ciphertext(): string;
    private _cryptoKey?;
    get cryptoKey(): string;
    set cryptoKey(value: string);
    get cryptoKeyInput(): string | undefined;
    get id(): string;
    private _plaintext?;
    get plaintext(): string;
    set plaintext(value: string);
    get plaintextInput(): string | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
