import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface DataGoogleMonitoringAppEngineServiceConfig extends cdktf.TerraformMetaArguments {
    /**
    * The ID of the App Engine module underlying this service.
  Corresponds to the 'moduleId' resource label for a 'gae_app'
  monitored resource(see https://cloud.google.com/monitoring/api/resources#tag_gae_app)
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/d/monitoring_app_engine_service#module_id DataGoogleMonitoringAppEngineService#module_id}
    */
    readonly moduleId: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/d/monitoring_app_engine_service#project DataGoogleMonitoringAppEngineService#project}
    */
    readonly project?: string;
}
export interface DataGoogleMonitoringAppEngineServiceTelemetry {
}
export declare function dataGoogleMonitoringAppEngineServiceTelemetryToTerraform(struct?: DataGoogleMonitoringAppEngineServiceTelemetry): any;
export declare class DataGoogleMonitoringAppEngineServiceTelemetryOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): DataGoogleMonitoringAppEngineServiceTelemetry | undefined;
    set internalValue(value: DataGoogleMonitoringAppEngineServiceTelemetry | undefined);
    get resourceName(): string;
}
export declare class DataGoogleMonitoringAppEngineServiceTelemetryList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): DataGoogleMonitoringAppEngineServiceTelemetryOutputReference;
}
/**
* Represents a {@link https://www.terraform.io/docs/providers/google/d/monitoring_app_engine_service google_monitoring_app_engine_service}
*/
export declare class DataGoogleMonitoringAppEngineService extends cdktf.TerraformDataSource {
    static readonly tfResourceType = "google_monitoring_app_engine_service";
    /**
    * Create a new {@link https://www.terraform.io/docs/providers/google/d/monitoring_app_engine_service google_monitoring_app_engine_service} Data Source
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options DataGoogleMonitoringAppEngineServiceConfig
    */
    constructor(scope: Construct, id: string, config: DataGoogleMonitoringAppEngineServiceConfig);
    get displayName(): string;
    get id(): string;
    private _moduleId?;
    get moduleId(): string;
    set moduleId(value: string);
    get moduleIdInput(): string | undefined;
    get name(): string;
    private _project?;
    get project(): string;
    set project(value: string);
    resetProject(): void;
    get projectInput(): string | undefined;
    get serviceId(): string;
    private _telemetry;
    get telemetry(): DataGoogleMonitoringAppEngineServiceTelemetryList;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
