import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface DataGoogleSourcerepoRepositoryConfig extends cdktf.TerraformMetaArguments {
    /**
    * Resource name of the repository, of the form '{{repo}}'.
  The repo name may contain slashes. eg, 'name/with/slash'
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/d/sourcerepo_repository#name DataGoogleSourcerepoRepository#name}
    */
    readonly name: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/d/sourcerepo_repository#project DataGoogleSourcerepoRepository#project}
    */
    readonly project?: string;
}
export interface DataGoogleSourcerepoRepositoryPubsubConfigs {
}
export declare function dataGoogleSourcerepoRepositoryPubsubConfigsToTerraform(struct?: DataGoogleSourcerepoRepositoryPubsubConfigs): any;
export declare class DataGoogleSourcerepoRepositoryPubsubConfigsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): DataGoogleSourcerepoRepositoryPubsubConfigs | undefined;
    set internalValue(value: DataGoogleSourcerepoRepositoryPubsubConfigs | undefined);
    get messageFormat(): string;
    get serviceAccountEmail(): string;
    get topic(): string;
}
export declare class DataGoogleSourcerepoRepositoryPubsubConfigsList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): DataGoogleSourcerepoRepositoryPubsubConfigsOutputReference;
}
/**
* Represents a {@link https://www.terraform.io/docs/providers/google/d/sourcerepo_repository google_sourcerepo_repository}
*/
export declare class DataGoogleSourcerepoRepository extends cdktf.TerraformDataSource {
    static readonly tfResourceType = "google_sourcerepo_repository";
    /**
    * Create a new {@link https://www.terraform.io/docs/providers/google/d/sourcerepo_repository google_sourcerepo_repository} Data Source
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options DataGoogleSourcerepoRepositoryConfig
    */
    constructor(scope: Construct, id: string, config: DataGoogleSourcerepoRepositoryConfig);
    get id(): string;
    private _name?;
    get name(): string;
    set name(value: string);
    get nameInput(): string | undefined;
    private _project?;
    get project(): string;
    set project(value: string);
    resetProject(): void;
    get projectInput(): string | undefined;
    private _pubsubConfigs;
    get pubsubConfigs(): DataGoogleSourcerepoRepositoryPubsubConfigsList;
    get size(): number;
    get url(): string;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
