import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface EndpointsServiceConsumersIamPolicyConfig extends cdktf.TerraformMetaArguments {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/endpoints_service_consumers_iam_policy#consumer_project EndpointsServiceConsumersIamPolicy#consumer_project}
    */
    readonly consumerProject: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/endpoints_service_consumers_iam_policy#policy_data EndpointsServiceConsumersIamPolicy#policy_data}
    */
    readonly policyData: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/endpoints_service_consumers_iam_policy#service_name EndpointsServiceConsumersIamPolicy#service_name}
    */
    readonly serviceName: string;
}
/**
* Represents a {@link https://www.terraform.io/docs/providers/google/r/endpoints_service_consumers_iam_policy google_endpoints_service_consumers_iam_policy}
*/
export declare class EndpointsServiceConsumersIamPolicy extends cdktf.TerraformResource {
    static readonly tfResourceType = "google_endpoints_service_consumers_iam_policy";
    /**
    * Create a new {@link https://www.terraform.io/docs/providers/google/r/endpoints_service_consumers_iam_policy google_endpoints_service_consumers_iam_policy} Resource
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options EndpointsServiceConsumersIamPolicyConfig
    */
    constructor(scope: Construct, id: string, config: EndpointsServiceConsumersIamPolicyConfig);
    private _consumerProject?;
    get consumerProject(): string;
    set consumerProject(value: string);
    get consumerProjectInput(): string | undefined;
    get etag(): string;
    get id(): string;
    private _policyData?;
    get policyData(): string;
    set policyData(value: string);
    get policyDataInput(): string | undefined;
    private _serviceName?;
    get serviceName(): string;
    set serviceName(value: string);
    get serviceNameInput(): string | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
