"use strict";
var _a, _b, _c, _d, _e;
Object.defineProperty(exports, "__esModule", { value: true });
exports.HealthcareFhirStore = exports.HealthcareFhirStoreTimeoutsOutputReference = exports.healthcareFhirStoreTimeoutsToTerraform = exports.healthcareFhirStoreStreamConfigsToTerraform = exports.HealthcareFhirStoreStreamConfigsBigqueryDestinationOutputReference = exports.healthcareFhirStoreStreamConfigsBigqueryDestinationToTerraform = exports.HealthcareFhirStoreStreamConfigsBigqueryDestinationSchemaConfigOutputReference = exports.healthcareFhirStoreStreamConfigsBigqueryDestinationSchemaConfigToTerraform = exports.HealthcareFhirStoreNotificationConfigOutputReference = exports.healthcareFhirStoreNotificationConfigToTerraform = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const cdktf = require("cdktf");
function healthcareFhirStoreNotificationConfigToTerraform(struct) {
    if (!cdktf.canInspect(struct) || cdktf.Tokenization.isResolvable(struct)) {
        return struct;
    }
    if (cdktf.isComplexElement(struct)) {
        throw new Error("A complex element was used as configuration, this is not supported: https://cdk.tf/complex-object-as-configuration");
    }
    return {
        pubsub_topic: cdktf.stringToTerraform(struct.pubsubTopic),
    };
}
exports.healthcareFhirStoreNotificationConfigToTerraform = healthcareFhirStoreNotificationConfigToTerraform;
class HealthcareFhirStoreNotificationConfigOutputReference extends cdktf.ComplexObject {
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource, terraformAttribute) {
        super(terraformResource, terraformAttribute, false, 0);
        this.isEmptyObject = false;
    }
    get internalValue() {
        let hasAnyValues = this.isEmptyObject;
        const internalValueResult = {};
        if (this._pubsubTopic !== undefined) {
            hasAnyValues = true;
            internalValueResult.pubsubTopic = this._pubsubTopic;
        }
        return hasAnyValues ? internalValueResult : undefined;
    }
    set internalValue(value) {
        if (value === undefined) {
            this.isEmptyObject = false;
            this._pubsubTopic = undefined;
        }
        else {
            this.isEmptyObject = Object.keys(value).length === 0;
            this._pubsubTopic = value.pubsubTopic;
        }
    }
    get pubsubTopic() {
        return this.getStringAttribute('pubsub_topic');
    }
    set pubsubTopic(value) {
        this._pubsubTopic = value;
    }
    // Temporarily expose input value. Use with caution.
    get pubsubTopicInput() {
        return this._pubsubTopic;
    }
}
exports.HealthcareFhirStoreNotificationConfigOutputReference = HealthcareFhirStoreNotificationConfigOutputReference;
_a = JSII_RTTI_SYMBOL_1;
HealthcareFhirStoreNotificationConfigOutputReference[_a] = { fqn: "@cdktf/provider-google.HealthcareFhirStoreNotificationConfigOutputReference", version: "0.8.24" };
function healthcareFhirStoreStreamConfigsBigqueryDestinationSchemaConfigToTerraform(struct) {
    if (!cdktf.canInspect(struct) || cdktf.Tokenization.isResolvable(struct)) {
        return struct;
    }
    if (cdktf.isComplexElement(struct)) {
        throw new Error("A complex element was used as configuration, this is not supported: https://cdk.tf/complex-object-as-configuration");
    }
    return {
        recursive_structure_depth: cdktf.numberToTerraform(struct.recursiveStructureDepth),
        schema_type: cdktf.stringToTerraform(struct.schemaType),
    };
}
exports.healthcareFhirStoreStreamConfigsBigqueryDestinationSchemaConfigToTerraform = healthcareFhirStoreStreamConfigsBigqueryDestinationSchemaConfigToTerraform;
class HealthcareFhirStoreStreamConfigsBigqueryDestinationSchemaConfigOutputReference extends cdktf.ComplexObject {
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource, terraformAttribute) {
        super(terraformResource, terraformAttribute, false, 0);
        this.isEmptyObject = false;
    }
    get internalValue() {
        let hasAnyValues = this.isEmptyObject;
        const internalValueResult = {};
        if (this._recursiveStructureDepth !== undefined) {
            hasAnyValues = true;
            internalValueResult.recursiveStructureDepth = this._recursiveStructureDepth;
        }
        if (this._schemaType !== undefined) {
            hasAnyValues = true;
            internalValueResult.schemaType = this._schemaType;
        }
        return hasAnyValues ? internalValueResult : undefined;
    }
    set internalValue(value) {
        if (value === undefined) {
            this.isEmptyObject = false;
            this._recursiveStructureDepth = undefined;
            this._schemaType = undefined;
        }
        else {
            this.isEmptyObject = Object.keys(value).length === 0;
            this._recursiveStructureDepth = value.recursiveStructureDepth;
            this._schemaType = value.schemaType;
        }
    }
    get recursiveStructureDepth() {
        return this.getNumberAttribute('recursive_structure_depth');
    }
    set recursiveStructureDepth(value) {
        this._recursiveStructureDepth = value;
    }
    // Temporarily expose input value. Use with caution.
    get recursiveStructureDepthInput() {
        return this._recursiveStructureDepth;
    }
    get schemaType() {
        return this.getStringAttribute('schema_type');
    }
    set schemaType(value) {
        this._schemaType = value;
    }
    resetSchemaType() {
        this._schemaType = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get schemaTypeInput() {
        return this._schemaType;
    }
}
exports.HealthcareFhirStoreStreamConfigsBigqueryDestinationSchemaConfigOutputReference = HealthcareFhirStoreStreamConfigsBigqueryDestinationSchemaConfigOutputReference;
_b = JSII_RTTI_SYMBOL_1;
HealthcareFhirStoreStreamConfigsBigqueryDestinationSchemaConfigOutputReference[_b] = { fqn: "@cdktf/provider-google.HealthcareFhirStoreStreamConfigsBigqueryDestinationSchemaConfigOutputReference", version: "0.8.24" };
function healthcareFhirStoreStreamConfigsBigqueryDestinationToTerraform(struct) {
    if (!cdktf.canInspect(struct) || cdktf.Tokenization.isResolvable(struct)) {
        return struct;
    }
    if (cdktf.isComplexElement(struct)) {
        throw new Error("A complex element was used as configuration, this is not supported: https://cdk.tf/complex-object-as-configuration");
    }
    return {
        dataset_uri: cdktf.stringToTerraform(struct.datasetUri),
        schema_config: healthcareFhirStoreStreamConfigsBigqueryDestinationSchemaConfigToTerraform(struct.schemaConfig),
    };
}
exports.healthcareFhirStoreStreamConfigsBigqueryDestinationToTerraform = healthcareFhirStoreStreamConfigsBigqueryDestinationToTerraform;
class HealthcareFhirStoreStreamConfigsBigqueryDestinationOutputReference extends cdktf.ComplexObject {
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource, terraformAttribute) {
        super(terraformResource, terraformAttribute, false, 0);
        this.isEmptyObject = false;
        // schema_config - computed: false, optional: false, required: true
        this._schemaConfig = new HealthcareFhirStoreStreamConfigsBigqueryDestinationSchemaConfigOutputReference(this, "schema_config");
    }
    get internalValue() {
        var _f, _g;
        let hasAnyValues = this.isEmptyObject;
        const internalValueResult = {};
        if (this._datasetUri !== undefined) {
            hasAnyValues = true;
            internalValueResult.datasetUri = this._datasetUri;
        }
        if (((_f = this._schemaConfig) === null || _f === void 0 ? void 0 : _f.internalValue) !== undefined) {
            hasAnyValues = true;
            internalValueResult.schemaConfig = (_g = this._schemaConfig) === null || _g === void 0 ? void 0 : _g.internalValue;
        }
        return hasAnyValues ? internalValueResult : undefined;
    }
    set internalValue(value) {
        if (value === undefined) {
            this.isEmptyObject = false;
            this._datasetUri = undefined;
            this._schemaConfig.internalValue = undefined;
        }
        else {
            this.isEmptyObject = Object.keys(value).length === 0;
            this._datasetUri = value.datasetUri;
            this._schemaConfig.internalValue = value.schemaConfig;
        }
    }
    get datasetUri() {
        return this.getStringAttribute('dataset_uri');
    }
    set datasetUri(value) {
        this._datasetUri = value;
    }
    // Temporarily expose input value. Use with caution.
    get datasetUriInput() {
        return this._datasetUri;
    }
    get schemaConfig() {
        return this._schemaConfig;
    }
    putSchemaConfig(value) {
        this._schemaConfig.internalValue = value;
    }
    // Temporarily expose input value. Use with caution.
    get schemaConfigInput() {
        return this._schemaConfig.internalValue;
    }
}
exports.HealthcareFhirStoreStreamConfigsBigqueryDestinationOutputReference = HealthcareFhirStoreStreamConfigsBigqueryDestinationOutputReference;
_c = JSII_RTTI_SYMBOL_1;
HealthcareFhirStoreStreamConfigsBigqueryDestinationOutputReference[_c] = { fqn: "@cdktf/provider-google.HealthcareFhirStoreStreamConfigsBigqueryDestinationOutputReference", version: "0.8.24" };
function healthcareFhirStoreStreamConfigsToTerraform(struct) {
    if (!cdktf.canInspect(struct) || cdktf.Tokenization.isResolvable(struct)) {
        return struct;
    }
    if (cdktf.isComplexElement(struct)) {
        throw new Error("A complex element was used as configuration, this is not supported: https://cdk.tf/complex-object-as-configuration");
    }
    return {
        resource_types: cdktf.listMapper(cdktf.stringToTerraform)(struct.resourceTypes),
        bigquery_destination: healthcareFhirStoreStreamConfigsBigqueryDestinationToTerraform(struct.bigqueryDestination),
    };
}
exports.healthcareFhirStoreStreamConfigsToTerraform = healthcareFhirStoreStreamConfigsToTerraform;
function healthcareFhirStoreTimeoutsToTerraform(struct) {
    if (!cdktf.canInspect(struct) || cdktf.Tokenization.isResolvable(struct)) {
        return struct;
    }
    if (cdktf.isComplexElement(struct)) {
        throw new Error("A complex element was used as configuration, this is not supported: https://cdk.tf/complex-object-as-configuration");
    }
    return {
        create: cdktf.stringToTerraform(struct.create),
        delete: cdktf.stringToTerraform(struct.delete),
        update: cdktf.stringToTerraform(struct.update),
    };
}
exports.healthcareFhirStoreTimeoutsToTerraform = healthcareFhirStoreTimeoutsToTerraform;
class HealthcareFhirStoreTimeoutsOutputReference extends cdktf.ComplexObject {
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource, terraformAttribute) {
        super(terraformResource, terraformAttribute, false, 0);
        this.isEmptyObject = false;
    }
    get internalValue() {
        let hasAnyValues = this.isEmptyObject;
        const internalValueResult = {};
        if (this._create !== undefined) {
            hasAnyValues = true;
            internalValueResult.create = this._create;
        }
        if (this._delete !== undefined) {
            hasAnyValues = true;
            internalValueResult.delete = this._delete;
        }
        if (this._update !== undefined) {
            hasAnyValues = true;
            internalValueResult.update = this._update;
        }
        return hasAnyValues ? internalValueResult : undefined;
    }
    set internalValue(value) {
        if (value === undefined) {
            this.isEmptyObject = false;
            this._create = undefined;
            this._delete = undefined;
            this._update = undefined;
        }
        else {
            this.isEmptyObject = Object.keys(value).length === 0;
            this._create = value.create;
            this._delete = value.delete;
            this._update = value.update;
        }
    }
    get create() {
        return this.getStringAttribute('create');
    }
    set create(value) {
        this._create = value;
    }
    resetCreate() {
        this._create = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get createInput() {
        return this._create;
    }
    get delete() {
        return this.getStringAttribute('delete');
    }
    set delete(value) {
        this._delete = value;
    }
    resetDelete() {
        this._delete = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get deleteInput() {
        return this._delete;
    }
    get update() {
        return this.getStringAttribute('update');
    }
    set update(value) {
        this._update = value;
    }
    resetUpdate() {
        this._update = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get updateInput() {
        return this._update;
    }
}
exports.HealthcareFhirStoreTimeoutsOutputReference = HealthcareFhirStoreTimeoutsOutputReference;
_d = JSII_RTTI_SYMBOL_1;
HealthcareFhirStoreTimeoutsOutputReference[_d] = { fqn: "@cdktf/provider-google.HealthcareFhirStoreTimeoutsOutputReference", version: "0.8.24" };
/**
* Represents a {@link https://www.terraform.io/docs/providers/google/r/healthcare_fhir_store google_healthcare_fhir_store}
*/
class HealthcareFhirStore extends cdktf.TerraformResource {
    // ===========
    // INITIALIZER
    // ===========
    /**
    * Create a new {@link https://www.terraform.io/docs/providers/google/r/healthcare_fhir_store google_healthcare_fhir_store} Resource
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options HealthcareFhirStoreConfig
    */
    constructor(scope, id, config) {
        super(scope, id, {
            terraformResourceType: 'google_healthcare_fhir_store',
            terraformGeneratorMetadata: {
                providerName: 'google',
                providerVersion: '4.19.0',
                providerVersionConstraint: '~> 4.0'
            },
            provider: config.provider,
            dependsOn: config.dependsOn,
            count: config.count,
            lifecycle: config.lifecycle
        });
        // notification_config - computed: false, optional: true, required: false
        this._notificationConfig = new HealthcareFhirStoreNotificationConfigOutputReference(this, "notification_config");
        // timeouts - computed: false, optional: true, required: false
        this._timeouts = new HealthcareFhirStoreTimeoutsOutputReference(this, "timeouts");
        this._dataset = config.dataset;
        this._disableReferentialIntegrity = config.disableReferentialIntegrity;
        this._disableResourceVersioning = config.disableResourceVersioning;
        this._enableHistoryImport = config.enableHistoryImport;
        this._enableUpdateCreate = config.enableUpdateCreate;
        this._labels = config.labels;
        this._name = config.name;
        this._version = config.version;
        this._notificationConfig.internalValue = config.notificationConfig;
        this._streamConfigs = config.streamConfigs;
        this._timeouts.internalValue = config.timeouts;
    }
    get dataset() {
        return this.getStringAttribute('dataset');
    }
    set dataset(value) {
        this._dataset = value;
    }
    // Temporarily expose input value. Use with caution.
    get datasetInput() {
        return this._dataset;
    }
    get disableReferentialIntegrity() {
        return this.getBooleanAttribute('disable_referential_integrity');
    }
    set disableReferentialIntegrity(value) {
        this._disableReferentialIntegrity = value;
    }
    resetDisableReferentialIntegrity() {
        this._disableReferentialIntegrity = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get disableReferentialIntegrityInput() {
        return this._disableReferentialIntegrity;
    }
    get disableResourceVersioning() {
        return this.getBooleanAttribute('disable_resource_versioning');
    }
    set disableResourceVersioning(value) {
        this._disableResourceVersioning = value;
    }
    resetDisableResourceVersioning() {
        this._disableResourceVersioning = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get disableResourceVersioningInput() {
        return this._disableResourceVersioning;
    }
    get enableHistoryImport() {
        return this.getBooleanAttribute('enable_history_import');
    }
    set enableHistoryImport(value) {
        this._enableHistoryImport = value;
    }
    resetEnableHistoryImport() {
        this._enableHistoryImport = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get enableHistoryImportInput() {
        return this._enableHistoryImport;
    }
    get enableUpdateCreate() {
        return this.getBooleanAttribute('enable_update_create');
    }
    set enableUpdateCreate(value) {
        this._enableUpdateCreate = value;
    }
    resetEnableUpdateCreate() {
        this._enableUpdateCreate = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get enableUpdateCreateInput() {
        return this._enableUpdateCreate;
    }
    // id - computed: true, optional: true, required: false
    get id() {
        return this.getStringAttribute('id');
    }
    get labels() {
        return this.getStringMapAttribute('labels');
    }
    set labels(value) {
        this._labels = value;
    }
    resetLabels() {
        this._labels = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get labelsInput() {
        return this._labels;
    }
    get name() {
        return this.getStringAttribute('name');
    }
    set name(value) {
        this._name = value;
    }
    // Temporarily expose input value. Use with caution.
    get nameInput() {
        return this._name;
    }
    // self_link - computed: true, optional: false, required: false
    get selfLink() {
        return this.getStringAttribute('self_link');
    }
    get version() {
        return this.getStringAttribute('version');
    }
    set version(value) {
        this._version = value;
    }
    // Temporarily expose input value. Use with caution.
    get versionInput() {
        return this._version;
    }
    get notificationConfig() {
        return this._notificationConfig;
    }
    putNotificationConfig(value) {
        this._notificationConfig.internalValue = value;
    }
    resetNotificationConfig() {
        this._notificationConfig.internalValue = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get notificationConfigInput() {
        return this._notificationConfig.internalValue;
    }
    get streamConfigs() {
        // Getting the computed value is not yet implemented
        return this.interpolationForAttribute('stream_configs');
    }
    set streamConfigs(value) {
        this._streamConfigs = value;
    }
    resetStreamConfigs() {
        this._streamConfigs = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get streamConfigsInput() {
        return this._streamConfigs;
    }
    get timeouts() {
        return this._timeouts;
    }
    putTimeouts(value) {
        this._timeouts.internalValue = value;
    }
    resetTimeouts() {
        this._timeouts.internalValue = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get timeoutsInput() {
        return this._timeouts.internalValue;
    }
    // =========
    // SYNTHESIS
    // =========
    synthesizeAttributes() {
        return {
            dataset: cdktf.stringToTerraform(this._dataset),
            disable_referential_integrity: cdktf.booleanToTerraform(this._disableReferentialIntegrity),
            disable_resource_versioning: cdktf.booleanToTerraform(this._disableResourceVersioning),
            enable_history_import: cdktf.booleanToTerraform(this._enableHistoryImport),
            enable_update_create: cdktf.booleanToTerraform(this._enableUpdateCreate),
            labels: cdktf.hashMapper(cdktf.stringToTerraform)(this._labels),
            name: cdktf.stringToTerraform(this._name),
            version: cdktf.stringToTerraform(this._version),
            notification_config: healthcareFhirStoreNotificationConfigToTerraform(this._notificationConfig.internalValue),
            stream_configs: cdktf.listMapper(healthcareFhirStoreStreamConfigsToTerraform)(this._streamConfigs),
            timeouts: healthcareFhirStoreTimeoutsToTerraform(this._timeouts.internalValue),
        };
    }
}
exports.HealthcareFhirStore = HealthcareFhirStore;
_e = JSII_RTTI_SYMBOL_1;
HealthcareFhirStore[_e] = { fqn: "@cdktf/provider-google.HealthcareFhirStore", version: "0.8.24" };
// =================
// STATIC PROPERTIES
// =================
HealthcareFhirStore.tfResourceType = "google_healthcare_fhir_store";
//# sourceMappingURL=data:application/json;base64,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