import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface LoggingLogViewConfig extends cdktf.TerraformMetaArguments {
    /**
    * The bucket of the resource
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/logging_log_view#bucket LoggingLogView#bucket}
    */
    readonly bucket: string;
    /**
    * Describes this view.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/logging_log_view#description LoggingLogView#description}
    */
    readonly description?: string;
    /**
    * Filter that restricts which log entries in a bucket are visible in this view. Filters are restricted to be a logical AND of ==/!= of any of the following: - originating project/folder/organization/billing account. - resource type - log id For example: SOURCE("projects/myproject") AND resource.type = "gce_instance" AND LOG_ID("stdout")
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/logging_log_view#filter LoggingLogView#filter}
    */
    readonly filter?: string;
    /**
    * The location of the resource. The supported locations are: global, us-central1, us-east1, us-west1, asia-east1, europe-west1.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/logging_log_view#location LoggingLogView#location}
    */
    readonly location?: string;
    /**
    * The resource name of the view. For example: `projects/my-project/locations/global/buckets/my-bucket/views/my-view`
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/logging_log_view#name LoggingLogView#name}
    */
    readonly name: string;
    /**
    * The parent of the resource.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/logging_log_view#parent LoggingLogView#parent}
    */
    readonly parent?: string;
    /**
    * timeouts block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/logging_log_view#timeouts LoggingLogView#timeouts}
    */
    readonly timeouts?: LoggingLogViewTimeouts;
}
export interface LoggingLogViewTimeouts {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/logging_log_view#create LoggingLogView#create}
    */
    readonly create?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/logging_log_view#delete LoggingLogView#delete}
    */
    readonly delete?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/logging_log_view#update LoggingLogView#update}
    */
    readonly update?: string;
}
export declare function loggingLogViewTimeoutsToTerraform(struct?: LoggingLogViewTimeoutsOutputReference | LoggingLogViewTimeouts | cdktf.IResolvable): any;
export declare class LoggingLogViewTimeoutsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): LoggingLogViewTimeouts | undefined;
    set internalValue(value: LoggingLogViewTimeouts | undefined);
    private _create?;
    get create(): string;
    set create(value: string);
    resetCreate(): void;
    get createInput(): string | undefined;
    private _delete?;
    get delete(): string;
    set delete(value: string);
    resetDelete(): void;
    get deleteInput(): string | undefined;
    private _update?;
    get update(): string;
    set update(value: string);
    resetUpdate(): void;
    get updateInput(): string | undefined;
}
/**
* Represents a {@link https://www.terraform.io/docs/providers/google/r/logging_log_view google_logging_log_view}
*/
export declare class LoggingLogView extends cdktf.TerraformResource {
    static readonly tfResourceType = "google_logging_log_view";
    /**
    * Create a new {@link https://www.terraform.io/docs/providers/google/r/logging_log_view google_logging_log_view} Resource
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options LoggingLogViewConfig
    */
    constructor(scope: Construct, id: string, config: LoggingLogViewConfig);
    private _bucket?;
    get bucket(): string;
    set bucket(value: string);
    get bucketInput(): string | undefined;
    get createTime(): string;
    private _description?;
    get description(): string;
    set description(value: string);
    resetDescription(): void;
    get descriptionInput(): string | undefined;
    private _filter?;
    get filter(): string;
    set filter(value: string);
    resetFilter(): void;
    get filterInput(): string | undefined;
    get id(): string;
    private _location?;
    get location(): string;
    set location(value: string);
    resetLocation(): void;
    get locationInput(): string | undefined;
    private _name?;
    get name(): string;
    set name(value: string);
    get nameInput(): string | undefined;
    private _parent?;
    get parent(): string;
    set parent(value: string);
    resetParent(): void;
    get parentInput(): string | undefined;
    get updateTime(): string;
    private _timeouts;
    get timeouts(): LoggingLogViewTimeoutsOutputReference;
    putTimeouts(value: LoggingLogViewTimeouts): void;
    resetTimeouts(): void;
    get timeoutsInput(): LoggingLogViewTimeouts | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
