import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface MonitoringMetricDescriptorConfig extends cdktf.TerraformMetaArguments {
    /**
    * A detailed description of the metric, which can be used in documentation.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/monitoring_metric_descriptor#description MonitoringMetricDescriptor#description}
    */
    readonly description: string;
    /**
    * A concise name for the metric, which can be displayed in user interfaces. Use sentence case without an ending period, for example "Request count".
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/monitoring_metric_descriptor#display_name MonitoringMetricDescriptor#display_name}
    */
    readonly displayName: string;
    /**
    * The launch stage of the metric definition. Possible values: ["LAUNCH_STAGE_UNSPECIFIED", "UNIMPLEMENTED", "PRELAUNCH", "EARLY_ACCESS", "ALPHA", "BETA", "GA", "DEPRECATED"]
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/monitoring_metric_descriptor#launch_stage MonitoringMetricDescriptor#launch_stage}
    */
    readonly launchStage?: string;
    /**
    * Whether the metric records instantaneous values, changes to a value, etc. Some combinations of metricKind and valueType might not be supported. Possible values: ["METRIC_KIND_UNSPECIFIED", "GAUGE", "DELTA", "CUMULATIVE"]
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/monitoring_metric_descriptor#metric_kind MonitoringMetricDescriptor#metric_kind}
    */
    readonly metricKind: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/monitoring_metric_descriptor#project MonitoringMetricDescriptor#project}
    */
    readonly project?: string;
    /**
    * The metric type, including its DNS name prefix. The type is not URL-encoded. All service defined metrics must be prefixed with the service name, in the format of {service name}/{relative metric name}, such as cloudsql.googleapis.com/database/cpu/utilization. The relative metric name must have only upper and lower-case letters, digits, '/' and underscores '_' are allowed. Additionally, the maximum number of characters allowed for the relative_metric_name is 100. All user-defined metric types have the DNS name custom.googleapis.com, external.googleapis.com, or logging.googleapis.com/user/.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/monitoring_metric_descriptor#type MonitoringMetricDescriptor#type}
    */
    readonly type: string;
    /**
    * The units in which the metric value is reported. It is only applicable if the
  valueType is INT64, DOUBLE, or DISTRIBUTION. The unit defines the representation of
  the stored metric values.
  
  Different systems may scale the values to be more easily displayed (so a value of
  0.02KBy might be displayed as 20By, and a value of 3523KBy might be displayed as
  3.5MBy). However, if the unit is KBy, then the value of the metric is always in
  thousands of bytes, no matter how it may be displayed.
  
  If you want a custom metric to record the exact number of CPU-seconds used by a job,
  you can create an INT64 CUMULATIVE metric whose unit is s{CPU} (or equivalently
  1s{CPU} or just s). If the job uses 12,005 CPU-seconds, then the value is written as
  12005.
  
  Alternatively, if you want a custom metric to record data in a more granular way, you
  can create a DOUBLE CUMULATIVE metric whose unit is ks{CPU}, and then write the value
  12.005 (which is 12005/1000), or use Kis{CPU} and write 11.723 (which is 12005/1024).
  The supported units are a subset of The Unified Code for Units of Measure standard.
  More info can be found in the API documentation
  (https://cloud.google.com/monitoring/api/ref_v3/rest/v3/projects.metricDescriptors).
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/monitoring_metric_descriptor#unit MonitoringMetricDescriptor#unit}
    */
    readonly unit?: string;
    /**
    * Whether the measurement is an integer, a floating-point number, etc. Some combinations of metricKind and valueType might not be supported. Possible values: ["BOOL", "INT64", "DOUBLE", "STRING", "DISTRIBUTION"]
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/monitoring_metric_descriptor#value_type MonitoringMetricDescriptor#value_type}
    */
    readonly valueType: string;
    /**
    * labels block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/monitoring_metric_descriptor#labels MonitoringMetricDescriptor#labels}
    */
    readonly labels?: MonitoringMetricDescriptorLabels[] | cdktf.IResolvable;
    /**
    * metadata block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/monitoring_metric_descriptor#metadata MonitoringMetricDescriptor#metadata}
    */
    readonly metadata?: MonitoringMetricDescriptorMetadata;
    /**
    * timeouts block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/monitoring_metric_descriptor#timeouts MonitoringMetricDescriptor#timeouts}
    */
    readonly timeouts?: MonitoringMetricDescriptorTimeouts;
}
export interface MonitoringMetricDescriptorLabels {
    /**
    * A human-readable description for the label.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/monitoring_metric_descriptor#description MonitoringMetricDescriptor#description}
    */
    readonly description?: string;
    /**
    * The key for this label. The key must not exceed 100 characters. The first character of the key must be an upper- or lower-case letter, the remaining characters must be letters, digits or underscores, and the key must match the regular expression [a-zA-Z][a-zA-Z0-9_]*
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/monitoring_metric_descriptor#key MonitoringMetricDescriptor#key}
    */
    readonly key: string;
    /**
    * The type of data that can be assigned to the label. Default value: "STRING" Possible values: ["STRING", "BOOL", "INT64"]
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/monitoring_metric_descriptor#value_type MonitoringMetricDescriptor#value_type}
    */
    readonly valueType?: string;
}
export declare function monitoringMetricDescriptorLabelsToTerraform(struct?: MonitoringMetricDescriptorLabels | cdktf.IResolvable): any;
export interface MonitoringMetricDescriptorMetadata {
    /**
    * The delay of data points caused by ingestion. Data points older than this age are guaranteed to be ingested and available to be read, excluding data loss due to errors. In '[duration format](https://developers.google.com/protocol-buffers/docs/reference/google.protobuf?&_ga=2.264881487.1507873253.1593446723-935052455.1591817775#google.protobuf.Duration)'.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/monitoring_metric_descriptor#ingest_delay MonitoringMetricDescriptor#ingest_delay}
    */
    readonly ingestDelay?: string;
    /**
    * The sampling period of metric data points. For metrics which are written periodically, consecutive data points are stored at this time interval, excluding data loss due to errors. Metrics with a higher granularity have a smaller sampling period. In '[duration format](https://developers.google.com/protocol-buffers/docs/reference/google.protobuf?&_ga=2.264881487.1507873253.1593446723-935052455.1591817775#google.protobuf.Duration)'.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/monitoring_metric_descriptor#sample_period MonitoringMetricDescriptor#sample_period}
    */
    readonly samplePeriod?: string;
}
export declare function monitoringMetricDescriptorMetadataToTerraform(struct?: MonitoringMetricDescriptorMetadataOutputReference | MonitoringMetricDescriptorMetadata): any;
export declare class MonitoringMetricDescriptorMetadataOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): MonitoringMetricDescriptorMetadata | undefined;
    set internalValue(value: MonitoringMetricDescriptorMetadata | undefined);
    private _ingestDelay?;
    get ingestDelay(): string;
    set ingestDelay(value: string);
    resetIngestDelay(): void;
    get ingestDelayInput(): string | undefined;
    private _samplePeriod?;
    get samplePeriod(): string;
    set samplePeriod(value: string);
    resetSamplePeriod(): void;
    get samplePeriodInput(): string | undefined;
}
export interface MonitoringMetricDescriptorTimeouts {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/monitoring_metric_descriptor#create MonitoringMetricDescriptor#create}
    */
    readonly create?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/monitoring_metric_descriptor#delete MonitoringMetricDescriptor#delete}
    */
    readonly delete?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/monitoring_metric_descriptor#update MonitoringMetricDescriptor#update}
    */
    readonly update?: string;
}
export declare function monitoringMetricDescriptorTimeoutsToTerraform(struct?: MonitoringMetricDescriptorTimeoutsOutputReference | MonitoringMetricDescriptorTimeouts | cdktf.IResolvable): any;
export declare class MonitoringMetricDescriptorTimeoutsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): MonitoringMetricDescriptorTimeouts | undefined;
    set internalValue(value: MonitoringMetricDescriptorTimeouts | undefined);
    private _create?;
    get create(): string;
    set create(value: string);
    resetCreate(): void;
    get createInput(): string | undefined;
    private _delete?;
    get delete(): string;
    set delete(value: string);
    resetDelete(): void;
    get deleteInput(): string | undefined;
    private _update?;
    get update(): string;
    set update(value: string);
    resetUpdate(): void;
    get updateInput(): string | undefined;
}
/**
* Represents a {@link https://www.terraform.io/docs/providers/google/r/monitoring_metric_descriptor google_monitoring_metric_descriptor}
*/
export declare class MonitoringMetricDescriptor extends cdktf.TerraformResource {
    static readonly tfResourceType = "google_monitoring_metric_descriptor";
    /**
    * Create a new {@link https://www.terraform.io/docs/providers/google/r/monitoring_metric_descriptor google_monitoring_metric_descriptor} Resource
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options MonitoringMetricDescriptorConfig
    */
    constructor(scope: Construct, id: string, config: MonitoringMetricDescriptorConfig);
    private _description?;
    get description(): string;
    set description(value: string);
    get descriptionInput(): string | undefined;
    private _displayName?;
    get displayName(): string;
    set displayName(value: string);
    get displayNameInput(): string | undefined;
    get id(): string;
    private _launchStage?;
    get launchStage(): string;
    set launchStage(value: string);
    resetLaunchStage(): void;
    get launchStageInput(): string | undefined;
    private _metricKind?;
    get metricKind(): string;
    set metricKind(value: string);
    get metricKindInput(): string | undefined;
    get monitoredResourceTypes(): string[];
    get name(): string;
    private _project?;
    get project(): string;
    set project(value: string);
    resetProject(): void;
    get projectInput(): string | undefined;
    private _type?;
    get type(): string;
    set type(value: string);
    get typeInput(): string | undefined;
    private _unit?;
    get unit(): string;
    set unit(value: string);
    resetUnit(): void;
    get unitInput(): string | undefined;
    private _valueType?;
    get valueType(): string;
    set valueType(value: string);
    get valueTypeInput(): string | undefined;
    private _labels?;
    get labels(): MonitoringMetricDescriptorLabels[] | cdktf.IResolvable;
    set labels(value: MonitoringMetricDescriptorLabels[] | cdktf.IResolvable);
    resetLabels(): void;
    get labelsInput(): cdktf.IResolvable | MonitoringMetricDescriptorLabels[] | undefined;
    private _metadata;
    get metadata(): MonitoringMetricDescriptorMetadataOutputReference;
    putMetadata(value: MonitoringMetricDescriptorMetadata): void;
    resetMetadata(): void;
    get metadataInput(): MonitoringMetricDescriptorMetadata | undefined;
    private _timeouts;
    get timeouts(): MonitoringMetricDescriptorTimeoutsOutputReference;
    putTimeouts(value: MonitoringMetricDescriptorTimeouts): void;
    resetTimeouts(): void;
    get timeoutsInput(): MonitoringMetricDescriptorTimeouts | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
