import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface SccSourceConfig extends cdktf.TerraformMetaArguments {
    /**
    * The description of the source (max of 1024 characters).
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/scc_source#description SccSource#description}
    */
    readonly description?: string;
    /**
    * The source’s display name. A source’s display name must be unique
  amongst its siblings, for example, two sources with the same parent
  can't share the same display name. The display name must start and end
  with a letter or digit, may contain letters, digits, spaces, hyphens,
  and underscores, and can be no longer than 32 characters.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/scc_source#display_name SccSource#display_name}
    */
    readonly displayName: string;
    /**
    * The organization whose Cloud Security Command Center the Source
  lives in.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/scc_source#organization SccSource#organization}
    */
    readonly organization: string;
    /**
    * timeouts block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/scc_source#timeouts SccSource#timeouts}
    */
    readonly timeouts?: SccSourceTimeouts;
}
export interface SccSourceTimeouts {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/scc_source#create SccSource#create}
    */
    readonly create?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/scc_source#delete SccSource#delete}
    */
    readonly delete?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/scc_source#update SccSource#update}
    */
    readonly update?: string;
}
export declare function sccSourceTimeoutsToTerraform(struct?: SccSourceTimeoutsOutputReference | SccSourceTimeouts | cdktf.IResolvable): any;
export declare class SccSourceTimeoutsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): SccSourceTimeouts | undefined;
    set internalValue(value: SccSourceTimeouts | undefined);
    private _create?;
    get create(): string;
    set create(value: string);
    resetCreate(): void;
    get createInput(): string | undefined;
    private _delete?;
    get delete(): string;
    set delete(value: string);
    resetDelete(): void;
    get deleteInput(): string | undefined;
    private _update?;
    get update(): string;
    set update(value: string);
    resetUpdate(): void;
    get updateInput(): string | undefined;
}
/**
* Represents a {@link https://www.terraform.io/docs/providers/google/r/scc_source google_scc_source}
*/
export declare class SccSource extends cdktf.TerraformResource {
    static readonly tfResourceType = "google_scc_source";
    /**
    * Create a new {@link https://www.terraform.io/docs/providers/google/r/scc_source google_scc_source} Resource
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options SccSourceConfig
    */
    constructor(scope: Construct, id: string, config: SccSourceConfig);
    private _description?;
    get description(): string;
    set description(value: string);
    resetDescription(): void;
    get descriptionInput(): string | undefined;
    private _displayName?;
    get displayName(): string;
    set displayName(value: string);
    get displayNameInput(): string | undefined;
    get id(): string;
    get name(): string;
    private _organization?;
    get organization(): string;
    set organization(value: string);
    get organizationInput(): string | undefined;
    private _timeouts;
    get timeouts(): SccSourceTimeoutsOutputReference;
    putTimeouts(value: SccSourceTimeouts): void;
    resetTimeouts(): void;
    get timeoutsInput(): SccSourceTimeouts | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
