# -*- coding: utf-8 -*-
from setuptools import setup

packages = \
['panoptes', 'panoptes.aws', 'panoptes.cli', 'panoptes.generic']

package_data = \
{'': ['*']}

install_requires = \
['Jinja2>=2.11,<3.0',
 'PyYAML>=5.3,<6.0',
 'boto3>=1.14,<2.0',
 'click>=7.1,<8.0',
 'colorama>=0.4.3,<0.5.0']

entry_points = \
{'console_scripts': ['panoptesctl = panoptes.panoptesctl:main']}

setup_kwargs = {
    'name': 'panoptes',
    'version': '0.5.0',
    'description': 'The multi cloud security group analyzer',
    'long_description': '# PANOPTES\n\nPanoptes is an automatic security group analyzer focused on reducing the amount of toiling. Mainly focused on AWS, built to be extensible in the future and support the big cloud providers out there.\n\n<img src="https://s3.amazonaws.com/tioxy.github/panoptes/sample.gif" data-canonical-src="https://s3.amazonaws.com/tioxy.github/panoptes/sample.gif" width="600" height="900" />\n\n<br>\n\n## [Prerequisites](#prerequisites)\n-----\n\n#### For lazy users\nThere is a Docker image [*tioxy/panoptes*](https://hub.docker.com/r/tioxy/panoptes/) which uses the Dockerfile located in the root of the repository\n\n#### Python \n- Python >= 3.6\n- pip\n\n#### For AWS usage\n- [AWS CLI](https://docs.aws.amazon.com/cli/latest/userguide/installing.html) installed and configured with your IAM credentials (if you want more customization use [Named Profiles](https://docs.aws.amazon.com/cli/latest/userguide/cli-multiple-profiles.html))\n\n<br>\n\n## [Installation](#installation)\n-----\nGet the latest version of the package from your terminal with *pip*:\n```bash\npip install panoptes --upgrade\n```\n\n<br>\n\n## [Getting Started](#getting-started)\n\n-----\nIf you want to see the available options:\n```bash\npanoptesctl aws analyze --help\n```\n\nGenerate an AWS analysis with human readable output:\n```bash\npanoptesctl aws analyze --region <YOUR_REGION_CODE>\n```\n\nGenerate an AWS analysis with an YML output and a Named Profile from AWS CLI:\n```bash\npanoptesctl aws analyze --region <YOUR_REGION_CODE> --profile <YOUR_PROFILE> --output yml\n```\n*Check out [AWS Regions](https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/using-regions-availability-zones.html#concepts-available-regions) to see available region codes*\n\n\n<br>\n\n## [Whitelisting](#whitelisting)\n-----\n\n### Manually\nIf you wish to whitelist IPs, not letting the analysis mark them as **Unsafe**, you can define a sample file with the desired IPs and CIDRs, like the following one:\n\n<br>\n\n**your_whitelist.txt**\n```\n111.111.111.111/32\n123.123.123.123/32\n```\nAnd then run the analysis with the parameter *--whitelist*:\n```\npanoptesctl aws analyze --region <YOUR_REGION_CODE> --output yml --whitelist /PATH/TO/your_whitelist.txt\n```\n\n<br>\n\n### Automatically\nPanoptes generates automatically a list of IPs which it does not consider harmful from the desired cloud provider.\n\n<br>\n\n#### AWS autogenerated\n- VPC ranges\n- Subnet ranges\n- Private IPs from EC2 VPC Instances\n- Public IPs from EC2 VPC Instances\n- Elastic IPs\n\n<br>\n\n## [Limitations](#limitations)\n----\nThe Automatic AWS Whitelist feature can\'t whitelist *public* and *private* IP\'s from **EC2 Classic**, so make sure that those instances have an *Elastic IP* attached and their security groups are pointing to the new *Elastic IP* attached instead of the default EC2 Classic ones.\n',
    'author': 'Gabriel Tiossi',
    'author_email': 'gabrieltiossi@gmail.com',
    'maintainer': None,
    'maintainer_email': None,
    'url': 'https://github.com/tioxy/panoptes',
    'packages': packages,
    'package_data': package_data,
    'install_requires': install_requires,
    'entry_points': entry_points,
    'python_requires': '>=3.7,<4.0',
}


setup(**setup_kwargs)
