"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.IotSql = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
/**
 * Defines AWS IoT SQL.
 */
class IotSql {
    /**
     * Uses the original SQL version built on 2015-10-08.
     *
     * @param sql The actual SQL-like syntax query
     * @returns Instance of IotSql
     */
    static fromStringAsVer20151008(sql) {
        return new IotSqlImpl('2015-10-08', sql);
    }
    /**
     * Uses the SQL version built on 2016-03-23.
     *
     * @param sql The actual SQL-like syntax query
     * @returns Instance of IotSql
     */
    static fromStringAsVer20160323(sql) {
        return new IotSqlImpl('2016-03-23', sql);
    }
    /**
     * Uses the most recent beta SQL version. If you use this version, it might
     * introduce breaking changes to your rules.
     *
     * @param sql The actual SQL-like syntax query
     * @returns Instance of IotSql
     */
    static fromStringAsVerNewestUnstable(sql) {
        return new IotSqlImpl('beta', sql);
    }
}
_a = JSII_RTTI_SYMBOL_1;
IotSql[_a] = { fqn: "@aws-cdk/aws-iot-alpha.IotSql", version: "2.73.0-alpha.0" };
exports.IotSql = IotSql;
class IotSqlImpl extends IotSql {
    constructor(version, sql) {
        super();
        this.version = version;
        this.sql = sql;
        if (sql === '') {
            throw new Error('IoT SQL string cannot be empty');
        }
    }
    bind(_scope) {
        return {
            awsIotSqlVersion: this.version,
            sql: this.sql,
        };
    }
}
//# sourceMappingURL=data:application/json;base64,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