# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from . import _utilities

__all__ = ['ExtraDiskSizeArgs', 'ExtraDiskSize']

@pulumi.input_type
class ExtraDiskSizeArgs:
    def __init__(__self__, *,
                 extra_disk_size: pulumi.Input[int],
                 instance_id: pulumi.Input[int]):
        """
        The set of arguments for constructing a ExtraDiskSize resource.
        :param pulumi.Input[int] extra_disk_size: Extra disk size in GB. Supported values: 25, 50, 100, 250, 500, 1000, 2000
        :param pulumi.Input[int] instance_id: The CloudAMQP instance ID.
        """
        pulumi.set(__self__, "extra_disk_size", extra_disk_size)
        pulumi.set(__self__, "instance_id", instance_id)

    @property
    @pulumi.getter(name="extraDiskSize")
    def extra_disk_size(self) -> pulumi.Input[int]:
        """
        Extra disk size in GB. Supported values: 25, 50, 100, 250, 500, 1000, 2000
        """
        return pulumi.get(self, "extra_disk_size")

    @extra_disk_size.setter
    def extra_disk_size(self, value: pulumi.Input[int]):
        pulumi.set(self, "extra_disk_size", value)

    @property
    @pulumi.getter(name="instanceId")
    def instance_id(self) -> pulumi.Input[int]:
        """
        The CloudAMQP instance ID.
        """
        return pulumi.get(self, "instance_id")

    @instance_id.setter
    def instance_id(self, value: pulumi.Input[int]):
        pulumi.set(self, "instance_id", value)


@pulumi.input_type
class _ExtraDiskSizeState:
    def __init__(__self__, *,
                 extra_disk_size: Optional[pulumi.Input[int]] = None,
                 instance_id: Optional[pulumi.Input[int]] = None):
        """
        Input properties used for looking up and filtering ExtraDiskSize resources.
        :param pulumi.Input[int] extra_disk_size: Extra disk size in GB. Supported values: 25, 50, 100, 250, 500, 1000, 2000
        :param pulumi.Input[int] instance_id: The CloudAMQP instance ID.
        """
        if extra_disk_size is not None:
            pulumi.set(__self__, "extra_disk_size", extra_disk_size)
        if instance_id is not None:
            pulumi.set(__self__, "instance_id", instance_id)

    @property
    @pulumi.getter(name="extraDiskSize")
    def extra_disk_size(self) -> Optional[pulumi.Input[int]]:
        """
        Extra disk size in GB. Supported values: 25, 50, 100, 250, 500, 1000, 2000
        """
        return pulumi.get(self, "extra_disk_size")

    @extra_disk_size.setter
    def extra_disk_size(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "extra_disk_size", value)

    @property
    @pulumi.getter(name="instanceId")
    def instance_id(self) -> Optional[pulumi.Input[int]]:
        """
        The CloudAMQP instance ID.
        """
        return pulumi.get(self, "instance_id")

    @instance_id.setter
    def instance_id(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "instance_id", value)


class ExtraDiskSize(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 extra_disk_size: Optional[pulumi.Input[int]] = None,
                 instance_id: Optional[pulumi.Input[int]] = None,
                 __props__=None):
        """
        This resource allows you to expand the disk with additional storage capacity. There is no downtime when expanding the disk.

        Only available for dedicated subscription plans hosted at Amazon Web Services (AWS) at this time.

        ⚠️  Due to restrictions from cloud providers, it's only possible to resize the disk every 8 hours.

        Pricing is available at [cloudamqp.com](https://www.cloudamqp.com/).

        ## Example Usage

        ```python
        import pulumi
        import pulumi_cloudamqp as cloudamqp

        # Instance
        instance = cloudamqp.Instance("instance",
            plan="squirrel-1",
            region="amazon-web-services::us-west-2",
            rmq_version="3.10.1")
        # Resize disk with 25 extra GB
        resize_disk = cloudamqp.ExtraDiskSize("resizeDisk",
            instance_id=instance.id,
            extra_disk_size=25)
        nodes = instance.id.apply(lambda id: cloudamqp.get_nodes_output(instance_id=id))
        ```

        ## Import

        Not possible to import this resource.

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[int] extra_disk_size: Extra disk size in GB. Supported values: 25, 50, 100, 250, 500, 1000, 2000
        :param pulumi.Input[int] instance_id: The CloudAMQP instance ID.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: ExtraDiskSizeArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        This resource allows you to expand the disk with additional storage capacity. There is no downtime when expanding the disk.

        Only available for dedicated subscription plans hosted at Amazon Web Services (AWS) at this time.

        ⚠️  Due to restrictions from cloud providers, it's only possible to resize the disk every 8 hours.

        Pricing is available at [cloudamqp.com](https://www.cloudamqp.com/).

        ## Example Usage

        ```python
        import pulumi
        import pulumi_cloudamqp as cloudamqp

        # Instance
        instance = cloudamqp.Instance("instance",
            plan="squirrel-1",
            region="amazon-web-services::us-west-2",
            rmq_version="3.10.1")
        # Resize disk with 25 extra GB
        resize_disk = cloudamqp.ExtraDiskSize("resizeDisk",
            instance_id=instance.id,
            extra_disk_size=25)
        nodes = instance.id.apply(lambda id: cloudamqp.get_nodes_output(instance_id=id))
        ```

        ## Import

        Not possible to import this resource.

        :param str resource_name: The name of the resource.
        :param ExtraDiskSizeArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(ExtraDiskSizeArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 extra_disk_size: Optional[pulumi.Input[int]] = None,
                 instance_id: Optional[pulumi.Input[int]] = None,
                 __props__=None):
        if opts is None:
            opts = pulumi.ResourceOptions()
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.version is None:
            opts.version = _utilities.get_version()
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = ExtraDiskSizeArgs.__new__(ExtraDiskSizeArgs)

            if extra_disk_size is None and not opts.urn:
                raise TypeError("Missing required property 'extra_disk_size'")
            __props__.__dict__["extra_disk_size"] = extra_disk_size
            if instance_id is None and not opts.urn:
                raise TypeError("Missing required property 'instance_id'")
            __props__.__dict__["instance_id"] = instance_id
        super(ExtraDiskSize, __self__).__init__(
            'cloudamqp:index/extraDiskSize:ExtraDiskSize',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            extra_disk_size: Optional[pulumi.Input[int]] = None,
            instance_id: Optional[pulumi.Input[int]] = None) -> 'ExtraDiskSize':
        """
        Get an existing ExtraDiskSize resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[int] extra_disk_size: Extra disk size in GB. Supported values: 25, 50, 100, 250, 500, 1000, 2000
        :param pulumi.Input[int] instance_id: The CloudAMQP instance ID.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _ExtraDiskSizeState.__new__(_ExtraDiskSizeState)

        __props__.__dict__["extra_disk_size"] = extra_disk_size
        __props__.__dict__["instance_id"] = instance_id
        return ExtraDiskSize(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter(name="extraDiskSize")
    def extra_disk_size(self) -> pulumi.Output[int]:
        """
        Extra disk size in GB. Supported values: 25, 50, 100, 250, 500, 1000, 2000
        """
        return pulumi.get(self, "extra_disk_size")

    @property
    @pulumi.getter(name="instanceId")
    def instance_id(self) -> pulumi.Output[int]:
        """
        The CloudAMQP instance ID.
        """
        return pulumi.get(self, "instance_id")

