# Covid-surge
COVID-19 surge period calculation and clustering for communities afflicted by the corona virus SARS-CoV-2.

  + [University of Massachusetts Lowell](https://www.uml.edu/)
  + [Dept. of Chemical Engineering](https://www.uml.edu/Engineering/Chemical/) (Nuclear Program)
  + [Prof. Valmor F. de Almeida](https://www.uml.edu/Engineering/Chemical/faculty/de-Almeida-Valmor.aspx) (valmor_dealmeida@uml.edu)

-----------

[![NBViewer](https://raw.githubusercontent.com/jupyter/design/master/logos/Badges/nbviewer_badge.svg)](https://nbviewer.jupyter.org/github/dpploy/covid-surge/tree/master/notebooks/)
[![Binder](https://mybinder.org/badge_logo.svg)](https://mybinder.org/v2/gh/dpploy/covid-surge/master)
[![Azure Notebooks](https://notebooks.azure.com/launch.svg)](https://notebooks.azure.com/dealmeidavf/projects/covid-surge)

[![PyPI Version](https://img.shields.io/pypi/v/covid-surge)](https://pypi.org/project/covid-surge/)
[![PyPI Python Version](https://img.shields.io/pypi/pyversions/covid-surge)](https://pypi.org/project/covid-surge/)
[![Repo Size](https://img.shields.io/github/repo-size/dpploy/covid-surge)](https://github.com/dpploy/covid-surge)


This development is in progress...

-----------

|   |
|:---|
|-----------------------------------------------------**WORLD**---------------------------------------------------------- |
|<img  width="900" src="https://raw.githubusercontent.com/dpploy/covid-surge/master/readme/group_surge_periods_global.png" title="Surge Periods"> |
| [Data source](https://github.com/CSSEGISandData/COVID-19/tree/master/csse_covid_19_data). |
| Distribution of mortality critical surge periods for the countries with the most evolved epidemics. The range of the critical period for the countries is between 17 to 29 days. That is, the number of days that stresses the health system the most. Countries to the right are less stressed than countries to the left. The colored bar plot shows countries grouped by 2-day bin widths. |
| The world average critical surge period at the date indicated by the plot is **22 days with a 3-day standard deviation**.|
| *To update this plot with live data, [run this Jupyter Notebook](https://nbviewer.jupyter.org/github/dpploy/covid-surge/blob/master/notebooks/countries-surge.ipynb).* |
|---------------------------------------------------------**US**----------------------------------------------------------|
|<img  width="900" src="https://raw.githubusercontent.com/dpploy/covid-surge/master/readme/group_surge_periods_us.png" title="Surge Periods"> |
| [Data source](https://github.com/CSSEGISandData/COVID-19/tree/master/csse_covid_19_data). |
| Distribution of mortality critical surge periods for the states in US with the most evolved epidemics. The range of the critical period for US states is between 16 to 27 days. That is, the number of days that stresses the health system the most. Groups to the right are less stressed than groups to the left. The colored bar plot shows countries grouped by 2-day bin widths.|
| The US state average critical surge period at the date indicated by the plot is **22 days with a 3-day standard deviation**.|
| *To update this plot with live data, [run this Jupyter Notebook](https://nbviewer.jupyter.org/github/dpploy/covid-surge/blob/master/notebooks/us-states-surge.ipynb).*  |
|---------------------------------------------**US State Counties/Towns (Top 3)**-----------------------------------------|
|<img  width="900" src="https://raw.githubusercontent.com/dpploy/covid-surge/master/readme/group_surge_periods_us_new_york.png" title="Surge Periods"> |
| [Data source](https://github.com/CSSEGISandData/COVID-19/tree/master/csse_covid_19_data). |
| Distribution of mortality critical surge periods for the counties/towns in US New York state with the most evolved epidemics. The range of the critical period is between 16 to 23 days. That is, the number of days that stresses the health system the most. Groups to the right are less stressed than groups to the left. The colored bar plot shows countries grouped by 2-day bin widths.|
| The average critical surge period at the date indicated by the plot is **20 days with a 3-day standard deviation**.|
| *To update this plot with live data, [run this Jupyter Notebook](https://nbviewer.jupyter.org/github/dpploy/covid-surge/blob/master/notebooks/us-state-counties.ipynb).*  |
|-------------------------------------------------------------------------------------------------------------------------|
|<img  width="900" src="https://raw.githubusercontent.com/dpploy/covid-surge/master/readme/group_surge_periods_us_new_jersey.png" title="Surge Periods"> |
| [Data source](https://github.com/CSSEGISandData/COVID-19/tree/master/csse_covid_19_data). |
|-------------------------------------------------------------------------------------------------------------------------|
|<img  width="900" src="https://raw.githubusercontent.com/dpploy/covid-surge/master/readme/group_surge_periods_us_massachusetts.png" title="Surge Periods"> |
| [Data source](https://github.com/CSSEGISandData/COVID-19/tree/master/csse_covid_19_data). |
