__all__ = ('BankCardPaymentPoint', 'PublicBankCardPaymentPoint', 'PaymentInvoicePoint')

from expressmoney.api import *

SERVICE = 'payments'


class BankCardPaymentCreateContract(Contract):
    amount = serializers.DecimalField(max_digits=16, decimal_places=0, min_value=1)
    withdraw = serializers.BooleanField()
    bank_card = serializers.IntegerField(min_value=1)
    order_id = serializers.IntegerField()
    order_type = serializers.CharField(max_length=128)


class PaymentInvoiceCreateContract(Contract):
    amount = serializers.DecimalField(max_digits=7, decimal_places=0)
    loan_type = serializers.CharField(max_length=16)
    description = serializers.CharField(max_length=512)


class PaymentInvoiceResponseContract(Contract):
    id = serializers.IntegerField(min_value=1)
    url = serializers.CharField(max_length=512)



class BankCardPaymentResponseContract(Contract):
    id = serializers.IntegerField(min_value=1)
    created = serializers.DateTimeField()


class BankCardPaymentReadContract(BankCardPaymentCreateContract):
    id = serializers.IntegerField(min_value=1)
    created = serializers.DateTimeField()


class PublicBankCardPaymentCreateContract(Contract):
    amount = serializers.DecimalField(max_digits=16, decimal_places=0, min_value=1)
    ip = serializers.CharField(max_length=32)
    withdraw = serializers.BooleanField()
    order_id = serializers.IntegerField()
    order_type = serializers.CharField(max_length=128)
    cryptogram = serializers.CharField(max_length=2048)


class PublicBankCardPaymentResponseContract(Contract):
    id = serializers.IntegerField(min_value=1)
    url = serializers.CharField(max_length=512)


class BankCardPaymentID(ID):
    _service = SERVICE
    _app = 'payments'
    _view_set = 'bank_card_payment'


class PaymentInvoiceID(ID):
    _service = SERVICE
    _app = 'payments'
    _view_set = 'payment_invoice'


class PublicBankCardPaymentID(ID):
    _service = SERVICE
    _app = 'payments'
    _view_set = 'bank_card_public_payment'


class BankCardPaymentPoint(ListPointMixin, ResponseMixin, CreatePointMixin, ContractPoint):
    _point_id = BankCardPaymentID()
    _create_contract = BankCardPaymentCreateContract
    _response_contract = BankCardPaymentResponseContract
    _read_contract = BankCardPaymentReadContract


class PaymentInvoicePoint(CreatePointMixin, ResponseMixin, ContractPoint):
    _point_id = PaymentInvoiceID()
    _create_contract = PaymentInvoiceCreateContract
    _response_contract = PaymentInvoiceResponseContract


class PublicBankCardPaymentPoint(ResponseMixin, CreatePointMixin, ContractPoint):
    _point_id = PublicBankCardPaymentID()
    _create_contract = PublicBankCardPaymentCreateContract
    _response_contract = PublicBankCardPaymentResponseContract
