# coding: utf-8

from enum import Enum

class Mark(Enum):
    D = "底分型"
    G = "顶分型"

class Direction(Enum):
    Up = "向上"
    Down = "向下"

class Freq(Enum):
    F1 = "1分钟"
    F5 = "5分钟"
    F15 = "15分钟"
    F30 = "30分钟"
    F60 = "60分钟"
    D = "日线"
    W = "周线"
    M = "月线"

class Signals(Enum):
    Other = "Other~其他"
    Y = "Y~是"
    N = "N~否"

    # 信号值编码规则：
    # 笔数：X3 - 三笔信号；X5 - 五笔信号；X7 - 七笔信号；X9 - 九笔信号；
    # 多空：L - 多头信号；S - 空头信号；
    # 编号：A0 - A类基础型；A1 - A类变种1 ... 以此类推
    # 组合规则：笔数_多空_编号；如 X5LA0 表示五笔多头信号A0
    # ============================================================================================
    # 五笔形态信号
    # 具体描述：https://blog.csdn.net/baidu_25764509/article/details/113639353
    # --------------------------------------------------------------------------------------------
    X5LA0 = "X5LA0~aAb式底背弛"
    X5LA1 = "X5LA1~aAb式底背弛&近九笔低点等于近五笔低点"
    X5LA2 = "X5LA2~aAb式底背弛&最近一笔RSQ大于0.8"

    X5LB0 = "X5LB0~三买"
    X5LB1 = "X5LB1~三买&近九笔低点等于近五笔低点"

    X5LC0 = "X5LC0~类趋势底背驰"
    X5LC1 = "X5LC1~类趋势底背驰&近九笔低点等于近五笔低点"

    X5LD0 = "X5LD0~向下三角扩张中枢"
    X5LE0 = "X5LE0~向下三角收敛中枢"
    X5LF0 = "X5LF0~上颈线突破"

    X5SA0 = "X5SA0~aAb式顶背驰"
    X5SA1 = "X5SA1~aAb式顶背驰&近九笔高点等于近五笔高点"
    X5SA2 = "X5SA2~aAb式顶背驰&最近一笔RSQ大于0.8"

    X5SB0 = "X5SB0~三卖"
    X5SB1 = "X5SB1~三卖&近九笔高点等于近五笔高点"

    X5SC0 = "X5SC0~类趋势顶背驰"
    X5SC1 = "X5SC1~类趋势顶背驰&近九笔高点等于近五笔高点"

    X5SD0 = "X5SD0~向上三角扩张中枢"
    X5SE0 = "X5SE0~向上三角收敛中枢"
    X5SF0 = "X5SF0~下颈线跌破"
    # --------------------------------------------------------------------------------------------
    # 七笔多头信号
    # 具体描述：https://blog.csdn.net/baidu_25764509/article/details/113649988
    # --------------------------------------------------------------------------------------------
    X7LA0 = "X7LA0~aAbcd式底背弛"
    X7LA1 = "X7LA1~aAbcd式底背弛&近九笔低点等于近七笔低点"
    X7LA2 = "X7LA2~aAbcd式底背弛&最近一笔RSQ大于0.8"

    X7LB0 = "X7LB0~abcAd式底背弛"
    X7LB1 = "X7LB1~abcAd式底背弛&近九笔低点等于近七笔低点"
    X7LB2 = "X7LB2~abcAd式底背弛&最近一笔RSQ大于0.8"

    X7LC0 = "X7LC0~aAb式底背弛"
    X7LC1 = "X7LC1~aAb式底背弛&近九笔低点等于近七笔低点"
    X7LC2 = "X7LC2~aAb式底背弛&最近一笔RSQ大于0.8"

    X7LD0 = "X7LD0~类趋势底背弛"
    X7LD1 = "X7LD1~类趋势底背弛&近九笔低点等于近七笔低点"

    X7LE0 = "X7LE0~BaA式右侧底"

    X7LF0 = "X7LF0~类趋势底背弛强反弹后不创新低"

    X7SA0 = "X7SA0~aAbcd式顶背驰"
    X7SA1 = "X7SA1~aAbcd式顶背驰&近九笔高点等于近七笔高点"
    X7SA2 = "X7SA2~aAbcd式顶背驰&最近一笔RSQ大于0.8"

    X7SB0 = "X7SB0~abcAd式顶背驰"
    X7SB1 = "X7SB1~abcAd式顶背驰&近九笔高点等于近七笔高点"
    X7SB2 = "X7SB2~abcAd式顶背驰&最近一笔RSQ大于0.8"

    X7SC0 = "X7SC0~aAb式顶背驰"
    X7SC1 = "X7SC1~aAb式顶背驰&近九笔高点等于近七笔高点"
    X7SC2 = "X7SC2~aAb式顶背驰&最近一笔RSQ大于0.8"

    X7SD0 = "X7SD0~类趋势顶背驰"
    X7SD1 = "X7SD1~类趋势顶背驰&近九笔高点等于近七笔高点"

    X7SE0 = "X7SE0~BaA式右侧顶"

    X7SF0 = "X7SF0~类趋势顶背驰强反弹后不创新高"

    # --------------------------------------------------------------------------------------------
    # 九笔信号
    # --------------------------------------------------------------------------------------------
    X9LA0 = "X9LA0~aAbBc式底背弛"
    X9LB0 = "X9LB0~aAb式底背弛"
    X9LC0 = "X9LC0~aAbcd式底背弛"

    X9SA0 = "X9SA0~aAbBc式顶背驰"
    X9SB0 = "X9SB0~aAb式顶背弛"
    X9SC0 = "X9SC0~aAbcd式顶背弛"
    # --------------------------------------------------------------------------------------------
    # 同级别组合信号
    # R 表示倒转的意思，R1 就是倒数第1笔， R2 就是倒数第2笔，以此类推
    # --------------------------------------------------------------------------------------------
    R5X7R1X5LA0 = "R5X7R1X5LA0~倒5七笔为abcAd式底背弛&倒1五笔为其他"


class Factors(Enum):
    Other = "Other~其他"
    # 因子值编码规则：
    # 级别：C1 - 1分钟；C2 - 5分钟; C3 - 15分钟; C4 - 30分钟; C5 - 60分钟; C6 - 日线;
    # 类型：
    #   L1 - 向下笔转折右侧；L2 - 向下笔转折左侧；L3 - 向上笔中继右侧；L4 - 向上笔中继左侧；
    #   S1 - 向上笔转折右侧；S2 - 向上笔转折左侧；S3 - 向下笔中继右侧；S4 - 向下笔中继左侧；
    # 编号：A0 - A类基础型；A1 - A类变种1 ... 以此类推
    # 组合规则为 本级别_次级别_类型_编号
    # ============================================================================================
    # 以下是三级别联立因子
    # ============================================================================================
    C6C5C3L1A0 = "C6C5C3L1A0~次级别三买"
    C6C5C3L1A1 = "C6C5C3L1A1~次级别三买&次级别近五笔高点等于近九笔高点"
    C6C5C3L1A2 = "C6C5C3L1A2~次级别三买&次级别近五笔低点等于近九笔低点"

    C6C4C2L1A0 = "C6C4C2L1A0~次级别三买"
    C6C4C2L1A1 = "C6C4C2L1A1~次级别三买&次级别近五笔高点等于近九笔高点"
    C6C4C2L1A2 = "C6C4C2L1A2~次级别三买&次级别近五笔低点等于近九笔低点"

    C6C3C1L1A0 = "C6C3C1L1A0~次级别三买"
    C6C3C1L1A1 = "C6C3C1L1A1~次级别三买&次级别近五笔高点等于近九笔高点"
    C6C3C1L1A2 = "C6C3C1L1A2~次级别三买&次级别近五笔低点等于近九笔低点"

    C5C3C1L1A0 = "C5C3C1L1A0~次级别三买"
    C5C3C1L1A1 = "C5C3C1L1A1~次级别三买&次级别近五笔高点等于近九笔高点"
    C5C3C1L1A2 = "C5C3C1L1A2~次级别三买&次级别近五笔低点等于近九笔低点"

    C5C2C1L1A0 = "C5C2C1L1A0~次级别三买"
    C5C2C1L1A1 = "C5C2C1L1A1~次级别三买&次级别近五笔高点等于近九笔高点"
    C5C2C1L1A2 = "C5C2C1L1A2~次级别三买&次级别近五笔低点等于近九笔低点"

    # --------------------------------------------------------------------------------------------
    C6C5C3L1B0 = "C6C5C3L1B0~本级别第N笔强底分&小级别近七笔为BaA式右侧底"
    C6C5C3L1B1 = "C6C5C3L1B1~本级别第N笔强底分&小级别近七笔为BaA式右侧底&小级别近五笔为上颈线突破"

    C6C4C2L1B0 = "C6C4C2L1B0~本级别第N笔强底分&小级别近七笔为BaA式右侧底"
    C6C4C2L1B1 = "C6C4C2L1B1~本级别第N笔强底分&小级别近七笔为BaA式右侧底&小级别近五笔为上颈线突破"

    C6C3C1L1B0 = "C6C3C1L1B0~本级别第N笔强底分&小级别近七笔为BaA式右侧底"
    C6C3C1L1B1 = "C6C3C1L1B1~本级别第N笔强底分&小级别近七笔为BaA式右侧底&小级别近五笔为上颈线突破"

    C5C3C1L1B0 = "C5C3C1L1B0~本级别第N笔强底分&小级别近七笔为BaA式右侧底"
    C5C3C1L1B1 = "C5C3C1L1B1~本级别第N笔强底分&小级别近七笔为BaA式右侧底&小级别近五笔为上颈线突破"

    C5C2C1L1B0 = "C5C2C1L1B0~本级别第N笔强底分&小级别近七笔为BaA式右侧底"
    C5C2C1L1B1 = "C5C2C1L1B1~本级别第N笔强底分&小级别近七笔为BaA式右侧底&小级别近五笔为上颈线突破"
    # --------------------------------------------------------------------------------------------
    C6C5C3L1C0 = "C6C5C3L1C0~本级别第N笔强底分&次级别近五笔为上颈线突破"

    C6C4C2L1C0 = "C6C4C2L1C0~本级别第N笔强底分&次级别近五笔为上颈线突破"

    C6C3C1L1C0 = "C6C3C1L1C0~本级别第N笔强底分&次级别近五笔为上颈线突破"

    C5C3C1L1C0 = "C5C3C1L1C0~本级别第N笔强底分&次级别近五笔为上颈线突破"

    C5C2C1L1C0 = "C5C2C1L1C0~本级别第N笔强底分&次级别近五笔为上颈线突破"
    # --------------------------------------------------------------------------------------------
    C6C5C3L2A0 = "C6C5C3L2A0~次级别近五笔为底背弛"
    C6C5C3L2A1 = "C6C5C3L2A1~次级别近五笔为底背弛&小级别近五笔为上颈线突破"

    C6C4C2L2A0 = "C6C4C2L2A0~次级别近五笔为底背弛"
    C6C4C2L2A1 = "C6C4C2L2A1~次级别近五笔为底背弛&小级别近五笔为上颈线突破"

    C6C3C1L2A0 = "C6C3C1L2A0~次级别近五笔为底背弛"
    C6C3C1L2A1 = "C6C3C1L2A1~次级别近五笔为底背弛&小级别近五笔为上颈线突破"

    C5C3C1L2A0 = "C5C3C1L2A0~次级别近五笔为底背弛"
    C5C3C1L2A1 = "C5C3C1L2A1~次级别近五笔为底背弛&小级别近五笔为上颈线突破"

    C5C2C1L2A0 = "C5C2C1L2A0~次级别近五笔为底背弛"
    C5C2C1L2A1 = "C5C2C1L2A1~次级别近五笔为底背弛&小级别近五笔为上颈线突破"
    # --------------------------------------------------------------------------------------------
    C6C5C3L2B0 = "C6C5C3L2B0~次级别近七笔为底背弛"
    C6C5C3L2B1 = "C6C5C3L2B1~次级别近七笔为底背弛&小级别近五笔为上颈线突破"

    C6C4C2L2B0 = "C6C4C2L2B0~次级别近七笔为底背弛"
    C6C4C2L2B1 = "C6C4C2L2B1~次级别近七笔为底背弛&小级别近五笔为上颈线突破"

    C6C3C1L2B0 = "C6C3C1L2B0~次级别近七笔为底背弛"
    C6C3C1L2B1 = "C6C3C1L2B1~次级别近七笔为底背弛&小级别近五笔为上颈线突破"

    C5C3C1L2B0 = "C5C3C1L2B0~次级别近七笔为底背弛"
    C5C3C1L2B1 = "C5C3C1L2B1~次级别近七笔为底背弛&小级别近五笔为上颈线突破"

    C5C2C1L2B0 = "C5C2C1L2B0~次级别近七笔为底背弛"
    C5C2C1L2B1 = "C5C2C1L2B1~次级别近七笔为底背弛&小级别近五笔为上颈线突破"
    # --------------------------------------------------------------------------------------------
    C6C5C3L2C0 = "C6C5C3L2C0~次级别近九笔为底背弛"
    C6C5C3L2C1 = "C6C5C3L2C1~次级别近九笔为aAbBc式底背弛"
    C6C5C3L2C2 = "C6C5C3L2C2~次级别近九笔为底背弛&小级别近五笔为上颈线突破"
    C6C5C3L2C3 = "C6C5C3L2C3~次级别近九笔为aAbBc式底背弛&小级别近五笔为上颈线突破"

    C6C4C2L2C0 = "C6C4C2L2C0~次级别近九笔为底背弛"
    C6C4C2L2C1 = "C6C4C2L2C1~次级别近九笔为aAbBc式底背弛"
    C6C4C2L2C2 = "C6C4C2L2C2~次级别近九笔为底背弛&小级别近五笔为上颈线突破"
    C6C4C2L2C3 = "C6C4C2L2C3~次级别近九笔为aAbBc式底背弛&小级别近五笔为上颈线突破"

    C6C3C1L2C0 = "C6C3C1L2C0~次级别近九笔为底背弛"
    C6C3C1L2C1 = "C6C3C1L2C1~次级别近九笔为aAbBc式底背弛"
    C6C3C1L2C2 = "C6C3C1L2C2~次级别近九笔为底背弛&小级别近五笔为上颈线突破"
    C6C3C1L2C3 = "C6C3C1L2C3~次级别近九笔为aAbBc式底背弛&小级别近五笔为上颈线突破"

    C5C3C1L2C0 = "C5C3C1L2C0~次级别近九笔为底背弛"
    C5C3C1L2C1 = "C5C3C1L2C1~次级别近九笔为aAbBc式底背弛"
    C5C3C1L2C2 = "C5C3C1L2C2~次级别近九笔为底背弛&小级别近五笔为上颈线突破"
    C5C3C1L2C3 = "C5C3C1L2C3~次级别近九笔为aAbBc式底背弛&小级别近五笔为上颈线突破"

    C5C2C1L2C0 = "C5C2C1L2C0~次级别近九笔为底背弛"
    C5C2C1L2C1 = "C5C2C1L2C1~次级别近九笔为aAbBc式底背弛"
    C5C2C1L2C2 = "C5C2C1L2C2~次级别近九笔为底背弛&小级别近五笔为上颈线突破"
    C5C2C1L2C3 = "C5C2C1L2C3~次级别近九笔为aAbBc式底背弛&小级别近五笔为上颈线突破"
    # --------------------------------------------------------------------------------------------
    C6C5C3L3A0 = "C6C5C3L3A0~60分钟近七笔为BaA式右侧底"

    C6C4C2L3A0 = "C6C4C2L3A0~30分钟近七笔为BaA式右侧底"

    C6C3C1L3A0 = "C6C3C1L3A0~15分钟近七笔为BaA式右侧底"

    C5C3C1L3A0 = "C5C3C1L3A0~1分钟近七笔为BaA式右侧底"

    C5C2C1L3A0 = "C5C2C1L3A0~1分钟近七笔为BaA式右侧底"
    # --------------------------------------------------------------------------------------------
    C6C5C3L3B0 = "C6C5C3L3B0~60分钟近五笔为上颈线突破"

    C6C4C2L3B0 = "C6C4C2L3B0~30分钟近五笔为上颈线突破"

    C6C3C1L3B0 = "C6C3C1L3B0~15分钟近五笔为上颈线突破"

    C5C3C1L3B0 = "C5C3C1L3B0~1分钟近五笔为上颈线突破"

    C5C2C1L3B0 = "C5C2C1L3B0~1分钟近五笔为上颈线突破"
    # --------------------------------------------------------------------------------------------
    C6C5C3L4A0 = "C6C5C3L4A0~15分钟近七笔为底背弛"

    C6C4C2L4A0 = "C6C4C2L4A0~5分钟近七笔为底背弛"

    C6C3C1L4A0 = "C6C3C1L4A0~1分钟近七笔为底背弛"

    C5C3C1L4A0 = "C5C3C1L4A0~1分钟近七笔为底背弛"

    C5C2C1L4A0 = "C5C2C1L4A0~1分钟近七笔为底背弛"
    # --------------------------------------------------------------------------------------------
    C6C5C3S1A0 = "C6C5C3S1A0~次级别三卖"
    C6C5C3S1A1 = "C6C5C3S1A1~次级别三卖&小级别下颈线跌破"

    C6C4C2S1A0 = "C6C4C2S1A0~次级别三卖"
    C6C4C2S1A1 = "C6C4C2S1A1~次级别三卖&小级别下颈线跌破"

    C6C3C1S1A0 = "C6C3C1S1A0~次级别三卖"
    C6C3C1S1A1 = "C6C3C1S1A1~次级别三卖&小级别下颈线跌破"

    C5C3C1S1A0 = "C5C3C1S1A0~次级别三卖"
    C5C3C1S1A1 = "C5C3C1S1A1~次级别三卖&小级别下颈线跌破"

    C5C2C1S1A0 = "C5C2C1S1A0~次级别三卖"
    C5C2C1S1A1 = "C5C2C1S1A1~次级别三卖&小级别下颈线跌破"
    # --------------------------------------------------------------------------------------------
    C6C5C3S1B0 = "C6C5C3S1B0~次级别近五笔为下颈线跌破"
    C6C5C3S1B1 = "C6C5C3S1B1~次级别和小级别近五笔都为下颈线跌破"

    C6C4C2S1B0 = "C6C4C2S1B0~次级别近五笔为下颈线跌破"
    C6C4C2S1B1 = "C6C4C2S1B1~次级别和小级别近五笔都为下颈线跌破"

    C6C3C1S1B0 = "C6C3C1S1B0~次级别近五笔为下颈线跌破"
    C6C3C1S1B1 = "C6C3C1S1B1~次级别和小级别近五笔都为下颈线跌破"

    C5C3C1S1B0 = "C5C3C1S1B0~次级别近五笔为下颈线跌破"
    C5C3C1S1B1 = "C5C3C1S1B1~次级别和小级别近五笔都为下颈线跌破"

    C5C2C1S1B0 = "C5C2C1S1B0~次级别近五笔为下颈线跌破"
    C5C2C1S1B1 = "C5C2C1S1B1~次级别和小级别近五笔都为下颈线跌破"
    # --------------------------------------------------------------------------------------------
    C6C5C3S2A0 = "C6C5C3S2A0~次级别顶背弛"
    C6C5C3S2A1 = "C6C5C3S2A1~次级别顶背弛&小级别下颈线跌破"

    C6C4C2S2A0 = "C6C4C2S2A0~次级别顶背弛"
    C6C4C2S2A1 = "C6C4C2S2A1~次级别顶背弛&小级别下颈线跌破"

    C6C3C1S2A0 = "C6C3C1S2A0~次级别顶背弛"
    C6C3C1S2A1 = "C6C3C1S2A1~次级别顶背弛&小级别下颈线跌破"

    C5C3C1S2A0 = "C5C3C1S2A0~次级别顶背弛"
    C5C3C1S2A1 = "C5C3C1S2A1~次级别顶背弛&小级别下颈线跌破"

    C5C2C1S2A0 = "C5C2C1S2A0~次级别顶背弛"
    C5C2C1S2A1 = "C5C2C1S2A1~次级别顶背弛&小级别下颈线跌破"
    # --------------------------------------------------------------------------------------------
    C6C5C3S3A0 = "C6C5C3S3A0~次级别下颈线跌破"
    C6C5C3S3A1 = "C6C5C3S3A1~次级别下颈线跌破&小级别下颈线跌破"

    C6C4C2S3A0 = "C6C4C2S3A0~次级别下颈线跌破"
    C6C4C2S3A1 = "C6C4C2S3A1~次级别下颈线跌破&小级别下颈线跌破"

    C6C3C1S3A0 = "C6C3C1S3A0~次级别下颈线跌破"
    C6C3C1S3A1 = "C6C3C1S3A1~次级别下颈线跌破&小级别下颈线跌破"

    C5C3C1S3A0 = "C5C3C1S3A0~次级别下颈线跌破"
    C5C3C1S3A1 = "C5C3C1S3A1~次级别下颈线跌破&小级别下颈线跌破"

    C5C2C1S3A0 = "C5C2C1S3A0~次级别下颈线跌破"
    C5C2C1S3A1 = "C5C2C1S3A1~次级别下颈线跌破&小级别下颈线跌破"
    # --------------------------------------------------------------------------------------------
    C6C5C3S4A0 = "C6C5C3S4A0~小级别顶背驰"

    C6C4C2S4A0 = "C6C4C2S4A0~小级别顶背驰"

    C6C3C1S4A0 = "C6C3C1S4A0~小级别顶背驰"

    C5C3C1S4A0 = "C5C3C1S4A0~小级别顶背驰"

    C5C2C1S4A0 = "C5C2C1S4A0~小级别顶背驰"
    # --------------------------------------------------------------------------------------------
    # 以下是两级别联立因子（暂未开发）
    # --------------------------------------------------------------------------------------------
    C4C2L1A0 = "C4C2L1A0~"
