import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
/**
 * @stability stable
 */
export interface AccessContextManagerGcpUserAccessBindingConfig extends cdktf.TerraformMetaArguments {
    /**
     * Required.
     *
     * Access level that a user must have to be granted access. Only one access level is supported, not multiple. This repeated field must have exactly one element. Example: "accessPolicies/9522/accessLevels/device_trusted"
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/access_context_manager_gcp_user_access_binding.html#access_levels AccessContextManagerGcpUserAccessBinding#access_levels}
     *
     * @stability stable
     */
    readonly accessLevels: string[];
    /**
     * Required.
     *
     * Immutable. Google Group id whose members are subject to this binding's restrictions. See "id" in the G Suite Directory API's Groups resource. If a group's email address/alias is changed, this resource will continue to point at the changed group. This field does not accept group email addresses or aliases. Example: "01d520gv4vjcrht"
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/access_context_manager_gcp_user_access_binding.html#group_key AccessContextManagerGcpUserAccessBinding#group_key}
     *
     * @stability stable
     */
    readonly groupKey: string;
    /**
     * Required. ID of the parent organization.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/access_context_manager_gcp_user_access_binding.html#organization_id AccessContextManagerGcpUserAccessBinding#organization_id}
     *
     * @stability stable
     */
    readonly organizationId: string;
    /**
     * timeouts block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/access_context_manager_gcp_user_access_binding.html#timeouts AccessContextManagerGcpUserAccessBinding#timeouts}
     *
     * @stability stable
     */
    readonly timeouts?: AccessContextManagerGcpUserAccessBindingTimeouts;
}
/**
 * @stability stable
 */
export interface AccessContextManagerGcpUserAccessBindingTimeouts {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/access_context_manager_gcp_user_access_binding.html#create AccessContextManagerGcpUserAccessBinding#create}.
     *
     * @stability stable
     */
    readonly create?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/access_context_manager_gcp_user_access_binding.html#delete AccessContextManagerGcpUserAccessBinding#delete}.
     *
     * @stability stable
     */
    readonly delete?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/access_context_manager_gcp_user_access_binding.html#update AccessContextManagerGcpUserAccessBinding#update}.
     *
     * @stability stable
     */
    readonly update?: string;
}
/**
 * @stability stable
 */
export declare class AccessContextManagerGcpUserAccessBindingTimeoutsOutputReference extends cdktf.ComplexObject {
    /**
     * @param terraformResource The parent resource.
     * @param terraformAttribute The attribute on the parent resource this class is referencing.
     * @param isSingleItem True if this is a block, false if it's a list.
     * @stability stable
     */
    constructor(terraformResource: cdktf.ITerraformResource, terraformAttribute: string, isSingleItem: boolean);
    private _create?;
    /**
     * @stability stable
     */
    get create(): string | undefined;
    /**
     * @stability stable
     */
    set create(value: string | undefined);
    /**
     * @stability stable
     */
    resetCreate(): void;
    /**
     * @stability stable
     */
    get createInput(): string | undefined;
    private _delete?;
    /**
     * @stability stable
     */
    get delete(): string | undefined;
    /**
     * @stability stable
     */
    set delete(value: string | undefined);
    /**
     * @stability stable
     */
    resetDelete(): void;
    /**
     * @stability stable
     */
    get deleteInput(): string | undefined;
    private _update?;
    /**
     * @stability stable
     */
    get update(): string | undefined;
    /**
     * @stability stable
     */
    set update(value: string | undefined);
    /**
     * @stability stable
     */
    resetUpdate(): void;
    /**
     * @stability stable
     */
    get updateInput(): string | undefined;
}
/**
 * Represents a {@link https://www.terraform.io/docs/providers/google/r/access_context_manager_gcp_user_access_binding.html google_access_context_manager_gcp_user_access_binding}.
 *
 * @stability stable
 */
export declare class AccessContextManagerGcpUserAccessBinding extends cdktf.TerraformResource {
    /**
     * @stability stable
     */
    static readonly tfResourceType: string;
    /**
     * Create a new {@link https://www.terraform.io/docs/providers/google/r/access_context_manager_gcp_user_access_binding.html google_access_context_manager_gcp_user_access_binding} Resource.
     *
     * @param scope The scope in which to define this construct.
     * @param id The scoped construct ID.
     * @stability stable
     */
    constructor(scope: Construct, id: string, config: AccessContextManagerGcpUserAccessBindingConfig);
    private _accessLevels?;
    /**
     * @stability stable
     */
    get accessLevels(): string[];
    /**
     * @stability stable
     */
    set accessLevels(value: string[]);
    /**
     * @stability stable
     */
    get accessLevelsInput(): string[] | undefined;
    private _groupKey?;
    /**
     * @stability stable
     */
    get groupKey(): string;
    /**
     * @stability stable
     */
    set groupKey(value: string);
    /**
     * @stability stable
     */
    get groupKeyInput(): string | undefined;
    /**
     * @stability stable
     */
    get id(): string;
    /**
     * @stability stable
     */
    get name(): string;
    private _organizationId?;
    /**
     * @stability stable
     */
    get organizationId(): string;
    /**
     * @stability stable
     */
    set organizationId(value: string);
    /**
     * @stability stable
     */
    get organizationIdInput(): string | undefined;
    private _timeouts?;
    private __timeoutsOutput;
    /**
     * @stability stable
     */
    get timeouts(): AccessContextManagerGcpUserAccessBindingTimeoutsOutputReference;
    /**
     * @stability stable
     */
    putTimeouts(value: AccessContextManagerGcpUserAccessBindingTimeouts | undefined): void;
    /**
     * @stability stable
     */
    resetTimeouts(): void;
    /**
     * @stability stable
     */
    get timeoutsInput(): AccessContextManagerGcpUserAccessBindingTimeouts | undefined;
    /**
     * @stability stable
     */
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
