import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
/**
 * @stability stable
 */
export interface ServiceAccountIamPolicyConfig extends cdktf.TerraformMetaArguments {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/service_account_iam_policy.html#policy_data ServiceAccountIamPolicy#policy_data}.
     *
     * @stability stable
     */
    readonly policyData: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/service_account_iam_policy.html#service_account_id ServiceAccountIamPolicy#service_account_id}.
     *
     * @stability stable
     */
    readonly serviceAccountId: string;
}
/**
 * Represents a {@link https://www.terraform.io/docs/providers/google/r/service_account_iam_policy.html google_service_account_iam_policy}.
 *
 * @stability stable
 */
export declare class ServiceAccountIamPolicy extends cdktf.TerraformResource {
    /**
     * @stability stable
     */
    static readonly tfResourceType: string;
    /**
     * Create a new {@link https://www.terraform.io/docs/providers/google/r/service_account_iam_policy.html google_service_account_iam_policy} Resource.
     *
     * @param scope The scope in which to define this construct.
     * @param id The scoped construct ID.
     * @stability stable
     */
    constructor(scope: Construct, id: string, config: ServiceAccountIamPolicyConfig);
    /**
     * @stability stable
     */
    get etag(): string;
    /**
     * @stability stable
     */
    get id(): string;
    private _policyData?;
    /**
     * @stability stable
     */
    get policyData(): string;
    /**
     * @stability stable
     */
    set policyData(value: string);
    /**
     * @stability stable
     */
    get policyDataInput(): string | undefined;
    private _serviceAccountId?;
    /**
     * @stability stable
     */
    get serviceAccountId(): string;
    /**
     * @stability stable
     */
    set serviceAccountId(value: string);
    /**
     * @stability stable
     */
    get serviceAccountIdInput(): string | undefined;
    /**
     * @stability stable
     */
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
