# HydroDashboards

Open Source Dashboards for Hydro-Data

[![test](https://github.com/d2hydro/hydrodashboards/actions/workflows/python-package-conda.yml/badge.svg)](https://github.com/d2hydro/hydrodashboards/actions/workflows/python-package-conda.yml)
[![Coverage](https://img.shields.io/codecov/c/github/d2hydro/hydrodashboards)](https://codecov.io/github/d2hydro/hydrodashboards)
[![Code style: black](https://img.shields.io/badge/code%20style-black-000000.svg)](https://github.com/psf/black)
[![Release: latest](https://img.shields.io/github/v/release/d2hydro/hydrodashboards)](https://pypi.org/project/hydrodashboards)
[![License: MIT](https://img.shields.io/badge/License-MIT-yellow.svg)](https://opensource.org/licenses/MIT)
---

**Documentation**: [https://d2hydro.github.io/hydrodashboards](https://d2hydro.github.io/hydrodashboards)

**Source Code**: [https://github.com/d2hydro/hydrodashboards](https://github.com/d2hydro/hydrodashboards)

---

## Installation

Hydrodashboards can be installed with pip in any environment with the following Python-packages properly installed:

* requests
* aiohttp
* nest-asyncio
* pandas
* geopandas

In that activated environment you can add hydrodashboards via pip by:
```
pip install hydrodashboards
```
We recommend to build your environment using [Anaconda](https://www.anaconda.com/). You can build an environment ánd install hydrodashboards by conda in one go using this <a href="https://github.com/d2hydro/hydrodashboards/blob/main/envs/environment.yml" target="_blank">environment.yml</a> from the command-line:
```
conda env create -f environment.yml
```
## About

Hydrodashboards is developed and maintained by [D2Hydro](https://d2hydro.nl/) and freely available under an Open Source <a href="https://github.com/d2hydro/hydrodashboards/blob/main/LICENSE" target="_blank">MIT license</a>.
