import * as cdk from '@aws-cdk/core';
import * as cfn_parse from '@aws-cdk/core/lib/cfn-parse';
/**
 * Properties for defining a `AWS::XRay::Group`.
 *
 * @external
 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-xray-group.html
 */
export interface CfnGroupProps {
    /**
     * `AWS::XRay::Group.FilterExpression`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-xray-group.html#cfn-xray-group-filterexpression
     */
    readonly filterExpression?: string;
    /**
     * `AWS::XRay::Group.GroupName`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-xray-group.html#cfn-xray-group-groupname
     */
    readonly groupName?: string;
    /**
     * `AWS::XRay::Group.InsightsConfiguration`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-xray-group.html#cfn-xray-group-insightsconfiguration
     */
    readonly insightsConfiguration?: CfnGroup.InsightsConfigurationProperty | cdk.IResolvable;
    /**
     * `AWS::XRay::Group.Tags`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-xray-group.html#cfn-xray-group-tags
     */
    readonly tags?: any[];
}
/**
 * A CloudFormation `AWS::XRay::Group`.
 *
 * @external
 * @cloudformationResource AWS::XRay::Group
 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-xray-group.html
 */
export declare class CfnGroup extends cdk.CfnResource implements cdk.IInspectable {
    /**
     * The CloudFormation resource type name for this resource class.
     *
     * @external
     */
    static readonly CFN_RESOURCE_TYPE_NAME = "AWS::XRay::Group";
    /**
     * A factory method that creates a new instance of this class from an object
     * containing the CloudFormation properties of this resource.
     * Used in the @aws-cdk/cloudformation-include module.
     *
     * @internal
     */
    static _fromCloudFormation(scope: cdk.Construct, id: string, resourceAttributes: any, options: cfn_parse.FromCloudFormationOptions): CfnGroup;
    /**
     * @external
     * @cloudformationAttribute GroupARN
     */
    readonly attrGroupArn: string;
    /**
     * `AWS::XRay::Group.FilterExpression`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-xray-group.html#cfn-xray-group-filterexpression
     */
    filterExpression: string | undefined;
    /**
     * `AWS::XRay::Group.GroupName`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-xray-group.html#cfn-xray-group-groupname
     */
    groupName: string | undefined;
    /**
     * `AWS::XRay::Group.InsightsConfiguration`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-xray-group.html#cfn-xray-group-insightsconfiguration
     */
    insightsConfiguration: CfnGroup.InsightsConfigurationProperty | cdk.IResolvable | undefined;
    /**
     * `AWS::XRay::Group.Tags`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-xray-group.html#cfn-xray-group-tags
     */
    tags: any[] | undefined;
    /**
     * Create a new `AWS::XRay::Group`.
     *
     * @param scope - scope in which this resource is defined.
     * @param id - scoped id of the resource.
     * @param props - resource properties.
     * @external
     */
    constructor(scope: cdk.Construct, id: string, props?: CfnGroupProps);
    /**
     * Examines the CloudFormation resource and discloses attributes.
     *
     * @param inspector - tree inspector to collect and process attributes.
     * @external
     */
    inspect(inspector: cdk.TreeInspector): void;
    /**
     * @external
     */
    protected get cfnProperties(): {
        [key: string]: any;
    };
    /**
     * @external
     */
    protected renderProperties(props: {
        [key: string]: any;
    }): {
        [key: string]: any;
    };
}
/**
 * A CloudFormation `AWS::XRay::Group`.
 *
 * @external
 * @cloudformationResource AWS::XRay::Group
 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-xray-group.html
 */
export declare namespace CfnGroup {
    /**
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-xray-group-insightsconfiguration.html
     */
    interface InsightsConfigurationProperty {
        /**
         * `CfnGroup.InsightsConfigurationProperty.InsightsEnabled`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-xray-group-insightsconfiguration.html#cfn-xray-group-insightsconfiguration-insightsenabled
         */
        readonly insightsEnabled?: boolean | cdk.IResolvable;
        /**
         * `CfnGroup.InsightsConfigurationProperty.NotificationsEnabled`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-xray-group-insightsconfiguration.html#cfn-xray-group-insightsconfiguration-notificationsenabled
         */
        readonly notificationsEnabled?: boolean | cdk.IResolvable;
    }
}
/**
 * Properties for defining a `AWS::XRay::SamplingRule`.
 *
 * @external
 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-xray-samplingrule.html
 */
export interface CfnSamplingRuleProps {
    /**
     * `AWS::XRay::SamplingRule.RuleName`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-xray-samplingrule.html#cfn-xray-samplingrule-rulename
     */
    readonly ruleName?: string;
    /**
     * `AWS::XRay::SamplingRule.SamplingRule`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-xray-samplingrule.html#cfn-xray-samplingrule-samplingrule
     */
    readonly samplingRule?: CfnSamplingRule.SamplingRuleProperty | cdk.IResolvable;
    /**
     * `AWS::XRay::SamplingRule.SamplingRuleRecord`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-xray-samplingrule.html#cfn-xray-samplingrule-samplingrulerecord
     */
    readonly samplingRuleRecord?: CfnSamplingRule.SamplingRuleRecordProperty | cdk.IResolvable;
    /**
     * `AWS::XRay::SamplingRule.SamplingRuleUpdate`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-xray-samplingrule.html#cfn-xray-samplingrule-samplingruleupdate
     */
    readonly samplingRuleUpdate?: CfnSamplingRule.SamplingRuleUpdateProperty | cdk.IResolvable;
    /**
     * `AWS::XRay::SamplingRule.Tags`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-xray-samplingrule.html#cfn-xray-samplingrule-tags
     */
    readonly tags?: any[];
}
/**
 * A CloudFormation `AWS::XRay::SamplingRule`.
 *
 * @external
 * @cloudformationResource AWS::XRay::SamplingRule
 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-xray-samplingrule.html
 */
export declare class CfnSamplingRule extends cdk.CfnResource implements cdk.IInspectable {
    /**
     * The CloudFormation resource type name for this resource class.
     *
     * @external
     */
    static readonly CFN_RESOURCE_TYPE_NAME = "AWS::XRay::SamplingRule";
    /**
     * A factory method that creates a new instance of this class from an object
     * containing the CloudFormation properties of this resource.
     * Used in the @aws-cdk/cloudformation-include module.
     *
     * @internal
     */
    static _fromCloudFormation(scope: cdk.Construct, id: string, resourceAttributes: any, options: cfn_parse.FromCloudFormationOptions): CfnSamplingRule;
    /**
     * @external
     * @cloudformationAttribute RuleARN
     */
    readonly attrRuleArn: string;
    /**
     * `AWS::XRay::SamplingRule.RuleName`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-xray-samplingrule.html#cfn-xray-samplingrule-rulename
     */
    ruleName: string | undefined;
    /**
     * `AWS::XRay::SamplingRule.SamplingRule`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-xray-samplingrule.html#cfn-xray-samplingrule-samplingrule
     */
    samplingRule: CfnSamplingRule.SamplingRuleProperty | cdk.IResolvable | undefined;
    /**
     * `AWS::XRay::SamplingRule.SamplingRuleRecord`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-xray-samplingrule.html#cfn-xray-samplingrule-samplingrulerecord
     */
    samplingRuleRecord: CfnSamplingRule.SamplingRuleRecordProperty | cdk.IResolvable | undefined;
    /**
     * `AWS::XRay::SamplingRule.SamplingRuleUpdate`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-xray-samplingrule.html#cfn-xray-samplingrule-samplingruleupdate
     */
    samplingRuleUpdate: CfnSamplingRule.SamplingRuleUpdateProperty | cdk.IResolvable | undefined;
    /**
     * `AWS::XRay::SamplingRule.Tags`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-xray-samplingrule.html#cfn-xray-samplingrule-tags
     */
    tags: any[] | undefined;
    /**
     * Create a new `AWS::XRay::SamplingRule`.
     *
     * @param scope - scope in which this resource is defined.
     * @param id - scoped id of the resource.
     * @param props - resource properties.
     * @external
     */
    constructor(scope: cdk.Construct, id: string, props?: CfnSamplingRuleProps);
    /**
     * Examines the CloudFormation resource and discloses attributes.
     *
     * @param inspector - tree inspector to collect and process attributes.
     * @external
     */
    inspect(inspector: cdk.TreeInspector): void;
    /**
     * @external
     */
    protected get cfnProperties(): {
        [key: string]: any;
    };
    /**
     * @external
     */
    protected renderProperties(props: {
        [key: string]: any;
    }): {
        [key: string]: any;
    };
}
/**
 * A CloudFormation `AWS::XRay::SamplingRule`.
 *
 * @external
 * @cloudformationResource AWS::XRay::SamplingRule
 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-xray-samplingrule.html
 */
export declare namespace CfnSamplingRule {
    /**
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-xray-samplingrule-samplingrule.html
     */
    interface SamplingRuleProperty {
        /**
         * `CfnSamplingRule.SamplingRuleProperty.Attributes`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-xray-samplingrule-samplingrule.html#cfn-xray-samplingrule-samplingrule-attributes
         */
        readonly attributes?: {
            [key: string]: (string);
        } | cdk.IResolvable;
        /**
         * `CfnSamplingRule.SamplingRuleProperty.FixedRate`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-xray-samplingrule-samplingrule.html#cfn-xray-samplingrule-samplingrule-fixedrate
         */
        readonly fixedRate?: number;
        /**
         * `CfnSamplingRule.SamplingRuleProperty.HTTPMethod`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-xray-samplingrule-samplingrule.html#cfn-xray-samplingrule-samplingrule-httpmethod
         */
        readonly httpMethod?: string;
        /**
         * `CfnSamplingRule.SamplingRuleProperty.Host`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-xray-samplingrule-samplingrule.html#cfn-xray-samplingrule-samplingrule-host
         */
        readonly host?: string;
        /**
         * `CfnSamplingRule.SamplingRuleProperty.Priority`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-xray-samplingrule-samplingrule.html#cfn-xray-samplingrule-samplingrule-priority
         */
        readonly priority?: number;
        /**
         * `CfnSamplingRule.SamplingRuleProperty.ReservoirSize`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-xray-samplingrule-samplingrule.html#cfn-xray-samplingrule-samplingrule-reservoirsize
         */
        readonly reservoirSize?: number;
        /**
         * `CfnSamplingRule.SamplingRuleProperty.ResourceARN`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-xray-samplingrule-samplingrule.html#cfn-xray-samplingrule-samplingrule-resourcearn
         */
        readonly resourceArn?: string;
        /**
         * `CfnSamplingRule.SamplingRuleProperty.RuleARN`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-xray-samplingrule-samplingrule.html#cfn-xray-samplingrule-samplingrule-rulearn
         */
        readonly ruleArn?: string;
        /**
         * `CfnSamplingRule.SamplingRuleProperty.RuleName`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-xray-samplingrule-samplingrule.html#cfn-xray-samplingrule-samplingrule-rulename
         */
        readonly ruleName?: string;
        /**
         * `CfnSamplingRule.SamplingRuleProperty.ServiceName`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-xray-samplingrule-samplingrule.html#cfn-xray-samplingrule-samplingrule-servicename
         */
        readonly serviceName?: string;
        /**
         * `CfnSamplingRule.SamplingRuleProperty.ServiceType`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-xray-samplingrule-samplingrule.html#cfn-xray-samplingrule-samplingrule-servicetype
         */
        readonly serviceType?: string;
        /**
         * `CfnSamplingRule.SamplingRuleProperty.URLPath`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-xray-samplingrule-samplingrule.html#cfn-xray-samplingrule-samplingrule-urlpath
         */
        readonly urlPath?: string;
        /**
         * `CfnSamplingRule.SamplingRuleProperty.Version`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-xray-samplingrule-samplingrule.html#cfn-xray-samplingrule-samplingrule-version
         */
        readonly version?: number;
    }
}
/**
 * A CloudFormation `AWS::XRay::SamplingRule`.
 *
 * @external
 * @cloudformationResource AWS::XRay::SamplingRule
 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-xray-samplingrule.html
 */
export declare namespace CfnSamplingRule {
    /**
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-xray-samplingrule-samplingrulerecord.html
     */
    interface SamplingRuleRecordProperty {
        /**
         * `CfnSamplingRule.SamplingRuleRecordProperty.CreatedAt`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-xray-samplingrule-samplingrulerecord.html#cfn-xray-samplingrule-samplingrulerecord-createdat
         */
        readonly createdAt?: string;
        /**
         * `CfnSamplingRule.SamplingRuleRecordProperty.ModifiedAt`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-xray-samplingrule-samplingrulerecord.html#cfn-xray-samplingrule-samplingrulerecord-modifiedat
         */
        readonly modifiedAt?: string;
        /**
         * `CfnSamplingRule.SamplingRuleRecordProperty.SamplingRule`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-xray-samplingrule-samplingrulerecord.html#cfn-xray-samplingrule-samplingrulerecord-samplingrule
         */
        readonly samplingRule?: CfnSamplingRule.SamplingRuleProperty | cdk.IResolvable;
    }
}
/**
 * A CloudFormation `AWS::XRay::SamplingRule`.
 *
 * @external
 * @cloudformationResource AWS::XRay::SamplingRule
 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-xray-samplingrule.html
 */
export declare namespace CfnSamplingRule {
    /**
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-xray-samplingrule-samplingruleupdate.html
     */
    interface SamplingRuleUpdateProperty {
        /**
         * `CfnSamplingRule.SamplingRuleUpdateProperty.Attributes`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-xray-samplingrule-samplingruleupdate.html#cfn-xray-samplingrule-samplingruleupdate-attributes
         */
        readonly attributes?: {
            [key: string]: (string);
        } | cdk.IResolvable;
        /**
         * `CfnSamplingRule.SamplingRuleUpdateProperty.FixedRate`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-xray-samplingrule-samplingruleupdate.html#cfn-xray-samplingrule-samplingruleupdate-fixedrate
         */
        readonly fixedRate?: number;
        /**
         * `CfnSamplingRule.SamplingRuleUpdateProperty.HTTPMethod`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-xray-samplingrule-samplingruleupdate.html#cfn-xray-samplingrule-samplingruleupdate-httpmethod
         */
        readonly httpMethod?: string;
        /**
         * `CfnSamplingRule.SamplingRuleUpdateProperty.Host`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-xray-samplingrule-samplingruleupdate.html#cfn-xray-samplingrule-samplingruleupdate-host
         */
        readonly host?: string;
        /**
         * `CfnSamplingRule.SamplingRuleUpdateProperty.Priority`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-xray-samplingrule-samplingruleupdate.html#cfn-xray-samplingrule-samplingruleupdate-priority
         */
        readonly priority?: number;
        /**
         * `CfnSamplingRule.SamplingRuleUpdateProperty.ReservoirSize`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-xray-samplingrule-samplingruleupdate.html#cfn-xray-samplingrule-samplingruleupdate-reservoirsize
         */
        readonly reservoirSize?: number;
        /**
         * `CfnSamplingRule.SamplingRuleUpdateProperty.ResourceARN`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-xray-samplingrule-samplingruleupdate.html#cfn-xray-samplingrule-samplingruleupdate-resourcearn
         */
        readonly resourceArn?: string;
        /**
         * `CfnSamplingRule.SamplingRuleUpdateProperty.RuleARN`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-xray-samplingrule-samplingruleupdate.html#cfn-xray-samplingrule-samplingruleupdate-rulearn
         */
        readonly ruleArn?: string;
        /**
         * `CfnSamplingRule.SamplingRuleUpdateProperty.RuleName`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-xray-samplingrule-samplingruleupdate.html#cfn-xray-samplingrule-samplingruleupdate-rulename
         */
        readonly ruleName?: string;
        /**
         * `CfnSamplingRule.SamplingRuleUpdateProperty.ServiceName`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-xray-samplingrule-samplingruleupdate.html#cfn-xray-samplingrule-samplingruleupdate-servicename
         */
        readonly serviceName?: string;
        /**
         * `CfnSamplingRule.SamplingRuleUpdateProperty.ServiceType`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-xray-samplingrule-samplingruleupdate.html#cfn-xray-samplingrule-samplingruleupdate-servicetype
         */
        readonly serviceType?: string;
        /**
         * `CfnSamplingRule.SamplingRuleUpdateProperty.URLPath`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-xray-samplingrule-samplingruleupdate.html#cfn-xray-samplingrule-samplingruleupdate-urlpath
         */
        readonly urlPath?: string;
    }
}
