# -*- coding: utf-8 -*-
from setuptools import setup

packages = \
['sr', 'sr.robot3', 'sr.robot3.vision', 'sr.robot3.vision.calibrations']

package_data = \
{'': ['*']}

install_requires = \
['astoria>=0.5.1,<0.6.0',
 'j5-zoloto>=0.1.0,<0.2.0',
 'j5>=0.13.0,<0.14.0',
 'pyserial>=3.4,<4.0']

setup_kwargs = {
    'name': 'sr.robot3',
    'version': '2022.0.1',
    'description': 'Student Robotics API for Python 3',
    'long_description': '# sr.robot3\n\n![Tests](https://github.com/srobo/sr-robot3/workflows/Tests/badge.svg)\n[![PyPI version](https://badge.fury.io/py/sr.robot3.svg)](https://pypi.org/project/sr.robot3/)\n[![MIT license](https://img.shields.io/badge/license-MIT-brightgreen.svg?style=flat)](https://opensource.org/licenses/MIT)\n![Bees](https://img.shields.io/badge/bees-110%25-yellow.svg)\n\nStudent Robotics API for Python 3\n\nThis package uses [PEP420](https://www.python.org/dev/peps/pep-0420/)-style namespace packaging.\n\n## Development\n\n### Requirements\n\nThis project uses the [Poetry](https://python-poetry.org) dependency and virtualenv manager.\n\nYou will also need:\n\n- Python 3.6+\n- Make\n\n### Setup\n\n- Clone the repository from GitHub to a folder on your local machine\n- `cd` to that folder, and tell Poetry to install dependencies and set up a virtualenv `poetry install`\n- You can now enter the virtual environment using `poetry shell` and develop using your IDE of choice.\n\n### Tests\n\nThe full type, test and lint suite can be run using make: `make`.\n\nYou can also run parts of the suite.\n\n- Unit tests: `make test`\n- Unit tests with HTML coverage: `make test-cov`\n- Linting: `make lint`\n- Static type checks: `make type`\n\n### Adding camera calibrations\n\nYou will need to print off a [chAruco marker grid](https://docs.opencv.org/4.5.3/charuco_board.png).\n\n`opencv_interactive-calibration -t=charuco -sz=GRID_SIZE`\n\nReplace GRID_SIZE with the length of one of the larger squares (in mm) from the printed marker grid.\n\nUse `-ci=1` for specifying camera index if multiple cameras are connected.\n\nPoint the camera at the marker grid. Until DF is at or below 30 then press S to save.\nThis will output a `cameraParameters.xml` file. Place this file in `sr/robot3/vision/calibrations` named by the camera model.\n\nYou will need to add a detection strategy for the camera in to `sr/robot3/vision/backend.py`.\n\n## Contributions\n\nThis project is released under the MIT Licence. For more information, please see LICENSE.\n\nThe CONTRIBUTORS file can be generated by executing CONTRIBUTORS.gen. This generated file contains a list of people who have contributed to sr.robot3.\n',
    'author': 'Student Robotics',
    'author_email': 'kit-brain@studentrobotics.org',
    'maintainer': None,
    'maintainer_email': None,
    'url': 'https://github.com/srobo/sr-robot3',
    'packages': packages,
    'package_data': package_data,
    'install_requires': install_requires,
    'python_requires': '>=3.6,<4.0',
}


setup(**setup_kwargs)
