# coding: utf-8

"""
    RIME Rest API

    API methods for RIME. Must be authenticated with `rime-api-key` header.  # noqa: E501

    OpenAPI spec version: 1.0
    Contact: dev@robustintelligence.com
    Generated by: https://github.com/swagger-api/swagger-codegen.git
"""

from __future__ import absolute_import

import re  # noqa: F401

# python 2 and python 3 compatibility library
import six

from rime_sdk.swagger.swagger_client.api_client import ApiClient


class IntegrationServiceApi(object):
    """NOTE: This class is auto generated by the swagger code generator program.

    Do not edit the class manually.
    Ref: https://github.com/swagger-api/swagger-codegen
    """

    def __init__(self, api_client=None):
        if api_client is None:
            api_client = ApiClient()
        self.api_client = api_client

    def integration_service_configure_integration(self, body, integration_id_uuid, **kwargs):  # noqa: E501
        """ConfigureIntegration  # noqa: E501

        Configures the Integration with specified ID.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.integration_service_configure_integration(body, integration_id_uuid, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param IntegrationsIntegrationIdUuidBody body: (required)
        :param str integration_id_uuid: Unique object ID. (required)
        :return: RimeConfigureIntegrationResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.integration_service_configure_integration_with_http_info(body, integration_id_uuid, **kwargs)  # noqa: E501
        else:
            (data) = self.integration_service_configure_integration_with_http_info(body, integration_id_uuid, **kwargs)  # noqa: E501
            return data

    def integration_service_configure_integration_with_http_info(self, body, integration_id_uuid, **kwargs):  # noqa: E501
        """ConfigureIntegration  # noqa: E501

        Configures the Integration with specified ID.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.integration_service_configure_integration_with_http_info(body, integration_id_uuid, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param IntegrationsIntegrationIdUuidBody body: (required)
        :param str integration_id_uuid: Unique object ID. (required)
        :return: RimeConfigureIntegrationResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['body', 'integration_id_uuid']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method integration_service_configure_integration" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'body' is set
        if ('body' not in params or
                params['body'] is None):
            raise ValueError("Missing the required parameter `body` when calling `integration_service_configure_integration`")  # noqa: E501
        # verify the required parameter 'integration_id_uuid' is set
        if ('integration_id_uuid' not in params or
                params['integration_id_uuid'] is None):
            raise ValueError("Missing the required parameter `integration_id_uuid` when calling `integration_service_configure_integration`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'integration_id_uuid' in params:
            path_params['integrationId.uuid'] = params['integration_id_uuid']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'body' in params:
            body_params = params['body']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['rime-api-key']  # noqa: E501

        return self.api_client.call_api(
            '/v1-beta/integrations/{integrationId.uuid}', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='RimeConfigureIntegrationResponse',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def integration_service_create_integration(self, body, **kwargs):  # noqa: E501
        """CreateIntegration  # noqa: E501

        Creates a new Integration.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.integration_service_create_integration(body, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param RimeCreateIntegrationRequest body: (required)
        :return: RimeCreateIntegrationResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.integration_service_create_integration_with_http_info(body, **kwargs)  # noqa: E501
        else:
            (data) = self.integration_service_create_integration_with_http_info(body, **kwargs)  # noqa: E501
            return data

    def integration_service_create_integration_with_http_info(self, body, **kwargs):  # noqa: E501
        """CreateIntegration  # noqa: E501

        Creates a new Integration.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.integration_service_create_integration_with_http_info(body, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param RimeCreateIntegrationRequest body: (required)
        :return: RimeCreateIntegrationResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['body']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method integration_service_create_integration" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'body' is set
        if ('body' not in params or
                params['body'] is None):
            raise ValueError("Missing the required parameter `body` when calling `integration_service_create_integration`")  # noqa: E501

        collection_formats = {}

        path_params = {}

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'body' in params:
            body_params = params['body']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['rime-api-key']  # noqa: E501

        return self.api_client.call_api(
            '/v1-beta/integrations', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='RimeCreateIntegrationResponse',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def integration_service_delete_integration(self, integration_id_uuid, **kwargs):  # noqa: E501
        """DeleteIntegration  # noqa: E501

        Delete an Integration by specified ID.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.integration_service_delete_integration(integration_id_uuid, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str integration_id_uuid: Unique object ID. (required)
        :return: RimeDeleteIntegrationResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.integration_service_delete_integration_with_http_info(integration_id_uuid, **kwargs)  # noqa: E501
        else:
            (data) = self.integration_service_delete_integration_with_http_info(integration_id_uuid, **kwargs)  # noqa: E501
            return data

    def integration_service_delete_integration_with_http_info(self, integration_id_uuid, **kwargs):  # noqa: E501
        """DeleteIntegration  # noqa: E501

        Delete an Integration by specified ID.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.integration_service_delete_integration_with_http_info(integration_id_uuid, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str integration_id_uuid: Unique object ID. (required)
        :return: RimeDeleteIntegrationResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['integration_id_uuid']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method integration_service_delete_integration" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'integration_id_uuid' is set
        if ('integration_id_uuid' not in params or
                params['integration_id_uuid'] is None):
            raise ValueError("Missing the required parameter `integration_id_uuid` when calling `integration_service_delete_integration`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'integration_id_uuid' in params:
            path_params['integrationId.uuid'] = params['integration_id_uuid']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['rime-api-key']  # noqa: E501

        return self.api_client.call_api(
            '/v1-beta/integrations/{integrationId.uuid}', 'DELETE',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='RimeDeleteIntegrationResponse',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def integration_service_get_integration(self, integration_id_uuid, **kwargs):  # noqa: E501
        """GetIntegration  # noqa: E501

        Returns an Integration by specified ID.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.integration_service_get_integration(integration_id_uuid, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str integration_id_uuid: Unique object ID. (required)
        :return: RimeGetIntegrationResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.integration_service_get_integration_with_http_info(integration_id_uuid, **kwargs)  # noqa: E501
        else:
            (data) = self.integration_service_get_integration_with_http_info(integration_id_uuid, **kwargs)  # noqa: E501
            return data

    def integration_service_get_integration_with_http_info(self, integration_id_uuid, **kwargs):  # noqa: E501
        """GetIntegration  # noqa: E501

        Returns an Integration by specified ID.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.integration_service_get_integration_with_http_info(integration_id_uuid, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str integration_id_uuid: Unique object ID. (required)
        :return: RimeGetIntegrationResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['integration_id_uuid']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method integration_service_get_integration" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'integration_id_uuid' is set
        if ('integration_id_uuid' not in params or
                params['integration_id_uuid'] is None):
            raise ValueError("Missing the required parameter `integration_id_uuid` when calling `integration_service_get_integration`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'integration_id_uuid' in params:
            path_params['integrationId.uuid'] = params['integration_id_uuid']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['rime-api-key']  # noqa: E501

        return self.api_client.call_api(
            '/v1-beta/integrations/{integrationId.uuid}', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='RimeGetIntegrationResponse',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def integration_service_list_workspace_integrations(self, workspace_id_uuid, **kwargs):  # noqa: E501
        """ListWorkspaceIntegrations  # noqa: E501

        List all Integrations for the Workspace with specified ID.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.integration_service_list_workspace_integrations(workspace_id_uuid, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str workspace_id_uuid: Unique object ID. (required)
        :return: RimeListWorkspaceIntegrationsResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.integration_service_list_workspace_integrations_with_http_info(workspace_id_uuid, **kwargs)  # noqa: E501
        else:
            (data) = self.integration_service_list_workspace_integrations_with_http_info(workspace_id_uuid, **kwargs)  # noqa: E501
            return data

    def integration_service_list_workspace_integrations_with_http_info(self, workspace_id_uuid, **kwargs):  # noqa: E501
        """ListWorkspaceIntegrations  # noqa: E501

        List all Integrations for the Workspace with specified ID.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.integration_service_list_workspace_integrations_with_http_info(workspace_id_uuid, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str workspace_id_uuid: Unique object ID. (required)
        :return: RimeListWorkspaceIntegrationsResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['workspace_id_uuid']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method integration_service_list_workspace_integrations" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'workspace_id_uuid' is set
        if ('workspace_id_uuid' not in params or
                params['workspace_id_uuid'] is None):
            raise ValueError("Missing the required parameter `workspace_id_uuid` when calling `integration_service_list_workspace_integrations`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'workspace_id_uuid' in params:
            path_params['workspaceId.uuid'] = params['workspace_id_uuid']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['rime-api-key']  # noqa: E501

        return self.api_client.call_api(
            '/v1-beta/integrations/workspace/{workspaceId.uuid}', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='RimeListWorkspaceIntegrationsResponse',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def integration_service_update_integration(self, body, integration_id_uuid, **kwargs):  # noqa: E501
        """UpdateIntegration  # noqa: E501

        Update the Integration with specified ID.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.integration_service_update_integration(body, integration_id_uuid, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param IntegrationsIntegrationIdUuidBody body: (required)
        :param str integration_id_uuid: Unique object ID. (required)
        :return: RimeUpdateIntegrationResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.integration_service_update_integration_with_http_info(body, integration_id_uuid, **kwargs)  # noqa: E501
        else:
            (data) = self.integration_service_update_integration_with_http_info(body, integration_id_uuid, **kwargs)  # noqa: E501
            return data

    def integration_service_update_integration_with_http_info(self, body, integration_id_uuid, **kwargs):  # noqa: E501
        """UpdateIntegration  # noqa: E501

        Update the Integration with specified ID.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.integration_service_update_integration_with_http_info(body, integration_id_uuid, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param IntegrationsIntegrationIdUuidBody body: (required)
        :param str integration_id_uuid: Unique object ID. (required)
        :return: RimeUpdateIntegrationResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['body', 'integration_id_uuid']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method integration_service_update_integration" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'body' is set
        if ('body' not in params or
                params['body'] is None):
            raise ValueError("Missing the required parameter `body` when calling `integration_service_update_integration`")  # noqa: E501
        # verify the required parameter 'integration_id_uuid' is set
        if ('integration_id_uuid' not in params or
                params['integration_id_uuid'] is None):
            raise ValueError("Missing the required parameter `integration_id_uuid` when calling `integration_service_update_integration`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'integration_id_uuid' in params:
            path_params['integration.id.uuid'] = params['integration_id_uuid']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'body' in params:
            body_params = params['body']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['rime-api-key']  # noqa: E501

        return self.api_client.call_api(
            '/v1-beta/integrations/{integration.id.uuid}', 'PUT',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='RimeUpdateIntegrationResponse',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)
