# coding: utf-8

"""
    RIME Rest API

    API methods for RIME. Must be authenticated with `rime-api-key` header.  # noqa: E501

    OpenAPI spec version: 1.0
    Contact: dev@robustintelligence.com
    Generated by: https://github.com/swagger-api/swagger-codegen.git
"""

from __future__ import absolute_import

import re  # noqa: F401

# python 2 and python 3 compatibility library
import six

from rime_sdk.swagger.swagger_client.api_client import ApiClient


class UserApi(object):
    """NOTE: This class is auto generated by the swagger code generator program.

    Do not edit the class manually.
    Ref: https://github.com/swagger-api/swagger-codegen
    """

    def __init__(self, api_client=None):
        if api_client is None:
            api_client = ApiClient()
        self.api_client = api_client

    def user_create_api_token(self, body, **kwargs):  # noqa: E501
        """CreateAPIToken  # noqa: E501

        Create a new API token.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.user_create_api_token(body, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param RimeCreateAPITokenRequest body: (required)
        :return: RimeCreateAPITokenResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.user_create_api_token_with_http_info(body, **kwargs)  # noqa: E501
        else:
            (data) = self.user_create_api_token_with_http_info(body, **kwargs)  # noqa: E501
            return data

    def user_create_api_token_with_http_info(self, body, **kwargs):  # noqa: E501
        """CreateAPIToken  # noqa: E501

        Create a new API token.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.user_create_api_token_with_http_info(body, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param RimeCreateAPITokenRequest body: (required)
        :return: RimeCreateAPITokenResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['body']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method user_create_api_token" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'body' is set
        if ('body' not in params or
                params['body'] is None):
            raise ValueError("Missing the required parameter `body` when calling `user_create_api_token`")  # noqa: E501

        collection_formats = {}

        path_params = {}

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'body' in params:
            body_params = params['body']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['rime-api-key']  # noqa: E501

        return self.api_client.call_api(
            '/v1/users/api-tokens', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='RimeCreateAPITokenResponse',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def user_create_user(self, body, **kwargs):  # noqa: E501
        """CreateUser  # noqa: E501

        Creates a user.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.user_create_user(body, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param RimeCreateUserRequest body: (required)
        :return: RimeCreateUserResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.user_create_user_with_http_info(body, **kwargs)  # noqa: E501
        else:
            (data) = self.user_create_user_with_http_info(body, **kwargs)  # noqa: E501
            return data

    def user_create_user_with_http_info(self, body, **kwargs):  # noqa: E501
        """CreateUser  # noqa: E501

        Creates a user.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.user_create_user_with_http_info(body, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param RimeCreateUserRequest body: (required)
        :return: RimeCreateUserResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['body']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method user_create_user" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'body' is set
        if ('body' not in params or
                params['body'] is None):
            raise ValueError("Missing the required parameter `body` when calling `user_create_user`")  # noqa: E501

        collection_formats = {}

        path_params = {}

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'body' in params:
            body_params = params['body']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['rime-api-key']  # noqa: E501

        return self.api_client.call_api(
            '/v1/users', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='RimeCreateUserResponse',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def user_delete_api_token(self, id_uuid, **kwargs):  # noqa: E501
        """DeleteAPIToken  # noqa: E501

        Delete an API token by ID.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.user_delete_api_token(id_uuid, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str id_uuid: Unique object ID. (required)
        :return: object
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.user_delete_api_token_with_http_info(id_uuid, **kwargs)  # noqa: E501
        else:
            (data) = self.user_delete_api_token_with_http_info(id_uuid, **kwargs)  # noqa: E501
            return data

    def user_delete_api_token_with_http_info(self, id_uuid, **kwargs):  # noqa: E501
        """DeleteAPIToken  # noqa: E501

        Delete an API token by ID.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.user_delete_api_token_with_http_info(id_uuid, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str id_uuid: Unique object ID. (required)
        :return: object
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['id_uuid']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method user_delete_api_token" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'id_uuid' is set
        if ('id_uuid' not in params or
                params['id_uuid'] is None):
            raise ValueError("Missing the required parameter `id_uuid` when calling `user_delete_api_token`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'id_uuid' in params:
            path_params['id.uuid'] = params['id_uuid']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['rime-api-key']  # noqa: E501

        return self.api_client.call_api(
            '/v1/users/api-tokens/{id.uuid}', 'DELETE',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='object',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def user_delete_user(self, user_id_uuid, **kwargs):  # noqa: E501
        """DeleteUser  # noqa: E501

        Delete the user with the specified ID.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.user_delete_user(user_id_uuid, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str user_id_uuid: Unique object ID. (required)
        :return: object
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.user_delete_user_with_http_info(user_id_uuid, **kwargs)  # noqa: E501
        else:
            (data) = self.user_delete_user_with_http_info(user_id_uuid, **kwargs)  # noqa: E501
            return data

    def user_delete_user_with_http_info(self, user_id_uuid, **kwargs):  # noqa: E501
        """DeleteUser  # noqa: E501

        Delete the user with the specified ID.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.user_delete_user_with_http_info(user_id_uuid, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str user_id_uuid: Unique object ID. (required)
        :return: object
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['user_id_uuid']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method user_delete_user" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'user_id_uuid' is set
        if ('user_id_uuid' not in params or
                params['user_id_uuid'] is None):
            raise ValueError("Missing the required parameter `user_id_uuid` when calling `user_delete_user`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'user_id_uuid' in params:
            path_params['userId.uuid'] = params['user_id_uuid']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['rime-api-key']  # noqa: E501

        return self.api_client.call_api(
            '/v1/users/{userId.uuid}', 'DELETE',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='object',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def user_get_user(self, user_id_uuid, **kwargs):  # noqa: E501
        """GetUser  # noqa: E501

        Return the user with the specified ID.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.user_get_user(user_id_uuid, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str user_id_uuid: Unique object ID. (required)
        :param str oidc_id_token: ID of the OIDC provider token.
        :return: RimeGetUserResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.user_get_user_with_http_info(user_id_uuid, **kwargs)  # noqa: E501
        else:
            (data) = self.user_get_user_with_http_info(user_id_uuid, **kwargs)  # noqa: E501
            return data

    def user_get_user_with_http_info(self, user_id_uuid, **kwargs):  # noqa: E501
        """GetUser  # noqa: E501

        Return the user with the specified ID.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.user_get_user_with_http_info(user_id_uuid, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str user_id_uuid: Unique object ID. (required)
        :param str oidc_id_token: ID of the OIDC provider token.
        :return: RimeGetUserResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['user_id_uuid', 'oidc_id_token']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method user_get_user" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'user_id_uuid' is set
        if ('user_id_uuid' not in params or
                params['user_id_uuid'] is None):
            raise ValueError("Missing the required parameter `user_id_uuid` when calling `user_get_user`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'user_id_uuid' in params:
            path_params['userId.uuid'] = params['user_id_uuid']  # noqa: E501

        query_params = []
        if 'oidc_id_token' in params:
            query_params.append(('oidcIdToken', params['oidc_id_token']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['rime-api-key']  # noqa: E501

        return self.api_client.call_api(
            '/v1/users/{userId.uuid}', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='RimeGetUserResponse',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def user_list_api_tokens(self, **kwargs):  # noqa: E501
        """ListAPITokens  # noqa: E501

        List all API tokens for a Workspace.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.user_list_api_tokens(async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str page_token: Specifies a page of the list returned by a ListAPITokens query. The ListAPITokens query returns a pageToken when there is more than one page of results.
        :param str page_size: The maximum number of API Token objects to return in a single page.
        :param str workspace_id_uuid: Unique object ID.
        :return: RimeListAPITokensResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.user_list_api_tokens_with_http_info(**kwargs)  # noqa: E501
        else:
            (data) = self.user_list_api_tokens_with_http_info(**kwargs)  # noqa: E501
            return data

    def user_list_api_tokens_with_http_info(self, **kwargs):  # noqa: E501
        """ListAPITokens  # noqa: E501

        List all API tokens for a Workspace.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.user_list_api_tokens_with_http_info(async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str page_token: Specifies a page of the list returned by a ListAPITokens query. The ListAPITokens query returns a pageToken when there is more than one page of results.
        :param str page_size: The maximum number of API Token objects to return in a single page.
        :param str workspace_id_uuid: Unique object ID.
        :return: RimeListAPITokensResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['page_token', 'page_size', 'workspace_id_uuid']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method user_list_api_tokens" % key
                )
            params[key] = val
        del params['kwargs']

        collection_formats = {}

        path_params = {}

        query_params = []
        if 'page_token' in params:
            query_params.append(('pageToken', params['page_token']))  # noqa: E501
        if 'page_size' in params:
            query_params.append(('pageSize', params['page_size']))  # noqa: E501
        if 'workspace_id_uuid' in params:
            query_params.append(('workspaceId.uuid', params['workspace_id_uuid']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['rime-api-key']  # noqa: E501

        return self.api_client.call_api(
            '/v1/users/api-tokens', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='RimeListAPITokensResponse',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def user_list_current_user_roles(self, **kwargs):  # noqa: E501
        """ListCurrentUserRoles  # noqa: E501

        Returns the list of roles of the logged in user.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.user_list_current_user_roles(async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :return: RimeListCurrentUserRolesResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.user_list_current_user_roles_with_http_info(**kwargs)  # noqa: E501
        else:
            (data) = self.user_list_current_user_roles_with_http_info(**kwargs)  # noqa: E501
            return data

    def user_list_current_user_roles_with_http_info(self, **kwargs):  # noqa: E501
        """ListCurrentUserRoles  # noqa: E501

        Returns the list of roles of the logged in user.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.user_list_current_user_roles_with_http_info(async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :return: RimeListCurrentUserRolesResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = []  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method user_list_current_user_roles" % key
                )
            params[key] = val
        del params['kwargs']

        collection_formats = {}

        path_params = {}

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['rime-api-key']  # noqa: E501

        return self.api_client.call_api(
            '/v1/users/roles', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='RimeListCurrentUserRolesResponse',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def user_list_users(self, **kwargs):  # noqa: E501
        """ListUsers  # noqa: E501

        List all users.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.user_list_users(async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str page_token: Specifies a page of the list returned by a ListUsers query. The ListUsers query returns a pageToken when there is more than one page of results. Specify either this field or the firstPageQuery field.
        :param str page_size: The maximum number of User objects to return in a single page.
        :return: RimeListUsersResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.user_list_users_with_http_info(**kwargs)  # noqa: E501
        else:
            (data) = self.user_list_users_with_http_info(**kwargs)  # noqa: E501
            return data

    def user_list_users_with_http_info(self, **kwargs):  # noqa: E501
        """ListUsers  # noqa: E501

        List all users.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.user_list_users_with_http_info(async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str page_token: Specifies a page of the list returned by a ListUsers query. The ListUsers query returns a pageToken when there is more than one page of results. Specify either this field or the firstPageQuery field.
        :param str page_size: The maximum number of User objects to return in a single page.
        :return: RimeListUsersResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['page_token', 'page_size']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method user_list_users" % key
                )
            params[key] = val
        del params['kwargs']

        collection_formats = {}

        path_params = {}

        query_params = []
        if 'page_token' in params:
            query_params.append(('pageToken', params['page_token']))  # noqa: E501
        if 'page_size' in params:
            query_params.append(('pageSize', params['page_size']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['rime-api-key']  # noqa: E501

        return self.api_client.call_api(
            '/v1/users', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='RimeListUsersResponse',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def user_reset_password(self, body, user_id_uuid, **kwargs):  # noqa: E501
        """ResetPassword  # noqa: E501

        Reset the password of a user with the specified ID.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.user_reset_password(body, user_id_uuid, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param ResetpasswordUserIdUuidBody body: (required)
        :param str user_id_uuid: Unique object ID. (required)
        :return: RimeResetPasswordResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.user_reset_password_with_http_info(body, user_id_uuid, **kwargs)  # noqa: E501
        else:
            (data) = self.user_reset_password_with_http_info(body, user_id_uuid, **kwargs)  # noqa: E501
            return data

    def user_reset_password_with_http_info(self, body, user_id_uuid, **kwargs):  # noqa: E501
        """ResetPassword  # noqa: E501

        Reset the password of a user with the specified ID.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.user_reset_password_with_http_info(body, user_id_uuid, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param ResetpasswordUserIdUuidBody body: (required)
        :param str user_id_uuid: Unique object ID. (required)
        :return: RimeResetPasswordResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['body', 'user_id_uuid']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method user_reset_password" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'body' is set
        if ('body' not in params or
                params['body'] is None):
            raise ValueError("Missing the required parameter `body` when calling `user_reset_password`")  # noqa: E501
        # verify the required parameter 'user_id_uuid' is set
        if ('user_id_uuid' not in params or
                params['user_id_uuid'] is None):
            raise ValueError("Missing the required parameter `user_id_uuid` when calling `user_reset_password`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'user_id_uuid' in params:
            path_params['userId.uuid'] = params['user_id_uuid']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'body' in params:
            body_params = params['body']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['rime-api-key']  # noqa: E501

        return self.api_client.call_api(
            '/v1/users/reset-password/{userId.uuid}', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='RimeResetPasswordResponse',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def user_update_user(self, body, user_id_uuid, **kwargs):  # noqa: E501
        """UpdateUser  # noqa: E501

        Update a user with the specified ID.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.user_update_user(body, user_id_uuid, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param UsersUserIdUuidBody body: (required)
        :param str user_id_uuid: Unique object ID. (required)
        :return: RimeUpdateUserResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.user_update_user_with_http_info(body, user_id_uuid, **kwargs)  # noqa: E501
        else:
            (data) = self.user_update_user_with_http_info(body, user_id_uuid, **kwargs)  # noqa: E501
            return data

    def user_update_user_with_http_info(self, body, user_id_uuid, **kwargs):  # noqa: E501
        """UpdateUser  # noqa: E501

        Update a user with the specified ID.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.user_update_user_with_http_info(body, user_id_uuid, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param UsersUserIdUuidBody body: (required)
        :param str user_id_uuid: Unique object ID. (required)
        :return: RimeUpdateUserResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['body', 'user_id_uuid']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method user_update_user" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'body' is set
        if ('body' not in params or
                params['body'] is None):
            raise ValueError("Missing the required parameter `body` when calling `user_update_user`")  # noqa: E501
        # verify the required parameter 'user_id_uuid' is set
        if ('user_id_uuid' not in params or
                params['user_id_uuid'] is None):
            raise ValueError("Missing the required parameter `user_id_uuid` when calling `user_update_user`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'user_id_uuid' in params:
            path_params['user.id.uuid'] = params['user_id_uuid']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'body' in params:
            body_params = params['body']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['rime-api-key']  # noqa: E501

        return self.api_client.call_api(
            '/v1/users/{user.id.uuid}', 'PUT',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='RimeUpdateUserResponse',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)
